/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.spinner.editspinner;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.PopupWindow;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.widget.spinner.editspinner.BaseEditSpinnerAdapter;
import com.xuexiang.xui.widget.spinner.editspinner.EditSpinnerAdapter;
import java.util.List;

public class EditSpinner
extends FrameLayout
implements View.OnClickListener,
AdapterView.OnItemClickListener,
TextWatcher {
    private static final int DEFAULT_MAX_LINE = 1;
    private EditText mEditText;
    private ImageView mIvArrow;
    private ListPopupWindow mPopupWindow;
    private BaseEditSpinnerAdapter mAdapter;
    private long popupWindowHideTime;
    private Animation mAnimation;
    private Animation mResetAnimation;
    private AdapterView.OnItemClickListener mOnItemClickListener;
    private int mMaxLine = 1;
    private Drawable mDropDownBg;
    private boolean mIsShowFilterData = true;
    private boolean mIsFilterKey = false;

    public EditSpinner(Context context) {
        this(context, null);
    }

    public EditSpinner(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.EditSpinnerStyle);
    }

    public EditSpinner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
        this.initAttrs(context, attrs, defStyleAttr);
        this.initAnimation();
    }

    private void initView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.xui_layout_edit_spinner, (ViewGroup)this);
        this.mEditText = (EditText)this.findViewById(R.id.edit_spinner_edit);
        this.mIvArrow = (ImageView)this.findViewById(R.id.edit_spinner_arrow);
        this.mIvArrow.setOnClickListener((View.OnClickListener)this);
        this.mEditText.addTextChangedListener((TextWatcher)this);
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.EditSpinner, defStyleAttr, 0);
        if (typedArray != null) {
            int arrowMargin;
            this.mIsShowFilterData = typedArray.getBoolean(R.styleable.EditSpinner_es_isShowFilterData, true);
            this.mIsFilterKey = typedArray.getBoolean(R.styleable.EditSpinner_es_isFilterKey, false);
            int imageId = typedArray.getResourceId(R.styleable.EditSpinner_es_arrowImage, 0);
            if (imageId != 0) {
                this.mIvArrow.setImageResource(imageId);
            }
            if ((arrowMargin = typedArray.getDimensionPixelSize(R.styleable.EditSpinner_es_arrowMargin, -1)) != -1) {
                FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mIvArrow.getLayoutParams();
                params.setMargins(arrowMargin, 0, arrowMargin, 0);
                this.mIvArrow.setLayoutParams((ViewGroup.LayoutParams)params);
            }
            this.mEditText.setHint((CharSequence)typedArray.getString(R.styleable.EditSpinner_es_hint));
            int bg = typedArray.getResourceId(R.styleable.EditSpinner_es_background, 0);
            if (bg != 0) {
                this.mEditText.setBackgroundResource(bg);
            }
            this.mMaxLine = typedArray.getInt(R.styleable.EditSpinner_es_maxLine, 1);
            this.mEditText.setMaxLines(this.mMaxLine);
            int height = typedArray.getDimensionPixelSize(R.styleable.EditSpinner_es_height, ThemeUtils.resolveDimension(this.getContext(), R.attr.ms_item_height_size));
            this.mEditText.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, height));
            this.setTextColors(typedArray.getColorStateList(R.styleable.EditSpinner_es_textColor));
            this.setTextSize(typedArray.getDimensionPixelSize(R.styleable.EditSpinner_es_textSize, ThemeUtils.resolveDimension(this.getContext(), R.attr.xui_config_size_spinner_text)));
            int entriesID = typedArray.getResourceId(R.styleable.EditSpinner_es_entries, 0);
            if (entriesID != 0) {
                this.setItems(ResUtils.getStringArray(entriesID));
            }
            this.mDropDownBg = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.EditSpinner_es_dropdown_bg);
            boolean enable = typedArray.getBoolean(R.styleable.EditSpinner_es_enable, true);
            this.setEnabled(enable);
            int maxLength = typedArray.getInteger(R.styleable.EditSpinner_es_maxLength, -1);
            this.setMaxLength(maxLength);
            int maxEms = typedArray.getInteger(R.styleable.EditSpinner_es_maxEms, -1);
            this.setMaxEms(maxEms);
            typedArray.recycle();
        }
    }

    private void initAnimation() {
        this.mAnimation = new RotateAnimation(0.0f, -180.0f, 1, 0.5f, 1, 0.5f);
        this.mAnimation.setDuration(300L);
        this.mAnimation.setFillAfter(true);
        this.mResetAnimation = new RotateAnimation(-180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.mResetAnimation.setDuration(300L);
        this.mResetAnimation.setFillAfter(true);
    }

    private void setBaseAdapter(BaseAdapter adapter) {
        if (this.mPopupWindow == null) {
            this.initPopupWindow();
        }
        this.mPopupWindow.setAdapter((ListAdapter)adapter);
    }

    private void initPopupWindow() {
        this.mPopupWindow = new ListPopupWindow(this.getContext()){

            public void show() {
                super.show();
                EditSpinner.this.mIvArrow.startAnimation(EditSpinner.this.mAnimation);
            }

            public void dismiss() {
                super.dismiss();
            }
        };
        this.mPopupWindow.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mPopupWindow.setInputMethodMode(2);
        this.mPopupWindow.setSoftInputMode(48);
        this.mPopupWindow.setPromptPosition(1);
        this.mPopupWindow.setWidth(-2);
        this.mPopupWindow.setHeight(-2);
        this.mPopupWindow.setAnchorView((View)this.mEditText);
        this.mPopupWindow.setVerticalOffset(ThemeUtils.resolveDimension(this.getContext(), R.attr.ms_dropdown_offset));
        this.mPopupWindow.setListSelector(ResUtils.getDrawable(this.getContext(), R.drawable.xui_config_list_item_selector));
        this.mPopupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                EditSpinner.this.popupWindowHideTime = System.currentTimeMillis();
                EditSpinner.this.mIvArrow.startAnimation(EditSpinner.this.mResetAnimation);
            }
        });
        if (this.mDropDownBg != null) {
            this.mPopupWindow.setBackgroundDrawable(this.mDropDownBg);
        } else {
            this.mPopupWindow.setBackgroundDrawable(ResUtils.getDrawable(this.getContext(), R.drawable.ms_drop_down_bg_radius));
        }
    }

    public final void onClick(View v) {
        this.togglePopupWindow();
    }

    private void togglePopupWindow() {
        if (System.currentTimeMillis() - this.popupWindowHideTime > 200L) {
            if (this.mAdapter == null || this.mPopupWindow == null) {
                return;
            }
            this.showFilterData("");
        }
    }

    public final void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.mEditText.setText((CharSequence)((BaseEditSpinnerAdapter)parent.getAdapter()).getItemString(position));
        if (this.mPopupWindow != null) {
            this.mPopupWindow.dismiss();
        }
        if (this.mOnItemClickListener != null) {
            this.mOnItemClickListener.onItemClick(parent, view, position, id2);
        }
    }

    public final void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public final void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public final void afterTextChanged(Editable s) {
        String key = s.toString();
        this.mEditText.setSelection(key.length());
        if (!TextUtils.isEmpty((CharSequence)key)) {
            if (this.mIsShowFilterData) {
                this.showFilterData(key);
            }
        } else if (this.mPopupWindow != null) {
            this.mPopupWindow.dismiss();
        }
    }

    private void showFilterData(String key) {
        if (this.mPopupWindow == null || this.mAdapter == null || this.mAdapter.getEditSpinnerFilter() == null) {
            if (this.mPopupWindow != null) {
                this.mPopupWindow.dismiss();
            }
            return;
        }
        if (this.mAdapter.getEditSpinnerFilter().onFilter(key)) {
            this.mPopupWindow.dismiss();
        } else {
            this.mPopupWindow.show();
        }
    }

    public String getText() {
        return this.mEditText != null ? this.mEditText.getText().toString() : "";
    }

    public EditSpinner setItems(String[] data) {
        this.mAdapter = new EditSpinnerAdapter(this.getContext(), data).setTextColor(this.mEditText.getTextColors().getDefaultColor()).setTextSize(this.mEditText.getTextSize()).setIsFilterKey(this.mIsFilterKey);
        this.setAdapter(this.mAdapter);
        return this;
    }

    public EditSpinner setItems(List<String> data) {
        this.mAdapter = new EditSpinnerAdapter(this.getContext(), data).setTextColor(this.mEditText.getTextColors().getDefaultColor()).setTextSize(this.mEditText.getTextSize()).setIsFilterKey(this.mIsFilterKey);
        this.setAdapter(this.mAdapter);
        return this;
    }

    public EditSpinner setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
        return this;
    }

    public EditSpinner setText(@NonNull String text) {
        if (this.mEditText != null) {
            this.mEditText.removeTextChangedListener((TextWatcher)this);
            this.mEditText.setText((CharSequence)text);
            this.mEditText.addTextChangedListener((TextWatcher)this);
        }
        return this;
    }

    public EditSpinner setTextColors(ColorStateList colors) {
        if (this.mEditText != null && colors != null) {
            this.mEditText.setTextColor(colors);
            if (this.mAdapter != null && this.mAdapter instanceof EditSpinnerAdapter) {
                ((EditSpinnerAdapter)this.mAdapter).setTextColor(colors.getDefaultColor());
            }
        }
        return this;
    }

    public EditSpinner setTextColor(@ColorInt int color2) {
        if (this.mEditText != null) {
            this.mEditText.setTextColor(color2);
            if (this.mAdapter != null && this.mAdapter instanceof EditSpinnerAdapter) {
                ((EditSpinnerAdapter)this.mAdapter).setTextColor(color2);
            }
        }
        return this;
    }

    public EditSpinner setBackgroundSelector(@DrawableRes int backgroundSelector) {
        if (this.mEditText != null) {
            this.mEditText.setBackgroundResource(backgroundSelector);
        }
        return this;
    }

    public EditSpinner setIsFilterKey(boolean isFilterKey) {
        if (this.mEditText != null && this.mAdapter != null && this.mAdapter instanceof EditSpinnerAdapter) {
            ((EditSpinnerAdapter)this.mAdapter).setIsFilterKey(isFilterKey);
        }
        return this;
    }

    public EditSpinner setTextSize(float textSize) {
        if (this.mEditText != null) {
            this.mEditText.setTextSize(0, textSize);
            if (this.mAdapter != null && this.mAdapter instanceof EditSpinnerAdapter) {
                ((EditSpinnerAdapter)this.mAdapter).setTextSize(textSize);
            }
        }
        return this;
    }

    public EditSpinner setHint(String hint) {
        if (this.mEditText != null) {
            this.mEditText.setHint((CharSequence)hint);
        }
        return this;
    }

    public EditSpinner setArrowImageDrawable(Drawable drawable2) {
        if (this.mIvArrow != null) {
            this.mIvArrow.setImageDrawable(drawable2);
        }
        return this;
    }

    public EditSpinner setArrowImageResource(@DrawableRes int res) {
        if (this.mIvArrow != null) {
            this.mIvArrow.setImageResource(res);
        }
        return this;
    }

    public EditSpinner setAdapter(BaseEditSpinnerAdapter adapter) {
        this.mAdapter = adapter;
        this.setBaseAdapter(this.mAdapter);
        return this;
    }

    public EditSpinner setMaxLine(int maxLine) {
        if (this.mEditText != null) {
            this.mMaxLine = maxLine;
            this.mEditText.setMaxLines(this.mMaxLine);
        }
        return this;
    }

    public EditSpinner setEditTextHeight(int dp) {
        if (this.mEditText != null) {
            this.mEditText.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, DensityUtils.dp2px(this.getContext(), dp)));
        }
        return this;
    }

    public EditSpinner setEditTextWidth(int dp) {
        ViewGroup.LayoutParams params = this.getLayoutParams();
        params.width = DensityUtils.dp2px(this.getContext(), dp);
        this.setLayoutParams(params);
        return this;
    }

    public void setEnabled(boolean enabled) {
        if (this.mEditText != null) {
            this.mEditText.setFocusable(enabled);
            this.mEditText.setFocusableInTouchMode(enabled);
            this.mEditText.setEnabled(enabled);
            this.mIvArrow.setEnabled(enabled);
        }
    }

    public EditSpinner setMaxLength(int maxLength) {
        if (this.mEditText != null && maxLength > 0) {
            InputFilter[] filters = new InputFilter[]{new InputFilter.LengthFilter(maxLength)};
            this.mEditText.setFilters(filters);
        }
        return this;
    }

    public EditSpinner setMaxEms(int maxEms) {
        if (this.mEditText != null && maxEms > 0) {
            this.mEditText.setMaxEms(maxEms);
        }
        return this;
    }

    public EditSpinner addTextChangedListener(TextWatcher watcher) {
        if (this.mEditText != null) {
            this.mEditText.addTextChangedListener(watcher);
        }
        return this;
    }

    public EditSpinner setInputType(int type) {
        if (this.mEditText != null) {
            this.mEditText.setInputType(type);
        }
        return this;
    }

    public EditText getEditText() {
        return this.mEditText;
    }
}

