/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.progress.ratingbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.LinearLayout;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.progress.ratingbar.IRatingBar;
import com.xuexiang.xui.widget.progress.ratingbar.PartialView;
import com.xuexiang.xui.widget.progress.ratingbar.RatingBarUtils;
import com.xuexiang.xui.widget.progress.ratingbar.SavedState;
import java.util.ArrayList;
import java.util.List;

public class RatingBar
extends LinearLayout
implements IRatingBar {
    private int mNumStars;
    private int mPadding = 20;
    private int mStarWidth;
    private int mStarHeight;
    private float mMinimumStars = 0.0f;
    private float mRating = -1.0f;
    private float mStepSize = 1.0f;
    private float mPreviousRating = 0.0f;
    private boolean mIsIndicator = false;
    private boolean mIsScrollable = true;
    private boolean mIsClickable = true;
    private boolean mClearRatingEnabled = true;
    private float mStartX;
    private float mStartY;
    private Drawable mEmptyDrawable;
    private Drawable mFilledDrawable;
    private OnRatingChangeListener mOnRatingChangeListener;
    protected List<PartialView> mPartialViews;

    public RatingBar(Context context) {
        this(context, null);
    }

    public RatingBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RatingBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RatingBar);
        float rating = typedArray.getFloat(R.styleable.RatingBar_srb_rating, 0.0f);
        this.mNumStars = typedArray.getInt(R.styleable.RatingBar_srb_numStars, this.mNumStars);
        this.mStepSize = typedArray.getFloat(R.styleable.RatingBar_srb_stepSize, this.mStepSize);
        this.mMinimumStars = typedArray.getFloat(R.styleable.RatingBar_srb_minimumStars, this.mMinimumStars);
        this.mPadding = typedArray.getDimensionPixelSize(R.styleable.RatingBar_srb_starPadding, this.mPadding);
        this.mStarWidth = typedArray.getDimensionPixelSize(R.styleable.RatingBar_srb_starWidth, 0);
        this.mStarHeight = typedArray.getDimensionPixelSize(R.styleable.RatingBar_srb_starHeight, 0);
        this.mEmptyDrawable = typedArray.hasValue(R.styleable.RatingBar_srb_drawableEmpty) ? ContextCompat.getDrawable((Context)context, (int)typedArray.getResourceId(R.styleable.RatingBar_srb_drawableEmpty, -1)) : null;
        this.mFilledDrawable = typedArray.hasValue(R.styleable.RatingBar_srb_drawableFilled) ? ContextCompat.getDrawable((Context)context, (int)typedArray.getResourceId(R.styleable.RatingBar_srb_drawableFilled, -1)) : null;
        this.mIsIndicator = typedArray.getBoolean(R.styleable.RatingBar_srb_isIndicator, this.mIsIndicator);
        this.mIsScrollable = typedArray.getBoolean(R.styleable.RatingBar_srb_scrollable, this.mIsScrollable);
        this.mIsClickable = typedArray.getBoolean(R.styleable.RatingBar_srb_clickable, this.mIsClickable);
        this.mClearRatingEnabled = typedArray.getBoolean(R.styleable.RatingBar_srb_clearRatingEnabled, this.mClearRatingEnabled);
        typedArray.recycle();
        this.verifyParamsValue();
        this.initRatingView();
        this.setRating(rating);
    }

    private void verifyParamsValue() {
        if (this.mNumStars <= 0) {
            this.mNumStars = 5;
        }
        if (this.mPadding < 0) {
            this.mPadding = 0;
        }
        if (this.mEmptyDrawable == null) {
            this.mEmptyDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.srb_ic_empty);
        }
        if (this.mFilledDrawable == null) {
            this.mFilledDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.srb_ic_filled);
        }
        if (this.mStepSize > 1.0f) {
            this.mStepSize = 1.0f;
        } else if (this.mStepSize < 0.1f) {
            this.mStepSize = 0.1f;
        }
        this.mMinimumStars = RatingBarUtils.getValidMinimumStars(this.mMinimumStars, this.mNumStars, this.mStepSize);
    }

    private void initRatingView() {
        this.mPartialViews = new ArrayList<PartialView>();
        for (int i = 1; i <= this.mNumStars; ++i) {
            PartialView partialView = this.getPartialView(i, this.mStarWidth, this.mStarHeight, this.mPadding, this.mFilledDrawable, this.mEmptyDrawable);
            this.addView((View)partialView);
            this.mPartialViews.add(partialView);
        }
    }

    private PartialView getPartialView(int partialViewId, int starWidth, int starHeight, int padding, Drawable filledDrawable, Drawable emptyDrawable) {
        PartialView partialView = new PartialView(this.getContext(), partialViewId, starWidth, starHeight, padding);
        partialView.setFilledDrawable(filledDrawable);
        partialView.setEmptyDrawable(emptyDrawable);
        return partialView;
    }

    protected void emptyRatingBar() {
        this.fillRatingBar(0.0f);
    }

    protected void fillRatingBar(float rating) {
        for (PartialView partialView : this.mPartialViews) {
            double maxIntOfRating;
            int ratingViewId = (Integer)partialView.getTag();
            if ((double)ratingViewId > (maxIntOfRating = Math.ceil(rating))) {
                partialView.setEmpty();
                continue;
            }
            if ((double)ratingViewId == maxIntOfRating) {
                partialView.setPartialFilled(rating);
                continue;
            }
            partialView.setFilled();
        }
    }

    @Override
    public void setNumStars(int numStars) {
        if (numStars <= 0) {
            return;
        }
        this.mPartialViews.clear();
        this.removeAllViews();
        this.mNumStars = numStars;
        this.initRatingView();
    }

    @Override
    public int getNumStars() {
        return this.mNumStars;
    }

    @Override
    public void setRating(float rating) {
        if (rating > (float)this.mNumStars) {
            rating = this.mNumStars;
        }
        if (rating < this.mMinimumStars) {
            rating = this.mMinimumStars;
        }
        if (this.mRating == rating) {
            return;
        }
        this.mRating = rating;
        if (this.mOnRatingChangeListener != null) {
            this.mOnRatingChangeListener.onRatingChange(this, this.mRating);
        }
        this.fillRatingBar(rating);
    }

    @Override
    public float getRating() {
        return this.mRating;
    }

    @Override
    public void setStarWidth(@IntRange(from=0L) int starWidth) {
        this.mStarWidth = starWidth;
        for (PartialView partialView : this.mPartialViews) {
            partialView.setStarWidth(starWidth);
        }
    }

    @Override
    public int getStarWidth() {
        return this.mStarWidth;
    }

    @Override
    public void setStarHeight(@IntRange(from=0L) int starHeight) {
        this.mStarHeight = starHeight;
        for (PartialView partialView : this.mPartialViews) {
            partialView.setStarHeight(starHeight);
        }
    }

    @Override
    public int getStarHeight() {
        return this.mStarHeight;
    }

    @Override
    public void setStarPadding(int ratingPadding) {
        if (ratingPadding < 0) {
            return;
        }
        this.mPadding = ratingPadding;
        for (PartialView partialView : this.mPartialViews) {
            partialView.setPadding(this.mPadding, this.mPadding, this.mPadding, this.mPadding);
        }
    }

    @Override
    public int getStarPadding() {
        return this.mPadding;
    }

    @Override
    public void setEmptyDrawableRes(@DrawableRes int res) {
        this.setEmptyDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)res));
    }

    @Override
    public void setFilledDrawableRes(@DrawableRes int res) {
        this.setFilledDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)res));
    }

    @Override
    public void setEmptyDrawable(Drawable drawable2) {
        this.mEmptyDrawable = drawable2;
        for (PartialView partialView : this.mPartialViews) {
            partialView.setEmptyDrawable(drawable2);
        }
    }

    @Override
    public void setFilledDrawable(Drawable drawable2) {
        this.mFilledDrawable = drawable2;
        for (PartialView partialView : this.mPartialViews) {
            partialView.setFilledDrawable(drawable2);
        }
    }

    @Override
    public void setMinimumStars(@FloatRange(from=0.0) float minimumStars) {
        this.mMinimumStars = RatingBarUtils.getValidMinimumStars(minimumStars, this.mNumStars, this.mStepSize);
    }

    @Override
    public boolean isIndicator() {
        return this.mIsIndicator;
    }

    @Override
    public void setIsIndicator(boolean indicator) {
        this.mIsIndicator = indicator;
    }

    @Override
    public boolean isScrollable() {
        return this.mIsScrollable;
    }

    @Override
    public void setScrollable(boolean scrollable) {
        this.mIsScrollable = scrollable;
    }

    @Override
    public boolean isClickable() {
        return this.mIsClickable;
    }

    @Override
    public void setClickable(boolean clickable) {
        this.mIsClickable = clickable;
    }

    @Override
    public void setClearRatingEnabled(boolean enabled) {
        this.mClearRatingEnabled = enabled;
    }

    @Override
    public boolean isClearRatingEnabled() {
        return this.mClearRatingEnabled;
    }

    @Override
    public float getStepSize() {
        return this.mStepSize;
    }

    @Override
    public void setStepSize(@FloatRange(from=0.1, to=1.0) float stepSize) {
        this.mStepSize = stepSize;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return true;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isIndicator()) {
            return false;
        }
        float eventX = event.getX();
        float eventY = event.getY();
        switch (event.getAction()) {
            case 0: {
                this.mStartX = eventX;
                this.mStartY = eventY;
                this.mPreviousRating = this.mRating;
                break;
            }
            case 2: {
                if (!this.isScrollable()) {
                    return false;
                }
                this.handleMoveEvent(eventX);
                break;
            }
            case 1: {
                if (!RatingBarUtils.isClickEvent(this.mStartX, this.mStartY, event) || !this.isClickable()) {
                    return false;
                }
                this.handleClickEvent(eventX);
            }
        }
        this.getParent().requestDisallowInterceptTouchEvent(true);
        return true;
    }

    private void handleMoveEvent(float eventX) {
        for (PartialView partialView : this.mPartialViews) {
            float rating;
            if (eventX < (float)partialView.getWidth() / 10.0f + this.mMinimumStars * (float)partialView.getWidth()) {
                this.setRating(this.mMinimumStars);
                return;
            }
            if (!this.isPositionInRatingView(eventX, (View)partialView) || this.mRating == (rating = RatingBarUtils.calculateRating(partialView, this.mStepSize, eventX))) continue;
            this.setRating(rating);
        }
    }

    private void handleClickEvent(float eventX) {
        for (PartialView partialView : this.mPartialViews) {
            float rating;
            if (!this.isPositionInRatingView(eventX, (View)partialView)) continue;
            float f = rating = this.mStepSize == 1.0f ? (float)((Integer)partialView.getTag()).intValue() : RatingBarUtils.calculateRating(partialView, this.mStepSize, eventX);
            if (this.mPreviousRating == rating && this.isClearRatingEnabled()) {
                this.setRating(this.mMinimumStars);
                break;
            }
            this.setRating(rating);
            break;
        }
    }

    private boolean isPositionInRatingView(float eventX, View ratingView) {
        return eventX > (float)ratingView.getLeft() && eventX < (float)ratingView.getRight();
    }

    public void setOnRatingChangeListener(OnRatingChangeListener onRatingChangeListener) {
        this.mOnRatingChangeListener = onRatingChangeListener;
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.setRating(this.mRating);
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setRating(ss.getRating());
    }

    public static interface OnRatingChangeListener {
        public void onRatingChange(RatingBar var1, float var2);
    }
}

