/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.progress.loading;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.widget.progress.loading.ARCLoadingView;
import com.xuexiang.xui.widget.progress.loading.IMessageLoader;
import com.xuexiang.xui.widget.progress.loading.LoadingCancelListener;

public class LoadingViewLayout
extends LinearLayout
implements IMessageLoader {
    private ARCLoadingView mLoadingView;
    private TextView mTvTipMessage;

    public LoadingViewLayout(@NonNull Context context) {
        super(context);
        this.initView(context);
        this.initAttrs(context, null);
    }

    public LoadingViewLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
        this.initAttrs(context, attrs);
    }

    public LoadingViewLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
        this.initAttrs(context, attrs);
    }

    private void initView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.xui_layout_loading_view, (ViewGroup)this, true);
        this.mLoadingView = (ARCLoadingView)this.findViewById(R.id.arc_loading_view);
        this.mTvTipMessage = (TextView)this.findViewById(R.id.tv_tip_message);
        this.initLayoutStyle(context);
    }

    private void initLayoutStyle(Context context) {
        this.setOrientation(1);
        this.setGravity(17);
        this.setVisibility(8);
        int padding = ThemeUtils.resolveDimension(context, R.attr.xui_dialog_loading_padding_size);
        this.setPadding(padding, padding, padding, padding);
        int minSize = ThemeUtils.resolveDimension(context, R.attr.xui_dialog_loading_min_size);
        this.setMinimumHeight(minSize);
        this.setMinimumWidth(minSize);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        if (null != attrs) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.LoadingViewLayout);
            String message = typedArray.getString(R.styleable.LoadingViewLayout_lvl_message);
            if (!TextUtils.isEmpty((CharSequence)message)) {
                this.updateMessage(message);
            }
            this.setLoadingIcon(ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.LoadingViewLayout_lvl_icon));
            typedArray.recycle();
        }
    }

    @Override
    public void updateMessage(String tipMessage) {
        if (this.mTvTipMessage != null) {
            this.mTvTipMessage.setText((CharSequence)tipMessage);
        }
    }

    @Override
    public void updateMessage(int tipMessageId) {
        this.updateMessage(this.getString(tipMessageId));
    }

    public LoadingViewLayout setLoadingIcon(Drawable icon) {
        if (this.mLoadingView != null) {
            this.mLoadingView.setLoadingIcon(icon);
        }
        return this;
    }

    public LoadingViewLayout setIconScale(float iconScale) {
        if (this.mLoadingView != null) {
            this.mLoadingView.setIconScale(iconScale);
        }
        return this;
    }

    public LoadingViewLayout setLoadingIcon(int iconResId) {
        return this.setLoadingIcon(this.getDrawable(iconResId));
    }

    @Override
    public void show() {
        this.setVisibility(0);
        if (this.mLoadingView != null) {
            this.mLoadingView.start();
        }
    }

    @Override
    public void dismiss() {
        if (this.mLoadingView != null) {
            this.mLoadingView.stop();
        }
        this.setVisibility(8);
    }

    @Override
    public void recycle() {
        if (this.mLoadingView != null) {
            this.mLoadingView.recycle();
        }
    }

    @Override
    public boolean isLoading() {
        return this.getVisibility() == 0;
    }

    @Override
    public void setCancelable(boolean cancelable) {
    }

    @Override
    public void setLoadingCancelListener(LoadingCancelListener listener) {
    }

    public String getString(int resId) {
        return this.getContext().getResources().getString(resId);
    }

    public Drawable getDrawable(int resId) {
        return ResUtils.getDrawable(this.getContext(), resId);
    }
}

