/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.progress.loading;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import com.xuexiang.xui.R;
import com.xuexiang.xui.UIConfig;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.Utils;

public class ARCLoadingView
extends View {
    private static final int DEFAULT_ARC_WIDTH = 6;
    private static final int DEFAULT_SPEED_OF_DEGREE = 5;
    private static final int DEFAULT_ARC_COLOR = Color.parseColor((String)"#299EE3");
    private static final int DEFAULT_ARC_DEGREE = 315;
    private boolean mIsDraw;
    private boolean mIsAutoMode = true;
    private Paint mArcPaint;
    private int mArcWidth;
    private int mArcColor = DEFAULT_ARC_COLOR;
    private RectF mArcRectF;
    private int mStartDegree = 10;
    private float mArcDegree;
    private int mSpeedOfDegree;
    private Bitmap mIconBitmap;
    private float mIconScale;
    private Paint mIconPaint;
    private int[] mGradientColors = new int[]{0, DEFAULT_ARC_COLOR};

    public ARCLoadingView(Context context) {
        super(context);
        this.initAttrs(context, null);
    }

    public ARCLoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
    }

    public ARCLoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        if (null != attrs) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.LoadingView);
            this.mArcColor = typedArray.getColor(R.styleable.LoadingView_lv_color, DEFAULT_ARC_COLOR);
            this.mArcDegree = typedArray.getInt(R.styleable.LoadingView_lv_arc_degree, 315);
            if (this.mArcColor != DEFAULT_ARC_COLOR) {
                this.mGradientColors = new int[]{0, this.mArcColor};
            }
            this.mArcWidth = typedArray.getDimensionPixelSize(R.styleable.LoadingView_lv_width, DensityUtils.dp2px(this.getContext(), 6.0f));
            this.mSpeedOfDegree = typedArray.getInt(R.styleable.LoadingView_lv_speed, 5);
            this.mIsDraw = this.mIsAutoMode = typedArray.getBoolean(R.styleable.LoadingView_lv_auto, true);
            boolean hasIcon = typedArray.getBoolean(R.styleable.LoadingView_lv_has_icon, true);
            if (hasIcon) {
                Drawable icon = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.LoadingView_lv_icon);
                if (icon != null) {
                    this.mIconBitmap = Utils.getBitmapFromDrawable(icon);
                } else {
                    Drawable appIcon = UIConfig.getInstance().getAppIcon();
                    if (appIcon != null) {
                        this.mIconBitmap = Utils.getBitmapFromDrawable(appIcon);
                    }
                }
                this.mIconScale = typedArray.getFloat(R.styleable.LoadingView_lv_icon_scale, 0.5f);
            }
            typedArray.recycle();
        }
        this.initPaint();
    }

    private void initPaint() {
        this.mArcPaint = new Paint();
        this.mArcPaint.setColor(this.mArcColor);
        this.mArcPaint.setAntiAlias(true);
        this.mArcPaint.setStyle(Paint.Style.STROKE);
        this.mArcPaint.setStrokeWidth((float)this.mArcWidth);
        this.mIconPaint = new Paint();
        this.mIconPaint.setColor(this.mArcColor);
        this.mIconPaint.setAntiAlias(true);
        this.mIconPaint.setFilterBitmap(true);
        this.mIconPaint.setStyle(Paint.Style.STROKE);
        this.mIconPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.mArcRectF = new RectF((float)(2 * this.mArcWidth), (float)(2 * this.mArcWidth), (float)(width - 2 * this.mArcWidth), (float)(height - 2 * this.mArcWidth));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.mIsDraw) {
            return;
        }
        this.drawArc(canvas);
        this.invalidate();
    }

    private void drawArc(Canvas canvas) {
        if (this.mIconBitmap != null) {
            canvas.drawBitmap(this.mIconBitmap, null, this.getIconBitmapRectF(this.mIconBitmap), this.mIconPaint);
        }
        this.mArcPaint.setShader((Shader)this.getSweepGradient(canvas));
        canvas.drawArc(this.mArcRectF, (float)this.mStartDegree, this.mArcDegree, false, this.mArcPaint);
        this.mStartDegree += this.mSpeedOfDegree;
        if (this.mStartDegree > 360) {
            this.mStartDegree -= 360;
        }
    }

    public RectF getIconBitmapRectF(Bitmap bitmap) {
        float height;
        float width = bitmap.getWidth();
        if (width >= (height = (float)bitmap.getHeight())) {
            height = (float)this.getWidth() / width * height;
            width = this.getWidth();
        } else {
            width = (float)this.getHeight() / height * width;
            height = this.getHeight();
        }
        float left = ((float)this.getWidth() - width * this.mIconScale) / 2.0f;
        float top = ((float)this.getHeight() - height * this.mIconScale) / 2.0f;
        float right = (float)this.getWidth() - left;
        float bottom = (float)this.getHeight() - top;
        return new RectF(left, top, right, bottom);
    }

    @NonNull
    private SweepGradient getSweepGradient(Canvas canvas) {
        SweepGradient sweepGradient = new SweepGradient((float)(canvas.getWidth() >> 1), (float)(canvas.getHeight() >> 1), this.mGradientColors, null);
        Matrix matrix = new Matrix();
        matrix.setRotate((float)this.mStartDegree, (float)(canvas.getWidth() >> 1), (float)(canvas.getHeight() >> 1));
        sweepGradient.setLocalMatrix(matrix);
        return sweepGradient;
    }

    public ARCLoadingView setLoadingIcon(Drawable icon) {
        if (icon != null) {
            this.mIconBitmap = Utils.getBitmapFromDrawable(icon);
        }
        return this;
    }

    public ARCLoadingView setLoadingIcon(Bitmap iconBitmap) {
        this.mIconBitmap = iconBitmap;
        return this;
    }

    public ARCLoadingView setLoadingColor(int color2) {
        this.mArcColor = color2;
        return this;
    }

    public int getLoadingColor() {
        return this.mArcColor;
    }

    public ARCLoadingView setSpeedOfDegree(int speedOfDegree) {
        this.mSpeedOfDegree = speedOfDegree;
        return this;
    }

    public ARCLoadingView setIconScale(float iconScale) {
        this.mIconScale = iconScale;
        return this;
    }

    public float getIconScale() {
        return this.mIconScale;
    }

    public void start() {
        if (!this.mIsAutoMode) {
            this.mIsDraw = true;
            this.invalidate();
        }
    }

    public void stop() {
        if (!this.mIsAutoMode) {
            this.pause();
        }
    }

    private void pause() {
        this.mIsDraw = false;
        this.invalidate();
    }

    public boolean isStart() {
        return this.mIsDraw;
    }

    public void recycle() {
        this.pause();
        if (this.mIconBitmap != null) {
            this.mIconBitmap.recycle();
            this.mIconBitmap = null;
        }
        this.mArcRectF = null;
        this.mArcPaint = null;
        this.mIconPaint = null;
        this.mGradientColors = null;
    }
}

