/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.popupwindow.status;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.popupwindow.status.SimpleAnimListener;
import com.xuexiang.xui.widget.popupwindow.status.Status;

public class StatusView
extends FrameLayout {
    private static final int DISMISS_ON_COMPLETE_DELAY = 1000;
    private Status mCurrentStatus;
    private boolean mHideOnComplete = true;
    private View mCompleteView;
    private View mErrorView;
    private View mLoadingView;
    private View mCustomView;
    private Animation mSlideOut;
    private Animation mSlideIn;
    private Handler mHandler;
    private Runnable mAutoDismissOnComplete = new Runnable(){

        @Override
        public void run() {
            StatusView.this.exitAnimation(StatusView.this.getCurrentView(StatusView.this.mCurrentStatus));
            StatusView.this.mHandler.removeCallbacks(StatusView.this.mAutoDismissOnComplete);
        }
    };

    public StatusView(Context context) {
        this(context, null);
    }

    public StatusView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.StatusViewStyle);
    }

    public StatusView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs, defStyleAttr);
    }

    public StatusView(Context context, int completeLayout, int errorLayout, int loadingLayout, int customLayout) {
        this(context, null, completeLayout, errorLayout, loadingLayout, customLayout);
    }

    public StatusView(Context context, AttributeSet attrs, int completeLayout, int errorLayout, int loadingLayout, int customLayout) {
        this(context, attrs, R.attr.StatusViewStyle, completeLayout, errorLayout, loadingLayout, customLayout);
    }

    public StatusView(Context context, AttributeSet attrs, int defStyleAttr, int completeLayout, int errorLayout, int loadingLayout, int customLayout) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, completeLayout, errorLayout, loadingLayout, customLayout);
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        this.init(context, attrs, defStyleAttr, 0, 0, 0, 0);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int completeLayout, int errorLayout, int loadingLayout, int customLayout) {
        this.mCurrentStatus = Status.NONE;
        this.mSlideIn = AnimationUtils.loadAnimation((Context)context, (int)R.anim.sv_slide_in);
        this.mSlideOut = AnimationUtils.loadAnimation((Context)context, (int)R.anim.sv_slide_out);
        LayoutInflater inflate = LayoutInflater.from((Context)context);
        this.mHandler = new Handler();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.StatusView, defStyleAttr, 0);
        int completeLayoutId = a.getResourceId(R.styleable.StatusView_sv_complete, 0);
        int errorLayoutId = a.getResourceId(R.styleable.StatusView_sv_error, 0);
        int loadingLayoutId = a.getResourceId(R.styleable.StatusView_sv_loading, 0);
        int customLayoutId = a.getResourceId(R.styleable.StatusView_sv_custom, 0);
        this.mHideOnComplete = a.getBoolean(R.styleable.StatusView_sv_dismissOnComplete, this.mHideOnComplete);
        this.mCompleteView = inflate.inflate(completeLayout != 0 ? completeLayout : completeLayoutId, null);
        this.mErrorView = inflate.inflate(errorLayout != 0 ? errorLayout : errorLayoutId, null);
        this.mLoadingView = inflate.inflate(loadingLayout != 0 ? loadingLayout : loadingLayoutId, null);
        this.mCustomView = inflate.inflate(customLayout != 0 ? customLayout : customLayoutId, null);
        this.mCompleteView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mErrorView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mLoadingView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mCustomView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.addView(this.mCompleteView);
        this.addView(this.mErrorView);
        this.addView(this.mLoadingView);
        this.addView(this.mCustomView);
        this.mCompleteView.setVisibility(4);
        this.mErrorView.setVisibility(4);
        this.mLoadingView.setVisibility(4);
        this.mCustomView.setVisibility(4);
        a.recycle();
    }

    public void setOnErrorClickListener(@NonNull View.OnClickListener onErrorClickListener) {
        this.mErrorView.setOnClickListener(onErrorClickListener);
    }

    public void setOnCustomClickListener(@NonNull View.OnClickListener onErrorClickListener) {
        this.mCustomView.setOnClickListener(onErrorClickListener);
    }

    public void setOnLoadingClickListener(@NonNull View.OnClickListener onLoadingClickListener) {
        this.mLoadingView.setOnClickListener(onLoadingClickListener);
    }

    public void setOnCompleteClickListener(@NonNull View.OnClickListener onCompleteClickListener) {
        this.mCompleteView.setOnClickListener(onCompleteClickListener);
    }

    public View getErrorView() {
        return this.mErrorView;
    }

    public View getCompleteView() {
        return this.mCompleteView;
    }

    public View getLoadingView() {
        return this.mLoadingView;
    }

    public View getCustomView() {
        return this.mCustomView;
    }

    public StatusView setHideOnComplete(boolean hideOnComplete) {
        this.mHideOnComplete = hideOnComplete;
        return this;
    }

    public View setCustomViewTitle(int id2, String title) {
        View view = this.mCustomView.findViewById(id2);
        if (view instanceof TextView) {
            ((TextView)view).setText((CharSequence)title);
        }
        return view;
    }

    public void setStatus(Status status) {
        this.setVisibility(0);
        if (this.mCurrentStatus == Status.NONE) {
            this.mCurrentStatus = status;
            this.enterAnimation(this.getCurrentView(this.mCurrentStatus));
        } else if (status != Status.NONE) {
            this.switchAnimation(this.getCurrentView(this.mCurrentStatus), this.getCurrentView(status));
            this.mCurrentStatus = status;
        } else {
            this.exitAnimation(this.getCurrentView(this.mCurrentStatus));
        }
        this.mHandler.removeCallbacksAndMessages(null);
        if (status == Status.COMPLETE && this.mHideOnComplete) {
            this.mHandler.postDelayed(this.mAutoDismissOnComplete, 1000L);
        }
    }

    public void dismiss() {
        this.setStatus(Status.NONE);
    }

    public Status getStatus() {
        return this.mCurrentStatus;
    }

    private View getCurrentView(Status status) {
        if (status == Status.NONE) {
            return null;
        }
        if (status == Status.COMPLETE) {
            return this.mCompleteView;
        }
        if (status == Status.ERROR) {
            return this.mErrorView;
        }
        if (status == Status.LOADING) {
            return this.mLoadingView;
        }
        if (status == Status.CUSTOM) {
            return this.mCustomView;
        }
        return null;
    }

    private void switchAnimation(final View exitView, final View enterView) {
        this.clearAnimation();
        exitView.setVisibility(0);
        exitView.startAnimation(this.mSlideOut);
        this.mSlideOut.setAnimationListener((Animation.AnimationListener)new SimpleAnimListener(){

            public void onAnimationEnd(Animation animation) {
                StatusView.this.mSlideOut.setAnimationListener(null);
                exitView.setVisibility(4);
                enterView.setVisibility(0);
                enterView.startAnimation(StatusView.this.mSlideIn);
            }
        });
    }

    private void enterAnimation(View enterView) {
        if (enterView == null) {
            return;
        }
        enterView.setVisibility(0);
        enterView.startAnimation(this.mSlideIn);
    }

    private void exitAnimation(final View exitView) {
        if (exitView == null) {
            return;
        }
        exitView.startAnimation(this.mSlideOut);
        this.mSlideOut.setAnimationListener((Animation.AnimationListener)new SimpleAnimListener(){

            public void onAnimationEnd(Animation animation) {
                StatusView.this.mCurrentStatus = Status.NONE;
                exitView.setVisibility(4);
                StatusView.this.mSlideOut.setAnimationListener(null);
                StatusView.this.setVisibility(8);
            }
        });
    }
}

