/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.popupwindow.popup;

import android.content.Context;
import android.graphics.Point;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.popupwindow.popup.XUIBasePopup;

public class XUIPopup
extends XUIBasePopup {
    public static final int ANIM_GROW_FROM_LEFT = 1;
    public static final int ANIM_GROW_FROM_RIGHT = 2;
    public static final int ANIM_GROW_FROM_CENTER = 3;
    public static final int ANIM_AUTO = 4;
    public static final int DIRECTION_TOP = 0;
    public static final int DIRECTION_BOTTOM = 1;
    public static final int DIRECTION_NONE = 2;
    private int mPopupLeftRightMinMargin = 0;
    private int mPopupTopBottomMinMargin = 0;
    protected ImageView mArrowUp;
    protected ImageView mArrowDown;
    protected int mAnimStyle = 4;
    private int mPreferredDirection;
    protected int mDirection;
    protected int mX = -1;
    protected int mY = -1;
    protected int mArrowCenter;
    private int mOffsetX = 0;
    private int mOffsetYWhenTop = 0;
    private int mOffsetYWhenBottom = 0;

    public XUIPopup(Context context) {
        this(context, 2);
    }

    public XUIPopup(Context context, int preferredDirection) {
        super(context);
        this.mDirection = this.mPreferredDirection = preferredDirection;
    }

    public void setPopupLeftRightMinMargin(int popupLeftRightMinMargin) {
        this.mPopupLeftRightMinMargin = popupLeftRightMinMargin;
    }

    public void setPopupTopBottomMinMargin(int popupTopBottomMinMargin) {
        this.mPopupTopBottomMinMargin = popupTopBottomMinMargin;
    }

    public XUIPopup setPositionOffsetX(int offsetX) {
        this.mOffsetX = offsetX;
        return this;
    }

    public XUIPopup setPositionOffsetYWhenTop(int offsetYWhenTop) {
        this.mOffsetYWhenTop = offsetYWhenTop;
        return this;
    }

    public XUIPopup setPositionOffsetYWhenBottom(int offsetYWhenBottom) {
        this.mOffsetYWhenBottom = offsetYWhenBottom;
        return this;
    }

    public XUIPopup setPreferredDirection(int preferredDirection) {
        this.mPreferredDirection = preferredDirection;
        return this;
    }

    @Override
    protected Point onShow(View attachedView) {
        this.calculatePosition(attachedView);
        this.showArrow();
        this.initAnimationStyle(this.mScreenSize.x, this.mArrowCenter);
        int offsetY = 0;
        if (this.mDirection == 0) {
            offsetY = this.mOffsetYWhenTop;
        } else if (this.mDirection == 1) {
            offsetY = this.mOffsetYWhenBottom;
        }
        return new Point(this.mX + this.mOffsetX, this.mY + offsetY);
    }

    private void calculatePosition(View attachedView) {
        if (attachedView != null) {
            int[] attachedViewLocation = new int[2];
            attachedView.getLocationOnScreen(attachedViewLocation);
            this.mArrowCenter = attachedViewLocation[0] + attachedView.getWidth() / 2;
            this.mX = this.mArrowCenter < this.mScreenSize.x / 2 ? (this.mArrowCenter - this.mWindowWidth / 2 > this.mPopupLeftRightMinMargin ? this.mArrowCenter - this.mWindowWidth / 2 : this.mPopupLeftRightMinMargin) : (this.mArrowCenter + this.mWindowWidth / 2 < this.mScreenSize.x - this.mPopupLeftRightMinMargin ? this.mArrowCenter - this.mWindowWidth / 2 : this.mScreenSize.x - this.mPopupLeftRightMinMargin - this.mWindowWidth);
            this.mDirection = this.mPreferredDirection;
            switch (this.mPreferredDirection) {
                case 0: {
                    this.mY = attachedViewLocation[1] - this.mWindowHeight;
                    if (this.mY >= this.mPopupTopBottomMinMargin) break;
                    this.mY = attachedViewLocation[1] + attachedView.getHeight();
                    this.mDirection = 1;
                    break;
                }
                case 1: {
                    this.mY = attachedViewLocation[1] + attachedView.getHeight();
                    if (this.mY <= this.mScreenSize.y - this.mPopupTopBottomMinMargin) break;
                    this.mY = attachedViewLocation[1] - this.mWindowHeight;
                    this.mDirection = 0;
                    break;
                }
                case 2: {
                    this.mY = attachedViewLocation[1];
                }
            }
        } else {
            this.mX = (this.mScreenSize.x - this.mWindowWidth) / 2;
            this.mY = (this.mScreenSize.y - this.mWindowHeight) / 2;
            this.mDirection = 2;
        }
    }

    private void initAnimationStyle(int screenWidth, int requestedX) {
        int arrowPos = requestedX;
        if (this.mArrowUp != null) {
            arrowPos -= this.mArrowUp.getMeasuredWidth() / 2;
        }
        boolean onTop = this.mDirection == 0;
        switch (this.mAnimStyle) {
            case 1: {
                this.getPopupWindow().setAnimationStyle(onTop ? R.style.XUI_Animation_PopUpMenu_Left : R.style.XUI_Animation_PopDownMenu_Left);
                break;
            }
            case 2: {
                this.getPopupWindow().setAnimationStyle(onTop ? R.style.XUI_Animation_PopUpMenu_Right : R.style.XUI_Animation_PopDownMenu_Right);
                break;
            }
            case 3: {
                this.getPopupWindow().setAnimationStyle(onTop ? R.style.XUI_Animation_PopUpMenu_Center : R.style.XUI_Animation_PopDownMenu_Center);
                break;
            }
            case 4: {
                if (arrowPos <= screenWidth / 4) {
                    this.getPopupWindow().setAnimationStyle(onTop ? R.style.XUI_Animation_PopUpMenu_Left : R.style.XUI_Animation_PopDownMenu_Left);
                    break;
                }
                if (arrowPos > screenWidth / 4 && arrowPos < 3 * (screenWidth / 4)) {
                    this.getPopupWindow().setAnimationStyle(onTop ? R.style.XUI_Animation_PopUpMenu_Center : R.style.XUI_Animation_PopDownMenu_Center);
                    break;
                }
                this.getPopupWindow().setAnimationStyle(onTop ? R.style.XUI_Animation_PopUpMenu_Right : R.style.XUI_Animation_PopDownMenu_Right);
            }
        }
    }

    private void showArrow() {
        ImageView showArrow = null;
        switch (this.mDirection) {
            case 1: {
                this.setViewVisibility((View)this.mArrowUp, true);
                this.setViewVisibility((View)this.mArrowDown, false);
                showArrow = this.mArrowUp;
                break;
            }
            case 0: {
                this.setViewVisibility((View)this.mArrowDown, true);
                this.setViewVisibility((View)this.mArrowUp, false);
                showArrow = this.mArrowDown;
                break;
            }
            case 2: {
                this.setViewVisibility((View)this.mArrowDown, false);
                this.setViewVisibility((View)this.mArrowUp, false);
                break;
            }
        }
        if (showArrow != null) {
            int arrowWidth = this.mArrowUp.getMeasuredWidth();
            ViewGroup.MarginLayoutParams param = (ViewGroup.MarginLayoutParams)showArrow.getLayoutParams();
            param.leftMargin = this.mArrowCenter - this.mX - arrowWidth / 2;
        }
    }

    public void setAnimStyle(int animStyle) {
        this.mAnimStyle = animStyle;
    }

    @Override
    public void setContentView(View root) {
        FrameLayout layout2 = (FrameLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.xui_layout_popup, null, false);
        this.mArrowDown = (ImageView)layout2.findViewById(R.id.arrow_down);
        this.mArrowUp = (ImageView)layout2.findViewById(R.id.arrow_up);
        FrameLayout box = (FrameLayout)layout2.findViewById(R.id.box);
        box.addView(root);
        super.setContentView((View)layout2);
    }

    private void setViewVisibility(View view, boolean visible) {
        if (view != null) {
            view.setVisibility(visible ? 0 : 4);
        }
    }

    public ViewGroup.LayoutParams generateLayoutParam(int width, int height) {
        return new FrameLayout.LayoutParams(width, height);
    }
}

