/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview.preview.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ImageView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.Utils;
import com.xuexiang.xui.widget.imageview.photoview.PhotoView;

public class SmoothImageView
extends PhotoView {
    private Status mStatus = Status.STATE_NORMAL;
    private static int TRANSFORM_DURATION = 400;
    private Paint mPaint;
    private Matrix matrix;
    private Transform startTransform;
    private Transform endTransform;
    private Transform animTransform;
    private Rect thumbRect;
    private boolean transformStart;
    private int bitmapWidth;
    private int bitmapHeight;
    private boolean isDrag;
    ValueAnimator animator;
    private float mMaxTransScale = 0.5f;
    private int downX;
    private int downY;
    private boolean isMoved = false;
    private boolean isDownPhoto = false;
    private int alpha = 0;
    private static final int MIN_TRANS_DEST = 5;
    private OnAlphaChangeListener alphaChangeListener;
    private OnTransformOutListener transformOutListener;
    private Transform markTransform;
    private onTransformListener onTransformListener;

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.bitmapWidth = 0;
        this.bitmapHeight = 0;
        this.thumbRect = null;
        this.mPaint = null;
        this.matrix = null;
        this.startTransform = null;
        this.endTransform = null;
        this.animTransform = null;
        if (this.animator != null) {
            this.animator.cancel();
            this.animator.clone();
            this.animator = null;
        }
    }

    private void initSmoothImageView() {
        this.mPaint = new Paint();
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(-16777216);
        this.matrix = new Matrix();
        this.setScaleType(ImageView.ScaleType.FIT_CENTER);
    }

    public boolean checkMinScale() {
        if (this.getScale() != 1.0f) {
            this.setScale(1.0f, true);
            return false;
        }
        return true;
    }

    protected void onDraw(Canvas canvas) {
        if (this.getDrawable() == null) {
            return;
        }
        if (this.mStatus == Status.STATE_OUT || this.mStatus == Status.STATE_IN) {
            if (this.startTransform == null || this.endTransform == null || this.animTransform == null) {
                this.initTransform();
            }
            if (this.animTransform == null) {
                super.onDraw(canvas);
                return;
            }
            this.mPaint.setAlpha(this.animTransform.alpha);
            canvas.drawPaint(this.mPaint);
            int saveCount = canvas.getSaveCount();
            this.matrix.setScale(this.animTransform.scale, this.animTransform.scale);
            float translateX = -((float)this.bitmapWidth * this.animTransform.scale - this.animTransform.width) / 2.0f;
            float translateY = -((float)this.bitmapHeight * this.animTransform.scale - this.animTransform.height) / 2.0f;
            this.matrix.postTranslate(translateX, translateY);
            canvas.translate(this.animTransform.left, this.animTransform.top);
            canvas.clipRect(0.0f, 0.0f, this.animTransform.width, this.animTransform.height);
            canvas.concat(this.matrix);
            this.getDrawable().draw(canvas);
            canvas.restoreToCount(saveCount);
            if (this.transformStart) {
                this.startTransform();
            }
        } else if (this.mStatus == Status.STATE_MOVE) {
            this.mPaint.setAlpha(0);
            canvas.drawPaint(this.mPaint);
            super.onDraw(canvas);
        } else {
            this.mPaint.setAlpha(255);
            canvas.drawPaint(this.mPaint);
            super.onDraw(canvas);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        block24: {
            int action;
            block23: {
                action = event.getAction();
                if (this.getScale() != 1.0f) break block23;
                switch (action) {
                    case 0: {
                        this.downX = (int)event.getX();
                        this.downY = (int)event.getY();
                        if (this.markTransform == null) {
                            this.initTransform();
                        }
                        this.isDownPhoto = false;
                        if (this.markTransform != null) {
                            int startY = (int)this.markTransform.top;
                            int endY = (int)(this.markTransform.height + this.markTransform.top);
                            if (this.downY >= startY && endY >= this.downY) {
                                this.isDownPhoto = true;
                            }
                        }
                        this.isMoved = false;
                        break;
                    }
                    case 2: {
                        boolean s;
                        if (!this.isDownPhoto && event.getPointerCount() == 1) break;
                        int mx = (int)event.getX();
                        int my = (int)event.getY();
                        int offsetX = mx - this.downX;
                        int offsetY = my - this.downY;
                        boolean bl = s = !this.isMoved && (Math.abs(offsetX) > Math.abs(offsetY) || Math.abs(offsetY) < 5);
                        if (s) {
                            return super.dispatchTouchEvent(event);
                        }
                        if (this.isDrag) {
                            return super.dispatchTouchEvent(event);
                        }
                        if (event.getPointerCount() == 1) {
                            this.mStatus = Status.STATE_MOVE;
                            this.offsetLeftAndRight(offsetX);
                            this.offsetTopAndBottom(offsetY);
                            float scale = this.moveScale();
                            float scaleXY = 1.0f - scale * 0.1f;
                            this.setScaleY(scaleXY);
                            this.setScaleX(scaleXY);
                            this.isMoved = true;
                            this.alpha = (int)(255.0f * (1.0f - scale * 0.5f));
                            this.invalidate();
                            if (this.alpha < 0) {
                                this.alpha = 0;
                            }
                            if (this.alphaChangeListener != null) {
                                this.alphaChangeListener.onAlphaChange(this.alpha);
                            }
                            return true;
                        }
                        break block24;
                    }
                    case 1: 
                    case 3: {
                        if (this.isMoved) {
                            if (this.moveScale() <= this.mMaxTransScale) {
                                this.moveToOldPosition();
                            } else {
                                this.changeTransform();
                                this.setTag(R.id.item_image_key, true);
                                if (this.transformOutListener != null) {
                                    this.transformOutListener.onTransformOut();
                                }
                            }
                            return true;
                        }
                        break block24;
                    }
                }
                break block24;
            }
            switch (action) {
                case 1: 
                case 3: {
                    if (!this.isMoved) break;
                    if (this.moveScale() <= this.mMaxTransScale) {
                        this.moveToOldPosition();
                    } else {
                        this.changeTransform();
                        this.setTag(R.id.item_image_key, true);
                        if (this.transformOutListener != null) {
                            this.transformOutListener.onTransformOut();
                        }
                    }
                    return true;
                }
            }
        }
        return super.dispatchTouchEvent(event);
    }

    private void moveToOldPosition() {
        ValueAnimator va = ValueAnimator.ofInt((int[])new int[]{this.getTop(), 0});
        va.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            int startValue = 0;

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (Integer)animation.getAnimatedValue();
                if (this.startValue != 0) {
                    SmoothImageView.this.offsetTopAndBottom(value - this.startValue);
                }
                this.startValue = value;
            }
        });
        ValueAnimator leftAnim = ValueAnimator.ofInt((int[])new int[]{this.getLeft(), 0});
        leftAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            int startValue = 0;

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (Integer)animation.getAnimatedValue();
                if (this.startValue != 0) {
                    SmoothImageView.this.offsetLeftAndRight(value - this.startValue);
                }
                this.startValue = value;
            }
        });
        ValueAnimator alphaAnim = ValueAnimator.ofInt((int[])new int[]{this.alpha, 255});
        alphaAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (SmoothImageView.this.alphaChangeListener != null) {
                    SmoothImageView.this.alphaChangeListener.onAlphaChange((Integer)animation.getAnimatedValue());
                }
            }
        });
        ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{this.getScaleX(), 1.0f});
        scaleAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float scale = ((Float)animation.getAnimatedValue()).floatValue();
                SmoothImageView.this.setScaleX(scale);
                SmoothImageView.this.setScaleY(scale);
            }
        });
        AnimatorSet as = new AnimatorSet();
        as.setDuration((long)TRANSFORM_DURATION);
        as.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        as.playTogether(new Animator[]{va, leftAnim, scaleAnim, alphaAnim});
        as.start();
    }

    private float moveScale() {
        if (this.markTransform == null) {
            this.initTransform();
        }
        return Math.abs((float)this.getTop() / this.markTransform.height);
    }

    public void setTransformOutListener(OnTransformOutListener transformOutListener) {
        this.transformOutListener = transformOutListener;
    }

    public void setAlphaChangeListener(OnAlphaChangeListener alphaChangeListener) {
        this.alphaChangeListener = alphaChangeListener;
    }

    private void changeTransform() {
        if (this.markTransform != null) {
            Transform tempTransform = this.markTransform.clone();
            tempTransform.top = this.markTransform.top + (float)this.getTop();
            tempTransform.left = this.markTransform.left + (float)this.getLeft();
            tempTransform.alpha = this.alpha;
            tempTransform.scale = this.markTransform.scale - (1.0f - this.getScaleX()) * this.markTransform.scale;
            this.animTransform = tempTransform.clone();
            this.endTransform = tempTransform.clone();
        }
    }

    private void startTransform() {
        this.transformStart = false;
        if (this.animTransform == null) {
            return;
        }
        this.animator = new ValueAnimator();
        this.animator.setDuration((long)TRANSFORM_DURATION);
        this.animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        if (this.mStatus == Status.STATE_IN) {
            PropertyValuesHolder scaleHolder = PropertyValuesHolder.ofFloat((String)"animScale", (float[])new float[]{this.startTransform.scale, this.endTransform.scale});
            PropertyValuesHolder alphaHolder = PropertyValuesHolder.ofInt((String)"animAlpha", (int[])new int[]{this.startTransform.alpha, this.endTransform.alpha});
            PropertyValuesHolder leftHolder = PropertyValuesHolder.ofFloat((String)"animLeft", (float[])new float[]{this.startTransform.left, this.endTransform.left});
            PropertyValuesHolder topHolder = PropertyValuesHolder.ofFloat((String)"animTop", (float[])new float[]{this.startTransform.top, this.endTransform.top});
            PropertyValuesHolder widthHolder = PropertyValuesHolder.ofFloat((String)"animWidth", (float[])new float[]{this.startTransform.width, this.endTransform.width});
            PropertyValuesHolder heightHolder = PropertyValuesHolder.ofFloat((String)"animHeight", (float[])new float[]{this.startTransform.height, this.endTransform.height});
            this.animator.setValues(new PropertyValuesHolder[]{scaleHolder, alphaHolder, leftHolder, topHolder, widthHolder, heightHolder});
        } else if (this.mStatus == Status.STATE_OUT) {
            PropertyValuesHolder scaleHolder = PropertyValuesHolder.ofFloat((String)"animScale", (float[])new float[]{this.endTransform.scale, this.startTransform.scale});
            PropertyValuesHolder alphaHolder = PropertyValuesHolder.ofInt((String)"animAlpha", (int[])new int[]{this.endTransform.alpha, this.startTransform.alpha});
            PropertyValuesHolder leftHolder = PropertyValuesHolder.ofFloat((String)"animLeft", (float[])new float[]{this.endTransform.left, this.startTransform.left});
            PropertyValuesHolder topHolder = PropertyValuesHolder.ofFloat((String)"animTop", (float[])new float[]{this.endTransform.top, this.startTransform.top});
            PropertyValuesHolder widthHolder = PropertyValuesHolder.ofFloat((String)"animWidth", (float[])new float[]{this.endTransform.width, this.startTransform.width});
            PropertyValuesHolder heightHolder = PropertyValuesHolder.ofFloat((String)"animHeight", (float[])new float[]{this.endTransform.height, this.startTransform.height});
            this.animator.setValues(new PropertyValuesHolder[]{scaleHolder, alphaHolder, leftHolder, topHolder, widthHolder, heightHolder});
        }
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ((SmoothImageView)SmoothImageView.this).animTransform.alpha = (Integer)animation.getAnimatedValue("animAlpha");
                ((SmoothImageView)SmoothImageView.this).animTransform.scale = ((Float)animation.getAnimatedValue("animScale")).floatValue();
                ((SmoothImageView)SmoothImageView.this).animTransform.left = ((Float)animation.getAnimatedValue("animLeft")).floatValue();
                ((SmoothImageView)SmoothImageView.this).animTransform.top = ((Float)animation.getAnimatedValue("animTop")).floatValue();
                ((SmoothImageView)SmoothImageView.this).animTransform.width = ((Float)animation.getAnimatedValue("animWidth")).floatValue();
                ((SmoothImageView)SmoothImageView.this).animTransform.height = ((Float)animation.getAnimatedValue("animHeight")).floatValue();
                SmoothImageView.this.invalidate();
            }
        });
        this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (SmoothImageView.this.getTag(R.id.item_image_key) != null) {
                    SmoothImageView.this.setTag(R.id.item_image_key, null);
                    SmoothImageView.this.setOnLongClickListener(null);
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (SmoothImageView.this.onTransformListener != null) {
                    SmoothImageView.this.onTransformListener.onTransformCompleted(SmoothImageView.this.mStatus);
                }
                if (SmoothImageView.this.mStatus == Status.STATE_IN) {
                    SmoothImageView.this.mStatus = Status.STATE_NORMAL;
                }
            }
        });
        this.animator.start();
    }

    public void transformIn(onTransformListener listener) {
        this.setOnTransformListener(listener);
        this.transformStart = true;
        this.mStatus = Status.STATE_IN;
        this.invalidate();
    }

    public void transformOut(onTransformListener listener) {
        if (this.getTop() != 0) {
            this.offsetTopAndBottom(-this.getTop());
        }
        if (this.getLeft() != 0) {
            this.offsetLeftAndRight(-this.getLeft());
        }
        if (this.getScaleX() != 1.0f) {
            this.setScaleX(1.0f);
            this.setScaleY(1.0f);
        }
        this.setOnTransformListener(listener);
        this.transformStart = true;
        this.mStatus = Status.STATE_OUT;
        this.invalidate();
    }

    public void setThumbRect(Rect thumbRect) {
        this.thumbRect = thumbRect;
    }

    private void initTransform() {
        float startScaleY;
        Bitmap mBitmap;
        if (this.getDrawable() == null) {
            return;
        }
        if (this.startTransform != null && this.endTransform != null && this.animTransform != null) {
            return;
        }
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        if (this.getDrawable() instanceof BitmapDrawable) {
            mBitmap = ((BitmapDrawable)this.getDrawable()).getBitmap();
            this.bitmapWidth = mBitmap.getWidth();
            this.bitmapHeight = mBitmap.getHeight();
        } else if (this.getDrawable() instanceof ColorDrawable) {
            ColorDrawable colorDrawable = (ColorDrawable)this.getDrawable();
            this.bitmapWidth = colorDrawable.getIntrinsicWidth();
            this.bitmapHeight = colorDrawable.getIntrinsicHeight();
        } else {
            mBitmap = Bitmap.createBitmap((int)this.getDrawable().getIntrinsicWidth(), (int)this.getDrawable().getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            this.bitmapWidth = mBitmap.getWidth();
            this.bitmapHeight = mBitmap.getHeight();
        }
        this.startTransform = new Transform();
        this.startTransform.alpha = 0;
        if (this.thumbRect == null) {
            this.thumbRect = new Rect();
        }
        this.startTransform.left = this.thumbRect.left;
        this.startTransform.top = this.thumbRect.top - Utils.getStatusBarHeight();
        this.startTransform.width = this.thumbRect.width();
        this.startTransform.height = this.thumbRect.height();
        float startScaleX = (float)this.thumbRect.width() / (float)this.bitmapWidth;
        this.startTransform.scale = startScaleX > (startScaleY = (float)this.thumbRect.height() / (float)this.bitmapHeight) ? startScaleX : startScaleY;
        float endScaleX = (float)this.getWidth() / (float)this.bitmapWidth;
        float endScaleY = (float)this.getHeight() / (float)this.bitmapHeight;
        this.endTransform = new Transform();
        this.endTransform.scale = endScaleX < endScaleY ? endScaleX : endScaleY;
        this.endTransform.alpha = 255;
        int endBitmapWidth = (int)(this.endTransform.scale * (float)this.bitmapWidth);
        int endBitmapHeight = (int)(this.endTransform.scale * (float)this.bitmapHeight);
        this.endTransform.left = (this.getWidth() - endBitmapWidth) / 2;
        this.endTransform.top = (this.getHeight() - endBitmapHeight) / 2;
        this.endTransform.width = endBitmapWidth;
        this.endTransform.height = endBitmapHeight;
        if (this.mStatus == Status.STATE_IN) {
            this.animTransform = this.startTransform.clone();
        } else if (this.mStatus == Status.STATE_OUT) {
            this.animTransform = this.endTransform.clone();
        }
        this.markTransform = this.endTransform;
    }

    public void setOnTransformListener(onTransformListener onTransformListener2) {
        this.onTransformListener = onTransformListener2;
    }

    public SmoothImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initSmoothImageView();
    }

    public SmoothImageView(Context context) {
        super(context);
        this.initSmoothImageView();
    }

    public void setDrag(boolean isDrag, float sensitivity) {
        this.isDrag = isDrag;
        this.mMaxTransScale = sensitivity;
    }

    public static void setDuration(int duration) {
        TRANSFORM_DURATION = duration;
    }

    private class Transform
    implements Cloneable {
        float left;
        float top;
        float width;
        float height;
        int alpha;
        float scale;

        private Transform() {
        }

        public Transform clone() {
            Transform obj = null;
            try {
                obj = (Transform)super.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return obj;
        }
    }

    public static interface onTransformListener {
        public void onTransformCompleted(Status var1);
    }

    public static interface OnAlphaChangeListener {
        public void onAlphaChange(int var1);
    }

    public static interface OnTransformOutListener {
        public void onTransformOut();
    }

    public static enum Status {
        STATE_NORMAL,
        STATE_IN,
        STATE_OUT,
        STATE_MOVE;

    }
}

