/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.imageview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.xuexiang.xui.widget.imageview.strategy.IImageLoadStrategy;
import com.xuexiang.xui.widget.imageview.strategy.impl.GlideImageLoadStrategy;

public class ImageLoader
implements IImageLoadStrategy {
    private static volatile ImageLoader sInstance = null;
    private IImageLoadStrategy mStrategy = new GlideImageLoadStrategy();

    private ImageLoader() {
    }

    public ImageLoader setImageLoadStrategy(@NonNull IImageLoadStrategy strategy) {
        this.mStrategy = strategy;
        return this;
    }

    public IImageLoadStrategy getStrategy() {
        return this.mStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageLoader get() {
        if (sInstance != null) return sInstance;
        Class<ImageLoader> clazz = ImageLoader.class;
        synchronized (ImageLoader.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ImageLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path) {
        this.mStrategy.loadImage(imageView, path);
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path) {
        this.mStrategy.loadGifImage(imageView, path);
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path, DiskCacheStrategy strategy) {
        this.mStrategy.loadImage(imageView, path, strategy);
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path, DiskCacheStrategy strategy) {
        this.mStrategy.loadGifImage(imageView, path, strategy);
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path, Drawable placeholder, DiskCacheStrategy strategy) {
        this.mStrategy.loadImage(imageView, path, placeholder, strategy);
    }

    @Override
    public void loadGifImage(@NonNull ImageView imageView, Object path, Drawable placeholder, DiskCacheStrategy strategy) {
        this.mStrategy.loadGifImage(imageView, path, placeholder, strategy);
    }

    @Override
    public void loadImage(@NonNull ImageView imageView, Object path, int width, int height, Drawable placeholder, DiskCacheStrategy strategy) {
        this.mStrategy.loadImage(imageView, path, width, height, placeholder, strategy);
    }

    @Override
    public void clearCache(Context context) {
        this.mStrategy.clearCache(context);
    }

    @Override
    public void clearMemoryCache(Context context) {
        this.mStrategy.clearMemoryCache(context);
    }

    @Override
    public void clearDiskCache(Context context) {
        this.mStrategy.clearDiskCache(context);
    }
}

