/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.guidview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Build;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import com.xuexiang.xui.widget.guidview.Calculator;
import com.xuexiang.xui.widget.guidview.FocusShape;

class GuideImageView
extends AppCompatImageView {
    private static final int DEFAULT_ANIM_COUNTER = 20;
    private Bitmap mBitmap;
    private Paint mBackgroundPaint;
    private Paint mErasePaint;
    private Paint mCircleBorderPaint;
    private int mBackgroundColor = 0;
    private int mFocusBorderColor = 0;
    private int mFocusBorderSize;
    private int mRoundRectRadius = 20;
    private Calculator mCalculator;
    private int mAnimCounter;
    private int mStep = 1;
    private double mAnimMoveFactor = 1.0;
    private boolean mAnimationEnabled = true;
    private Path mPath;
    private RectF rectF;
    private int mFocusAnimationMaxValue;
    private int mFocusAnimationStep;

    public GuideImageView(Context context) {
        super(context);
        this.init();
    }

    public GuideImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public GuideImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(2, null);
        }
        this.setWillNotDraw(false);
        this.setBackgroundColor(0);
        this.mBackgroundPaint = new Paint();
        this.mBackgroundPaint.setAntiAlias(true);
        this.mBackgroundPaint.setColor(this.mBackgroundColor);
        this.mBackgroundPaint.setAlpha(255);
        this.mErasePaint = new Paint();
        this.mErasePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.mErasePaint.setAlpha(255);
        this.mErasePaint.setAntiAlias(true);
        this.mPath = new Path();
        this.mCircleBorderPaint = new Paint();
        this.mCircleBorderPaint.setAntiAlias(true);
        this.mCircleBorderPaint.setColor(this.mFocusBorderColor);
        this.mCircleBorderPaint.setStrokeWidth((float)this.mFocusBorderSize);
        this.mCircleBorderPaint.setStyle(Paint.Style.STROKE);
        this.rectF = new RectF();
    }

    public void setParameters(int backgroundColor, Calculator calculator) {
        this.mBackgroundColor = backgroundColor;
        this.mAnimMoveFactor = 1.0;
        this.mCalculator = calculator;
    }

    public void setBorderParameters(int focusBorderColor, int focusBorderSize) {
        this.mFocusBorderSize = focusBorderSize;
        this.mCircleBorderPaint.setColor(focusBorderColor);
        this.mCircleBorderPaint.setStrokeWidth((float)focusBorderSize);
    }

    public void setRoundRectRadius(int roundRectRadius) {
        this.mRoundRectRadius = roundRectRadius;
    }

    public void setAnimationEnabled(boolean animationEnabled) {
        this.mAnimationEnabled = animationEnabled;
        this.mAnimCounter = this.mAnimationEnabled ? 20 : 0;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mBitmap == null) {
            this.mBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mBitmap.eraseColor(this.mBackgroundColor);
        }
        canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, this.mBackgroundPaint);
        if (this.mCalculator.hasFocus()) {
            if (this.mCalculator.getFocusShape().equals((Object)FocusShape.CIRCLE)) {
                this.drawCircle(canvas);
            } else {
                this.drawRoundedRectangle(canvas);
            }
            if (this.mAnimationEnabled) {
                if (this.mAnimCounter == this.mFocusAnimationMaxValue) {
                    this.mStep = -1 * this.mFocusAnimationStep;
                } else if (this.mAnimCounter == 0) {
                    this.mStep = this.mFocusAnimationStep;
                }
                this.mAnimCounter += this.mStep;
                this.postInvalidate();
            }
        }
    }

    private void drawCircle(Canvas canvas) {
        canvas.drawCircle((float)this.mCalculator.getCircleCenterX(), (float)this.mCalculator.getCircleCenterY(), this.mCalculator.circleRadius(this.mAnimCounter, this.mAnimMoveFactor), this.mErasePaint);
        if (this.mFocusBorderSize > 0) {
            this.mPath.reset();
            this.mPath.moveTo((float)this.mCalculator.getCircleCenterX(), (float)this.mCalculator.getCircleCenterY());
            this.mPath.addCircle((float)this.mCalculator.getCircleCenterX(), (float)this.mCalculator.getCircleCenterY(), this.mCalculator.circleRadius(this.mAnimCounter, this.mAnimMoveFactor), Path.Direction.CW);
            canvas.drawPath(this.mPath, this.mCircleBorderPaint);
        }
    }

    private void drawRoundedRectangle(Canvas canvas) {
        float left = this.mCalculator.roundRectLeft(this.mAnimCounter, this.mAnimMoveFactor);
        float top = this.mCalculator.roundRectTop(this.mAnimCounter, this.mAnimMoveFactor);
        float right = this.mCalculator.roundRectRight(this.mAnimCounter, this.mAnimMoveFactor);
        float bottom = this.mCalculator.roundRectBottom(this.mAnimCounter, this.mAnimMoveFactor);
        this.rectF.set(left, top, right, bottom);
        canvas.drawRoundRect(this.rectF, (float)this.mRoundRectRadius, (float)this.mRoundRectRadius, this.mErasePaint);
        if (this.mFocusBorderSize > 0) {
            this.mPath.reset();
            this.mPath.moveTo((float)this.mCalculator.getCircleCenterX(), (float)this.mCalculator.getCircleCenterY());
            this.mPath.addRoundRect(this.rectF, (float)this.mRoundRectRadius, (float)this.mRoundRectRadius, Path.Direction.CW);
            canvas.drawPath(this.mPath, this.mCircleBorderPaint);
        }
    }

    public void setFocusAnimationParameters(int maxValue, int step) {
        this.mFocusAnimationMaxValue = maxValue;
        this.mFocusAnimationStep = step;
    }
}

