/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.guidview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.AttrRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.StyleRes;
import android.text.Spanned;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.widget.guidview.Calculator;
import com.xuexiang.xui.widget.guidview.DismissListener;
import com.xuexiang.xui.widget.guidview.FocusShape;
import com.xuexiang.xui.widget.guidview.GuideImageView;
import com.xuexiang.xui.widget.guidview.OnViewInflateListener;
import com.xuexiang.xui.widget.guidview.Utils;

public class GuideCaseView
extends FrameLayout
implements ViewTreeObserver.OnGlobalLayoutListener {
    private static final String CONTAINER_TAG = "ShowCaseViewTag";
    private static final String PREF_NAME = "PrefShowCaseView";
    private Activity mActivity;
    private String mTitle;
    private Spanned mSpannedTitle;
    private String mId;
    private double mFocusCircleRadiusFactor;
    private View mView;
    private int mBackgroundColor;
    private int mFocusBorderColor;
    private int mTitleGravity;
    private int mTitleStyle;
    private int mTitleSize;
    private int mTitleSizeUnit;
    private int mPictureResId;
    private int mPictureWidth;
    private int mPictureHeight;
    private int mCustomViewRes;
    private int mFocusBorderSize;
    private int mRoundRectRadius;
    private OnViewInflateListener mViewInflateListener;
    private Animation mEnterAnimation;
    private Animation mExitAnimation;
    private boolean mCloseOnTouch;
    private boolean mFitSystemWindows;
    private int mAdjustHeight;
    private FocusShape mFocusShape;
    private DismissListener mDismissListener;
    private int mAnimationDuration = 400;
    private int mFocusAnimationMaxValue;
    private int mFocusAnimationStep;
    private int mCenterX;
    private int mCenterY;
    private ViewGroup mRoot;
    private SharedPreferences mSharedPreferences;
    private Calculator mCalculator;
    private int mFocusPositionX;
    private int mFocusPositionY;
    private int mFocusCircleRadius;
    private int mFocusRectangleWidth;
    private int mFocusRectangleHeight;
    private boolean mFocusAnimationEnabled;

    GuideCaseView(@NonNull Context context) {
        super(context);
    }

    GuideCaseView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    GuideCaseView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    GuideCaseView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public static void setShowOnce(Context context, String id2) {
        SharedPreferences sharedPrefs = context.getSharedPreferences(PREF_NAME, 0);
        sharedPrefs.edit().putBoolean(id2, true).apply();
    }

    public static boolean isShowOnce(Context context, String id2) {
        SharedPreferences sharedPrefs = context.getSharedPreferences(PREF_NAME, 0);
        return sharedPrefs.getBoolean(id2, false);
    }

    public static void resetShowOnce(Context context, String id2) {
        SharedPreferences sharedPrefs = context.getSharedPreferences(PREF_NAME, 0);
        sharedPrefs.edit().remove(id2).apply();
    }

    public static void resetAllShowOnce(Context context) {
        SharedPreferences sharedPrefs = context.getSharedPreferences(PREF_NAME, 0);
        sharedPrefs.edit().clear().apply();
    }

    public GuideCaseView(Builder builder) {
        this(builder.mActivity, builder.mView, builder.mId, builder.mTitle, builder.mSpannedTitle, builder.mTitleGravity, builder.mTitleStyle, builder.mTitleSize, builder.mTitleSizeUnit, builder.mFocusCircleRadiusFactor, builder.mBackgroundColor, builder.mFocusBorderColor, builder.mFocusBorderSize, builder.mCustomViewRes, builder.mViewInflateListener, builder.mEnterAnimation, builder.mExitAnimation, builder.mCloseOnTouch, builder.mFitSystemWindows, builder.mAdjustHeight, builder.mFocusShape, builder.mDismissListener, builder.mRoundRectRadius, builder.mPictureResId, builder.mPictureWidth, builder.mPictureHeight, builder.mFocusPositionX, builder.mFocusPositionY, builder.mFocusCircleRadius, builder.mFocusRectangleWidth, builder.mFocusRectangleHeight, builder.mFocusAnimationEnabled, builder.mFocusAnimationMaxValue, builder.mFocusAnimationStep);
    }

    private GuideCaseView(Activity activity, View view, String id2, String title, Spanned spannedTitle, int titleGravity, int titleStyle, int titleSize, int titleSizeUnit, double focusCircleRadiusFactor, int backgroundColor, int focusBorderColor, int focusBorderSize, int customViewRes, OnViewInflateListener viewInflateListener, Animation enterAnimation, Animation exitAnimation, boolean closeOnTouch, boolean fitSystemWindows, int adjustHeight, FocusShape focusShape, DismissListener dismissListener, int roundRectRadius, int pictureResId, int pictureWidth, int pictureHeight, int focusPositionX, int focusPositionY, int focusCircleRadius, int focusRectangleWidth, int focusRectangleHeight, boolean animationEnabled, int focusAnimationMaxValue, int focusAnimationStep) {
        super((Context)activity);
        this.mId = id2;
        this.mActivity = activity;
        this.mView = view;
        this.mTitle = title;
        this.mSpannedTitle = spannedTitle;
        this.mFocusCircleRadiusFactor = focusCircleRadiusFactor;
        this.mBackgroundColor = backgroundColor;
        this.mFocusBorderColor = focusBorderColor;
        this.mFocusBorderSize = focusBorderSize;
        this.mTitleGravity = titleGravity;
        this.mTitleStyle = titleStyle;
        this.mTitleSize = titleSize;
        this.mTitleSizeUnit = titleSizeUnit;
        this.mRoundRectRadius = roundRectRadius;
        this.mPictureResId = pictureResId;
        this.mPictureWidth = pictureWidth;
        this.mPictureHeight = pictureHeight;
        this.mCustomViewRes = customViewRes;
        this.mViewInflateListener = viewInflateListener;
        this.mEnterAnimation = enterAnimation;
        this.mExitAnimation = exitAnimation;
        this.mCloseOnTouch = closeOnTouch;
        this.mFitSystemWindows = fitSystemWindows;
        this.mAdjustHeight = adjustHeight;
        this.mFocusShape = focusShape;
        this.mDismissListener = dismissListener;
        this.mFocusPositionX = focusPositionX;
        this.mFocusPositionY = focusPositionY;
        this.mFocusCircleRadius = focusCircleRadius;
        this.mFocusRectangleWidth = focusRectangleWidth;
        this.mFocusRectangleHeight = focusRectangleHeight;
        this.mFocusAnimationEnabled = animationEnabled;
        this.mFocusAnimationMaxValue = focusAnimationMaxValue;
        this.mFocusAnimationStep = focusAnimationStep;
        this.initializeParameters();
    }

    private void initializeParameters() {
        this.mBackgroundColor = this.mBackgroundColor != 0 ? this.mBackgroundColor : this.mActivity.getResources().getColor(R.color.default_guide_case_view_background_color);
        this.mTitleGravity = this.mTitleGravity >= 0 ? this.mTitleGravity : 17;
        this.mTitleStyle = this.mTitleStyle != 0 ? this.mTitleStyle : R.style.DefaultGuideCaseTitleStyle;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.mActivity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        int deviceWidth = displayMetrics.widthPixels;
        int deviceHeight = displayMetrics.heightPixels;
        this.mCenterX = deviceWidth / 2;
        this.mCenterY = deviceHeight / 2;
        this.mSharedPreferences = this.mActivity.getSharedPreferences(PREF_NAME, 0);
    }

    public void show() {
        if (this.mActivity == null || this.mId != null && this.isShownBefore()) {
            if (this.mDismissListener != null) {
                this.mDismissListener.onSkipped(this.mId);
            }
            return;
        }
        if (this.mView != null) {
            if (this.mView.getWidth() == 0 && this.mView.getHeight() == 0) {
                this.mView.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                this.focus();
            }
        } else {
            this.focus();
        }
    }

    private void focus() {
        this.mCalculator = new Calculator(this.mActivity, this.mFocusShape, this.mView, this.mFocusCircleRadiusFactor, this.mFitSystemWindows, this.mAdjustHeight);
        ViewGroup androidContent = (ViewGroup)this.mActivity.findViewById(0x1020002);
        this.mRoot = (ViewGroup)androidContent.getParent().getParent();
        GuideCaseView visibleView = (GuideCaseView)this.mRoot.findViewWithTag((Object)CONTAINER_TAG);
        this.setClickable(true);
        if (visibleView == null) {
            this.setTag(CONTAINER_TAG);
            if (this.mCloseOnTouch) {
                this.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        GuideCaseView.this.hide();
                    }
                });
            }
            this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this.mRoot.addView((View)this);
            GuideImageView imageView = new GuideImageView((Context)this.mActivity);
            imageView.setFocusAnimationParameters(this.mFocusAnimationMaxValue, this.mFocusAnimationStep);
            if (this.mCalculator.hasFocus()) {
                this.mCenterX = this.mCalculator.getCircleCenterX();
                this.mCenterY = this.mCalculator.getCircleCenterY();
            }
            imageView.setParameters(this.mBackgroundColor, this.mCalculator);
            if (this.mFocusRectangleWidth > 0 && this.mFocusRectangleHeight > 0) {
                this.mCalculator.setRectPosition(this.mFocusPositionX, this.mFocusPositionY, this.mFocusRectangleWidth, this.mFocusRectangleHeight);
            }
            if (this.mFocusCircleRadius > 0) {
                this.mCalculator.setCirclePosition(this.mFocusPositionX, this.mFocusPositionY, this.mFocusCircleRadius);
            }
            imageView.setAnimationEnabled(this.mFocusAnimationEnabled);
            imageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            if (this.mFocusBorderColor != 0 && this.mFocusBorderSize > 0) {
                imageView.setBorderParameters(this.mFocusBorderColor, this.mFocusBorderSize);
            }
            if (this.mRoundRectRadius > 0) {
                imageView.setRoundRectRadius(this.mRoundRectRadius);
            }
            this.addView((View)imageView);
            if (this.mCustomViewRes == 0) {
                if (this.mPictureResId == 0) {
                    this.inflateTitleView();
                } else {
                    this.inflatePicture();
                }
            } else {
                this.inflateCustomView(this.mCustomViewRes, this.mViewInflateListener);
            }
            this.startEnterAnimation();
            this.writeShown();
        }
    }

    public static Boolean isVisible(Activity activity) {
        ViewGroup androidContent = (ViewGroup)activity.findViewById(0x1020002);
        ViewGroup mRoot = (ViewGroup)androidContent.getParent().getParent();
        GuideCaseView mContainer = (GuideCaseView)mRoot.findViewWithTag((Object)CONTAINER_TAG);
        return mContainer != null;
    }

    public static void hideCurrent(Activity activity) {
        ViewGroup androidContent = (ViewGroup)activity.findViewById(0x1020002);
        ViewGroup mRoot = (ViewGroup)androidContent.getParent().getParent();
        GuideCaseView mContainer = (GuideCaseView)mRoot.findViewWithTag((Object)CONTAINER_TAG);
        mContainer.hide();
    }

    private void startEnterAnimation() {
        if (this.mEnterAnimation != null) {
            this.startAnimation(this.mEnterAnimation);
        } else if (Utils.shouldShowCircularAnimation()) {
            this.doCircularEnterAnimation();
        } else {
            Animation fadeInAnimation = AnimationUtils.loadAnimation((Context)this.mActivity, (int)R.anim.gcv_fade_in);
            fadeInAnimation.setFillAfter(true);
            this.startAnimation(fadeInAnimation);
        }
    }

    public void hide() {
        if (this.mExitAnimation != null) {
            this.startAnimation(this.mExitAnimation);
        } else if (Utils.shouldShowCircularAnimation()) {
            this.doCircularExitAnimation();
        } else {
            Animation fadeOut = AnimationUtils.loadAnimation((Context)this.mActivity, (int)R.anim.gcv_fade_out);
            fadeOut.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    GuideCaseView.this.removeView();
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            fadeOut.setFillAfter(true);
            this.startAnimation(fadeOut);
        }
    }

    private void inflateCustomView(@LayoutRes int layout2, OnViewInflateListener viewInflateListener) {
        View view = this.mActivity.getLayoutInflater().inflate(layout2, (ViewGroup)this, false);
        this.addView(view);
        if (viewInflateListener != null) {
            viewInflateListener.onViewInflated(view);
        }
    }

    private void inflateTitleView() {
        this.inflateCustomView(R.layout.gcv_layout_title, new OnViewInflateListener(){

            @Override
            public void onViewInflated(View view) {
                TextView textView = (TextView)view.findViewById(R.id.gcv_title);
                if (Build.VERSION.SDK_INT >= 23) {
                    textView.setTextAppearance(GuideCaseView.this.mTitleStyle);
                } else {
                    textView.setTextAppearance((Context)GuideCaseView.this.mActivity, GuideCaseView.this.mTitleStyle);
                }
                if (GuideCaseView.this.mTitleSize != -1) {
                    textView.setTextSize(GuideCaseView.this.mTitleSizeUnit, (float)GuideCaseView.this.mTitleSize);
                }
                textView.setGravity(GuideCaseView.this.mTitleGravity);
                textView.setTypeface(XUI.getDefaultTypeface());
                if (GuideCaseView.this.mSpannedTitle != null) {
                    textView.setText((CharSequence)GuideCaseView.this.mSpannedTitle);
                } else {
                    textView.setText((CharSequence)GuideCaseView.this.mTitle);
                }
            }
        });
    }

    private void inflatePicture() {
        this.inflateCustomView(R.layout.gcv_layout_image, new OnViewInflateListener(){

            @Override
            public void onViewInflated(View view) {
                ImageView imageView = (ImageView)view.findViewById(R.id.gcv_img);
                imageView.setImageResource(GuideCaseView.this.mPictureResId);
                if (GuideCaseView.this.mPictureHeight != 0 || GuideCaseView.this.mPictureWidth != 0) {
                    ViewGroup.LayoutParams params = imageView.getLayoutParams();
                    if (GuideCaseView.this.mPictureHeight != 0) {
                        params.height = GuideCaseView.this.mPictureHeight;
                    }
                    if (GuideCaseView.this.mPictureWidth != 0) {
                        params.width = GuideCaseView.this.mPictureWidth;
                    }
                    imageView.setLayoutParams(params);
                }
            }
        });
    }

    @RequiresApi(api=21)
    private void doCircularEnterAnimation() {
        this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                GuideCaseView.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                int revealRadius = (int)Math.hypot(GuideCaseView.this.getWidth(), GuideCaseView.this.getHeight());
                int startRadius = 0;
                if (GuideCaseView.this.mView != null) {
                    startRadius = GuideCaseView.this.mView.getWidth() / 2;
                } else if (GuideCaseView.this.mFocusCircleRadius > 0 || GuideCaseView.this.mFocusRectangleWidth > 0 || GuideCaseView.this.mFocusRectangleHeight > 0) {
                    GuideCaseView.this.mCenterX = GuideCaseView.this.mFocusPositionX;
                    GuideCaseView.this.mCenterY = GuideCaseView.this.mFocusPositionY;
                }
                Animator enterAnimator = ViewAnimationUtils.createCircularReveal((View)GuideCaseView.this, (int)GuideCaseView.this.mCenterX, (int)GuideCaseView.this.mCenterY, (float)startRadius, (float)revealRadius);
                enterAnimator.setDuration((long)GuideCaseView.this.mAnimationDuration);
                enterAnimator.setInterpolator((TimeInterpolator)AnimationUtils.loadInterpolator((Context)GuideCaseView.this.mActivity, (int)17563650));
                enterAnimator.start();
                return false;
            }
        });
    }

    @TargetApi(value=21)
    private void doCircularExitAnimation() {
        int revealRadius = (int)Math.hypot(this.getWidth(), this.getHeight());
        Animator exitAnimator = ViewAnimationUtils.createCircularReveal((View)this, (int)this.mCenterX, (int)this.mCenterY, (float)revealRadius, (float)0.0f);
        exitAnimator.setDuration((long)this.mAnimationDuration);
        exitAnimator.setInterpolator((TimeInterpolator)AnimationUtils.loadInterpolator((Context)this.mActivity, (int)17563651));
        exitAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                GuideCaseView.this.removeView();
            }
        });
        exitAnimator.start();
    }

    private void writeShown() {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putBoolean(this.mId, true);
        editor.apply();
    }

    public boolean isShownBefore() {
        return this.mSharedPreferences.getBoolean(this.mId, false);
    }

    public void removeView() {
        this.mRoot.removeView((View)this);
        if (this.mDismissListener != null) {
            this.mDismissListener.onDismiss(this.mId);
        }
    }

    protected DismissListener getDismissListener() {
        return this.mDismissListener;
    }

    protected void setDismissListener(DismissListener dismissListener) {
        this.mDismissListener = dismissListener;
    }

    public void onGlobalLayout() {
        if (Build.VERSION.SDK_INT < 16) {
            this.mView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        } else {
            this.mView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.focus();
    }

    public int getFocusCenterX() {
        return this.mCalculator.getCircleCenterX();
    }

    public int getFocusCenterY() {
        return this.mCalculator.getCircleCenterY();
    }

    public float getFocusRadius() {
        return FocusShape.CIRCLE.equals((Object)this.mFocusShape) ? this.mCalculator.circleRadius(0, 1.0) : 0.0f;
    }

    public int getFocusWidth() {
        return this.mCalculator.getFocusWidth();
    }

    public int getFocusHeight() {
        return this.mCalculator.getFocusHeight();
    }

    public static class Builder {
        private Activity mActivity;
        private View mView;
        private String mId;
        private String mTitle;
        private Spanned mSpannedTitle;
        private double mFocusCircleRadiusFactor = 1.0;
        private int mBackgroundColor;
        private int mFocusBorderColor;
        private int mTitleGravity = -1;
        private int mTitleSize = -1;
        private int mTitleSizeUnit = -1;
        private int mTitleStyle;
        private int mPictureResId;
        private int mPictureWidth;
        private int mPictureHeight;
        private int mCustomViewRes;
        private int mRoundRectRadius;
        private OnViewInflateListener mViewInflateListener;
        private Animation mEnterAnimation;
        private Animation mExitAnimation;
        private boolean mCloseOnTouch = true;
        private boolean mFitSystemWindows;
        private int mAdjustHeight = -1;
        private FocusShape mFocusShape = FocusShape.CIRCLE;
        private DismissListener mDismissListener = null;
        private int mFocusBorderSize;
        private int mFocusPositionX;
        private int mFocusPositionY;
        private int mFocusCircleRadius;
        private int mFocusRectangleWidth;
        private int mFocusRectangleHeight;
        private boolean mFocusAnimationEnabled = true;
        private int mFocusAnimationMaxValue = 20;
        private int mFocusAnimationStep = 1;

        public Builder(Activity activity) {
            this.mActivity = activity;
        }

        public Builder title(String title) {
            this.mTitle = title;
            this.mSpannedTitle = null;
            return this;
        }

        public Builder title(Spanned title) {
            this.mSpannedTitle = title;
            this.mTitle = null;
            return this;
        }

        public Builder picture(int pictureResId) {
            this.mPictureResId = pictureResId;
            return this;
        }

        public Builder picture(int pictureResId, int width, int height) {
            this.mPictureResId = pictureResId;
            this.mPictureWidth = width;
            this.mPictureHeight = height;
            return this;
        }

        public Builder titleStyle(@StyleRes int style2, int titleGravity) {
            this.mTitleGravity = titleGravity;
            this.mTitleStyle = style2;
            return this;
        }

        public Builder focusBorderColor(int focusBorderColor) {
            this.mFocusBorderColor = focusBorderColor;
            return this;
        }

        public Builder focusBorderSize(int focusBorderSize) {
            this.mFocusBorderSize = focusBorderSize;
            return this;
        }

        public Builder titleGravity(int titleGravity) {
            this.mTitleGravity = titleGravity;
            return this;
        }

        public Builder titleSize(int titleSize, int unit) {
            this.mTitleSize = titleSize;
            this.mTitleSizeUnit = unit;
            return this;
        }

        public Builder showOnce(String id2) {
            this.mId = id2;
            return this;
        }

        public Builder focusOn(View view) {
            this.mView = view;
            return this;
        }

        public Builder backgroundColor(int backgroundColor) {
            this.mBackgroundColor = backgroundColor;
            return this;
        }

        public Builder focusCircleRadiusFactor(double focusCircleRadiusFactor) {
            this.mFocusCircleRadiusFactor = focusCircleRadiusFactor;
            return this;
        }

        public Builder customView(@LayoutRes int layoutResource, @Nullable OnViewInflateListener listener) {
            this.mCustomViewRes = layoutResource;
            this.mViewInflateListener = listener;
            return this;
        }

        public Builder enterAnimation(Animation enterAnimation) {
            this.mEnterAnimation = enterAnimation;
            return this;
        }

        public Builder exitAnimation(Animation exitAnimation) {
            this.mExitAnimation = exitAnimation;
            return this;
        }

        public Builder closeOnTouch(boolean closeOnTouch) {
            this.mCloseOnTouch = closeOnTouch;
            return this;
        }

        public Builder fitSystemWindows(boolean fitSystemWindows) {
            this.mFitSystemWindows = fitSystemWindows;
            return this;
        }

        public Builder fitWindowsAuto() {
            if (Build.VERSION.SDK_INT >= 21) {
                this.mFitSystemWindows = true;
            } else {
                this.adjustHeight(0);
            }
            return this;
        }

        public Builder adjustHeight(int adjustHeight) {
            this.mAdjustHeight = adjustHeight;
            return this;
        }

        public Builder focusShape(FocusShape focusShape) {
            this.mFocusShape = focusShape;
            return this;
        }

        public Builder focusRectAtPosition(int positionX, int positionY, int positionWidth, int positionHeight) {
            this.mFocusPositionX = positionX;
            this.mFocusPositionY = positionY;
            this.mFocusRectangleWidth = positionWidth;
            this.mFocusRectangleHeight = positionHeight;
            return this;
        }

        public Builder focusCircleAtPosition(int positionX, int positionY, int radius) {
            this.mFocusPositionX = positionX;
            this.mFocusPositionY = positionY;
            this.mFocusCircleRadius = radius;
            return this;
        }

        public Builder dismissListener(DismissListener dismissListener) {
            this.mDismissListener = dismissListener;
            return this;
        }

        public Builder roundRectRadius(int roundRectRadius) {
            this.mRoundRectRadius = roundRectRadius;
            return this;
        }

        public Builder disableFocusAnimation() {
            this.mFocusAnimationEnabled = false;
            return this;
        }

        public Builder focusAnimationMaxValue(int focusAnimationMaxValue) {
            this.mFocusAnimationMaxValue = focusAnimationMaxValue;
            return this;
        }

        public Builder focusAnimationStep(int focusAnimationStep) {
            this.mFocusAnimationStep = focusAnimationStep;
            return this;
        }

        public GuideCaseView build() {
            return new GuideCaseView(this);
        }
    }
}

