/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.grouplist;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.utils.ViewUtils;
import com.xuexiang.xui.widget.grouplist.XUICommonListItemView;
import com.xuexiang.xui.widget.grouplist.XUIGroupListSectionHeaderFooterView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class XUIGroupListView
extends LinearLayout {
    public static final int SEPARATOR_STYLE_NORMAL = 0;
    public static final int SEPARATOR_STYLE_NONE = 1;
    private int mSeparatorStyle;
    private SparseArray<Section> mSections;

    public XUIGroupListView(Context context) {
        this(context, null, R.attr.XUIGroupListViewStyle);
    }

    public XUIGroupListView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.XUIGroupListViewStyle);
    }

    public XUIGroupListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.XUIGroupListView, defStyleAttr, 0);
        this.mSeparatorStyle = array.getInt(R.styleable.XUIGroupListView_xui_separatorStyle, 0);
        array.recycle();
        this.mSections = new SparseArray();
        this.setOrientation(1);
    }

    public static Section newSection(Context context) {
        return new Section(context);
    }

    public int getSeparatorStyle() {
        return this.mSeparatorStyle;
    }

    public void setSeparatorStyle(int separatorStyle) {
        this.mSeparatorStyle = separatorStyle;
    }

    public int getSectionCount() {
        return this.mSections.size();
    }

    public XUICommonListItemView createItemView(Drawable imageDrawable, CharSequence titleText, String detailText, int orientation, int accessoryType, int height) {
        XUICommonListItemView itemView = new XUICommonListItemView(this.getContext());
        itemView.setOrientation(orientation);
        itemView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, height));
        itemView.setImageDrawable(imageDrawable);
        itemView.setText(titleText);
        itemView.setDetailText(detailText);
        itemView.setAccessoryType(accessoryType);
        return itemView;
    }

    public XUICommonListItemView createItemView(Drawable imageDrawable, CharSequence titleText, String detailText, int orientation, int accessoryType) {
        if (orientation == 0) {
            int height = ThemeUtils.resolveDimension(this.getContext(), R.attr.xui_list_item_height_higher);
            return this.createItemView(imageDrawable, titleText, detailText, orientation, accessoryType, height);
        }
        int height = ThemeUtils.resolveDimension(this.getContext(), R.attr.xui_list_item_height);
        return this.createItemView(imageDrawable, titleText, detailText, orientation, accessoryType, height);
    }

    public XUICommonListItemView createItemView(CharSequence titleText) {
        return this.createItemView(null, titleText, null, 1, 0);
    }

    public XUICommonListItemView createItemView(int orientation) {
        return this.createItemView(null, null, null, orientation, 0);
    }

    private void addSection(Section section) {
        this.mSections.append(this.mSections.size(), (Object)section);
    }

    private void removeSection(Section section) {
        for (int i = 0; i < this.mSections.size(); ++i) {
            Section each = (Section)this.mSections.valueAt(i);
            if (each != section) continue;
            this.mSections.remove(i);
        }
    }

    public Section getSection(int index) {
        return (Section)this.mSections.get(index);
    }

    public static class Section {
        private Context mContext;
        private XUIGroupListSectionHeaderFooterView mTitleView;
        private XUIGroupListSectionHeaderFooterView mDescriptionView;
        private SparseArray<XUICommonListItemView> mItemViews;
        private boolean mUseDefaultTitleIfNone;
        private boolean mUseTitleViewForSectionSpace = true;
        private int mSeparatorDrawableForSingle = 0;
        private int mSeparatorDrawableForTop = 0;
        private int mSeparatorDrawableForBottom = 0;
        private int mSeparatorDrawableForMiddle = 0;
        private int mLeftIconWidth = -2;
        private int mLeftIconHeight = -2;

        public Section(Context context) {
            this.mContext = context;
            this.mItemViews = new SparseArray();
        }

        public Section addItemView(XUICommonListItemView itemView, View.OnClickListener onClickListener) {
            return this.addItemView(itemView, onClickListener, null);
        }

        public Section addItemView(final XUICommonListItemView itemView, View.OnClickListener onClickListener, View.OnLongClickListener onLongClickListener) {
            if (itemView.getAccessoryType() == 2) {
                itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        itemView.getSwitch().toggle();
                    }
                });
            } else if (onClickListener != null) {
                itemView.setOnClickListener(onClickListener);
            }
            if (onLongClickListener != null) {
                itemView.setOnLongClickListener(onLongClickListener);
            }
            this.mItemViews.append(this.mItemViews.size(), (Object)itemView);
            return this;
        }

        public Section setTitle(CharSequence title) {
            this.mTitleView = this.createSectionHeader(title);
            return this;
        }

        public Section setDescription(CharSequence description) {
            this.mDescriptionView = this.createSectionFooter(description);
            return this;
        }

        public Section setUseDefaultTitleIfNone(boolean useDefaultTitleIfNone) {
            this.mUseDefaultTitleIfNone = useDefaultTitleIfNone;
            return this;
        }

        public Section setUseTitleViewForSectionSpace(boolean useTitleViewForSectionSpace) {
            this.mUseTitleViewForSectionSpace = useTitleViewForSectionSpace;
            return this;
        }

        public Section setSeparatorDrawableRes(int single, int top, int bottom, int middle) {
            this.mSeparatorDrawableForSingle = single;
            this.mSeparatorDrawableForTop = top;
            this.mSeparatorDrawableForBottom = bottom;
            this.mSeparatorDrawableForMiddle = middle;
            return this;
        }

        public Section setSeparatorDrawableRes(int middle) {
            this.mSeparatorDrawableForMiddle = middle;
            return this;
        }

        public Section setLeftIconSize(int width, int height) {
            this.mLeftIconHeight = height;
            this.mLeftIconWidth = width;
            return this;
        }

        public void addTo(XUIGroupListView groupListView) {
            if (this.mTitleView == null) {
                if (this.mUseDefaultTitleIfNone) {
                    this.setTitle("Section " + groupListView.getSectionCount());
                } else if (this.mUseTitleViewForSectionSpace) {
                    this.setTitle("");
                }
            }
            if (this.mTitleView != null) {
                groupListView.addView((View)this.mTitleView);
            }
            if (groupListView.getSeparatorStyle() == 0) {
                if (this.mSeparatorDrawableForSingle == 0) {
                    this.mSeparatorDrawableForSingle = R.drawable.xui_list_item_bg_with_border_double_selector;
                }
                if (this.mSeparatorDrawableForTop == 0) {
                    this.mSeparatorDrawableForTop = R.drawable.xui_list_item_bg_with_border_double_selector;
                }
                if (this.mSeparatorDrawableForBottom == 0) {
                    this.mSeparatorDrawableForBottom = R.drawable.xui_list_item_bg_with_border_bottom_selector;
                }
                if (this.mSeparatorDrawableForMiddle == 0) {
                    this.mSeparatorDrawableForMiddle = R.drawable.xui_list_item_bg_with_border_bottom_selector;
                }
            }
            int itemViewCount = this.mItemViews.size();
            XUICommonListItemView.LayoutParamConfig leftIconLpConfig = new XUICommonListItemView.LayoutParamConfig(){

                @Override
                public RelativeLayout.LayoutParams onConfig(RelativeLayout.LayoutParams lp) {
                    lp.width = Section.this.mLeftIconWidth;
                    lp.height = Section.this.mLeftIconHeight;
                    return lp;
                }
            };
            for (int i = 0; i < itemViewCount; ++i) {
                XUICommonListItemView itemView = (XUICommonListItemView)((Object)this.mItemViews.get(i));
                int resDrawableId = groupListView.getSeparatorStyle() == 0 ? (itemViewCount == 1 ? this.mSeparatorDrawableForSingle : (i == 0 ? this.mSeparatorDrawableForTop : (i == itemViewCount - 1 ? this.mSeparatorDrawableForBottom : this.mSeparatorDrawableForMiddle))) : R.drawable.xui_list_item_bg_with_border_none_selector;
                itemView.updateImageViewLp(leftIconLpConfig);
                ViewUtils.setBackgroundKeepingPadding((View)itemView, resDrawableId);
                groupListView.addView((View)itemView);
            }
            if (this.mDescriptionView != null) {
                groupListView.addView((View)this.mDescriptionView);
            }
            groupListView.addSection(this);
        }

        public void removeFrom(XUIGroupListView parent) {
            if (this.mTitleView != null && this.mTitleView.getParent() == parent) {
                parent.removeView((View)this.mTitleView);
            }
            for (int i = 0; i < this.mItemViews.size(); ++i) {
                XUICommonListItemView itemView = (XUICommonListItemView)((Object)this.mItemViews.get(i));
                parent.removeView((View)itemView);
            }
            if (this.mDescriptionView != null && this.mDescriptionView.getParent() == parent) {
                parent.removeView((View)this.mDescriptionView);
            }
            parent.removeSection(this);
        }

        public XUIGroupListSectionHeaderFooterView createSectionHeader(CharSequence titleText) {
            return new XUIGroupListSectionHeaderFooterView(this.mContext, titleText);
        }

        public XUIGroupListSectionHeaderFooterView createSectionFooter(CharSequence text) {
            return new XUIGroupListSectionHeaderFooterView(this.mContext, text, true);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SeparatorStyle {
    }
}

