/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.grouplist;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.utils.Utils;

public class XUIGroupListSectionHeaderFooterView
extends LinearLayout {
    private TextView mTextView;

    public XUIGroupListSectionHeaderFooterView(Context context) {
        this(context, null, R.attr.XUIGroupListSectionViewStyle);
    }

    public XUIGroupListSectionHeaderFooterView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.XUIGroupListSectionViewStyle);
    }

    public XUIGroupListSectionHeaderFooterView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public XUIGroupListSectionHeaderFooterView(Context context, CharSequence titleText) {
        this(context);
        this.setText(titleText);
    }

    public XUIGroupListSectionHeaderFooterView(Context context, CharSequence titleText, boolean isFooter) {
        this(context);
        if (isFooter) {
            this.setPadding(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), 0);
        }
        this.setText(titleText);
    }

    private void init(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.xui_layout_group_list_section, (ViewGroup)this, true);
        this.setGravity(80);
        this.mTextView = (TextView)this.findViewById(R.id.group_list_section_header_textView);
    }

    public void setText(CharSequence text) {
        if (Utils.isNullOrEmpty(text)) {
            this.mTextView.setVisibility(8);
        } else {
            this.mTextView.setVisibility(0);
        }
        this.mTextView.setText(text);
    }

    public TextView getTextView() {
        return this.mTextView;
    }

    public void setTextGravity(int gravity) {
        this.mTextView.setGravity(gravity);
    }
}

