/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.banner.widget.banner;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.xuexiang.xui.R;
import com.xuexiang.xui.widget.banner.widget.banner.BannerItem;
import com.xuexiang.xui.widget.banner.widget.banner.base.BaseIndicatorBanner;
import com.xuexiang.xui.widget.imageview.ImageLoader;
import java.lang.ref.WeakReference;

public class SimpleImageBanner
extends BaseIndicatorBanner<BannerItem, SimpleImageBanner> {
    private ColorDrawable mColorDrawable = new ColorDrawable(Color.parseColor((String)"#555555"));
    private boolean mEnableCache = true;
    private double mScale = 0.5625;

    public SimpleImageBanner(Context context) {
        super(context);
    }

    public SimpleImageBanner(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SimpleImageBanner(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public void onTitleSelect(TextView tv, int position) {
        BannerItem item = (BannerItem)this.getItem(position);
        if (item != null) {
            tv.setText((CharSequence)item.title);
        }
    }

    @Override
    public View onCreateItemView(int position) {
        View inflate = View.inflate((Context)this.mContext, (int)R.layout.xui_adapter_simple_image, null);
        ImageView iv = (ImageView)inflate.findViewById(R.id.iv);
        WeakReference<ImageView> imageViewWeakReference = new WeakReference<ImageView>(iv);
        ImageView target = (ImageView)imageViewWeakReference.get();
        BannerItem item = (BannerItem)this.getItem(position);
        if (item != null && target != null) {
            this.loadingImageView(target, item);
        }
        return inflate;
    }

    protected void loadingImageView(ImageView iv, BannerItem item) {
        int itemWidth = this.mDisplayMetrics.widthPixels;
        int itemHeight = (int)((double)itemWidth * this.mScale);
        iv.setScaleType(ImageView.ScaleType.CENTER_CROP);
        iv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(itemWidth, itemHeight));
        String imgUrl = item.imgUrl;
        if (!TextUtils.isEmpty((CharSequence)imgUrl)) {
            ImageLoader.get().loadImage(iv, imgUrl, itemWidth, itemHeight, (Drawable)this.mColorDrawable, this.mEnableCache ? DiskCacheStrategy.RESOURCE : DiskCacheStrategy.NONE);
        } else {
            iv.setImageDrawable((Drawable)this.mColorDrawable);
        }
    }

    public SimpleImageBanner enableCache(boolean enableCache) {
        this.mEnableCache = enableCache;
        return this;
    }

    public boolean getEnableCache() {
        return this.mEnableCache;
    }

    public ColorDrawable getColorDrawable() {
        return this.mColorDrawable;
    }

    public SimpleImageBanner setColorDrawable(ColorDrawable colorDrawable) {
        this.mColorDrawable = colorDrawable;
        return this;
    }

    public double getScale() {
        return this.mScale;
    }

    public SimpleImageBanner setScale(double scale) {
        this.mScale = scale;
        return this;
    }

    protected void onDetachedFromWindow() {
        this.pauseScroll();
        super.onDetachedFromWindow();
    }
}

