/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.banner.recycler.layout;

import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.xuexiang.xui.widget.banner.recycler.layout.BannerLayoutManager;

public class CenterSnapHelper
extends RecyclerView.OnFlingListener {
    RecyclerView mRecyclerView;
    Scroller mGravityScroller;
    private boolean snapToCenter = false;
    private final RecyclerView.OnScrollListener mScrollListener = new RecyclerView.OnScrollListener(){
        boolean mScrolled = false;

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            BannerLayoutManager layoutManager = (BannerLayoutManager)recyclerView.getLayoutManager();
            BannerLayoutManager.OnPageChangeListener onPageChangeListener = layoutManager.onPageChangeListener;
            if (onPageChangeListener != null) {
                onPageChangeListener.onPageScrollStateChanged(newState);
            }
            if (newState == 0 && this.mScrolled) {
                this.mScrolled = false;
                if (!CenterSnapHelper.this.snapToCenter) {
                    CenterSnapHelper.this.snapToCenter = true;
                    CenterSnapHelper.this.snapToCenterView(layoutManager, onPageChangeListener);
                } else {
                    CenterSnapHelper.this.snapToCenter = false;
                }
            }
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            if (dx != 0 || dy != 0) {
                this.mScrolled = true;
            }
        }
    };

    public boolean onFling(int velocityX, int velocityY) {
        BannerLayoutManager layoutManager = (BannerLayoutManager)this.mRecyclerView.getLayoutManager();
        if (layoutManager == null) {
            return false;
        }
        RecyclerView.Adapter adapter = this.mRecyclerView.getAdapter();
        if (adapter == null) {
            return false;
        }
        if (!(layoutManager.getInfinite() || layoutManager.mOffset != layoutManager.getMaxOffset() && layoutManager.mOffset != layoutManager.getMinOffset())) {
            return false;
        }
        int minFlingVelocity = this.mRecyclerView.getMinFlingVelocity();
        this.mGravityScroller.fling(0, 0, velocityX, velocityY, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        if (layoutManager.mOrientation == 1 && Math.abs(velocityY) > minFlingVelocity) {
            int currentPosition = layoutManager.getCurrentPosition();
            int offsetPosition = (int)((float)this.mGravityScroller.getFinalY() / layoutManager.mInterval / layoutManager.getDistanceRatio());
            this.mRecyclerView.smoothScrollToPosition(layoutManager.getReverseLayout() ? currentPosition - offsetPosition : currentPosition + offsetPosition);
            return true;
        }
        if (layoutManager.mOrientation == 0 && Math.abs(velocityX) > minFlingVelocity) {
            int currentPosition = layoutManager.getCurrentPosition();
            int offsetPosition = (int)((float)this.mGravityScroller.getFinalX() / layoutManager.mInterval / layoutManager.getDistanceRatio());
            this.mRecyclerView.smoothScrollToPosition(layoutManager.getReverseLayout() ? currentPosition - offsetPosition : currentPosition + offsetPosition);
            return true;
        }
        return true;
    }

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) throws IllegalStateException {
        if (this.mRecyclerView == recyclerView) {
            return;
        }
        if (this.mRecyclerView != null) {
            this.destroyCallbacks();
        }
        this.mRecyclerView = recyclerView;
        if (this.mRecyclerView != null) {
            RecyclerView.LayoutManager layoutManager = this.mRecyclerView.getLayoutManager();
            if (!(layoutManager instanceof BannerLayoutManager)) {
                return;
            }
            this.setupCallbacks();
            this.mGravityScroller = new Scroller(this.mRecyclerView.getContext(), (Interpolator)new DecelerateInterpolator());
            this.snapToCenterView((BannerLayoutManager)layoutManager, ((BannerLayoutManager)layoutManager).onPageChangeListener);
        }
    }

    void snapToCenterView(BannerLayoutManager layoutManager, BannerLayoutManager.OnPageChangeListener listener) {
        int delta = layoutManager.getOffsetToCenter();
        if (delta != 0) {
            if (layoutManager.getOrientation() == 1) {
                this.mRecyclerView.smoothScrollBy(0, delta);
            } else {
                this.mRecyclerView.smoothScrollBy(delta, 0);
            }
        } else {
            this.snapToCenter = false;
        }
        if (listener != null) {
            listener.onPageSelected(layoutManager.getCurrentPosition());
        }
    }

    void setupCallbacks() throws IllegalStateException {
        if (this.mRecyclerView.getOnFlingListener() != null) {
            throw new IllegalStateException("An instance of OnFlingListener already set.");
        }
        this.mRecyclerView.addOnScrollListener(this.mScrollListener);
        this.mRecyclerView.setOnFlingListener((RecyclerView.OnFlingListener)this);
    }

    void destroyCallbacks() {
        this.mRecyclerView.removeOnScrollListener(this.mScrollListener);
        this.mRecyclerView.setOnFlingListener(null);
    }
}

