/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.widget.actionbar;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xuexiang.xui.R;
import com.xuexiang.xui.XUI;
import com.xuexiang.xui.utils.DensityUtils;
import com.xuexiang.xui.utils.ResUtils;
import com.xuexiang.xui.utils.ThemeUtils;
import com.xuexiang.xui.widget.alpha.XUIAlphaImageView;
import com.xuexiang.xui.widget.alpha.XUIAlphaTextView;
import com.xuexiang.xui.widget.textview.AutoMoveTextView;
import java.util.LinkedList;
import uk.co.chrisjenx.calligraphy.HasTypeface;

public class TitleBar
extends ViewGroup
implements View.OnClickListener,
HasTypeface {
    private static final String STATUS_BAR_HEIGHT_RES_NAME = "status_bar_height";
    public static final int CENTER_CENTER = 0;
    public static final int CENTER_LEFT = 1;
    public static final int CENTER_RIGHT = 2;
    private XUIAlphaTextView mLeftText;
    private LinearLayout mRightLayout;
    private LinearLayout mCenterLayout;
    private TextView mCenterText;
    private TextView mSubTitleText;
    private View mCustomCenterView;
    private View mDividerView;
    private boolean mImmersive;
    private int mScreenWidth;
    private int mBarHeight;
    private int mStatusBarHeight;
    private int mActionPadding;
    private int mSideTextPadding;
    private int mCenterGravity;
    private int mSideTextSize;
    private int mTitleTextSize;
    private int mSubTitleTextSize;
    private int mActionTextSize;
    private int mSideTextColor;
    private int mTitleTextColor;
    private int mSubTitleTextColor;
    private int mActionTextColor;
    private Drawable mLeftImageResource;
    private String mLeftTextString;
    private String mTitleTextString;
    private String mSubTextString;
    private int mDividerColor;
    private int mDivideHeight;
    private boolean mIsUseThemeColor;

    public TitleBar(Context context) {
        this(context, null);
    }

    public TitleBar(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.TitleBarStyle);
    }

    public TitleBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        if (this.isInEditMode()) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.TitleBar, defStyleAttr, 0);
        this.mBarHeight = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_barHeight, ThemeUtils.resolveDimension(context, R.attr.xui_actionbar_height));
        this.mImmersive = typedArray.getBoolean(R.styleable.TitleBar_tb_immersive, ThemeUtils.resolveBoolean(context, R.attr.xui_actionbar_immersive));
        this.mActionPadding = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_actionPadding, ThemeUtils.resolveDimension(context, R.attr.xui_actionbar_action_padding));
        this.mSideTextPadding = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_sideTextPadding, ThemeUtils.resolveDimension(context, R.attr.xui_actionbar_side_text_padding));
        this.mCenterGravity = typedArray.getInt(R.styleable.TitleBar_tb_centerGravity, 0);
        this.mSideTextSize = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_sideTextSize, ThemeUtils.resolveDimension(context, R.attr.xui_actionbar_action_text_size));
        this.mTitleTextSize = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_titleTextSize, ThemeUtils.resolveDimension(context, R.attr.xui_actionbar_title_text_size));
        this.mSubTitleTextSize = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_subTitleTextSize, ThemeUtils.resolveDimension(context, R.attr.xui_actionbar_sub_text_size));
        this.mActionTextSize = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_actionTextSize, ThemeUtils.resolveDimension(context, R.attr.xui_actionbar_action_text_size));
        this.mSideTextColor = typedArray.getColor(R.styleable.TitleBar_tb_sideTextColor, ThemeUtils.resolveColor(this.getContext(), R.attr.xui_actionbar_text_color, -1));
        this.mTitleTextColor = typedArray.getColor(R.styleable.TitleBar_tb_titleTextColor, ThemeUtils.resolveColor(this.getContext(), R.attr.xui_actionbar_text_color, -1));
        this.mSubTitleTextColor = typedArray.getColor(R.styleable.TitleBar_tb_subTitleTextColor, ThemeUtils.resolveColor(this.getContext(), R.attr.xui_actionbar_text_color, -1));
        this.mActionTextColor = typedArray.getColor(R.styleable.TitleBar_tb_actionTextColor, ThemeUtils.resolveColor(this.getContext(), R.attr.xui_actionbar_text_color, -1));
        this.mLeftImageResource = ResUtils.getDrawableAttrRes(this.getContext(), typedArray, R.styleable.TitleBar_tb_leftImageResource);
        this.mLeftTextString = typedArray.getString(R.styleable.TitleBar_tb_leftText);
        this.mTitleTextString = typedArray.getString(R.styleable.TitleBar_tb_titleText);
        this.mSubTextString = typedArray.getString(R.styleable.TitleBar_tb_subTitleText);
        this.mDividerColor = typedArray.getColor(R.styleable.TitleBar_tb_dividerColor, 0);
        this.mDivideHeight = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_dividerHeight, DensityUtils.dp2px(1.0f));
        this.mIsUseThemeColor = typedArray.getBoolean(R.styleable.TitleBar_tb_useThemeColor, true);
        typedArray.recycle();
    }

    private void init(Context context) {
        this.mScreenWidth = this.getResources().getDisplayMetrics().widthPixels;
        if (this.mImmersive) {
            this.mStatusBarHeight = TitleBar.getStatusBarHeight();
        }
        this.initView(context);
    }

    private void initView(Context context) {
        this.mLeftText = new XUIAlphaTextView(context);
        this.mCenterLayout = new LinearLayout(context);
        this.mRightLayout = new LinearLayout(context);
        this.mDividerView = new View(context);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
        this.mLeftText.setTextSize(0, this.mSideTextSize);
        this.mLeftText.setTextColor(this.mSideTextColor);
        this.mLeftText.setText(this.mLeftTextString);
        if (this.mLeftImageResource != null) {
            this.mLeftText.setCompoundDrawablesWithIntrinsicBounds(this.mLeftImageResource, null, null, null);
        }
        this.mLeftText.setSingleLine();
        this.mLeftText.setGravity(16);
        this.mLeftText.setPadding(this.mSideTextPadding, 0, this.mSideTextPadding, 0);
        this.mLeftText.setTypeface(XUI.getDefaultTypeface());
        this.mCenterText = new AutoMoveTextView(context);
        this.mSubTitleText = new TextView(context);
        if (!TextUtils.isEmpty((CharSequence)this.mSubTextString)) {
            this.mCenterLayout.setOrientation(1);
        }
        this.mCenterText.setTextSize(0, (float)this.mTitleTextSize);
        this.mCenterText.setTextColor(this.mTitleTextColor);
        this.mCenterText.setText((CharSequence)this.mTitleTextString);
        this.mCenterText.setSingleLine();
        this.mCenterText.setEllipsize(TextUtils.TruncateAt.MARQUEE);
        this.mCenterText.setTypeface(XUI.getDefaultTypeface());
        this.mSubTitleText.setTextSize(0, (float)this.mSubTitleTextSize);
        this.mSubTitleText.setTextColor(this.mSubTitleTextColor);
        this.mSubTitleText.setText((CharSequence)this.mSubTextString);
        this.mSubTitleText.setSingleLine();
        this.mSubTitleText.setPadding(0, DensityUtils.dp2px(this.getContext(), 2.0f), 0, 0);
        this.mSubTitleText.setEllipsize(TextUtils.TruncateAt.END);
        this.mSubTitleText.setTypeface(XUI.getDefaultTypeface());
        if (this.mCenterGravity == 1) {
            this.setCenterGravity(8388627);
        } else if (this.mCenterGravity == 2) {
            this.setCenterGravity(8388629);
        } else {
            this.setCenterGravity(17);
        }
        this.mCenterLayout.addView((View)this.mCenterText);
        this.mCenterLayout.addView((View)this.mSubTitleText);
        this.mRightLayout.setPadding(this.mSideTextPadding, 0, this.mSideTextPadding, 0);
        this.mDividerView.setBackgroundColor(this.mDividerColor);
        this.addView((View)this.mLeftText, layoutParams);
        this.addView((View)this.mCenterLayout);
        this.addView((View)this.mRightLayout, layoutParams);
        this.addView(this.mDividerView, new ViewGroup.LayoutParams(-1, this.mDivideHeight));
        if (this.mIsUseThemeColor) {
            Drawable backgroundDrawable = ThemeUtils.resolveDrawable(this.getContext(), R.attr.xui_actionbar_background);
            if (backgroundDrawable != null) {
                this.setBackground(backgroundDrawable);
            } else {
                this.setBackgroundColor(ThemeUtils.resolveColor(context, R.attr.xui_actionbar_color));
            }
        }
    }

    public TitleBar setImmersive(boolean immersive) {
        this.mImmersive = immersive;
        this.mStatusBarHeight = this.mImmersive ? TitleBar.getStatusBarHeight() : 0;
        return this;
    }

    public TitleBar setHeight(int height) {
        this.mBarHeight = height;
        this.setMeasuredDimension(this.getMeasuredWidth(), this.mBarHeight);
        return this;
    }

    public TitleBar setLeftImageResource(int resId) {
        if (this.mLeftText != null) {
            this.mLeftText.setCompoundDrawablesWithIntrinsicBounds(resId, 0, 0, 0);
        }
        return this;
    }

    public TitleBar setLeftImageDrawable(Drawable leftImageDrawable) {
        this.mLeftImageResource = leftImageDrawable;
        if (this.mLeftText != null) {
            this.mLeftText.setCompoundDrawablesWithIntrinsicBounds(this.mLeftImageResource, null, null, null);
        }
        return this;
    }

    @Deprecated
    public TitleBar setBackImageResource(int resId) {
        if (resId != 0) {
            this.mLeftImageResource = ResUtils.getDrawable(this.getContext(), resId);
            this.mLeftImageResource.setBounds(0, 0, DensityUtils.dp2px(this.getContext(), 12.0f), DensityUtils.dp2px(this.getContext(), 22.0f));
            this.mLeftText.setCompoundDrawables(this.mLeftImageResource, null, null, null);
        } else {
            this.mLeftImageResource = null;
            this.mLeftText.setCompoundDrawables(null, null, null, null);
        }
        return this;
    }

    public TitleBar setLeftClickListener(View.OnClickListener l) {
        this.mLeftText.setOnClickListener(l);
        return this;
    }

    public TitleBar setLeftText(CharSequence title) {
        this.mLeftText.setText(title);
        return this;
    }

    public TitleBar setLeftText(int resId) {
        this.mLeftText.setText(resId);
        return this;
    }

    public TitleBar setLeftTextSize(float size) {
        this.mLeftText.setTextSize(0, size);
        return this;
    }

    public TitleBar setLeftTextMaxEms(int maxEms) {
        this.mLeftText.setMaxEms(maxEms);
        return this;
    }

    public TitleBar setLeftTextMaxWidth(int maxPixels) {
        this.mLeftText.setMaxWidth(maxPixels);
        return this;
    }

    public TitleBar setLeftTextEllipsize(TextUtils.TruncateAt where) {
        this.mLeftText.setEllipsize(where);
        return this;
    }

    public TitleBar setLeftTextPadding(int paddingStart, int paddingEnd) {
        this.mLeftText.setPadding(paddingStart, 0, paddingEnd, 0);
        return this;
    }

    public TitleBar setLeftTextColor(int color) {
        this.mLeftText.setTextColor(color);
        return this;
    }

    public TitleBar setLeftVisible(boolean visible) {
        this.mLeftText.setVisibility(visible ? 0 : 8);
        return this;
    }

    public TitleBar disableLeftView() {
        this.setBackImageResource(0);
        this.setLeftTextPadding(this.mActionPadding, 0);
        this.setLeftVisible(false);
        return this;
    }

    public TitleBar setTitle(CharSequence title) {
        int index = title.toString().indexOf("\n");
        if (index > 0) {
            this.setTitle(title.subSequence(0, index), title.subSequence(index + 1, title.length()), 1);
        } else {
            index = title.toString().indexOf("\t");
            if (index > 0) {
                this.setTitle(title.subSequence(0, index), "  " + title.subSequence(index + 1, title.length()), 0);
            } else {
                this.mCenterText.setText(title);
                this.mSubTitleText.setVisibility(8);
            }
        }
        return this;
    }

    public TitleBar setTitle(CharSequence title, CharSequence subTitle, int orientation) {
        this.mCenterLayout.setOrientation(orientation);
        this.mCenterText.setText(title);
        this.mSubTitleText.setText(subTitle);
        this.mSubTitleText.setVisibility(0);
        return this;
    }

    public TitleBar setSubTitle(CharSequence subTitle) {
        this.mSubTitleText.setText(subTitle);
        this.mSubTitleText.setVisibility(0);
        return this;
    }

    public TitleBar setCenterGravity(int gravity) {
        this.mCenterLayout.setGravity(gravity);
        this.mCenterText.setGravity(gravity);
        this.mSubTitleText.setGravity(gravity);
        return this;
    }

    public TitleBar setCenterClickListener(View.OnClickListener l) {
        this.mCenterLayout.setOnClickListener(l);
        return this;
    }

    public TitleBar setTitle(int resId) {
        this.setTitle(this.getResources().getString(resId));
        return this;
    }

    public TitleBar setTitleColor(int resId) {
        this.mCenterText.setTextColor(resId);
        return this;
    }

    public TitleBar setTitleSize(float size) {
        this.mCenterText.setTextSize(0, size);
        return this;
    }

    public TitleBar setTitleBackground(int resId) {
        this.mCenterText.setBackgroundResource(resId);
        return this;
    }

    public TitleBar setSubTitleColor(int resId) {
        this.mSubTitleText.setTextColor(resId);
        return this;
    }

    public TitleBar setSubTitleSize(float size) {
        this.mSubTitleText.setTextSize(0, size);
        return this;
    }

    public TitleBar setCustomTitle(View titleView) {
        if (titleView == null) {
            this.mCenterText.setVisibility(0);
            if (this.mCustomCenterView != null) {
                this.mCenterLayout.removeView(this.mCustomCenterView);
            }
        } else {
            if (this.mCustomCenterView != null) {
                this.mCenterLayout.removeView(this.mCustomCenterView);
            }
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
            this.mCustomCenterView = titleView;
            this.mCenterLayout.addView(titleView, layoutParams);
            this.mCenterText.setVisibility(8);
        }
        return this;
    }

    public TitleBar setDivider(Drawable drawable2) {
        this.mDividerView.setBackgroundDrawable(drawable2);
        return this;
    }

    public TitleBar setDividerColor(int color) {
        this.mDividerView.setBackgroundColor(color);
        return this;
    }

    public TitleBar setDividerHeight(int dividerHeight) {
        this.mDividerView.getLayoutParams().height = dividerHeight;
        return this;
    }

    public TitleBar setActionTextColor(int colorResId) {
        this.mActionTextColor = colorResId;
        return this;
    }

    public TitleBar setOnTitleClickListener(View.OnClickListener listener) {
        this.mCenterText.setOnClickListener(listener);
        return this;
    }

    public void onClick(View view) {
        Object tag = view.getTag();
        if (tag instanceof Action) {
            Action action = (Action)tag;
            action.performAction(view);
        }
    }

    public TitleBar addActions(ActionList actionList) {
        int actions = actionList.size();
        for (int i = 0; i < actions; ++i) {
            this.addAction((Action)actionList.get(i));
        }
        return this;
    }

    public View addAction(Action action) {
        int index = this.mRightLayout.getChildCount();
        return this.addAction(action, index);
    }

    public View addAction(Action action, int index) {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -1);
        View view = this.inflateAction(action);
        this.mRightLayout.addView(view, index, (ViewGroup.LayoutParams)params);
        return view;
    }

    public void removeAllActions() {
        this.mRightLayout.removeAllViews();
    }

    public void removeActionAt(int index) {
        this.mRightLayout.removeViewAt(index);
    }

    public void removeAction(Action action) {
        int childCount = this.mRightLayout.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Object tag;
            View view = this.mRightLayout.getChildAt(i);
            if (view == null || !((tag = view.getTag()) instanceof Action) || !tag.equals(action)) continue;
            this.mRightLayout.removeView(view);
        }
    }

    public int getActionCount() {
        return this.mRightLayout.getChildCount();
    }

    protected View inflateAction(Action action) {
        Object view = null;
        if (TextUtils.isEmpty((CharSequence)action.getText())) {
            XUIAlphaImageView img = new XUIAlphaImageView(this.getContext());
            img.setImageResource(action.getDrawable());
            view = img;
        } else {
            XUIAlphaTextView text = new XUIAlphaTextView(this.getContext());
            text.setGravity(17);
            text.setText(action.getText());
            text.setTextSize(0, this.mActionTextSize);
            if (DensityUtils.px2sp(this.getContext(), this.mActionTextSize) >= 16) {
                TextPaint tp = text.getPaint();
                tp.setFakeBoldText(true);
            }
            text.setTypeface(XUI.getDefaultTypeface());
            if (this.mActionTextColor != 0) {
                text.setTextColor(this.mActionTextColor);
            }
            view = text;
        }
        view.setPadding(action.leftPadding() != -1 ? action.leftPadding() : this.mActionPadding, 0, action.rightPadding() != -1 ? action.rightPadding() : this.mActionPadding, 0);
        view.setTag(action);
        view.setOnClickListener(this);
        return view;
    }

    public View getViewByAction(Action action) {
        return this.findViewWithTag(action);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (heightMode != 0x40000000) {
            height = this.mBarHeight + this.mStatusBarHeight;
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mBarHeight, (int)0x40000000);
        } else {
            height = View.MeasureSpec.getSize((int)heightMeasureSpec) + this.mStatusBarHeight;
        }
        this.measureChild((View)this.mLeftText, widthMeasureSpec, heightMeasureSpec);
        this.measureChild((View)this.mRightLayout, widthMeasureSpec, heightMeasureSpec);
        if (this.mLeftText.getMeasuredWidth() > this.mRightLayout.getMeasuredWidth()) {
            this.mCenterLayout.measure(View.MeasureSpec.makeMeasureSpec((int)(this.mScreenWidth - 2 * this.mLeftText.getMeasuredWidth()), (int)0x40000000), heightMeasureSpec);
        } else {
            this.mCenterLayout.measure(View.MeasureSpec.makeMeasureSpec((int)(this.mScreenWidth - 2 * this.mRightLayout.getMeasuredWidth()), (int)0x40000000), heightMeasureSpec);
        }
        this.measureChild(this.mDividerView, widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mLeftText.layout(0, this.mStatusBarHeight, this.mLeftText.getMeasuredWidth(), this.mLeftText.getMeasuredHeight() + this.mStatusBarHeight);
        this.mRightLayout.layout(this.mScreenWidth - this.mRightLayout.getMeasuredWidth(), this.mStatusBarHeight, this.mScreenWidth, this.mRightLayout.getMeasuredHeight() + this.mStatusBarHeight);
        if (this.mCenterGravity == 1) {
            this.mCenterLayout.layout(this.mLeftText.getMeasuredWidth(), this.mStatusBarHeight, this.mScreenWidth - this.mLeftText.getMeasuredWidth(), this.getMeasuredHeight());
        } else if (this.mCenterGravity == 2) {
            this.mCenterLayout.layout(this.mRightLayout.getMeasuredWidth(), this.mStatusBarHeight, this.mScreenWidth - this.mRightLayout.getMeasuredWidth(), this.getMeasuredHeight());
        } else if (this.mLeftText.getMeasuredWidth() > this.mRightLayout.getMeasuredWidth()) {
            this.mCenterLayout.layout(this.mLeftText.getMeasuredWidth(), this.mStatusBarHeight, this.mScreenWidth - this.mLeftText.getMeasuredWidth(), this.getMeasuredHeight());
        } else {
            this.mCenterLayout.layout(this.mRightLayout.getMeasuredWidth(), this.mStatusBarHeight, this.mScreenWidth - this.mRightLayout.getMeasuredWidth(), this.getMeasuredHeight());
        }
        this.mDividerView.layout(0, this.getMeasuredHeight() - this.mDividerView.getMeasuredHeight(), this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    public static int getStatusBarHeight() {
        return TitleBar.getInternalDimensionSize(Resources.getSystem(), STATUS_BAR_HEIGHT_RES_NAME);
    }

    private static int getInternalDimensionSize(Resources res, String key) {
        int result = 0;
        int resourceId = res.getIdentifier(key, "dimen", "android");
        if (resourceId > 0) {
            result = res.getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public void setTypeface(Typeface tf) {
        if (this.mLeftText != null) {
            this.mLeftText.setTypeface(tf);
        }
        if (this.mCenterText != null) {
            this.mCenterText.setTypeface(tf);
        }
        if (this.mSubTitleText != null) {
            this.mSubTitleText.setTypeface(tf);
        }
    }

    public XUIAlphaTextView getLeftText() {
        return this.mLeftText;
    }

    public TextView getSubTitleText() {
        return this.mSubTitleText;
    }

    public TextView getCenterText() {
        return this.mCenterText;
    }

    public View getDividerView() {
        return this.mDividerView;
    }

    public static abstract class TextAction
    implements Action {
        private final String mText;

        public TextAction(String text) {
            this.mText = text;
        }

        @Override
        public int getDrawable() {
            return 0;
        }

        @Override
        public String getText() {
            return this.mText;
        }

        @Override
        public int leftPadding() {
            return -1;
        }

        @Override
        public int rightPadding() {
            return 0;
        }
    }

    public static abstract class ImageAction
    implements Action {
        private int mDrawable;

        public ImageAction(int drawable2) {
            this.mDrawable = drawable2;
        }

        @Override
        public int getDrawable() {
            return this.mDrawable;
        }

        @Override
        public String getText() {
            return null;
        }

        @Override
        public int leftPadding() {
            return -1;
        }

        @Override
        public int rightPadding() {
            return 0;
        }
    }

    public static interface Action {
        public String getText();

        public int getDrawable();

        public void performAction(View var1);

        public int leftPadding();

        public int rightPadding();
    }

    public static class ActionList
    extends LinkedList<Action> {
    }
}

