/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.adapter.recyclerview;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.xuexiang.xui.adapter.recyclerview.RecyclerViewHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class XRecyclerAdapter<T, V extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<V> {
    protected final List<T> mData = new ArrayList<T>();
    private RecyclerViewHolder.OnItemClickListener<T> mClickListener;
    private RecyclerViewHolder.OnItemLongClickListener<T> mLongClickListener;
    private int mSelectPosition = -1;

    public XRecyclerAdapter() {
        this(null);
    }

    public XRecyclerAdapter(List<T> list) {
        if (list != null) {
            this.mData.addAll(list);
        }
    }

    @NonNull
    protected abstract V getViewHolder(@NonNull ViewGroup var1, int var2);

    protected abstract void bindData(@NonNull V var1, int var2, T var3);

    protected View inflateView(ViewGroup parent, @LayoutRes int layoutId) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(layoutId, parent, false);
    }

    @NonNull
    public V onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        V holder = this.getViewHolder(parent, viewType);
        if (this.mClickListener != null) {
            ((RecyclerView.ViewHolder)holder).itemView.setOnClickListener(new View.OnClickListener((RecyclerView.ViewHolder)holder){
                final /* synthetic */ RecyclerView.ViewHolder val$holder;
                {
                    this.val$holder = viewHolder;
                }

                public void onClick(View v) {
                    XRecyclerAdapter.this.mClickListener.onItemClick(this.val$holder.itemView, XRecyclerAdapter.this.getItem(this.val$holder.getLayoutPosition()), this.val$holder.getLayoutPosition());
                }
            });
        }
        if (this.mLongClickListener != null) {
            ((RecyclerView.ViewHolder)holder).itemView.setOnLongClickListener(new View.OnLongClickListener((RecyclerView.ViewHolder)holder){
                final /* synthetic */ RecyclerView.ViewHolder val$holder;
                {
                    this.val$holder = viewHolder;
                }

                public boolean onLongClick(View v) {
                    XRecyclerAdapter.this.mLongClickListener.onItemLongClick(this.val$holder.itemView, XRecyclerAdapter.this.getItem(this.val$holder.getLayoutPosition()), this.val$holder.getLayoutPosition());
                    return true;
                }
            });
        }
        return holder;
    }

    public void onBindViewHolder(@NonNull V holder, int position) {
        this.bindData(holder, position, this.mData.get(position));
    }

    public T getItem(int position) {
        return position < this.getItemCount() ? (T)this.mData.get(position) : null;
    }

    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    public int getItemCount() {
        return this.mData.size();
    }

    public XRecyclerAdapter add(int pos, T item) {
        this.mData.add(pos, item);
        this.notifyItemInserted(pos);
        return this;
    }

    public XRecyclerAdapter delete(int pos) {
        this.mData.remove(pos);
        this.notifyItemRemoved(pos);
        return this;
    }

    public XRecyclerAdapter refresh(Collection<T> collection) {
        if (collection != null) {
            this.mData.clear();
            this.mData.addAll(collection);
            this.mSelectPosition = -1;
            this.notifyDataSetChanged();
        }
        return this;
    }

    public XRecyclerAdapter loadMore(Collection<T> collection) {
        if (collection != null) {
            this.mData.addAll(collection);
            this.notifyDataSetChanged();
        }
        return this;
    }

    public XRecyclerAdapter load(T item) {
        if (item != null) {
            this.mData.add(item);
            this.notifyDataSetChanged();
        }
        return this;
    }

    public XRecyclerAdapter setOnItemClickListener(RecyclerViewHolder.OnItemClickListener<T> listener) {
        this.mClickListener = listener;
        return this;
    }

    public XRecyclerAdapter setOnItemLongClickListener(RecyclerViewHolder.OnItemLongClickListener<T> listener) {
        this.mLongClickListener = listener;
        return this;
    }

    public int getSelectPosition() {
        return this.mSelectPosition;
    }

    public XRecyclerAdapter setSelectPosition(int selectPosition) {
        this.mSelectPosition = selectPosition;
        this.notifyDataSetChanged();
        return this;
    }

    public void clear() {
        if (!this.isEmpty()) {
            this.mData.clear();
            this.mSelectPosition = -1;
            this.notifyDataSetChanged();
        }
    }
}

