/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui.adapter.listview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.xuexiang.xui.adapter.listview.OnListItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class XListAdapter<T>
extends BaseAdapter {
    private List<T> mData = new ArrayList<T>();
    private OnListItemListener<T> mOnListItemListener;
    private Context mContext;

    public XListAdapter(Context context) {
        this.mContext = context;
    }

    public XListAdapter(Context context, OnListItemListener<T> callback) {
        this(context);
        this.mOnListItemListener = callback;
    }

    public XListAdapter(Context context, List<T> data) {
        this.mContext = context;
        this.setData(data);
    }

    public XListAdapter(Context context, T[] data) {
        this.mContext = context;
        this.setData(data);
    }

    public void setData(List<T> data) {
        if (data != null) {
            this.mData.clear();
            this.mData.addAll(data);
        } else {
            this.mData.clear();
        }
        this.notifyDataSetChanged();
    }

    public void setData(T[] data) {
        if (data != null && data.length > 0) {
            this.setData(Arrays.asList(data));
        }
    }

    public List<T> translateData(T[] data) {
        if (data != null && data.length > 0) {
            ArrayList<T> result = new ArrayList<T>();
            result.addAll(Arrays.asList(data));
            return result;
        }
        return null;
    }

    public void addData(List<T> data) {
        if (data != null && data.size() > 0) {
            if (this.mData == null) {
                this.mData = new ArrayList<T>();
            }
            this.mData.addAll(data);
            this.notifyDataSetChanged();
        }
    }

    public void addData(T[] data) {
        this.addData((T)Arrays.asList(data));
    }

    public void addData(T data) {
        if (data != null) {
            if (this.mData == null) {
                this.mData = new ArrayList<T>();
            }
            this.mData.add(data);
            this.notifyDataSetChanged();
        }
    }

    public void removeElement(T element) {
        if (this.mData.contains(element)) {
            this.mData.remove(element);
            this.notifyDataSetChanged();
        }
    }

    public void removeElement(int position) {
        if (this.mData != null && this.mData.size() > position) {
            this.mData.remove(position);
            this.notifyDataSetChanged();
        }
    }

    public void removeElements(List<T> elements) {
        if (this.mData != null && elements != null && elements.size() > 0 && this.mData.size() >= elements.size()) {
            for (T element : elements) {
                if (!this.mData.contains(element)) continue;
                this.mData.remove(element);
            }
            this.notifyDataSetChanged();
        }
    }

    public void removeElements(T[] elements) {
        if (elements != null && elements.length > 0) {
            this.removeElements(Arrays.asList(elements));
        }
    }

    public void updateElement(T element, int position) {
        if (position >= 0 && this.mData.size() > position) {
            this.mData.remove(position);
            this.mData.add(position, element);
            this.notifyDataSetChanged();
        }
    }

    public void addElement(T element) {
        if (element != null) {
            if (this.mData == null) {
                this.mData = new ArrayList<T>();
            }
            this.mData.add(element);
            this.notifyDataSetChanged();
        }
    }

    public void clearData() {
        if (this.mData != null) {
            this.mData.clear();
            this.notifyDataSetChanged();
        }
    }

    public void clearNotNotify() {
        if (this.mData != null) {
            this.mData.clear();
        }
    }

    protected void visible(boolean flag, View view) {
        if (flag) {
            view.setVisibility(0);
        }
    }

    protected void gone(boolean flag, View view) {
        if (flag) {
            view.setVisibility(8);
        }
    }

    protected void inVisible(View view) {
        view.setVisibility(4);
    }

    protected Drawable getDrawable(int resId) {
        return this.mContext.getResources().getDrawable(resId);
    }

    protected String getString(int resId) {
        return this.mContext.getResources().getString(resId);
    }

    protected int getColor(int resId) {
        return this.mContext.getResources().getColor(resId);
    }

    public List<T> getItems() {
        return this.mData;
    }

    public void setOnListItemListener(OnListItemListener<T> listener) {
        this.mOnListItemListener = listener;
    }

    public OnListItemListener<T> getOnListItemListener() {
        return this.mOnListItemListener;
    }

    public int getSize() {
        return this.mData == null ? 0 : this.mData.size();
    }

    public int getCount() {
        return this.mData == null || this.mData.isEmpty() ? 0 : this.mData.size();
    }

    public T getItem(int position) {
        return this.mData != null ? (T)this.mData.get(position) : null;
    }

    public long getItemId(int position) {
        return position;
    }

    public abstract View getView(int var1, View var2, ViewGroup var3);

    public Context getContext() {
        return this.mContext;
    }
}

