/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xui;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.xuexiang.xui.R;
import com.xuexiang.xui.logs.UILog;
import uk.co.chrisjenx.calligraphy.CalligraphyConfig;
import uk.co.chrisjenx.calligraphy.TypefaceUtils;

public class XUI {
    private static volatile XUI sInstance = null;
    private static Application sContext;
    private static boolean sIsTabletChecked;
    private static int sScreenType;

    private XUI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XUI getInstance() {
        if (sInstance != null) return sInstance;
        Class<XUI> clazz = XUI.class;
        synchronized (XUI.class) {
            if (sInstance != null) return sInstance;
            sInstance = new XUI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public static void init(Application context) {
        sContext = context;
    }

    public XUI initFontStyle(String defaultFontAssetPath) {
        CalligraphyConfig.initDefault((CalligraphyConfig)new CalligraphyConfig.Builder().setDefaultFontPath(defaultFontAssetPath).setFontAttrId(R.attr.fontPath).build());
        return this;
    }

    public static Context getContext() {
        XUI.testInitialize();
        return sContext;
    }

    private static void testInitialize() {
        if (sContext == null) {
            throw new ExceptionInInitializerError("\u8bf7\u5148\u5728\u5168\u5c40Application\u4e2d\u8c03\u7528 XUI.init() \u521d\u59cb\u5316\uff01");
        }
    }

    public static void debug(String tag) {
        UILog.debug(tag);
    }

    public static void debug(boolean isDebug) {
        UILog.debug(isDebug);
    }

    @Nullable
    public static Typeface getDefaultTypeface() {
        String fontPath = CalligraphyConfig.get().getFontPath();
        if (!TextUtils.isEmpty((CharSequence)fontPath)) {
            return TypefaceUtils.load((AssetManager)XUI.getContext().getAssets(), (String)fontPath);
        }
        return null;
    }

    @Nullable
    public static Typeface getDefaultTypeface(String fontPath) {
        if (TextUtils.isEmpty((CharSequence)fontPath)) {
            fontPath = CalligraphyConfig.get().getFontPath();
        }
        if (!TextUtils.isEmpty((CharSequence)fontPath)) {
            return TypefaceUtils.load((AssetManager)XUI.getContext().getAssets(), (String)fontPath);
        }
        return null;
    }

    private static int checkScreenSize(Context context) {
        int screenSize = context.getResources().getConfiguration().screenLayout & 0xF;
        if (screenSize >= 3) {
            if (screenSize >= 4) {
                return 3;
            }
            return 2;
        }
        return 1;
    }

    public static int getScreenType() {
        if (sIsTabletChecked) {
            return sScreenType;
        }
        sScreenType = XUI.checkScreenSize(XUI.getContext());
        sIsTabletChecked = true;
        return sScreenType;
    }

    public static boolean isTablet() {
        return XUI.getScreenType() == 2 || XUI.getScreenType() == 3;
    }

    public static void initTheme(Activity activity) {
        int screenType = XUI.getScreenType();
        if (screenType == 1) {
            activity.setTheme(R.style.XUITheme_Phone);
        } else if (screenType == 2) {
            activity.setTheme(R.style.XUITheme_Tablet_Small);
        } else {
            activity.setTheme(R.style.XUITheme_Tablet_Big);
        }
    }
}

