/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xqrcode.logs;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.xuexiang.xqrcode.logs.ILogger;
import com.xuexiang.xqrcode.logs.LogcatLogger;

public final class QCLog {
    public static final String DEFAULT_LOG_TAG = "[QCLog]";
    private static final int MAX_LOG_PRIORITY = 10;
    private static final int MIN_LOG_PRIORITY = 0;
    private static ILogger sILogger = new LogcatLogger();
    private static String sTag = "[QCLog]";
    private static boolean sIsDebug = false;
    private static int sLogPriority = 10;

    private QCLog() {
        throw new UnsupportedOperationException("Do not need instantiate!");
    }

    public static void setLogger(@NonNull ILogger logger) {
        sILogger = logger;
    }

    public static void setTag(String tag) {
        sTag = tag;
    }

    public static void setDebug(boolean isDebug) {
        sIsDebug = isDebug;
    }

    public static void setPriority(int priority) {
        sLogPriority = priority;
    }

    public static void debug(boolean isDebug) {
        if (isDebug) {
            QCLog.debug(DEFAULT_LOG_TAG);
        } else {
            QCLog.debug("");
        }
    }

    public static void debug(String tag) {
        if (!TextUtils.isEmpty((CharSequence)tag)) {
            QCLog.setDebug(true);
            QCLog.setPriority(0);
            QCLog.setTag(tag);
        } else {
            QCLog.setDebug(false);
            QCLog.setPriority(10);
            QCLog.setTag("");
        }
    }

    public static void v(String msg) {
        if (QCLog.enableLog(2)) {
            sILogger.log(2, sTag, msg, null);
        }
    }

    public static void vTag(String tag, String msg) {
        if (QCLog.enableLog(2)) {
            sILogger.log(2, tag, msg, null);
        }
    }

    public static void d(String msg) {
        if (QCLog.enableLog(3)) {
            sILogger.log(3, sTag, msg, null);
        }
    }

    public static void dTag(String tag, String msg) {
        if (QCLog.enableLog(3)) {
            sILogger.log(3, tag, msg, null);
        }
    }

    public static void i(String msg) {
        if (QCLog.enableLog(4)) {
            sILogger.log(4, sTag, msg, null);
        }
    }

    public static void iTag(String tag, String msg) {
        if (QCLog.enableLog(4)) {
            sILogger.log(4, tag, msg, null);
        }
    }

    public static void w(String msg) {
        if (QCLog.enableLog(5)) {
            sILogger.log(5, sTag, msg, null);
        }
    }

    public static void wTag(String tag, String msg) {
        if (QCLog.enableLog(5)) {
            sILogger.log(5, tag, msg, null);
        }
    }

    public static void e(String msg) {
        if (QCLog.enableLog(6)) {
            sILogger.log(6, sTag, msg, null);
        }
    }

    public static void eTag(String tag, String msg) {
        if (QCLog.enableLog(6)) {
            sILogger.log(6, tag, msg, null);
        }
    }

    public static void e(Throwable t) {
        if (QCLog.enableLog(6)) {
            sILogger.log(6, sTag, null, t);
        }
    }

    public static void eTag(String tag, Throwable t) {
        if (QCLog.enableLog(6)) {
            sILogger.log(6, tag, null, t);
        }
    }

    public static void e(String msg, Throwable t) {
        if (QCLog.enableLog(6)) {
            sILogger.log(6, sTag, msg, t);
        }
    }

    public static void eTag(String tag, String msg, Throwable t) {
        if (QCLog.enableLog(6)) {
            sILogger.log(6, tag, msg, t);
        }
    }

    public static void wtf(String msg) {
        if (QCLog.enableLog(7)) {
            sILogger.log(7, sTag, msg, null);
        }
    }

    public static void wtfTag(String tag, String msg) {
        if (QCLog.enableLog(7)) {
            sILogger.log(7, tag, msg, null);
        }
    }

    private static boolean enableLog(int logPriority) {
        return sILogger != null && sIsDebug && logPriority >= sLogPriority;
    }
}

