/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xpage.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.xuexiang.xpage.annotation.Page;
import com.xuexiang.xpage.enums.CoreAnim;
import com.xuexiang.xpage.model.PageInfo;
import com.xuexiang.xpage.util.Logger;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

@SupportedOptions(value={"moduleName"})
public class PageConfigProcessor
extends AbstractProcessor {
    private Filer mFiler;
    private Types mTypes;
    private Elements mElements;
    private Logger mLogger;
    private String moduleName = null;
    private static final String PACKAGE_NAME = "com.xuexiang.xpage";
    private static final String PAGE_CONFIG_CLASS_NAME = "PageConfig";
    private TypeMirror mFragment = null;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.mFiler = processingEnv.getFiler();
        this.mTypes = processingEnv.getTypeUtils();
        this.mElements = processingEnv.getElementUtils();
        this.mLogger = new Logger(processingEnv.getMessager());
        Map<String, String> options = processingEnv.getOptions();
        if (MapUtils.isNotEmpty(options)) {
            this.moduleName = options.get("moduleName");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.moduleName)) {
            this.moduleName = this.moduleName.replaceAll("[^0-9a-zA-Z_]+", "");
            this.mLogger.info("The user has configuration the module name, it was [" + this.moduleName + "]");
        } else {
            this.mLogger.info("These no module name, at 'build.gradle', like :\njavaCompileOptions {\n    annotationProcessorOptions {\n        arguments = [ moduleName : project.getName() ]\n    }\n}\n");
            this.moduleName = "app";
        }
        this.mFragment = this.mElements.getTypeElement("android.support.v4.app.Fragment").asType();
        this.mLogger.info(">>> PageConfigProcessor init. <<<");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        if (CollectionUtils.isNotEmpty(annotations)) {
            Set<? extends Element> pageElements = roundEnvironment.getElementsAnnotatedWith(Page.class);
            try {
                this.mLogger.info(">>> Found Pages, start... <<<");
                this.parsePages(pageElements);
            }
            catch (Exception e) {
                this.mLogger.error(e);
            }
            return true;
        }
        return false;
    }

    private void parsePages(Set<? extends Element> pageElements) throws IOException {
        if (CollectionUtils.isNotEmpty(pageElements)) {
            this.mLogger.info(">>> Found Pages, size is " + pageElements.size() + " <<<");
            ClassName pageConfigClassName = ClassName.get((String)PACKAGE_NAME, (String)(PageConfigProcessor.upperFirstLetter(this.moduleName) + PAGE_CONFIG_CLASS_NAME), (String[])new String[0]);
            TypeSpec.Builder pageConfigBuilder = TypeSpec.classBuilder((ClassName)pageConfigClassName);
            FieldSpec instanceField = FieldSpec.builder((TypeName)pageConfigClassName, (String)"sInstance", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).addModifiers(new Modifier[]{Modifier.STATIC}).build();
            ParameterizedTypeName inputListTypeOfPage = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get(PageInfo.class)});
            FieldSpec pagesField = FieldSpec.builder((TypeName)inputListTypeOfPage, (String)"mPages", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
            MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("mPages = new $T<>()", new Object[]{ClassName.get(ArrayList.class)});
            for (Element element : pageElements) {
                TypeMirror tm = element.asType();
                if (!this.mTypes.isSubtype(tm, this.mFragment)) continue;
                this.mLogger.info(">>> Found Fragment Page: " + tm.toString() + " <<<");
                Page page = element.getAnnotation(Page.class);
                String name = StringUtils.isEmpty((CharSequence)page.name()) ? element.getSimpleName().toString() : page.name();
                constructorBuilder.addStatement("mPages.add(new $T($S, $S, $S, $T.$L, $L))", new Object[]{PageInfo.class, name, tm.toString(), PageInfo.getParams((String[])page.params()), ClassName.get(CoreAnim.class), page.anim(), page.extra()});
            }
            MethodSpec constructorMethod = constructorBuilder.build();
            MethodSpec methodSpec = MethodSpec.methodBuilder((String)"getInstance").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)pageConfigClassName).addCode("if (sInstance == null) {\n    synchronized ($T.class) {\n        if (sInstance == null) {\n            sInstance = new $T();\n        }\n    }\n}\n", new Object[]{pageConfigClassName, pageConfigClassName}).addStatement("return sInstance", new Object[0]).build();
            MethodSpec getPagesMethod = MethodSpec.methodBuilder((String)"getPages").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)inputListTypeOfPage).addStatement("return mPages", new Object[0]).build();
            CodeBlock javaDoc = CodeBlock.builder().add("<p>\u8fd9\u662fPageConfigProcessor\u81ea\u52a8\u751f\u6210\u7684\u7c7b\uff0c\u7528\u4ee5\u81ea\u52a8\u8fdb\u884c\u9875\u9762\u7684\u6ce8\u518c\u3002</p>\n", new Object[0]).add("<p><a href=\"mailto:xuexiangjys@163.com\">Contact me.</a></p>\n", new Object[0]).add("\n", new Object[0]).add("@author xuexiang \n", new Object[0]).add("@date ", new Object[0]).add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()), new Object[0]).add("\n", new Object[0]).build();
            pageConfigBuilder.addJavadoc(javaDoc).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(instanceField).addField(pagesField).addMethod(constructorMethod).addMethod(methodSpec).addMethod(getPagesMethod);
            JavaFile.builder((String)PACKAGE_NAME, (TypeSpec)pageConfigBuilder.build()).build().writeTo(this.mFiler);
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        types.add(Page.class.getCanonicalName());
        return types;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    public static String upperFirstLetter(String s) {
        if (StringUtils.isEmpty((CharSequence)s) || !Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return String.valueOf((char)(s.charAt(0) - 32)) + s.substring(1);
    }
}

