/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public final class RequestBodyUtils {
    private RequestBodyUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static RequestBody create(final MediaType mediaType, final InputStream inputStream) {
        return new RequestBody(){

            public MediaType contentType() {
                return mediaType;
            }

            public long contentLength() {
                try {
                    return inputStream.available();
                }
                catch (IOException e) {
                    return 0L;
                }
            }

            public void writeTo(BufferedSink sink) throws IOException {
                Source source = null;
                try {
                    source = Okio.source((InputStream)inputStream);
                    sink.writeAll(source);
                }
                finally {
                    Util.closeQuietly((Closeable)source);
                }
            }
        };
    }
}

