/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.request.body;

import com.xuexiang.xhttp2.callback.impl.IProgressResponseCallBack;
import com.xuexiang.xhttp2.logs.HttpLog;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class UploadProgressRequestBody
extends RequestBody {
    protected RequestBody delegate;
    protected IProgressResponseCallBack progressCallBack;
    protected CountingSink countingSink;

    public UploadProgressRequestBody(IProgressResponseCallBack listener) {
        this.progressCallBack = listener;
    }

    public UploadProgressRequestBody(RequestBody delegate, IProgressResponseCallBack progressCallBack) {
        this.delegate = delegate;
        this.progressCallBack = progressCallBack;
    }

    public void setRequestBody(RequestBody delegate) {
        this.delegate = delegate;
    }

    public MediaType contentType() {
        return this.delegate.contentType();
    }

    public long contentLength() {
        try {
            return this.delegate.contentLength();
        }
        catch (IOException e) {
            HttpLog.e(e);
            return -1L;
        }
    }

    public void writeTo(BufferedSink sink) throws IOException {
        this.countingSink = new CountingSink((Sink)sink);
        BufferedSink bufferedSink = Okio.buffer((Sink)this.countingSink);
        this.delegate.writeTo(bufferedSink);
        bufferedSink.flush();
    }

    protected final class CountingSink
    extends ForwardingSink {
        private long bytesWritten;
        private long contentLength;
        private long lastRefreshUiTime;

        public CountingSink(Sink delegate) {
            super(delegate);
            this.bytesWritten = 0L;
            this.contentLength = 0L;
        }

        public void write(Buffer source, long byteCount) throws IOException {
            super.write(source, byteCount);
            if (this.contentLength <= 0L) {
                this.contentLength = UploadProgressRequestBody.this.contentLength();
            }
            this.bytesWritten += byteCount;
            long curTime = System.currentTimeMillis();
            if (curTime - this.lastRefreshUiTime >= 100L || this.bytesWritten == this.contentLength) {
                UploadProgressRequestBody.this.progressCallBack.onResponseProgress(this.bytesWritten, this.contentLength, this.bytesWritten == this.contentLength);
                this.lastRefreshUiTime = System.currentTimeMillis();
            }
            HttpLog.d("bytesWritten=" + this.bytesWritten + " ,totalBytesCount=" + this.contentLength);
        }
    }
}

