/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.reflect.impl;

import com.xuexiang.xhttp2.reflect.TypeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;

public class ParameterizedTypeImpl
implements ParameterizedType {
    private final Class raw;
    private final Type[] args;
    private final Type owner;

    public ParameterizedTypeImpl(Class raw, Type[] args, Type owner) {
        this.raw = raw;
        this.args = args != null ? args : new Type[]{};
        this.owner = owner;
        this.checkArgs();
    }

    private void checkArgs() {
        if (this.raw == null) {
            throw new TypeException("raw class can't be null");
        }
        TypeVariable<Class<T>>[] typeParameters = this.raw.getTypeParameters();
        if (this.args.length != 0 && typeParameters.length != this.args.length) {
            throw new TypeException(this.raw.getName() + " expect " + typeParameters.length + " arg(s), got " + this.args.length);
        }
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.args;
    }

    @Override
    public Type getRawType() {
        return this.raw;
    }

    @Override
    public Type getOwnerType() {
        return this.owner;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.raw.getName());
        if (this.args.length != 0) {
            sb.append('<');
            for (int i = 0; i < this.args.length; ++i) {
                Type type;
                if (i != 0) {
                    sb.append(", ");
                }
                if (!((type = this.args[i]) instanceof Class)) {
                    sb.append(this.args[i].toString());
                    continue;
                }
                Class<?> clazz = (Class<?>)type;
                if (!clazz.isArray()) {
                    sb.append(clazz.getName());
                    continue;
                }
                int count = 0;
                do {
                    ++count;
                } while ((clazz = clazz.getComponentType()).isArray());
                sb.append(clazz.getName());
                for (int j = count; j > 0; --j) {
                    sb.append("[]");
                }
            }
            sb.append('>');
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o instanceof ParameterizedTypeImpl) {
            ParameterizedTypeImpl that = (ParameterizedTypeImpl)o;
            return !this.raw.equals(that.raw) ? false : (!Arrays.equals(this.args, that.args) ? false : (this.owner != null ? this.owner.equals(that.owner) : that.owner == null));
        }
        return false;
    }

    public int hashCode() {
        int result = this.raw.hashCode();
        result = 31 * result + Arrays.hashCode(this.args);
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        return result;
    }
}

