/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.model;

import com.xuexiang.xhttp2.callback.impl.IProgressResponseCallBack;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;

public class HttpParams
implements Serializable {
    public LinkedHashMap<String, Object> urlParamsMap;
    public LinkedHashMap<String, List<FileWrapper>> fileParamsMap;

    public HttpParams() {
        this.init();
    }

    public HttpParams(String key, String value) {
        this.init();
        this.put(key, value);
    }

    public HttpParams(Map<String, Object> params) {
        this.init();
        this.put(params);
    }

    private void init() {
        this.urlParamsMap = new LinkedHashMap();
        this.fileParamsMap = new LinkedHashMap();
    }

    public HttpParams put(HttpParams params) {
        if (params != null) {
            if (params.urlParamsMap != null && !params.urlParamsMap.isEmpty()) {
                this.urlParamsMap.putAll(params.urlParamsMap);
            }
            if (params.fileParamsMap != null && !params.fileParamsMap.isEmpty()) {
                this.fileParamsMap.putAll(params.fileParamsMap);
            }
        }
        return this;
    }

    public HttpParams put(Map<String, Object> params) {
        if (params != null && !params.isEmpty()) {
            this.urlParamsMap.putAll(params);
        }
        return this;
    }

    public HttpParams put(String key, Object value) {
        this.urlParamsMap.put(key, value);
        return this;
    }

    public <T extends File> void put(String key, T file, IProgressResponseCallBack responseCallBack) {
        this.put(key, file, file.getName(), responseCallBack);
    }

    public <T extends File> void put(String key, T file, String fileName, IProgressResponseCallBack responseCallBack) {
        this.put(key, file, fileName, this.guessMimeType(fileName), responseCallBack);
    }

    public <T extends InputStream> void put(String key, T file, String fileName, IProgressResponseCallBack responseCallBack) {
        this.put(key, file, fileName, this.guessMimeType(fileName), responseCallBack);
    }

    public void put(String key, byte[] bytes, String fileName, IProgressResponseCallBack responseCallBack) {
        this.put(key, bytes, fileName, this.guessMimeType(fileName), responseCallBack);
    }

    public <T extends File> void putFileParams(String key, List<T> files, IProgressResponseCallBack responseCallBack) {
        if (key != null && files != null && !files.isEmpty()) {
            for (File file : files) {
                this.put(key, file, responseCallBack);
            }
        }
    }

    private <T> void put(String key, T content, String fileName, MediaType contentType, IProgressResponseCallBack responseCallBack) {
        if (this.fileParamsMap != null && key != null) {
            List<FileWrapper> fileWrappers = this.fileParamsMap.get(key);
            if (fileWrappers == null) {
                fileWrappers = new ArrayList<FileWrapper>();
                this.fileParamsMap.put(key, fileWrappers);
            }
            fileWrappers.add(new FileWrapper<T>(content, fileName, contentType, responseCallBack));
        }
    }

    public void removeUrl(String key) {
        if (this.urlParamsMap != null) {
            this.urlParamsMap.remove(key);
        }
    }

    public void removeFile(String key) {
        if (this.fileParamsMap != null) {
            this.fileParamsMap.remove(key);
        }
    }

    public void remove(String key) {
        this.removeUrl(key);
        this.removeFile(key);
    }

    public void clear() {
        if (this.urlParamsMap != null) {
            this.urlParamsMap.clear();
        }
        if (this.fileParamsMap != null) {
            this.fileParamsMap.clear();
        }
    }

    private MediaType guessMimeType(String path) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentType = fileNameMap.getContentTypeFor(path = path.replace("#", ""));
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        return MediaType.parse((String)contentType);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.urlParamsMap.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(entry.getKey()).append("=").append(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.fileParamsMap.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return result.toString();
    }

    public static class FileWrapper<T> {
        public T file;
        public String fileName;
        public MediaType contentType;
        public long fileSize;
        public IProgressResponseCallBack responseCallBack;

        public FileWrapper(T file, String fileName, MediaType contentType, IProgressResponseCallBack responseCallBack) {
            this.file = file;
            this.fileName = fileName;
            this.contentType = contentType;
            if (file instanceof File) {
                this.fileSize = ((File)file).length();
            } else if (file instanceof byte[]) {
                this.fileSize = ((byte[])file).length;
            }
            this.responseCallBack = responseCallBack;
        }

        public String toString() {
            return "FileWrapper{content=" + this.file + ", fileName='" + this.fileName + ", contentType=" + this.contentType + ", fileSize=" + this.fileSize + '}';
        }
    }
}

