/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.logs;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.xuexiang.xhttp2.logs.ILogger;
import com.xuexiang.xhttp2.logs.LogcatLogger;

public final class HttpLog {
    public static final String DEFAULT_LOG_TAG = "[XHttp]";
    private static final int MAX_LOG_PRIORITY = 10;
    private static final int MIN_LOG_PRIORITY = 0;
    private static ILogger sILogger = new LogcatLogger();
    private static String sTag = "[XHttp]";
    private static boolean sIsDebug = false;
    private static int sLogPriority = 10;

    public static void setLogger(@NonNull ILogger logger) {
        sILogger = logger;
    }

    public static void setTag(String tag) {
        sTag = tag;
    }

    public static void setDebug(boolean isDebug) {
        sIsDebug = isDebug;
    }

    public static void setPriority(int priority) {
        sLogPriority = priority;
    }

    public static void debug(boolean isDebug) {
        if (isDebug) {
            HttpLog.debug(DEFAULT_LOG_TAG);
        } else {
            HttpLog.debug("");
        }
    }

    public static void debug(String tag) {
        if (!TextUtils.isEmpty((CharSequence)tag)) {
            HttpLog.setDebug(true);
            HttpLog.setPriority(0);
            HttpLog.setTag(tag);
        } else {
            HttpLog.setDebug(false);
            HttpLog.setPriority(10);
            HttpLog.setTag("");
        }
    }

    public static void v(String msg) {
        if (HttpLog.enableLog(2)) {
            sILogger.log(2, sTag, msg, null);
        }
    }

    public static void d(String msg) {
        if (HttpLog.enableLog(3)) {
            sILogger.log(3, sTag, msg, null);
        }
    }

    public static void i(String msg) {
        if (HttpLog.enableLog(4)) {
            sILogger.log(4, sTag, msg, null);
        }
    }

    public static void w(String msg) {
        if (HttpLog.enableLog(5)) {
            sILogger.log(5, sTag, msg, null);
        }
    }

    public static void e(String msg) {
        if (HttpLog.enableLog(6)) {
            sILogger.log(6, sTag, msg, null);
        }
    }

    public static void e(Throwable t) {
        if (HttpLog.enableLog(6)) {
            sILogger.log(6, sTag, null, t);
        }
    }

    public static void e(String msg, Throwable t) {
        if (HttpLog.enableLog(6)) {
            sILogger.log(6, sTag, msg, t);
        }
    }

    public static void wtf(String msg) {
        if (HttpLog.enableLog(7)) {
            sILogger.log(7, sTag, msg, null);
        }
    }

    private static boolean enableLog(int logPriority) {
        return sILogger != null && sIsDebug && logPriority >= sLogPriority;
    }
}

