/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.interceptor;

import com.xuexiang.xhttp2.utils.HttpUtils;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public abstract class BaseInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request requestTmp = this.onBeforeRequest(chain.request(), chain);
        Request request = requestTmp != null ? requestTmp : chain.request();
        Response response = chain.proceed(request);
        boolean isText = HttpUtils.isText(response.body().contentType());
        if (!isText) {
            return response;
        }
        String bodyString = HttpUtils.getResponseBodyString(response);
        Response tmp = this.onAfterRequest(response, chain, bodyString);
        if (tmp != null) {
            return tmp;
        }
        return response;
    }

    protected abstract Request onBeforeRequest(Request var1, Interceptor.Chain var2);

    protected abstract Response onAfterRequest(Response var1, Interceptor.Chain var2, String var3);
}

