/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2;

import android.app.Application;
import android.text.TextUtils;
import com.xuexiang.xhttp2.XHttp;
import com.xuexiang.xhttp2.XHttpRequestPool;
import com.xuexiang.xhttp2.annotation.RequestParams;
import com.xuexiang.xhttp2.cache.converter.GsonDiskConverter;
import com.xuexiang.xhttp2.cache.model.CacheMode;
import com.xuexiang.xhttp2.interceptor.HttpLoggingInterceptor;
import com.xuexiang.xhttp2.model.XHttpRequest;
import com.xuexiang.xhttp2.request.PostRequest;
import com.xuexiang.xhttp2.subsciber.BaseSubscriber;
import com.xuexiang.xhttp2.utils.HttpUtils;
import com.xuexiang.xhttp2.utils.Utils;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import java.lang.reflect.Type;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;

public final class XHttpSDK {
    private XHttpSDK() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void init(Application application) {
        XHttp.init(application);
        XHttp.getInstance().setTimeout(15000L).setRetryCount(0).setRetryDelay(500).setCacheMode(CacheMode.NO_CACHE).setCacheDiskConverter(new GsonDiskConverter()).setCacheMaxSize(0x3200000L);
    }

    public static void addInterceptor(Interceptor interceptor) {
        XHttp.getInstance().addInterceptor(interceptor);
    }

    public static boolean setBaseUrl(String baseUrl) {
        if (XHttpSDK.verifyBaseUrl(baseUrl)) {
            XHttp.getInstance().setBaseUrl(baseUrl);
            return true;
        }
        return false;
    }

    public static boolean verifyBaseUrl(String baseUrl) {
        HttpUrl httpUrl;
        if (!TextUtils.isEmpty((CharSequence)baseUrl) && (httpUrl = HttpUrl.parse((String)baseUrl)) != null) {
            List pathSegments = httpUrl.pathSegments();
            return "".equals(pathSegments.get(pathSegments.size() - 1));
        }
        return false;
    }

    public static void setSubUrl(String subUrl) {
        XHttp.getInstance().setSubUrl(subUrl);
    }

    public static void debug() {
        XHttp.getInstance().debug("[XHttp]");
    }

    public static void debug(String tag) {
        XHttp.getInstance().debug(tag);
    }

    public static void debug(HttpLoggingInterceptor loggingInterceptor) {
        XHttp.getInstance().debug(loggingInterceptor);
    }

    public static PostRequest post(String url, String json, String threadType) {
        return XHttpSDK.post(url, true, json, threadType);
    }

    public static PostRequest post(String url, boolean isAccessToken, String json, String threadType) {
        return (PostRequest)((PostRequest)((PostRequest)XHttp.post(url).accessToken(isAccessToken)).upJson(json)).threadType(threadType);
    }

    public static PostRequest post(String url, boolean isAccessToken, String json, boolean isSyncRequest, boolean toMainThread) {
        return (PostRequest)((PostRequest)((PostRequest)((PostRequest)XHttp.post(url).accessToken(isAccessToken)).upJson(json)).syncRequest(isSyncRequest)).onMainThread(toMainThread);
    }

    public static <T> Observable<T> execute(String url, boolean isAccessToken, String json, boolean isSyncRequest, boolean toMainThread, Class<T> clazz) {
        return XHttpSDK.post(url, isAccessToken, json, isSyncRequest, toMainThread).execute(clazz);
    }

    public static <T> Observable<T> execute(String url, boolean isAccessToken, String json, boolean isSyncRequest, boolean toMainThread, Type type) {
        return XHttpSDK.post(url, isAccessToken, json, isSyncRequest, toMainThread).execute(type);
    }

    public static <T> Observable<T> execute(PostRequest postRequest, Type type) {
        return postRequest.execute(type);
    }

    public static <T> Observable<T> execute(PostRequest postRequest, Class<T> clazz) {
        return postRequest.execute(clazz);
    }

    public static <T> Disposable execute(PostRequest postRequest, Class<T> clazz, BaseSubscriber<T> subscriber) {
        return XHttpSDK.addRequest(postRequest.getUrl(), (Disposable)postRequest.execute(clazz).subscribeWith(subscriber));
    }

    public static PostRequest postToMain(String url, String json) {
        return XHttpSDK.post(url, true, json, false, true);
    }

    public static <T> Observable<T> postToMain(String url, String json, Class<T> clazz) {
        return XHttpSDK.execute(XHttpSDK.postToMain(url, json), clazz);
    }

    public static PostRequest postToMain(XHttpRequest xHttpRequest) {
        return XHttpSDK.post(xHttpRequest, false, true);
    }

    public static Observable executeToMain(XHttpRequest xHttpRequest) {
        return XHttpSDK.execute(xHttpRequest, false, true);
    }

    public static <T> Disposable executeToMain(XHttpRequest xHttpRequest, BaseSubscriber<T> subscriber) {
        return XHttpSDK.addRequest(xHttpRequest.getUrl(), (Disposable)XHttpSDK.executeToMain(xHttpRequest).subscribeWith(subscriber));
    }

    public static <T> Disposable executeToMain(XHttpRequest xHttpRequest, BaseSubscriber<T> subscriber, Object tagName) {
        return XHttpSDK.addRequest(tagName, (Disposable)XHttpSDK.executeToMain(xHttpRequest).subscribeWith(subscriber));
    }

    public static <T> Observable<T> postToMain(XHttpRequest xHttpRequest, Class<T> clazz) {
        return XHttpSDK.execute(XHttpSDK.postToMain(xHttpRequest), clazz);
    }

    public static <T> Disposable postToMain(XHttpRequest xHttpRequest, Class<T> clazz, BaseSubscriber<T> subscriber) {
        return XHttpSDK.execute(XHttpSDK.postToMain(xHttpRequest), clazz, subscriber);
    }

    public static PostRequest postToMain(String json, Class<?> clazz) {
        return XHttpSDK.post(json, clazz, false, true);
    }

    public static PostRequest postJsonToMain(XHttpRequest xHttpRequest) {
        return XHttpSDK.postJson(xHttpRequest, false, true);
    }

    public static PostRequest postToIO(String url, String json) {
        return XHttpSDK.post(url, true, json, false, false);
    }

    public static <T> Observable<T> postToIO(String url, String json, Class<T> clazz) {
        return XHttpSDK.execute(XHttpSDK.postToIO(url, json), clazz);
    }

    public static PostRequest postToIO(XHttpRequest xHttpRequest) {
        return XHttpSDK.post(xHttpRequest, false, false);
    }

    public static Observable executeToIO(XHttpRequest xHttpRequest) {
        return XHttpSDK.execute(xHttpRequest, false, false);
    }

    public static <T> Disposable executeToIO(XHttpRequest xHttpRequest, BaseSubscriber<T> subscriber) {
        return XHttpSDK.addRequest(xHttpRequest.getUrl(), (Disposable)XHttpSDK.executeToIO(xHttpRequest).subscribeWith(subscriber));
    }

    public static <T> Disposable executeToIO(XHttpRequest xHttpRequest, BaseSubscriber<T> subscriber, Object tagName) {
        return XHttpSDK.addRequest(tagName, (Disposable)XHttpSDK.executeToIO(xHttpRequest).subscribeWith(subscriber));
    }

    public static <T> Observable<T> postToIO(XHttpRequest xHttpRequest, Class<T> clazz) {
        return XHttpSDK.execute(XHttpSDK.postToIO(xHttpRequest), clazz);
    }

    public static PostRequest postInThread(String url, String json) {
        return XHttpSDK.post(url, true, json, true, false);
    }

    public static <T> Observable<T> postInThread(String url, String json, Class<T> clazz) {
        return XHttpSDK.execute(XHttpSDK.postInThread(url, json), clazz);
    }

    public static PostRequest postInThread(XHttpRequest xHttpRequest) {
        return XHttpSDK.post(xHttpRequest, true, false);
    }

    public static Observable executeInThread(XHttpRequest xHttpRequest) {
        return XHttpSDK.execute(xHttpRequest, true, false);
    }

    public static <T> Disposable executeInThread(XHttpRequest xHttpRequest, BaseSubscriber<T> subscriber) {
        return XHttpSDK.addRequest(xHttpRequest.getUrl(), (Disposable)XHttpSDK.executeInThread(xHttpRequest).subscribeWith(subscriber));
    }

    public static <T> Disposable executeInThread(XHttpRequest xHttpRequest, BaseSubscriber<T> subscriber, Object tagName) {
        return XHttpSDK.addRequest(tagName, (Disposable)XHttpSDK.executeInThread(xHttpRequest).subscribeWith(subscriber));
    }

    public static <T> Observable<T> postInThread(XHttpRequest xHttpRequest, Class<T> clazz) {
        return XHttpSDK.execute(XHttpSDK.postInThread(xHttpRequest), clazz);
    }

    public static PostRequest post(XHttpRequest xHttpRequest, boolean isSyncRequest, boolean toMainThread) {
        return XHttpSDK.post(xHttpRequest.toString(), xHttpRequest.getClass(), isSyncRequest, toMainThread);
    }

    public static Observable execute(XHttpRequest xHttpRequest, boolean isSyncRequest, boolean toMainThread) {
        return XHttpSDK.execute(XHttpSDK.post(xHttpRequest, isSyncRequest, toMainThread), xHttpRequest.parseReturnType());
    }

    public static Observable execute(PostRequest postRequest, XHttpRequest xHttpRequest) {
        return XHttpSDK.execute(postRequest, xHttpRequest.parseReturnType());
    }

    public static Observable executePost(PostRequest postRequest, Type type) {
        return XHttpSDK.execute(postRequest, type);
    }

    public static <T> Disposable execute(PostRequest postRequest, XHttpRequest xHttpRequest, BaseSubscriber<T> subscriber, Object tagName) {
        return XHttpSDK.addRequest(tagName, (Disposable)XHttpSDK.execute(postRequest, xHttpRequest).subscribeWith(subscriber));
    }

    public static <T> Disposable execute(PostRequest postRequest, Type type, BaseSubscriber<T> subscriber, Object tagName) {
        return XHttpSDK.addRequest(tagName, (Disposable)XHttpSDK.executePost(postRequest, type).subscribeWith(subscriber));
    }

    public static PostRequest postJson(XHttpRequest xHttpRequest, boolean isSyncRequest, boolean toMainThread) {
        String jsonString = xHttpRequest.toString();
        try {
            jsonString = HttpUtils.getAnnotationParamString(xHttpRequest);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return XHttpSDK.post(jsonString, xHttpRequest.getClass(), isSyncRequest, toMainThread);
    }

    public static PostRequest post(String json, Class<?> clazz, boolean isSyncRequest, boolean toMainThread) {
        RequestParams requestParams = clazz.getAnnotation(RequestParams.class);
        Utils.checkNotNull(requestParams, "requestParams == null");
        String baseUrl = requestParams.baseUrl();
        String url = requestParams.url();
        long timeout = requestParams.timeout();
        boolean accessToken = requestParams.accessToken();
        CacheMode cacheMode = requestParams.cacheMode();
        PostRequest postRequest = XHttp.post(url);
        if (!TextUtils.isEmpty((CharSequence)baseUrl)) {
            postRequest.baseUrl(baseUrl);
        }
        if (!CacheMode.NO_CACHE.equals((Object)cacheMode)) {
            ((PostRequest)postRequest.cacheMode(cacheMode)).cacheKey(url);
        }
        if (timeout <= 0L) {
            timeout = 15000L;
        }
        return (PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)postRequest.accessToken(accessToken)).timeOut(timeout)).upJson(json)).syncRequest(isSyncRequest)).onMainThread(toMainThread);
    }

    public static Disposable addRequest(Object tagName, Disposable disposable) {
        return XHttpRequestPool.get().add(tagName, disposable);
    }

    public static Disposable addRequest(Disposable disposable, Object tagName) {
        return XHttpRequestPool.get().add(disposable, tagName);
    }

    public static void cancelRequest(Object tagName) {
        XHttpRequestPool.get().remove(tagName);
    }

    public static void cancelAll() {
        XHttpRequestPool.get().removeAll();
    }
}

