/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xaop.aspectj;

import android.text.TextUtils;
import com.xuexiang.xaop.annotation.MemoryCache;
import com.xuexiang.xaop.cache.XMemoryCache;
import com.xuexiang.xaop.logger.XLogger;
import com.xuexiang.xaop.util.Utils;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class MemoryCacheAspectJ {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ MemoryCacheAspectJ ajc$perSingletonInstance;

    @Pointcut(value="within(@com.xuexiang.xaop.annotation.MemoryCache *)")
    public void withinAnnotatedClass() {
    }

    @Pointcut(value="execution(!synthetic * *(..)) && withinAnnotatedClass()")
    public void methodInsideAnnotatedType() {
    }

    @Pointcut(value="execution(@com.xuexiang.xaop.annotation.MemoryCache * *(..)) || methodInsideAnnotatedType()")
    public void method() {
    }

    @Around(value="method() && @annotation(memoryCache)")
    public Object aroundJoinPoint(ProceedingJoinPoint joinPoint, MemoryCache memoryCache) throws Throwable {
        if (!Utils.isHasReturnType(joinPoint.getSignature())) {
            return joinPoint.proceed();
        }
        String key = memoryCache.value();
        if (TextUtils.isEmpty((CharSequence)key)) {
            key = Utils.getCacheKey(joinPoint);
        }
        Object result = XMemoryCache.getInstance().load(key);
        XLogger.dTag("MemoryCache", this.getCacheMsg(joinPoint, key, result));
        if (result != null && (memoryCache.enableEmpty() || !Utils.isEmpty(result))) {
            return result;
        }
        result = joinPoint.proceed();
        if (result != null && (memoryCache.enableEmpty() || !Utils.isEmpty(result))) {
            this.saveResult(key, result);
        }
        return result;
    }

    private void saveResult(String key, Object result) {
        XMemoryCache.getInstance().save(key, result);
        XLogger.dTag("MemoryCache", "key\uff1a" + key + "--->save ");
    }

    private String getCacheMsg(ProceedingJoinPoint joinPoint, String key, Object value) {
        return "key\uff1a" + key + "--->" + (value != null ? "not null, do not need to proceed method " + joinPoint.getSignature().getName() : "null, need to proceed method " + joinPoint.getSignature().getName());
    }

    public static MemoryCacheAspectJ aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.xuexiang.xaop.aspectj.MemoryCacheAspectJ", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            MemoryCacheAspectJ.ajc$perSingletonInstance = new MemoryCacheAspectJ();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

