/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xaop;

import android.app.Application;
import android.content.Context;
import androidx.annotation.NonNull;
import com.xuexiang.xaop.cache.XCache;
import com.xuexiang.xaop.cache.XDiskCache;
import com.xuexiang.xaop.cache.XMemoryCache;
import com.xuexiang.xaop.cache.converter.IDiskConverter;
import com.xuexiang.xaop.cache.converter.SerializableDiskConverter;
import com.xuexiang.xaop.cache.key.DefaultCacheKeyCreator;
import com.xuexiang.xaop.cache.key.ICacheKeyCreator;
import com.xuexiang.xaop.checker.IThrowableHandler;
import com.xuexiang.xaop.checker.Interceptor;
import com.xuexiang.xaop.logger.ILogger;
import com.xuexiang.xaop.logger.XLogger;
import com.xuexiang.xaop.util.PermissionUtils;
import com.xuexiang.xaop.util.Strings;

public final class XAOP {
    private static Context sContext;
    private static PermissionUtils.OnPermissionDeniedListener sOnPermissionDeniedListener;
    private static IDiskConverter sIDiskConverter;
    private static ICacheKeyCreator sICacheKeyCreator;
    private static Interceptor sInterceptor;
    private static IThrowableHandler sIThrowableHandler;

    public static void init(Application application) {
        sContext = application.getApplicationContext();
    }

    public static Context getContext() {
        XAOP.testInitialize();
        return sContext;
    }

    private static void testInitialize() {
        if (sContext == null) {
            throw new ExceptionInInitializerError("\u8bf7\u5148\u5728\u5168\u5c40Application\u4e2d\u8c03\u7528 XAOP.init() \u521d\u59cb\u5316\uff01");
        }
    }

    public static void setOnPermissionDeniedListener(@NonNull PermissionUtils.OnPermissionDeniedListener listener) {
        sOnPermissionDeniedListener = listener;
    }

    public static PermissionUtils.OnPermissionDeniedListener getOnPermissionDeniedListener() {
        return sOnPermissionDeniedListener;
    }

    public static void setIDiskConverter(@NonNull IDiskConverter sIDiskConverter) {
        XAOP.sIDiskConverter = sIDiskConverter;
    }

    public static IDiskConverter getIDiskConverter() {
        return sIDiskConverter;
    }

    public static void setICacheKeyCreator(@NonNull ICacheKeyCreator sICacheKeyCreator) {
        XAOP.sICacheKeyCreator = sICacheKeyCreator;
    }

    public static ICacheKeyCreator getICacheKeyCreator() {
        return sICacheKeyCreator;
    }

    public static void setInterceptor(@NonNull Interceptor sInterceptor) {
        XAOP.sInterceptor = sInterceptor;
    }

    public static Interceptor getInterceptor() {
        return sInterceptor;
    }

    public static void setIThrowableHandler(@NonNull IThrowableHandler sIThrowableHandler) {
        XAOP.sIThrowableHandler = sIThrowableHandler;
    }

    public static IThrowableHandler getIThrowableHandler() {
        return sIThrowableHandler;
    }

    public static void debug(boolean isDebug) {
        XLogger.debug(isDebug);
    }

    public static void debug(String tag) {
        XLogger.debug(tag);
    }

    public static void setPriority(int priority) {
        XLogger.setPriority(priority);
    }

    public static void setISerializer(@NonNull Strings.ISerializer sISerializer) {
        XLogger.setISerializer(sISerializer);
    }

    public static void setLogger(@NonNull ILogger logger) {
        XLogger.setLogger(logger);
    }

    public static void initMemoryCache(int memoryMaxSize) {
        XMemoryCache.getInstance().init(memoryMaxSize);
    }

    public static void initDiskCache(XCache.Builder builder) {
        XDiskCache.getInstance().init(builder.isDiskCache(true));
    }

    static {
        sIDiskConverter = new SerializableDiskConverter();
        sICacheKeyCreator = new DefaultCacheKeyCreator();
    }
}

