/*
 * Decompiled with CFR 0.152.
 */
package com.xiao.nicevideoplayer;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.CountDownTimer;
import android.support.annotation.DrawableRes;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import com.xiao.nicevideoplayer.ChangeClarityDialog;
import com.xiao.nicevideoplayer.Clarity;
import com.xiao.nicevideoplayer.INiceVideoPlayer;
import com.xiao.nicevideoplayer.NiceUtil;
import com.xiao.nicevideoplayer.NiceVideoPlayerController;
import com.xiao.nicevideoplayer.R;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class TxVideoPlayerController
extends NiceVideoPlayerController
implements View.OnClickListener,
SeekBar.OnSeekBarChangeListener,
ChangeClarityDialog.OnClarityChangedListener {
    private Context mContext;
    private ImageView mImage;
    private ImageView mCenterStart;
    private LinearLayout mTop;
    private ImageView mBack;
    private TextView mTitle;
    private LinearLayout mBatteryTime;
    private ImageView mBattery;
    private TextView mTime;
    private LinearLayout mBottom;
    private ImageView mRestartPause;
    private TextView mPosition;
    private TextView mDuration;
    private SeekBar mSeek;
    private TextView mClarity;
    private ImageView mFullScreen;
    private TextView mLength;
    private LinearLayout mLoading;
    private TextView mLoadText;
    private LinearLayout mChangePositon;
    private TextView mChangePositionCurrent;
    private ProgressBar mChangePositionProgress;
    private LinearLayout mChangeBrightness;
    private ProgressBar mChangeBrightnessProgress;
    private LinearLayout mChangeVolume;
    private ProgressBar mChangeVolumeProgress;
    private LinearLayout mError;
    private TextView mRetry;
    private LinearLayout mCompleted;
    private TextView mReplay;
    private TextView mShare;
    private boolean topBottomVisible;
    private CountDownTimer mDismissTopBottomCountDownTimer;
    private List<Clarity> clarities;
    private int defaultClarityIndex;
    private ChangeClarityDialog mClarityDialog;
    private boolean hasRegisterBatteryReceiver;
    private BroadcastReceiver mBatterReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int status = intent.getIntExtra("status", 1);
            if (status == 2) {
                TxVideoPlayerController.this.mBattery.setImageResource(R.drawable.battery_charging);
            } else if (status == 5) {
                TxVideoPlayerController.this.mBattery.setImageResource(R.drawable.battery_full);
            } else {
                int scale;
                int level = intent.getIntExtra("level", 0);
                int percentage = (int)((float)level / (float)(scale = intent.getIntExtra("scale", 0)) * 100.0f);
                if (percentage <= 10) {
                    TxVideoPlayerController.this.mBattery.setImageResource(R.drawable.battery_10);
                } else if (percentage <= 20) {
                    TxVideoPlayerController.this.mBattery.setImageResource(R.drawable.battery_20);
                } else if (percentage <= 50) {
                    TxVideoPlayerController.this.mBattery.setImageResource(R.drawable.battery_50);
                } else if (percentage <= 80) {
                    TxVideoPlayerController.this.mBattery.setImageResource(R.drawable.battery_80);
                } else if (percentage <= 100) {
                    TxVideoPlayerController.this.mBattery.setImageResource(R.drawable.battery_100);
                }
            }
        }
    };

    public TxVideoPlayerController(Context context) {
        super(context);
        this.mContext = context;
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.tx_video_palyer_controller, (ViewGroup)this, true);
        this.mCenterStart = (ImageView)this.findViewById(R.id.center_start);
        this.mImage = (ImageView)this.findViewById(R.id.image);
        this.mTop = (LinearLayout)this.findViewById(R.id.top);
        this.mBack = (ImageView)this.findViewById(R.id.back);
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mBatteryTime = (LinearLayout)this.findViewById(R.id.battery_time);
        this.mBattery = (ImageView)this.findViewById(R.id.battery);
        this.mTime = (TextView)this.findViewById(R.id.time);
        this.mBottom = (LinearLayout)this.findViewById(R.id.bottom);
        this.mRestartPause = (ImageView)this.findViewById(R.id.restart_or_pause);
        this.mPosition = (TextView)this.findViewById(R.id.position);
        this.mDuration = (TextView)this.findViewById(R.id.duration);
        this.mSeek = (SeekBar)this.findViewById(R.id.seek);
        this.mFullScreen = (ImageView)this.findViewById(R.id.full_screen);
        this.mClarity = (TextView)this.findViewById(R.id.clarity);
        this.mLength = (TextView)this.findViewById(R.id.length);
        this.mLoading = (LinearLayout)this.findViewById(R.id.loading);
        this.mLoadText = (TextView)this.findViewById(R.id.load_text);
        this.mChangePositon = (LinearLayout)this.findViewById(R.id.change_position);
        this.mChangePositionCurrent = (TextView)this.findViewById(R.id.change_position_current);
        this.mChangePositionProgress = (ProgressBar)this.findViewById(R.id.change_position_progress);
        this.mChangeBrightness = (LinearLayout)this.findViewById(R.id.change_brightness);
        this.mChangeBrightnessProgress = (ProgressBar)this.findViewById(R.id.change_brightness_progress);
        this.mChangeVolume = (LinearLayout)this.findViewById(R.id.change_volume);
        this.mChangeVolumeProgress = (ProgressBar)this.findViewById(R.id.change_volume_progress);
        this.mError = (LinearLayout)this.findViewById(R.id.error);
        this.mRetry = (TextView)this.findViewById(R.id.retry);
        this.mCompleted = (LinearLayout)this.findViewById(R.id.completed);
        this.mReplay = (TextView)this.findViewById(R.id.replay);
        this.mShare = (TextView)this.findViewById(R.id.share);
        this.mCenterStart.setOnClickListener((View.OnClickListener)this);
        this.mBack.setOnClickListener((View.OnClickListener)this);
        this.mRestartPause.setOnClickListener((View.OnClickListener)this);
        this.mFullScreen.setOnClickListener((View.OnClickListener)this);
        this.mClarity.setOnClickListener((View.OnClickListener)this);
        this.mRetry.setOnClickListener((View.OnClickListener)this);
        this.mReplay.setOnClickListener((View.OnClickListener)this);
        this.mShare.setOnClickListener((View.OnClickListener)this);
        this.mSeek.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.setOnClickListener(this);
    }

    @Override
    public void setTitle(String title) {
        this.mTitle.setText((CharSequence)title);
    }

    @Override
    public ImageView imageView() {
        return this.mImage;
    }

    @Override
    public void setImage(@DrawableRes int resId) {
        this.mImage.setImageResource(resId);
    }

    @Override
    public void setLenght(long length) {
        this.mLength.setText((CharSequence)NiceUtil.formatTime(length));
    }

    @Override
    public void setNiceVideoPlayer(INiceVideoPlayer niceVideoPlayer) {
        super.setNiceVideoPlayer(niceVideoPlayer);
        if (this.clarities != null && this.clarities.size() > 1) {
            this.mNiceVideoPlayer.setUp(this.clarities.get((int)this.defaultClarityIndex).videoUrl, null);
        }
    }

    public void setClarity(List<Clarity> clarities, int defaultClarityIndex) {
        if (clarities != null && clarities.size() > 1) {
            this.clarities = clarities;
            this.defaultClarityIndex = defaultClarityIndex;
            ArrayList<String> clarityGrades = new ArrayList<String>();
            for (Clarity clarity : clarities) {
                clarityGrades.add(clarity.grade + " " + clarity.p);
            }
            this.mClarity.setText((CharSequence)clarities.get((int)defaultClarityIndex).grade);
            this.mClarityDialog = new ChangeClarityDialog(this.mContext);
            this.mClarityDialog.setClarityGrade(clarityGrades, defaultClarityIndex);
            this.mClarityDialog.setOnClarityCheckedListener(this);
            if (this.mNiceVideoPlayer != null) {
                this.mNiceVideoPlayer.setUp(clarities.get((int)defaultClarityIndex).videoUrl, null);
            }
        }
    }

    @Override
    protected void onPlayStateChanged(int playState) {
        switch (playState) {
            case 0: {
                break;
            }
            case 1: {
                this.mImage.setVisibility(8);
                this.mLoading.setVisibility(0);
                this.mLoadText.setText((CharSequence)"\u6b63\u5728\u51c6\u5907...");
                this.mError.setVisibility(8);
                this.mCompleted.setVisibility(8);
                this.mTop.setVisibility(8);
                this.mBottom.setVisibility(8);
                this.mCenterStart.setVisibility(8);
                this.mLength.setVisibility(8);
                break;
            }
            case 2: {
                this.startUpdateProgressTimer();
                break;
            }
            case 3: {
                this.mLoading.setVisibility(8);
                this.mRestartPause.setImageResource(R.drawable.ic_player_pause);
                this.startDismissTopBottomTimer();
                break;
            }
            case 4: {
                this.mLoading.setVisibility(8);
                this.mRestartPause.setImageResource(R.drawable.ic_player_start);
                this.cancelDismissTopBottomTimer();
                break;
            }
            case 5: {
                this.mLoading.setVisibility(0);
                this.mRestartPause.setImageResource(R.drawable.ic_player_pause);
                this.mLoadText.setText((CharSequence)"\u6b63\u5728\u7f13\u51b2...");
                this.startDismissTopBottomTimer();
                break;
            }
            case 6: {
                this.mLoading.setVisibility(0);
                this.mRestartPause.setImageResource(R.drawable.ic_player_start);
                this.mLoadText.setText((CharSequence)"\u6b63\u5728\u7f13\u51b2...");
                this.cancelDismissTopBottomTimer();
                break;
            }
            case -1: {
                this.cancelUpdateProgressTimer();
                this.setTopBottomVisible(false);
                this.mTop.setVisibility(0);
                this.mError.setVisibility(0);
                break;
            }
            case 7: {
                this.cancelUpdateProgressTimer();
                this.setTopBottomVisible(false);
                this.mImage.setVisibility(0);
                this.mCompleted.setVisibility(0);
            }
        }
    }

    @Override
    protected void onPlayModeChanged(int playMode) {
        switch (playMode) {
            case 10: {
                this.mBack.setVisibility(8);
                this.mFullScreen.setImageResource(R.drawable.ic_player_enlarge);
                this.mFullScreen.setVisibility(0);
                this.mClarity.setVisibility(8);
                this.mBatteryTime.setVisibility(8);
                if (!this.hasRegisterBatteryReceiver) break;
                this.mContext.unregisterReceiver(this.mBatterReceiver);
                this.hasRegisterBatteryReceiver = false;
                break;
            }
            case 11: {
                this.mBack.setVisibility(0);
                this.mFullScreen.setVisibility(8);
                this.mFullScreen.setImageResource(R.drawable.ic_player_shrink);
                if (this.clarities != null && this.clarities.size() > 1) {
                    this.mClarity.setVisibility(0);
                }
                this.mBatteryTime.setVisibility(0);
                if (this.hasRegisterBatteryReceiver) break;
                this.mContext.registerReceiver(this.mBatterReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
                this.hasRegisterBatteryReceiver = true;
                break;
            }
            case 12: {
                this.mBack.setVisibility(0);
                this.mClarity.setVisibility(8);
            }
        }
    }

    @Override
    protected void reset() {
        this.topBottomVisible = false;
        this.cancelUpdateProgressTimer();
        this.cancelDismissTopBottomTimer();
        this.mSeek.setProgress(0);
        this.mSeek.setSecondaryProgress(0);
        this.mCenterStart.setVisibility(0);
        this.mImage.setVisibility(0);
        this.mBottom.setVisibility(8);
        this.mFullScreen.setImageResource(R.drawable.ic_player_enlarge);
        this.mLength.setVisibility(0);
        this.mTop.setVisibility(0);
        this.mBack.setVisibility(8);
        this.mLoading.setVisibility(8);
        this.mError.setVisibility(8);
        this.mCompleted.setVisibility(8);
    }

    public void onClick(View v) {
        if (v == this.mCenterStart) {
            if (this.mNiceVideoPlayer.isIdle()) {
                this.mNiceVideoPlayer.start();
            }
        } else if (v == this.mBack) {
            if (this.mNiceVideoPlayer.isFullScreen()) {
                this.mNiceVideoPlayer.exitFullScreen();
            } else if (this.mNiceVideoPlayer.isTinyWindow()) {
                this.mNiceVideoPlayer.exitTinyWindow();
            }
        } else if (v == this.mRestartPause) {
            if (this.mNiceVideoPlayer.isPlaying() || this.mNiceVideoPlayer.isBufferingPlaying()) {
                this.mNiceVideoPlayer.pause();
            } else if (this.mNiceVideoPlayer.isPaused() || this.mNiceVideoPlayer.isBufferingPaused()) {
                this.mNiceVideoPlayer.restart();
            }
        } else if (v == this.mFullScreen) {
            if (this.mNiceVideoPlayer.isNormal() || this.mNiceVideoPlayer.isTinyWindow()) {
                this.mNiceVideoPlayer.enterFullScreen();
            } else if (this.mNiceVideoPlayer.isFullScreen()) {
                this.mNiceVideoPlayer.exitFullScreen();
            }
        } else if (v == this.mClarity) {
            this.setTopBottomVisible(false);
            this.mClarityDialog.show();
        } else if (v == this.mRetry) {
            this.mNiceVideoPlayer.restart();
        } else if (v == this.mReplay) {
            this.mRetry.performClick();
        } else if (v == this.mShare) {
            Toast.makeText((Context)this.mContext, (CharSequence)"\u5206\u4eab", (int)0).show();
        } else if (v == this && (this.mNiceVideoPlayer.isPlaying() || this.mNiceVideoPlayer.isPaused() || this.mNiceVideoPlayer.isBufferingPlaying() || this.mNiceVideoPlayer.isBufferingPaused())) {
            this.setTopBottomVisible(!this.topBottomVisible);
        }
    }

    @Override
    public void onClarityChanged(int clarityIndex) {
        Clarity clarity = this.clarities.get(clarityIndex);
        this.mClarity.setText((CharSequence)clarity.grade);
        long currentPosition = this.mNiceVideoPlayer.getCurrentPosition();
        this.mNiceVideoPlayer.releasePlayer();
        this.mNiceVideoPlayer.setUp(clarity.videoUrl, null);
        this.mNiceVideoPlayer.start(currentPosition);
    }

    @Override
    public void onClarityNotChanged() {
        this.setTopBottomVisible(true);
    }

    private void setTopBottomVisible(boolean visible) {
        this.mTop.setVisibility(visible ? 0 : 8);
        this.mBottom.setVisibility(visible ? 0 : 8);
        this.topBottomVisible = visible;
        if (visible) {
            if (!this.mNiceVideoPlayer.isPaused() && !this.mNiceVideoPlayer.isBufferingPaused()) {
                this.startDismissTopBottomTimer();
            }
        } else {
            this.cancelDismissTopBottomTimer();
        }
    }

    private void startDismissTopBottomTimer() {
        this.cancelDismissTopBottomTimer();
        if (this.mDismissTopBottomCountDownTimer == null) {
            this.mDismissTopBottomCountDownTimer = new CountDownTimer(8000L, 8000L){

                public void onTick(long millisUntilFinished) {
                }

                public void onFinish() {
                    TxVideoPlayerController.this.setTopBottomVisible(false);
                }
            };
        }
        this.mDismissTopBottomCountDownTimer.start();
    }

    private void cancelDismissTopBottomTimer() {
        if (this.mDismissTopBottomCountDownTimer != null) {
            this.mDismissTopBottomCountDownTimer.cancel();
        }
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        if (this.mNiceVideoPlayer.isBufferingPaused() || this.mNiceVideoPlayer.isPaused()) {
            this.mNiceVideoPlayer.restart();
        }
        long position = (long)((float)(this.mNiceVideoPlayer.getDuration() * (long)seekBar.getProgress()) / 100.0f);
        this.mNiceVideoPlayer.seekTo(position);
        this.startDismissTopBottomTimer();
    }

    @Override
    protected void updateProgress() {
        long position = this.mNiceVideoPlayer.getCurrentPosition();
        long duration = this.mNiceVideoPlayer.getDuration();
        int bufferPercentage = this.mNiceVideoPlayer.getBufferPercentage();
        this.mSeek.setSecondaryProgress(bufferPercentage);
        int progress = (int)(100.0f * (float)position / (float)duration);
        this.mSeek.setProgress(progress);
        this.mPosition.setText((CharSequence)NiceUtil.formatTime(position));
        this.mDuration.setText((CharSequence)NiceUtil.formatTime(duration));
        this.mTime.setText((CharSequence)new SimpleDateFormat("HH:mm", Locale.CHINA).format(new Date()));
    }

    @Override
    protected void showChangePosition(long duration, int newPositionProgress) {
        this.mChangePositon.setVisibility(0);
        long newPosition = (long)((float)(duration * (long)newPositionProgress) / 100.0f);
        this.mChangePositionCurrent.setText((CharSequence)NiceUtil.formatTime(newPosition));
        this.mChangePositionProgress.setProgress(newPositionProgress);
        this.mSeek.setProgress(newPositionProgress);
        this.mPosition.setText((CharSequence)NiceUtil.formatTime(newPosition));
    }

    @Override
    protected void hideChangePosition() {
        this.mChangePositon.setVisibility(8);
    }

    @Override
    protected void showChangeVolume(int newVolumeProgress) {
        this.mChangeVolume.setVisibility(0);
        this.mChangeVolumeProgress.setProgress(newVolumeProgress);
    }

    @Override
    protected void hideChangeVolume() {
        this.mChangeVolume.setVisibility(8);
    }

    @Override
    protected void showChangeBrightness(int newBrightnessProgress) {
        this.mChangeBrightness.setVisibility(0);
        this.mChangeBrightnessProgress.setProgress(newBrightnessProgress);
    }

    @Override
    protected void hideChangeBrightness() {
        this.mChangeBrightness.setVisibility(8);
    }
}

