/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.impl;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.util.SparseArray;
import com.xiaojinzi.component.Component;
import com.xiaojinzi.component.ComponentActivityStack;
import com.xiaojinzi.component.support.Action;
import com.xiaojinzi.component.support.Consumer;
import com.xiaojinzi.component.support.ParameterSupport;
import com.xiaojinzi.component.support.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RouterRequest {
    public static final String KEY_SYNC_URI = "_componentSyncUri";
    @Nullable
    public final Context context;
    @Nullable
    public final Fragment fragment;
    @NonNull
    public final Uri uri;
    @Nullable
    public final Integer requestCode;
    public final boolean isForResult;
    @Nullable
    public final Bundle options;
    @NonNull
    public final List<Integer> intentFlags;
    @NonNull
    public final List<String> intentCategories;
    @NonNull
    public final Bundle bundle = new Bundle();
    @Nullable
    public final Consumer<Intent> intentConsumer;
    @Nullable
    public final Action beforeAction;
    @Nullable
    public final Action beforeStartAction;
    @Nullable
    public final Action afterStartAction;
    @Nullable
    public final Action afterAction;
    @Nullable
    public final Action afterErrorAction;
    @Nullable
    public final Action afterEventAction;

    private RouterRequest(@NonNull Builder builder) {
        this.uri = builder.buildURI();
        this.context = builder.context;
        this.fragment = builder.fragment;
        this.requestCode = builder.requestCode;
        this.isForResult = builder.isForResult;
        this.options = builder.options;
        this.intentCategories = Collections.unmodifiableList(builder.intentCategories);
        this.intentFlags = Collections.unmodifiableList(builder.intentFlags);
        this.bundle.putAll(builder.bundle);
        this.intentConsumer = builder.intentConsumer;
        this.beforeAction = builder.beforeAction;
        this.beforeStartAction = builder.beforeStartAction;
        this.afterStartAction = builder.afterStartAction;
        this.afterAction = builder.afterAction;
        this.afterErrorAction = builder.afterErrorAction;
        this.afterEventAction = builder.afterEventAction;
    }

    public void syncUriToBundle() {
        if (this.bundle.getInt(KEY_SYNC_URI) == this.uri.hashCode()) {
            return;
        }
        ParameterSupport.syncUriToBundle(this.uri, this.bundle);
        this.bundle.putInt(KEY_SYNC_URI, this.uri.hashCode());
    }

    @Nullable
    public final Context getRawContext() {
        Context rawContext = null;
        if (this.context != null) {
            rawContext = this.context;
        } else if (this.fragment != null) {
            rawContext = this.fragment.getContext();
        }
        Activity rawAct = Utils.getActivityFromContext(rawContext);
        if (rawAct == null) {
            return rawContext;
        }
        if (Utils.isActivityDestoryed(rawAct)) {
            return null;
        }
        return rawContext;
    }

    @Nullable
    public final Activity getActivity() {
        if (this.context == null) {
            return null;
        }
        Activity realActivity = Utils.getActivityFromContext(this.context);
        if (realActivity == null) {
            return null;
        }
        if (Utils.isActivityDestoryed(realActivity)) {
            return null;
        }
        return realActivity;
    }

    @Nullable
    public final Activity getRawActivity() {
        Activity rawActivity = this.getActivity();
        if (rawActivity == null && this.fragment != null) {
            rawActivity = this.fragment.getActivity();
        }
        if (rawActivity == null) {
            return null;
        }
        if (Utils.isActivityDestoryed(rawActivity)) {
            return null;
        }
        return rawActivity;
    }

    @Nullable
    public final Activity getRawOrTopActivity() {
        Activity result = this.getRawActivity();
        if (result == null) {
            result = ComponentActivityStack.getInstance().getTopAliveActivity();
        }
        return result;
    }

    @NonNull
    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.fragment = this.fragment;
        builder.context = this.context;
        builder.scheme = this.uri.getScheme();
        builder.host = this.uri.getHost();
        builder.path = this.uri.getPath();
        Set queryParameterNames = this.uri.getQueryParameterNames();
        if (queryParameterNames != null) {
            for (String queryParameterName : queryParameterNames) {
                builder.queryMap.put(queryParameterName, this.uri.getQueryParameter(queryParameterName));
            }
        }
        if (builder.bundle == null) {
            builder.bundle = new Bundle();
        }
        builder.bundle.putAll(this.bundle);
        builder.requestCode = this.requestCode;
        builder.isForResult = this.isForResult;
        builder.options = this.options;
        builder.intentCategories = new ArrayList<String>(this.intentCategories);
        builder.intentFlags = new ArrayList<Integer>(this.intentFlags);
        builder.intentConsumer = this.intentConsumer;
        builder.beforeAction = this.beforeAction;
        builder.beforeStartAction = this.beforeStartAction;
        builder.afterStartAction = this.afterStartAction;
        builder.afterAction = this.afterAction;
        builder.afterErrorAction = this.afterErrorAction;
        builder.afterEventAction = this.afterEventAction;
        return builder;
    }

    public static class URIBuilder {
        @Nullable
        protected String url;
        @Nullable
        protected String scheme;
        @Nullable
        protected String userInfo;
        @Nullable
        protected String host;
        @Nullable
        protected String path;
        @Nullable
        protected Map<String, String> queryMap = new HashMap<String, String>();

        public URIBuilder url(@NonNull String url) {
            Utils.checkStringNullPointer(url, "url");
            this.url = url;
            return this;
        }

        public URIBuilder scheme(@NonNull String scheme) {
            Utils.checkStringNullPointer(scheme, "scheme");
            this.scheme = scheme;
            return this;
        }

        public URIBuilder hostAndPath(@NonNull String hostAndPath) {
            Utils.checkNullPointer(hostAndPath, "hostAndPath");
            int index = hostAndPath.indexOf("/");
            if (index > 0) {
                this.host(hostAndPath.substring(0, index));
                this.path(hostAndPath.substring(index + 1));
            } else {
                Utils.debugThrowException(new IllegalArgumentException(hostAndPath + " is invalid"));
            }
            return this;
        }

        public URIBuilder userInfo(@NonNull String userInfo) {
            Utils.checkStringNullPointer(userInfo, "userInfo");
            this.userInfo = userInfo;
            return this;
        }

        public URIBuilder host(@NonNull String host) {
            Utils.checkStringNullPointer(host, "host");
            this.host = host;
            return this;
        }

        public URIBuilder path(@NonNull String path) {
            Utils.checkStringNullPointer(path, "path");
            this.path = path;
            return this;
        }

        public URIBuilder query(@NonNull String queryName, @NonNull String queryValue) {
            Utils.checkStringNullPointer(queryName, "queryName");
            Utils.checkStringNullPointer(queryValue, "queryValue");
            this.queryMap.put(queryName, queryValue);
            return this;
        }

        public URIBuilder query(@NonNull String queryName, boolean queryValue) {
            return this.query(queryName, String.valueOf(queryValue));
        }

        public URIBuilder query(@NonNull String queryName, byte queryValue) {
            return this.query(queryName, String.valueOf(queryValue));
        }

        public URIBuilder query(@NonNull String queryName, int queryValue) {
            return this.query(queryName, String.valueOf(queryValue));
        }

        public URIBuilder query(@NonNull String queryName, float queryValue) {
            return this.query(queryName, String.valueOf(queryValue));
        }

        public URIBuilder query(@NonNull String queryName, long queryValue) {
            return this.query(queryName, String.valueOf(queryValue));
        }

        public URIBuilder query(@NonNull String queryName, double queryValue) {
            return this.query(queryName, String.valueOf(queryValue));
        }

        @NonNull
        public Uri buildURI() {
            URIBuilder builder = this;
            Uri result = null;
            if (builder.url == null) {
                Uri.Builder uriBuilder = new Uri.Builder();
                StringBuffer authoritySB = new StringBuffer();
                if (this.userInfo != null && !this.userInfo.isEmpty()) {
                    authoritySB.append(Uri.encode((String)this.userInfo)).append("@");
                }
                authoritySB.append(Uri.encode((String)Utils.checkStringNullPointer(builder.host, "host", "do you forget call host() to set host?")));
                uriBuilder.scheme(TextUtils.isEmpty((CharSequence)builder.scheme) ? Component.getConfig().getDefaultScheme() : builder.scheme).encodedAuthority(authoritySB.toString()).path(Utils.checkStringNullPointer(builder.path, "path", "do you forget call path() to set path?"));
                for (Map.Entry<String, String> entry : builder.queryMap.entrySet()) {
                    uriBuilder.appendQueryParameter(entry.getKey(), entry.getValue());
                }
                result = uriBuilder.build();
            } else {
                result = Uri.parse((String)builder.url);
                if (builder.queryMap.size() > 0) {
                    Uri.Builder uriBuilder = result.buildUpon();
                    for (Map.Entry<String, String> entry : builder.queryMap.entrySet()) {
                        uriBuilder.appendQueryParameter(entry.getKey(), entry.getValue());
                    }
                    result = uriBuilder.build();
                }
            }
            return result;
        }

        @NonNull
        public String buildURL() {
            return this.buildURI().toString();
        }
    }

    public static class Builder
    extends URIBuilder {
        @Nullable
        protected Bundle options;
        @NonNull
        protected List<Integer> intentFlags = new ArrayList<Integer>(2);
        @NonNull
        protected List<String> intentCategories = new ArrayList<String>(2);
        @Nullable
        protected Bundle bundle = new Bundle();
        @Nullable
        protected Context context;
        @Nullable
        protected Fragment fragment;
        @Nullable
        protected Integer requestCode;
        protected boolean isForResult;
        @Nullable
        protected Consumer<Intent> intentConsumer;
        @Nullable
        protected Action beforeAction;
        @Nullable
        protected Action beforeStartAction;
        @Nullable
        protected Action afterStartAction;
        @Nullable
        protected Action afterAction;
        @Nullable
        protected Action afterErrorAction;
        @Nullable
        protected Action afterEventAction;

        public Builder context(@Nullable Context context) {
            this.context = context;
            return this;
        }

        public Builder fragment(@Nullable Fragment fragment) {
            this.fragment = fragment;
            return this;
        }

        public Builder beforeAction(@Nullable @UiThread Action action) {
            this.beforeAction = action;
            return this;
        }

        public Builder beforeStartAction(@Nullable @UiThread Action action) {
            this.beforeStartAction = action;
            return this;
        }

        public Builder afterStartAction(@Nullable @UiThread Action action) {
            this.afterStartAction = action;
            return this;
        }

        public Builder afterAction(@Nullable @UiThread Action action) {
            this.afterAction = action;
            return this;
        }

        public Builder afterErrorAction(@Nullable @UiThread Action action) {
            this.afterErrorAction = action;
            return this;
        }

        public Builder afterEventAction(@Nullable @UiThread Action action) {
            this.afterEventAction = action;
            return this;
        }

        public Builder requestCode(@Nullable Integer requestCode) {
            this.requestCode = requestCode;
            return this;
        }

        public Builder intentConsumer(@Nullable @UiThread Consumer<Intent> intentConsumer) {
            this.intentConsumer = intentConsumer;
            return this;
        }

        public Builder addIntentFlags(Integer ... flags) {
            if (flags != null) {
                this.intentFlags.addAll(Arrays.asList(flags));
            }
            return this;
        }

        public Builder addIntentCategories(String ... categories) {
            if (categories != null) {
                this.intentCategories.addAll(Arrays.asList(categories));
            }
            return this;
        }

        public Builder options(@Nullable Bundle options) {
            this.options = options;
            return this;
        }

        @Override
        public Builder url(@NonNull String url) {
            super.url(url);
            return this;
        }

        @Override
        public Builder scheme(@NonNull String scheme) {
            super.scheme(scheme);
            return this;
        }

        @Override
        public Builder hostAndPath(@NonNull String hostAndPath) {
            super.hostAndPath(hostAndPath);
            return this;
        }

        @Override
        public Builder userInfo(@NonNull String userInfo) {
            super.userInfo(userInfo);
            return this;
        }

        @Override
        public Builder host(@NonNull String host) {
            super.host(host);
            return this;
        }

        @Override
        public Builder path(@NonNull String path) {
            super.path(path);
            return this;
        }

        public Builder putAll(@NonNull Bundle bundle) {
            Utils.checkNullPointer(bundle, "bundle");
            this.bundle.putAll(bundle);
            return this;
        }

        public Builder putBundle(@NonNull String key, @Nullable Bundle bundle) {
            this.bundle.putBundle(key, bundle);
            return this;
        }

        public Builder putCharSequence(@NonNull String key, @Nullable CharSequence value) {
            this.bundle.putCharSequence(key, value);
            return this;
        }

        public Builder putCharSequenceArray(@NonNull String key, @Nullable CharSequence[] value) {
            this.bundle.putCharSequenceArray(key, value);
            return this;
        }

        public Builder putCharSequenceArrayList(@NonNull String key, @Nullable ArrayList<CharSequence> value) {
            this.bundle.putCharSequenceArrayList(key, value);
            return this;
        }

        public Builder putByte(@NonNull String key, @Nullable byte value) {
            this.bundle.putByte(key, value);
            return this;
        }

        public Builder putByteArray(@NonNull String key, @Nullable byte[] value) {
            this.bundle.putByteArray(key, value);
            return this;
        }

        public Builder putChar(@NonNull String key, @Nullable char value) {
            this.bundle.putChar(key, value);
            return this;
        }

        public Builder putCharArray(@NonNull String key, @Nullable char[] value) {
            this.bundle.putCharArray(key, value);
            return this;
        }

        public Builder putBoolean(@NonNull String key, @Nullable boolean value) {
            this.bundle.putBoolean(key, value);
            return this;
        }

        public Builder putBooleanArray(@NonNull String key, @Nullable boolean[] value) {
            this.bundle.putBooleanArray(key, value);
            return this;
        }

        public Builder putString(@NonNull String key, @Nullable String value) {
            this.bundle.putString(key, value);
            return this;
        }

        public Builder putStringArray(@NonNull String key, @Nullable String[] value) {
            this.bundle.putStringArray(key, value);
            return this;
        }

        public Builder putStringArrayList(@NonNull String key, @Nullable ArrayList<String> value) {
            this.bundle.putStringArrayList(key, value);
            return this;
        }

        public Builder putShort(@NonNull String key, @Nullable short value) {
            this.bundle.putShort(key, value);
            return this;
        }

        public Builder putShortArray(@NonNull String key, @Nullable short[] value) {
            this.bundle.putShortArray(key, value);
            return this;
        }

        public Builder putInt(@NonNull String key, @Nullable int value) {
            this.bundle.putInt(key, value);
            return this;
        }

        public Builder putIntArray(@NonNull String key, @Nullable int[] value) {
            this.bundle.putIntArray(key, value);
            return this;
        }

        public Builder putIntegerArrayList(@NonNull String key, @Nullable ArrayList<Integer> value) {
            this.bundle.putIntegerArrayList(key, value);
            return this;
        }

        public Builder putLong(@NonNull String key, @Nullable long value) {
            this.bundle.putLong(key, value);
            return this;
        }

        public Builder putLongArray(@NonNull String key, @Nullable long[] value) {
            this.bundle.putLongArray(key, value);
            return this;
        }

        public Builder putFloat(@NonNull String key, @Nullable float value) {
            this.bundle.putFloat(key, value);
            return this;
        }

        public Builder putFloatArray(@NonNull String key, @Nullable float[] value) {
            this.bundle.putFloatArray(key, value);
            return this;
        }

        public Builder putDouble(@NonNull String key, @Nullable double value) {
            this.bundle.putDouble(key, value);
            return this;
        }

        public Builder putDoubleArray(@NonNull String key, @Nullable double[] value) {
            this.bundle.putDoubleArray(key, value);
            return this;
        }

        public Builder putParcelable(@NonNull String key, @Nullable Parcelable value) {
            this.bundle.putParcelable(key, value);
            return this;
        }

        public Builder putParcelableArray(@NonNull String key, @Nullable Parcelable[] value) {
            this.bundle.putParcelableArray(key, value);
            return this;
        }

        public Builder putParcelableArrayList(@NonNull String key, @Nullable ArrayList<? extends Parcelable> value) {
            this.bundle.putParcelableArrayList(key, value);
            return this;
        }

        public Builder putSparseParcelableArray(@NonNull String key, @Nullable SparseArray<? extends Parcelable> value) {
            this.bundle.putSparseParcelableArray(key, value);
            return this;
        }

        public Builder putSerializable(@NonNull String key, @Nullable Serializable value) {
            this.bundle.putSerializable(key, value);
            return this;
        }

        @Override
        public Builder query(@NonNull String queryName, @NonNull String queryValue) {
            super.query(queryName, queryValue);
            return this;
        }

        @Override
        public Builder query(@NonNull String queryName, boolean queryValue) {
            super.query(queryName, queryValue);
            return this;
        }

        @Override
        public Builder query(@NonNull String queryName, byte queryValue) {
            super.query(queryName, queryValue);
            return this;
        }

        @Override
        public Builder query(@NonNull String queryName, int queryValue) {
            super.query(queryName, queryValue);
            return this;
        }

        @Override
        public Builder query(@NonNull String queryName, float queryValue) {
            super.query(queryName, queryValue);
            return this;
        }

        @Override
        public Builder query(@NonNull String queryName, long queryValue) {
            super.query(queryName, queryValue);
            return this;
        }

        @Override
        public Builder query(@NonNull String queryName, double queryValue) {
            super.query(queryName, queryValue);
            return this;
        }

        @NonNull
        public RouterRequest build() {
            return new RouterRequest(this);
        }
    }
}

