/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.cache;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.xiaojinzi.component.cache.Cache;
import com.xiaojinzi.component.support.Utils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class LruCache<K, V>
implements Cache<K, V> {
    private final LinkedHashMap<K, V> cache = new LinkedHashMap(100, 0.75f, true);
    private final int initialMaxSize;
    private int maxSize;
    private int currentSize = 0;

    public LruCache(int size) {
        this.initialMaxSize = size;
        this.maxSize = size;
    }

    public synchronized void setSizeMultiplier(float multiplier) {
        if (multiplier < 0.0f) {
            throw new IllegalArgumentException("Multiplier must be >= 0");
        }
        this.maxSize = Math.round((float)this.initialMaxSize * multiplier);
        this.evict();
    }

    protected int getItemSize(K key, V value) {
        return 1;
    }

    private int safeSizeOf(K key, V value) {
        int result = this.getItemSize(key, value);
        if (result < 0) {
            throw new IllegalStateException("Negative Size: " + key + "=" + value);
        }
        return result;
    }

    protected void onItemEvicted(K key, V value) {
    }

    @Override
    public synchronized int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public synchronized int size() {
        return this.currentSize;
    }

    @Override
    public synchronized boolean containsKey(@NonNull K key) {
        Utils.checkNullPointer(key, "key");
        return this.cache.containsKey(key);
    }

    @Override
    public synchronized Set<K> keySet() {
        return this.cache.keySet();
    }

    @Override
    @Nullable
    public synchronized V get(@NonNull K key) {
        Utils.checkNullPointer(key, "key");
        return this.cache.get(key);
    }

    @Override
    @Nullable
    public synchronized V put(@NonNull K key, @Nullable V value) {
        Utils.checkNullPointer(key, "key");
        int itemSize = this.safeSizeOf(key, value);
        if (itemSize >= this.maxSize) {
            this.onItemEvicted(key, value);
            return null;
        }
        V result = this.cache.put(key, value);
        if (value != null) {
            this.currentSize += this.safeSizeOf(key, value);
        }
        if (result != null) {
            this.currentSize -= this.safeSizeOf(key, result);
        }
        this.evict();
        return result;
    }

    @Override
    @Nullable
    public synchronized V remove(@NonNull K key) {
        Utils.checkNullPointer(key, "key");
        Object value = this.cache.remove(key);
        if (value != null) {
            this.currentSize -= this.safeSizeOf(key, value);
        }
        return value;
    }

    @Override
    public void clear() {
        this.trimToSize(0);
    }

    protected synchronized void trimToSize(int size) {
        Iterator<Map.Entry<K, V>> iterator = null;
        while (this.currentSize > size) {
            if (iterator == null) {
                iterator = this.cache.entrySet().iterator();
            }
            Map.Entry last = (Map.Entry)iterator.next();
            Object key = last.getKey();
            Object value = last.getValue();
            iterator.remove();
            this.currentSize -= this.safeSizeOf(key, value);
            this.onItemEvicted(key, value);
        }
    }

    private void evict() {
        this.trimToSize(this.maxSize);
    }
}

