/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component;

import android.app.Application;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.xiaojinzi.component.support.ObjectToJsonConverter;
import com.xiaojinzi.component.support.Utils;

public class Config {
    @NonNull
    private final Application application;
    @NonNull
    private final String defaultScheme;
    private final boolean isErrorCheck;
    private final boolean isInitRouterAsync;
    private final boolean isOptimizeInit;
    private final boolean isAutoRegisterModule;
    private final boolean isTipWhenUseApplication;
    private final boolean isUseRouteRepeatCheckInterceptor;
    private final long routeRepeatCheckDuration;
    private final ObjectToJsonConverter objectToJsonConverter;
    private final long notifyModuleChangedDelayTime;

    private Config(@NonNull Builder builder) {
        this.application = builder.application;
        this.isErrorCheck = builder.isErrorCheck;
        this.isInitRouterAsync = builder.isInitRouterAsync;
        this.isOptimizeInit = builder.isOptimizeInit;
        this.isAutoRegisterModule = builder.isAutoRegisterModule;
        this.isTipWhenUseApplication = builder.isTipWhenUseApplication;
        this.defaultScheme = builder.defaultScheme;
        this.isUseRouteRepeatCheckInterceptor = builder.isUseRouteRepeatCheckInterceptor;
        this.routeRepeatCheckDuration = builder.routeRepeatCheckDuration;
        this.objectToJsonConverter = builder.objectToJsonConverter;
        this.notifyModuleChangedDelayTime = builder.notifyModuleChangedDelayTime;
    }

    @NonNull
    public Application getApplication() {
        return this.application;
    }

    @NonNull
    public String getDefaultScheme() {
        return this.defaultScheme;
    }

    public boolean isErrorCheck() {
        return this.isErrorCheck;
    }

    public boolean isInitRouterAsync() {
        return this.isInitRouterAsync;
    }

    public boolean isOptimizeInit() {
        return this.isOptimizeInit;
    }

    public boolean isAutoRegisterModule() {
        return this.isAutoRegisterModule;
    }

    public boolean isTipWhenUseApplication() {
        return this.isTipWhenUseApplication;
    }

    public boolean isUseRouteRepeatCheckInterceptor() {
        return this.isUseRouteRepeatCheckInterceptor;
    }

    public long getRouteRepeatCheckDuration() {
        return this.routeRepeatCheckDuration;
    }

    @Nullable
    public ObjectToJsonConverter getObjectToJsonConverter() {
        return this.objectToJsonConverter;
    }

    public long getNotifyModuleChangedDelayTime() {
        return this.notifyModuleChangedDelayTime;
    }

    @NonNull
    public static Builder with(@NonNull Application application) {
        return new Builder(application);
    }

    public static class Builder {
        private Application application;
        private String defaultScheme = "router";
        private boolean isErrorCheck = true;
        private boolean isInitRouterAsync = true;
        private boolean isOptimizeInit = false;
        private boolean isAutoRegisterModule = false;
        private boolean isTipWhenUseApplication = true;
        private boolean isUseRouteRepeatCheckInterceptor = true;
        private long routeRepeatCheckDuration = 1000L;
        private ObjectToJsonConverter objectToJsonConverter;
        private long notifyModuleChangedDelayTime = 0L;
        private boolean isUsed = false;

        public Builder(@NonNull Application application) {
            Utils.checkNullPointer(application, "application");
            this.application = application;
        }

        public Builder defaultScheme(String defaultScheme) {
            Utils.checkStringNullPointer(defaultScheme, "defaultScheme");
            this.defaultScheme = defaultScheme;
            return this;
        }

        public Builder initRouterAsync(boolean isInitRouterAsync) {
            this.isInitRouterAsync = isInitRouterAsync;
            return this;
        }

        public Builder errorCheck(boolean isCheck) {
            this.isErrorCheck = isCheck;
            return this;
        }

        public Builder optimizeInit(boolean isOptimizeInit) {
            this.isOptimizeInit = isOptimizeInit;
            return this;
        }

        public Builder autoRegisterModule(boolean isAutoRegisterModule) {
            this.isAutoRegisterModule = isAutoRegisterModule;
            return this;
        }

        public Builder tipWhenUseApplication(boolean isTipWhenUseApplication) {
            this.isTipWhenUseApplication = isTipWhenUseApplication;
            return this;
        }

        public Builder useRouteRepeatCheckInterceptor(boolean isUseRouteRepeatCheckInterceptor) {
            this.isUseRouteRepeatCheckInterceptor = isUseRouteRepeatCheckInterceptor;
            return this;
        }

        public Builder routeRepeatCheckDuration(long routeRepeatCheckDuration) {
            this.routeRepeatCheckDuration = routeRepeatCheckDuration;
            return this;
        }

        public Builder objectToJsonConverter(ObjectToJsonConverter objectToJsonConverter) {
            this.objectToJsonConverter = objectToJsonConverter;
            return this;
        }

        public Builder notifyModuleChangedDelayTime(long notifyModuleChangedDelayTime) {
            this.notifyModuleChangedDelayTime = notifyModuleChangedDelayTime;
            return this;
        }

        @NonNull
        public Config build() {
            Utils.checkNullPointer(this.application, "application");
            Utils.checkNullPointer(this.defaultScheme, "application");
            if (this.isAutoRegisterModule && !this.isOptimizeInit) {
                throw new UnsupportedOperationException("you must call optimizeInit(true) method");
            }
            if (this.isUsed) {
                throw new UnsupportedOperationException("this builder only can build once!");
            }
            this.isUsed = true;
            Config config = new Config(this);
            this.application = null;
            this.defaultScheme = null;
            return config;
        }
    }
}

