/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.xiaojinzi.component.support.Utils;
import java.util.Stack;

public class ComponentActivityStack {
    private Stack<Activity> activityStack = new Stack();

    private ComponentActivityStack() {
    }

    @UiThread
    public static ComponentActivityStack getInstance() {
        return Holder.INSTANCE;
    }

    public synchronized void pushActivity(Activity activity) {
        if (activity == null) {
            return;
        }
        if (this.activityStack.contains(activity)) {
            return;
        }
        this.activityStack.add(activity);
    }

    public synchronized void removeActivity(Activity activity) {
        this.activityStack.remove(activity);
    }

    public synchronized boolean isEmpty() {
        return this.activityStack == null || this.activityStack.size() == 0;
    }

    public synchronized int getSize() {
        if (this.activityStack == null) {
            return 0;
        }
        return this.activityStack.size();
    }

    @Nullable
    public synchronized Activity getTopActivity() {
        return this.isEmpty() ? null : (Activity)this.activityStack.get(this.activityStack.size() - 1);
    }

    @Nullable
    public synchronized Activity getTopAliveActivity() {
        Activity result = null;
        if (!this.isEmpty()) {
            int size = this.activityStack.size();
            for (int i = size - 1; i >= 0; --i) {
                Activity activity = (Activity)this.activityStack.get(i);
                if (Utils.isActivityDestoryed(activity)) continue;
                result = activity;
                break;
            }
        }
        return result;
    }

    @Nullable
    public synchronized Activity getTopActivityExcept(@NonNull Class<? extends Activity> clazz) {
        int size = this.activityStack.size();
        for (int i = size - 1; i >= 0; --i) {
            Activity itemActivity = (Activity)this.activityStack.get(i);
            if (itemActivity.getClass() == clazz) continue;
            return itemActivity;
        }
        return null;
    }

    @Nullable
    public synchronized Activity getSecondTopActivity() {
        return this.isEmpty() || this.activityStack.size() < 2 ? null : (Activity)this.activityStack.get(this.activityStack.size() - 2);
    }

    @Nullable
    public synchronized Activity getBottomActivity() {
        return this.isEmpty() || this.activityStack.size() < 1 ? null : (Activity)this.activityStack.get(0);
    }

    public synchronized boolean isExistActivity(@NonNull Class<? extends Activity> clazz) {
        for (Activity activity : this.activityStack) {
            if (activity.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isExistOtherActivityExcept(@NonNull Class<? extends Activity> clazz) {
        for (Activity activity : this.activityStack) {
            if (activity.getClass() == clazz) continue;
            return true;
        }
        return false;
    }

    private static class Holder {
        private static ComponentActivityStack INSTANCE = new ComponentActivityStack();

        private Holder() {
        }
    }
}

