/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component;

import com.google.auto.service.AutoService;
import com.google.gson.Gson;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.xiaojinzi.component.BaseHostProcessor;
import com.xiaojinzi.component.ComponentUtil;
import com.xiaojinzi.component.ProcessException;
import com.xiaojinzi.component.Utils;
import com.xiaojinzi.component.anno.AttrValueAutowiredAnno;
import com.xiaojinzi.component.anno.ServiceAutowiredAnno;
import com.xiaojinzi.component.bean.ActivityAttrDocBean;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.collections4.CollectionUtils;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedAnnotationTypes(value={"com.xiaojinzi.component.anno.AttrValueAutowiredAnno", "com.xiaojinzi.component.anno.ServiceAutowiredAnno"})
@AutoService(value={Processor.class})
public class AutowireProcessor
extends BaseHostProcessor {
    @Nullable
    private TypeElement kotlinJvmFieldTypeElement;
    @Nullable
    private Class kotlinJvmFieldClass;
    private TypeElement charsequenceTypeElement;
    private TypeMirror charsequenceTypeMirror;
    private TypeName charsequenceTypeName;
    private ClassName injectClassName = null;
    private TypeMirror parameterSupportTypeMirror;
    private TypeMirror serializableTypeMirror;
    private TypeMirror parcelableTypeMirror;
    private TypeMirror activityTypeMirror;
    private TypeMirror fragmentTypeMirror;
    @Nullable
    private TypeMirror kotlinMetadataTypeMirror;
    private TypeElement serviceTypeElement;
    private TypeElement arrayListTypeElement;
    private ClassName arrayListClassName;
    private TypeElement bundleTypeElement;
    private AtomicInteger intCount = new AtomicInteger();
    private Map<TypeElement, Set<VariableElement>> map = new HashMap<TypeElement, Set<VariableElement>>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.bundleTypeElement = this.mElements.getTypeElement("android.os.Bundle");
        this.kotlinJvmFieldTypeElement = this.mElements.getTypeElement("kotlin.jvm.JvmField");
        try {
            this.kotlinJvmFieldClass = Class.forName("kotlin.jvm.JvmField");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.charsequenceTypeElement = this.mElements.getTypeElement("java.lang.CharSequence");
        this.charsequenceTypeMirror = this.charsequenceTypeElement.asType();
        this.charsequenceTypeName = ClassName.get((TypeMirror)this.charsequenceTypeMirror);
        this.serviceTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.impl.service.ServiceManager");
        TypeElement injectTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.support.Inject");
        this.injectClassName = ClassName.get((TypeElement)injectTypeElement);
        TypeElement parameterSupportTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.support.ParameterSupport");
        this.parameterSupportTypeMirror = parameterSupportTypeElement.asType();
        TypeElement serializableTypeElement = this.mElements.getTypeElement("java.io.Serializable");
        this.serializableTypeMirror = serializableTypeElement.asType();
        TypeElement parcelableTypeElement = this.mElements.getTypeElement("android.os.Parcelable");
        this.parcelableTypeMirror = parcelableTypeElement.asType();
        TypeElement kotlinMetadataTypeElement = this.mElements.getTypeElement("kotlin.Metadata");
        if (kotlinMetadataTypeElement != null) {
            this.kotlinMetadataTypeMirror = kotlinMetadataTypeElement.asType();
        }
        this.arrayListTypeElement = this.mElements.getTypeElement("java.util.ArrayList");
        this.arrayListClassName = ClassName.get((TypeElement)this.arrayListTypeElement);
        this.activityTypeMirror = this.mElements.getTypeElement("android.app.Activity").asType();
        TypeElement typeElementFragment = this.mElements.getTypeElement("android.support.v4.app.Fragment");
        if (typeElementFragment == null) {
            throw new ProcessException(this.getAddDependencyTip(Arrays.asList("android.support.v4.app.Fragment"), false));
        }
        this.fragmentTypeMirror = typeElementFragment.asType();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (CollectionUtils.isNotEmpty(set)) {
            Set<? extends Element> filedAutowiredElements = roundEnvironment.getElementsAnnotatedWith(AttrValueAutowiredAnno.class);
            Set<? extends Element> serviceAutowiredElements = roundEnvironment.getElementsAnnotatedWith(ServiceAutowiredAnno.class);
            HashSet<Element> annotatedElements = new HashSet<Element>();
            annotatedElements.addAll(filedAutowiredElements);
            annotatedElements.addAll(serviceAutowiredElements);
            HashSet<VariableElement> fieldElements = new HashSet<VariableElement>();
            for (Element element : annotatedElements) {
                if (!(element instanceof VariableElement) || !(element.getEnclosingElement() instanceof TypeElement)) continue;
                VariableElement variableElement = (VariableElement)element;
                fieldElements.add(variableElement);
            }
            this.findSameTargetElement(fieldElements);
            this.createImpl();
            try {
                this.createRouterAttrDocJson();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private void findSameTargetElement(Set<VariableElement> fieldElements) {
        for (VariableElement variableElement : fieldElements) {
            TypeElement typeElement = (TypeElement)variableElement.getEnclosingElement();
            Set<VariableElement> variableElements = this.map.get(typeElement);
            if (variableElements == null) {
                variableElements = new HashSet<VariableElement>();
                this.map.put(typeElement, variableElements);
            }
            variableElements.add(variableElement);
        }
    }

    private void createImpl() {
        Set<Map.Entry<TypeElement, Set<VariableElement>>> entrySet = this.map.entrySet();
        for (Map.Entry<TypeElement, Set<VariableElement>> entry : entrySet) {
            TypeElement targetClass = entry.getKey();
            Set<VariableElement> parameterFieldSet = entry.getValue();
            this.createInjectClass(targetClass, parameterFieldSet);
        }
    }

    private void createInjectClass(TypeElement targetClass, Set<VariableElement> parameterFieldSet) {
        boolean isKotlinFile = Utils.isKotlinFile(targetClass);
        String fullClassName = targetClass.getQualifiedName().toString();
        int lastPointIndex = fullClassName.lastIndexOf(46);
        String pkg = fullClassName.substring(0, lastPointIndex);
        String className = fullClassName.substring(lastPointIndex + 1);
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)(className + "_inject")).addAnnotation(this.mClassNameKeep).addAnnotation(this.mClassNameComponentGeneratedAnno).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)this.injectClassName, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)this.mElements.getTypeElement(fullClassName).asType())})).addMethod(this.injectAttrValueMethod1(targetClass)).addMethod(this.injectAttrValueMethod2(targetClass, isKotlinFile, parameterFieldSet)).addMethod(this.injectServiceMethod(isKotlinFile, targetClass, parameterFieldSet));
        try {
            JavaFile.builder((String)pkg, (TypeSpec)classBuilder.build()).indent("    ").build().writeTo(this.mFiler);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createRouterAttrDocJson() throws IOException {
        if (!this.isRouterDocEnable()) {
            return;
        }
        File attrFolder = new File(this.routerDocFolder, "attr");
        if (attrFolder.exists() && attrFolder.isFile()) {
            attrFolder.delete();
        }
        attrFolder.mkdirs();
        Set<Map.Entry<TypeElement, Set<VariableElement>>> entrySet = this.map.entrySet();
        Gson gson = new Gson();
        for (Map.Entry<TypeElement, Set<VariableElement>> entry : entrySet) {
            File file;
            ArrayList<ActivityAttrDocBean> activityAttrDocBeans = new ArrayList<ActivityAttrDocBean>();
            TypeElement targetClass = entry.getKey();
            TypeMirror targetClassTypeMirror = targetClass.asType();
            if (this.mTypes.isSubtype(targetClassTypeMirror, this.activityTypeMirror)) {
                Set<VariableElement> variableElementSet = entry.getValue();
                for (VariableElement variableElement : variableElementSet) {
                    AttrValueAutowiredAnno attrValueAutowiredAnno = variableElement.getAnnotation(AttrValueAutowiredAnno.class);
                    if (attrValueAutowiredAnno == null) continue;
                    ActivityAttrDocBean activityAttrDocBean = new ActivityAttrDocBean();
                    activityAttrDocBean.setAttrKey(attrValueAutowiredAnno.value());
                    activityAttrDocBean.setAttrType(variableElement.asType().toString());
                    activityAttrDocBeans.add(activityAttrDocBean);
                }
            }
            if ((file = new File(attrFolder, targetClassTypeMirror.toString() + ".json")).exists()) {
                file.delete();
            }
            String json = gson.toJson(activityAttrDocBeans);
            FileWriter writer = new FileWriter(file);
            writer.write(json);
            ((Writer)writer).close();
        }
    }

    private MethodSpec injectAttrValueMethod1(TypeElement targetClass) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"injectAttrValue").addJavadoc("\u5c5e\u6027\u6ce8\u5165\n", new Object[0]).addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)targetClass.asType()), (String)"target", (Modifier[])new Modifier[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.mTypes.isSubtype(targetClass.asType(), this.activityTypeMirror)) {
            methodBuilder.addStatement("injectAttrValue(target, target.getIntent().getExtras())", new Object[0]);
        } else if (this.mTypes.isSubtype(targetClass.asType(), this.fragmentTypeMirror)) {
            methodBuilder.addStatement("injectAttrValue(target, target.getArguments())", new Object[0]);
        }
        return methodBuilder.build();
    }

    private MethodSpec injectAttrValueMethod2(TypeElement targetClass, boolean isKotlinFile, Set<VariableElement> parameterFieldSet) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"injectAttrValue").addJavadoc("\u5c5e\u6027\u6ce8\u5165\n", new Object[0]).addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)targetClass.asType()), (String)"target", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)this.bundleTypeElement.asType()), (String)"bundle", (Modifier[])new Modifier[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        methodBuilder.beginControlFlow("if(bundle == null)", new Object[0]);
        methodBuilder.addStatement("return", new Object[0]);
        methodBuilder.endControlFlow();
        for (VariableElement variableElement : parameterFieldSet) {
            String parameterOwnerName = "target";
            String parameterName = variableElement.getSimpleName().toString();
            this.generateParameterCodeForInject(isKotlinFile, variableElement, methodBuilder, parameterOwnerName, parameterName, "bundle");
        }
        return methodBuilder.build();
    }

    private MethodSpec injectServiceMethod(boolean isKotlinFile, TypeElement targetClass, Set<VariableElement> parameterFieldSet) {
        String parameterOwnerName = "target";
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"injectService").addJavadoc("Service\u6ce8\u5165\n", new Object[0]).addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)targetClass.asType()), (String)"target", (Modifier[])new Modifier[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (VariableElement variableElement : parameterFieldSet) {
            this.generateParameterCodeForInjectService(isKotlinFile, parameterOwnerName, variableElement, methodBuilder);
        }
        return methodBuilder.build();
    }

    public void generateParameterCodeForInject(boolean isKotlinFile, VariableElement variableElement, MethodSpec.Builder methodBuilder, String parameterOwnerName, String parameterName, String bundleCallStr) {
        AttrValueAutowiredAnno attrValueAutowiredAnno = variableElement.getAnnotation(AttrValueAutowiredAnno.class);
        TypeMirror variableTypeMirror = variableElement.asType();
        TypeName parameterClassName = ClassName.get((TypeMirror)variableTypeMirror);
        if (attrValueAutowiredAnno != null) {
            String[] keyNames = attrValueAutowiredAnno.value();
            if (keyNames.length == 1) {
                this.generateOneGetValueCode(isKotlinFile, variableElement, methodBuilder, parameterOwnerName, parameterName, bundleCallStr, variableTypeMirror, parameterClassName, keyNames[0]);
            } else {
                for (int i = 0; i < keyNames.length; ++i) {
                    String keyName = keyNames[i];
                    if (i == 0) {
                        methodBuilder.beginControlFlow("if($T.containsKey($N, $S))", new Object[]{this.parameterSupportTypeMirror, bundleCallStr, keyName});
                    } else {
                        methodBuilder.beginControlFlow("else if($T.containsKey($N, $S))", new Object[]{this.parameterSupportTypeMirror, bundleCallStr, keyName});
                    }
                    this.generateOneGetValueCode(isKotlinFile, variableElement, methodBuilder, parameterOwnerName, parameterName, bundleCallStr, variableTypeMirror, parameterClassName, keyNames[i]);
                    methodBuilder.endControlFlow();
                }
            }
        }
    }

    private void generateOneGetValueCode(boolean isKotlinFile, VariableElement variableElement, MethodSpec.Builder methodBuilder, String parameterOwnerName, String parameterName, String bundleCallStr, TypeMirror variableTypeMirror, TypeName parameterClassName, String keyName) {
        String parameterCallStr = parameterOwnerName + "." + parameterName;
        String tempMethodName = null;
        boolean isBoolean = false;
        if (parameterClassName.equals((Object)this.mClassNameString)) {
            tempMethodName = "getString";
        } else if (parameterClassName.equals((Object)this.charsequenceTypeName)) {
            tempMethodName = "getCharSequence";
        } else if (parameterClassName.equals((Object)ClassName.CHAR) || parameterClassName.equals((Object)ClassName.CHAR.box())) {
            tempMethodName = "getChar";
        } else if (parameterClassName.equals((Object)ClassName.BYTE) || parameterClassName.equals((Object)ClassName.BYTE.box())) {
            tempMethodName = "getByte";
        } else if (parameterClassName.equals((Object)ClassName.SHORT) || parameterClassName.equals((Object)ClassName.SHORT.box())) {
            tempMethodName = "getShort";
        } else if (parameterClassName.equals((Object)ClassName.INT) || parameterClassName.equals((Object)ClassName.INT.box())) {
            tempMethodName = "getInt";
        } else if (parameterClassName.equals((Object)ClassName.LONG) || parameterClassName.equals((Object)ClassName.LONG.box())) {
            tempMethodName = "getLong";
        } else if (parameterClassName.equals((Object)ClassName.FLOAT) || parameterClassName.equals((Object)ClassName.FLOAT.box())) {
            tempMethodName = "getFloat";
        } else if (parameterClassName.equals((Object)ClassName.DOUBLE) || parameterClassName.equals((Object)ClassName.DOUBLE.box())) {
            tempMethodName = "getDouble";
        } else if (parameterClassName.equals((Object)ClassName.BOOLEAN) || parameterClassName.equals((Object)ClassName.BOOLEAN.box())) {
            tempMethodName = "getBoolean";
            isBoolean = true;
        } else if (variableTypeMirror instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)variableTypeMirror;
            if (declaredType.asElement() instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                ClassName className = ClassName.get((TypeElement)typeElement);
                if (this.arrayListClassName.equals((Object)className)) {
                    List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                    if (typeArguments.size() == 1) {
                        String tempArrayListMethodName = null;
                        if (this.mTypeElementString.asType().equals(typeArguments.get(0))) {
                            tempArrayListMethodName = "getStringArrayList";
                        } else if (this.mTypes.isSubtype(typeArguments.get(0), this.parcelableTypeMirror)) {
                            tempArrayListMethodName = "getParcelableArrayList";
                        } else if (this.mTypes.isSubtype(typeArguments.get(0), this.serializableTypeMirror)) {
                            tempArrayListMethodName = "getSerializable";
                        } else if (this.charsequenceTypeMirror.equals(typeArguments.get(0))) {
                            tempArrayListMethodName = "getCharSequenceArrayList";
                        } else if (this.mTypeElementInteger.asType().equals(typeArguments.get(0))) {
                            tempArrayListMethodName = "getIntegerArrayList";
                        }
                        if (tempArrayListMethodName != null) {
                            if (isKotlinFile) {
                                methodBuilder.addStatement("$L.$L($T.$L($N,$S,$L.$L()))", new Object[]{parameterOwnerName, ComponentUtil.getGetSetMethodName((String)parameterName, (boolean)false, (boolean)false), this.parameterSupportTypeMirror, tempArrayListMethodName, bundleCallStr, keyName, parameterOwnerName, ComponentUtil.getGetSetMethodName((String)parameterName, (boolean)true, (boolean)false)});
                            } else {
                                methodBuilder.addStatement("$N = $T.$L($N,$S,$L)", new Object[]{parameterCallStr, this.parameterSupportTypeMirror, tempArrayListMethodName, bundleCallStr, keyName, parameterCallStr});
                            }
                        }
                    }
                } else if (this.mClassNameSparseArray.equals((Object)className)) {
                    List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                    if (typeArguments.size() == 1 && this.mTypes.isSubtype(typeArguments.get(0), this.parcelableTypeMirror)) {
                        if (isKotlinFile) {
                            methodBuilder.addStatement("$L.$L($T.$L($N,$S,$L.$L()))", new Object[]{parameterOwnerName, ComponentUtil.getGetSetMethodName((String)parameterName, (boolean)false, (boolean)false), this.parameterSupportTypeMirror, "getSparseParcelableArray", bundleCallStr, keyName, parameterOwnerName, ComponentUtil.getGetSetMethodName((String)parameterName, (boolean)true, (boolean)false)});
                        } else {
                            methodBuilder.addStatement("$N = $T.getSparseParcelableArray($N,$S,$L)", new Object[]{parameterCallStr, this.parameterSupportTypeMirror, bundleCallStr, keyName, parameterCallStr});
                        }
                    }
                } else {
                    String tempName;
                    boolean isSubParcelableType = this.mTypes.isSubtype(variableTypeMirror, this.parcelableTypeMirror);
                    boolean isSubSerializableType = this.mTypes.isSubtype(variableTypeMirror, this.serializableTypeMirror);
                    boolean isSubParcelableTypeAndSubSerializableType = isSubParcelableType && isSubSerializableType;
                    String isHaveValueName = "isHaveValue" + this.intCount.incrementAndGet();
                    if (isSubParcelableTypeAndSubSerializableType) {
                        methodBuilder.addStatement("boolean $N = false", new Object[]{isHaveValueName});
                    }
                    if (isSubParcelableType) {
                        tempName = "temp" + this.intCount.incrementAndGet();
                        methodBuilder.addStatement("$T $N = $T.getParcelable($N, $S)", new Object[]{variableTypeMirror, tempName, this.parameterSupportTypeMirror, bundleCallStr, keyName});
                        methodBuilder.beginControlFlow("if ($N != null)", new Object[]{tempName});
                        if (isKotlinFile) {
                            methodBuilder.addStatement("$L.$L($N)", new Object[]{parameterOwnerName, ComponentUtil.getGetSetMethodName((String)parameterName, (boolean)false, (boolean)false), tempName});
                        } else {
                            methodBuilder.addStatement("$N = $N", new Object[]{parameterCallStr, tempName});
                        }
                        if (isSubParcelableTypeAndSubSerializableType) {
                            methodBuilder.addStatement("$N = true", new Object[]{isHaveValueName});
                        }
                        methodBuilder.endControlFlow();
                    }
                    if (isSubSerializableType) {
                        if (isSubParcelableTypeAndSubSerializableType) {
                            methodBuilder.beginControlFlow("if (!$N)", new Object[]{isHaveValueName});
                        }
                        tempName = "temp" + this.intCount.incrementAndGet();
                        methodBuilder.addStatement("$T $N = $T.getSerializable($N, $S)", new Object[]{variableTypeMirror, tempName, this.parameterSupportTypeMirror, bundleCallStr, keyName});
                        methodBuilder.beginControlFlow("if ($N != null)", new Object[]{tempName});
                        if (isKotlinFile) {
                            methodBuilder.addStatement("$L.$L($N)", new Object[]{parameterOwnerName, ComponentUtil.getGetSetMethodName((String)parameterName, (boolean)false, (boolean)false), tempName});
                        } else {
                            methodBuilder.addStatement("$N = $N", new Object[]{parameterCallStr, tempName});
                        }
                        methodBuilder.endControlFlow();
                        if (isSubParcelableTypeAndSubSerializableType) {
                            methodBuilder.endControlFlow();
                        }
                    }
                }
            }
        } else if (variableTypeMirror instanceof ArrayType) {
            ArrayType parameterArrayType = (ArrayType)variableTypeMirror;
            TypeName parameterComponentTypeName = ClassName.get((TypeMirror)parameterArrayType.getComponentType());
            String tempArrayMethodName = null;
            if (parameterArrayType.getComponentType().equals(this.mTypeElementString.asType())) {
                tempArrayMethodName = "getStringArray";
            } else if (parameterArrayType.getComponentType().equals(this.charsequenceTypeElement.asType())) {
                tempArrayMethodName = "getCharSequenceArray";
            } else if (parameterArrayType.getComponentType().equals(this.mTypeElementString.asType())) {
                tempArrayMethodName = "getStringArray";
            } else if (parameterComponentTypeName.equals((Object)ClassName.BYTE) || parameterComponentTypeName.equals((Object)ClassName.BYTE.box())) {
                tempArrayMethodName = "getByteArray";
            } else if (parameterComponentTypeName.equals((Object)ClassName.CHAR) || parameterComponentTypeName.equals((Object)ClassName.CHAR.box())) {
                tempArrayMethodName = "getCharArray";
            } else if (parameterComponentTypeName.equals((Object)ClassName.SHORT) || parameterComponentTypeName.equals((Object)ClassName.SHORT.box())) {
                tempArrayMethodName = "getShortArray";
            } else if (parameterComponentTypeName.equals((Object)ClassName.INT) || parameterComponentTypeName.equals((Object)ClassName.INT.box())) {
                tempArrayMethodName = "getIntArray";
            } else if (parameterComponentTypeName.equals((Object)ClassName.LONG) || parameterComponentTypeName.equals((Object)ClassName.LONG.box())) {
                tempArrayMethodName = "getLongArray";
            } else if (parameterComponentTypeName.equals((Object)ClassName.FLOAT) || parameterComponentTypeName.equals((Object)ClassName.FLOAT.box())) {
                tempArrayMethodName = "getFloatArray";
            } else if (parameterComponentTypeName.equals((Object)ClassName.DOUBLE) || parameterComponentTypeName.equals((Object)ClassName.DOUBLE.box())) {
                tempArrayMethodName = "getDoubleArray";
            } else if (parameterComponentTypeName.equals((Object)ClassName.BOOLEAN) || parameterComponentTypeName.equals((Object)ClassName.BOOLEAN.box())) {
                tempArrayMethodName = "getBooleanArray";
            } else if (this.mTypes.isSameType(parameterArrayType.getComponentType(), this.parcelableTypeMirror)) {
                tempArrayMethodName = "getParcelableArray";
            } else {
                throw new ProcessException("can't to resolve unknow type parameter(" + variableElement.getEnclosingElement().getSimpleName() + "#" + variableElement.getSimpleName().toString() + ")");
            }
            if (isKotlinFile) {
                methodBuilder.addStatement("$L.$L($T.$L($N,$S,$L.$L()))", new Object[]{parameterOwnerName, ComponentUtil.getGetSetMethodName((String)parameterName, (boolean)false, (boolean)false), this.parameterSupportTypeMirror, tempArrayMethodName, bundleCallStr, keyName, parameterOwnerName, ComponentUtil.getGetSetMethodName((String)parameterName, (boolean)true, (boolean)false)});
            } else {
                methodBuilder.addStatement("$N = $T.$L($N,$S,$L)", new Object[]{parameterCallStr, this.parameterSupportTypeMirror, tempArrayMethodName, bundleCallStr, keyName, parameterCallStr});
            }
        }
        if (tempMethodName != null) {
            if (isKotlinFile) {
                methodBuilder.addStatement("$L.$L($T.$L($N,$S,$L.$L()))", new Object[]{parameterOwnerName, ComponentUtil.getGetSetMethodName((String)parameterName, (boolean)false, (boolean)isBoolean), this.parameterSupportTypeMirror, tempMethodName, bundleCallStr, keyName, parameterOwnerName, ComponentUtil.getGetSetMethodName((String)parameterName, (boolean)true, (boolean)isBoolean)});
            } else {
                methodBuilder.addStatement("$N = $T.$L($N,$S,$L)", new Object[]{parameterCallStr, this.parameterSupportTypeMirror, tempMethodName, bundleCallStr, keyName, parameterCallStr});
            }
        }
    }

    public void generateParameterCodeForInjectService(boolean isKotlinFile, String parameterOwnerName, VariableElement variableElement, MethodSpec.Builder methodBuilder) {
        String parameterName = variableElement.getSimpleName().toString();
        ServiceAutowiredAnno serviceAutowiredAnno = variableElement.getAnnotation(ServiceAutowiredAnno.class);
        TypeMirror variableTypeMirror = variableElement.asType();
        TypeName parameterTypeName = ClassName.get((TypeMirror)variableTypeMirror);
        if (serviceAutowiredAnno != null) {
            methodBuilder.addComment("may be null here", new Object[0]);
            if (isKotlinFile) {
                methodBuilder.addStatement("$L.$L($T.get($T.class, $S))", new Object[]{parameterOwnerName, ComponentUtil.getGetSetMethodName((String)parameterName, (boolean)false, (boolean)false), this.serviceTypeElement, parameterTypeName, serviceAutowiredAnno.name()});
            } else {
                methodBuilder.addStatement("$N.$N = $T.get($T.class, $S)", new Object[]{parameterOwnerName, parameterName, this.serviceTypeElement, parameterTypeName, serviceAutowiredAnno.name()});
            }
        }
    }
}

