/*
 * Decompiled with CFR 0.152.
 */
package wseemann.media;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class FFmpegMediaMetadataRetriever {
    private static final String TAG = "FFmpegMediaMetadataRetriever";
    public static Bitmap.Config IN_PREFERRED_CONFIG;
    private static final String[] JNI_LIBRARIES;
    private long mNativeContext;
    public static final int OPTION_PREVIOUS_SYNC = 0;
    public static final int OPTION_NEXT_SYNC = 1;
    public static final int OPTION_CLOSEST_SYNC = 2;
    public static final int OPTION_CLOSEST = 3;
    public static final String METADATA_KEY_ALBUM = "album";
    public static final String METADATA_KEY_ALBUM_ARTIST = "album_artist";
    public static final String METADATA_KEY_ARTIST = "artist";
    public static final String METADATA_KEY_COMMENT = "comment";
    public static final String METADATA_KEY_COMPOSER = "composer";
    public static final String METADATA_KEY_COPYRIGHT = "copyright";
    public static final String METADATA_KEY_CREATION_TIME = "creation_time";
    public static final String METADATA_KEY_DATE = "date";
    public static final String METADATA_KEY_DISC = "disc";
    public static final String METADATA_KEY_ENCODER = "encoder";
    public static final String METADATA_KEY_ENCODED_BY = "encoded_by";
    public static final String METADATA_KEY_FILENAME = "filename";
    public static final String METADATA_KEY_GENRE = "genre";
    public static final String METADATA_KEY_LANGUAGE = "language";
    public static final String METADATA_KEY_PERFORMER = "performer";
    public static final String METADATA_KEY_PUBLISHER = "publisher";
    public static final String METADATA_KEY_SERVICE_NAME = "service_name";
    public static final String METADATA_KEY_SERVICE_PROVIDER = "service_provider";
    public static final String METADATA_KEY_TITLE = "title";
    public static final String METADATA_KEY_TRACK = "track";
    public static final String METADATA_KEY_VARIANT_BITRATE = "bitrate";
    public static final String METADATA_KEY_DURATION = "duration";
    public static final String METADATA_KEY_AUDIO_CODEC = "audio_codec";
    public static final String METADATA_KEY_VIDEO_CODEC = "video_codec";
    public static final String METADATA_KEY_VIDEO_ROTATION = "rotate";
    public static final String METADATA_KEY_ICY_METADATA = "icy_metadata";
    public static final String METADATA_KEY_FRAMERATE = "framerate";
    public static final String METADATA_KEY_CHAPTER_START_TIME = "chapter_start_time";
    public static final String METADATA_KEY_CHAPTER_END_TIME = "chapter_end_time";
    public static final String METADATA_CHAPTER_COUNT = "chapter_count";
    public static final String METADATA_KEY_FILESIZE = "filesize";
    public static final String METADATA_KEY_VIDEO_WIDTH = "video_width";
    public static final String METADATA_KEY_VIDEO_HEIGHT = "video_height";

    public FFmpegMediaMetadataRetriever() {
        this.native_setup();
    }

    public native void setDataSource(String var1) throws IllegalArgumentException;

    public void setDataSource(String uri, Map<String, String> headers) throws IllegalArgumentException {
        int i = 0;
        String[] keys = new String[headers.size()];
        String[] values = new String[headers.size()];
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            keys[i] = entry.getKey();
            values[i] = entry.getValue();
            ++i;
        }
        this._setDataSource(uri, keys, values);
    }

    private native void _setDataSource(String var1, String[] var2, String[] var3) throws IllegalArgumentException;

    public native void setDataSource(FileDescriptor var1, long var2, long var4) throws IllegalArgumentException;

    public void setDataSource(FileDescriptor fd) throws IllegalArgumentException {
        this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSource(Context context, Uri uri) throws IllegalArgumentException, SecurityException {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.setDataSource(uri.getPath());
            return;
        }
        AssetFileDescriptor fd = null;
        try {
            ContentResolver resolver = context.getContentResolver();
            try {
                fd = resolver.openAssetFileDescriptor(uri, "r");
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException();
            }
            if (fd == null) {
                throw new IllegalArgumentException();
            }
            FileDescriptor descriptor = fd.getFileDescriptor();
            if (!descriptor.valid()) {
                throw new IllegalArgumentException();
            }
            if (fd.getDeclaredLength() < 0L) {
                this.setDataSource(descriptor);
            } else {
                this.setDataSource(descriptor, fd.getStartOffset(), fd.getDeclaredLength());
            }
            return;
        }
        catch (SecurityException securityException) {
        }
        finally {
            try {
                if (fd != null) {
                    fd.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.setDataSource(uri.toString());
    }

    public native String extractMetadata(String var1);

    public native String extractMetadataFromChapter(String var1, int var2);

    public Metadata getMetadata() {
        boolean update_only = false;
        boolean apply_filter = false;
        Metadata data = new Metadata();
        HashMap<String, String> metadata = null;
        if ((metadata = this.native_getMetadata(update_only, apply_filter, metadata)) == null) {
            return null;
        }
        if (!data.parse(metadata)) {
            return null;
        }
        return data;
    }

    private final native HashMap<String, String> native_getMetadata(boolean var1, boolean var2, HashMap<String, String> var3);

    public Bitmap getFrameAtTime(long timeUs, int option) {
        if (option < 0 || option > 3) {
            throw new IllegalArgumentException("Unsupported option: " + option);
        }
        Bitmap b = null;
        BitmapFactory.Options bitmapOptionsCache = new BitmapFactory.Options();
        bitmapOptionsCache.inDither = false;
        byte[] picture = this._getFrameAtTime(timeUs, option);
        if (picture != null) {
            b = BitmapFactory.decodeByteArray((byte[])picture, (int)0, (int)picture.length, (BitmapFactory.Options)bitmapOptionsCache);
        }
        return b;
    }

    public Bitmap getFrameAtTime(long timeUs) {
        Bitmap b = null;
        BitmapFactory.Options bitmapOptionsCache = new BitmapFactory.Options();
        bitmapOptionsCache.inDither = false;
        byte[] picture = this._getFrameAtTime(timeUs, 2);
        if (picture != null) {
            b = BitmapFactory.decodeByteArray((byte[])picture, (int)0, (int)picture.length, (BitmapFactory.Options)bitmapOptionsCache);
        }
        return b;
    }

    public Bitmap getFrameAtTime() {
        return this.getFrameAtTime(-1L, 2);
    }

    private native byte[] _getFrameAtTime(long var1, int var3);

    public Bitmap getScaledFrameAtTime(long timeUs, int option, int width, int height) {
        if (option < 0 || option > 3) {
            throw new IllegalArgumentException("Unsupported option: " + option);
        }
        Bitmap b = null;
        BitmapFactory.Options bitmapOptionsCache = new BitmapFactory.Options();
        bitmapOptionsCache.inDither = false;
        byte[] picture = this._getScaledFrameAtTime(timeUs, option, width, height);
        if (picture != null) {
            b = BitmapFactory.decodeByteArray((byte[])picture, (int)0, (int)picture.length, (BitmapFactory.Options)bitmapOptionsCache);
        }
        return b;
    }

    public Bitmap getScaledFrameAtTime(long timeUs, int width, int height) {
        Bitmap b = null;
        BitmapFactory.Options bitmapOptionsCache = new BitmapFactory.Options();
        bitmapOptionsCache.inDither = false;
        byte[] picture = this._getScaledFrameAtTime(timeUs, 2, width, height);
        if (picture != null) {
            b = BitmapFactory.decodeByteArray((byte[])picture, (int)0, (int)picture.length, (BitmapFactory.Options)bitmapOptionsCache);
        }
        return b;
    }

    private native byte[] _getScaledFrameAtTime(long var1, int var3, int var4, int var5);

    public native byte[] getEmbeddedPicture();

    public native void release();

    private native void native_setup();

    private static native void native_init();

    private final native void native_finalize();

    protected void finalize() throws Throwable {
        try {
            this.native_finalize();
        }
        finally {
            super.finalize();
        }
    }

    public native void setSurface(Object var1);

    static {
        JNI_LIBRARIES = new String[]{"avutil", "swscale", "avcodec", "avformat", "ffmpeg_mediametadataretriever_jni"};
        for (int i = 0; i < JNI_LIBRARIES.length; ++i) {
            System.loadLibrary(JNI_LIBRARIES[i]);
        }
        FFmpegMediaMetadataRetriever.native_init();
    }

    public class Metadata {
        public static final int STRING_VAL = 1;
        public static final int INTEGER_VAL = 2;
        public static final int BOOLEAN_VAL = 3;
        public static final int LONG_VAL = 4;
        public static final int DOUBLE_VAL = 5;
        public static final int DATE_VAL = 6;
        public static final int BYTE_ARRAY_VAL = 7;
        private HashMap<String, String> mParcel;

        public boolean parse(HashMap<String, String> metadata) {
            if (metadata == null) {
                return false;
            }
            this.mParcel = metadata;
            return true;
        }

        public boolean has(String metadataId) {
            if (!this.checkMetadataId(metadataId)) {
                throw new IllegalArgumentException("Invalid key: " + metadataId);
            }
            return this.mParcel.containsKey(metadataId);
        }

        public HashMap<String, String> getAll() {
            return this.mParcel;
        }

        public String getString(String key) {
            this.checkType(key, 1);
            return String.valueOf(this.mParcel.get(key));
        }

        public int getInt(String key) {
            this.checkType(key, 2);
            return Integer.valueOf(this.mParcel.get(key));
        }

        public boolean getBoolean(String key) {
            this.checkType(key, 3);
            return Integer.valueOf(this.mParcel.get(key)) == 1;
        }

        public long getLong(String key) {
            this.checkType(key, 4);
            return Long.valueOf(this.mParcel.get(key));
        }

        public double getDouble(String key) {
            this.checkType(key, 5);
            return Double.valueOf(this.mParcel.get(key));
        }

        public byte[] getByteArray(String key) {
            this.checkType(key, 7);
            return this.mParcel.get(key).getBytes();
        }

        public Date getDate(String key) {
            this.checkType(key, 6);
            long timeSinceEpoch = Long.valueOf(this.mParcel.get(key));
            String timeZone = this.mParcel.get(key);
            if (timeZone.length() == 0) {
                return new Date(timeSinceEpoch);
            }
            TimeZone tz = TimeZone.getTimeZone(timeZone);
            Calendar cal = Calendar.getInstance(tz);
            cal.setTimeInMillis(timeSinceEpoch);
            return cal.getTime();
        }

        private boolean checkMetadataId(String val) {
            return true;
        }

        private void checkType(String key, int expectedType) {
            String type = this.mParcel.get(key);
            if (type == null) {
                throw new IllegalStateException("Wrong type " + expectedType + " but got " + type);
            }
        }
    }
}

