/*
 * Decompiled with CFR 0.152.
 */
package org.woheller69.freeDroidWarn;

import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.preference.PreferenceManager;
import org.woheller69.freeDroidWarn.R;

public class FreeDroidWarn {
    static boolean shouldShowWarningDialog(Context context, int buildVersion) {
        SharedPreferences prefManager = PreferenceManager.getDefaultSharedPreferences((Context)context);
        int versionCode = prefManager.getInt("versionCodeWarn", 0);
        if (buildVersion > versionCode) {
            SharedPreferences.Editor editor = prefManager.edit();
            editor.putInt("versionCodeWarn", buildVersion);
            editor.apply();
            return true;
        }
        SharedPreferences.Editor editor = prefManager.edit();
        editor.putInt("versionCodeWarn", buildVersion);
        editor.apply();
        return false;
    }

    public static void showWarningOnUpgrade(Context context, int buildVersion) {
        if (FreeDroidWarn.shouldShowWarningDialog(context, buildVersion)) {
            AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(context);
            alertDialogBuilder.setMessage(R.string.dialog_Warning);
            alertDialogBuilder.setPositiveButton((CharSequence)context.getString(R.string.dialog_more_info), (dialog, which) -> context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)"https://developer.android.com/developer-verification"))));
            alertDialogBuilder.setNegativeButton((CharSequence)context.getString(17039370), (dialog, which) -> {});
            AlertDialog alertDialog = alertDialogBuilder.create();
            alertDialog.show();
        }
    }
}

