/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.flattener;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.github.wnameless.json.flattener.FlattenMode;
import com.github.wnameless.json.flattener.IndexedPeekIterator;
import com.github.wnameless.json.flattener.JsonifyArrayList;
import com.github.wnameless.json.flattener.JsonifyLinkedHashMap;
import com.github.wnameless.json.flattener.PrintMode;
import com.github.wnameless.json.flattener.StringEscapePolicy;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public final class JsonFlattener {
    public static final String ROOT = "root";
    private final JsonValue source;
    private final Deque<IndexedPeekIterator<?>> elementIters = new ArrayDeque();
    private JsonifyLinkedHashMap<String, Object> flattenedMap;
    private FlattenMode flattenMode = FlattenMode.NORMAL;
    private StringEscapePolicy policy = StringEscapePolicy.NORMAL;
    private Character separator = Character.valueOf('.');
    private PrintMode printMode = PrintMode.MINIMAL;

    public static String flatten(String json) {
        return new JsonFlattener(json).flatten();
    }

    public static Map<String, Object> flattenAsMap(String json) {
        return new JsonFlattener(json).flattenAsMap();
    }

    public JsonFlattener(String json) {
        this.source = Json.parse((String)json);
    }

    public JsonFlattener withFlattenMode(FlattenMode flattenMode) {
        this.flattenMode = (FlattenMode)((Object)Validate.notNull((Object)((Object)flattenMode)));
        this.flattenedMap = null;
        return this;
    }

    public JsonFlattener withStringEscapePolicy(StringEscapePolicy policy) {
        this.policy = (StringEscapePolicy)((Object)Validate.notNull((Object)((Object)policy)));
        this.flattenedMap = null;
        return this;
    }

    public JsonFlattener withSeparator(char separator) {
        this.separator = Character.valueOf(separator);
        this.flattenedMap = null;
        return this;
    }

    public JsonFlattener withPrintMode(PrintMode printMode) {
        this.printMode = (PrintMode)((Object)Validate.notNull((Object)((Object)printMode)));
        return this;
    }

    public String flatten() {
        this.flattenAsMap();
        if (this.flattenedMap.containsKey(ROOT)) {
            return this.javaObj2Json(this.flattenedMap.get(ROOT));
        }
        return this.flattenedMap.toString(this.printMode);
    }

    private String javaObj2Json(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof CharSequence) {
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            sb.append(this.policy.getCharSequenceTranslator().translate((CharSequence)obj));
            sb.append('\"');
            return sb.toString();
        }
        if (obj instanceof JsonifyArrayList) {
            JsonifyArrayList list = (JsonifyArrayList)obj;
            return list.toString(this.printMode);
        }
        return obj.toString();
    }

    public Map<String, Object> flattenAsMap() {
        if (this.flattenedMap != null) {
            return this.flattenedMap;
        }
        this.flattenedMap = this.newJsonifyLinkedHashMap();
        this.reduce(this.source);
        while (!this.elementIters.isEmpty()) {
            IndexedPeekIterator<?> deepestIter = this.elementIters.getLast();
            if (!deepestIter.hasNext()) {
                this.elementIters.removeLast();
                continue;
            }
            if (deepestIter.peek() instanceof JsonObject.Member) {
                JsonObject.Member mem = (JsonObject.Member)deepestIter.next();
                this.reduce(mem.getValue());
                continue;
            }
            JsonValue val = (JsonValue)deepestIter.next();
            this.reduce(val);
        }
        return this.flattenedMap;
    }

    private void reduce(JsonValue val) {
        if (val.isObject() && val.asObject().iterator().hasNext()) {
            this.elementIters.add(IndexedPeekIterator.newIndexedPeekIterator(val.asObject()));
        } else if (val.isArray() && val.asArray().iterator().hasNext()) {
            switch (this.flattenMode) {
                case KEEP_ARRAYS: {
                    JsonifyArrayList array = this.newJsonifyArrayList();
                    for (JsonValue value : val.asArray()) {
                        array.add(this.jsonVal2Obj(value));
                    }
                    this.flattenedMap.put(this.computeKey(), array);
                    break;
                }
                default: {
                    this.elementIters.add(IndexedPeekIterator.newIndexedPeekIterator(val.asArray()));
                    break;
                }
            }
        } else {
            String key = this.computeKey();
            Object value = this.jsonVal2Obj(val);
            if (!ROOT.equals(key) || !((Object)Collections.emptyMap()).equals(value)) {
                this.flattenedMap.put(key, this.jsonVal2Obj(val));
            }
        }
    }

    private Object jsonVal2Obj(JsonValue val) {
        if (val.isBoolean()) {
            return val.asBoolean();
        }
        if (val.isString()) {
            return val.asString();
        }
        if (val.isNumber()) {
            return new BigDecimal(val.toString());
        }
        switch (this.flattenMode) {
            case KEEP_ARRAYS: {
                if (val.isArray()) {
                    JsonifyArrayList array = this.newJsonifyArrayList();
                    for (JsonValue value : val.asArray()) {
                        array.add(this.jsonVal2Obj(value));
                    }
                    return array;
                }
                if (!val.isObject()) break;
                if (val.asObject().iterator().hasNext()) {
                    return this.newJsonFlattener(val.toString()).flattenAsMap();
                }
                return this.newJsonifyLinkedHashMap();
            }
        }
        if (val.isArray()) {
            return this.newJsonifyArrayList();
        }
        if (val.isObject()) {
            return this.newJsonifyLinkedHashMap();
        }
        return null;
    }

    private String computeKey() {
        if (this.elementIters.isEmpty()) {
            return ROOT;
        }
        StringBuilder sb = new StringBuilder();
        for (IndexedPeekIterator<?> iter : this.elementIters) {
            if (iter.getCurrent() instanceof JsonObject.Member) {
                String key = ((JsonObject.Member)iter.getCurrent()).getName();
                if (key.contains(this.separator.toString())) {
                    sb.append('[');
                    sb.append('\\');
                    sb.append('\"');
                    sb.append(this.policy.getCharSequenceTranslator().translate((CharSequence)key));
                    sb.append('\\');
                    sb.append('\"');
                    sb.append(']');
                    continue;
                }
                if (sb.length() != 0) {
                    sb.append(this.separator);
                }
                sb.append(this.policy.getCharSequenceTranslator().translate((CharSequence)key));
                continue;
            }
            sb.append('[');
            sb.append(iter.getIndex());
            sb.append(']');
        }
        return sb.toString();
    }

    private <T> JsonifyArrayList<T> newJsonifyArrayList() {
        JsonifyArrayList array = new JsonifyArrayList();
        array.setTranslator(this.policy.getCharSequenceTranslator());
        return array;
    }

    private <K, V> JsonifyLinkedHashMap<K, V> newJsonifyLinkedHashMap() {
        JsonifyLinkedHashMap map = new JsonifyLinkedHashMap();
        map.setTranslator(this.policy.getCharSequenceTranslator());
        return map;
    }

    private JsonFlattener newJsonFlattener(String json) {
        return new JsonFlattener(json).withFlattenMode(this.flattenMode).withSeparator(this.separator.charValue()).withStringEscapePolicy(this.policy).withPrintMode(this.printMode);
    }

    public int hashCode() {
        int result = 27;
        result = 31 * result + this.source.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonFlattener)) {
            return false;
        }
        return this.source.equals((Object)((JsonFlattener)o).source);
    }

    public String toString() {
        return "JsonFlattener{source=" + this.source + "}";
    }
}

