/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.unflattener;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.PrettyPrint;
import com.eclipsesource.json.WriterConfig;
import com.github.wnameless.json.flattener.PrintMode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JsonUnflattener {
    private static final String arrayIndex = "\\[\\s*\\d+\\s*\\]";
    private static final String objectComplexKey = "\\[\\s*\".*\"\\s*\\]";
    private final JsonValue root;
    private Character separator = Character.valueOf('.');
    private PrintMode printMode = PrintMode.MINIMAL;
    private String unflattenedJson = null;

    public JsonUnflattener(String json) {
        this.root = Json.parse((String)json);
    }

    private String objectKey() {
        return "[^" + Pattern.quote(this.separator.toString()) + "\\[\\]]+";
    }

    private Pattern keyPartPattern() {
        return Pattern.compile("\\[\\s*\\d+\\s*\\]|\\[\\s*\".*\"\\s*\\]|" + this.objectKey());
    }

    public JsonUnflattener withSeparator(char separator) {
        this.separator = Character.valueOf(separator);
        return this;
    }

    public JsonUnflattener withPrintMode(PrintMode printMode) {
        if (this.unflattenedJson != null) {
            throw new IllegalStateException("Print mode can NOT be changed after unflattening JSON");
        }
        this.printMode = printMode;
        return this;
    }

    private WriterConfig getWriterConfig() {
        switch (this.printMode) {
            case REGULAR: {
                return PrettyPrint.singleLine();
            }
            case PRETTY: {
                return WriterConfig.PRETTY_PRINT;
            }
        }
        return WriterConfig.MINIMAL;
    }

    public static String unflatten(String json) {
        return new JsonUnflattener(json).unflatten();
    }

    public String unflatten() {
        if (this.unflattenedJson != null) {
            return this.unflattenedJson;
        }
        StringWriter sw = new StringWriter();
        if (this.root.isArray()) {
            try {
                this.unflattenArray(this.root.asArray()).writeTo((Writer)sw, this.getWriterConfig());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.unflattenedJson = sw.toString();
            return this.unflattenedJson;
        }
        if (!this.root.isObject()) {
            this.unflattenedJson = this.root.toString();
            return this.unflattenedJson;
        }
        JsonObject flattened = this.root.asObject();
        JsonObject unflattened = flattened.names().isEmpty() ? Json.object() : null;
        for (String key : flattened.names()) {
            JsonObject currentVal = unflattened;
            String objKey = null;
            Integer aryIdx = null;
            Matcher matcher = this.keyPartPattern().matcher(key);
            while (matcher.find()) {
                String keyPart = matcher.group();
                if (objKey != null ^ aryIdx != null) {
                    if (JsonUnflattener.isJsonArray(keyPart)) {
                        currentVal = JsonUnflattener.findOrCreateJsonArray((JsonValue)currentVal, objKey, aryIdx);
                        objKey = null;
                        aryIdx = JsonUnflattener.extractIndex(keyPart);
                    } else {
                        if (flattened.get(key).isArray()) {
                            flattened.set(key, (JsonValue)this.unflattenArray(flattened.get(key).asArray()));
                        }
                        currentVal = JsonUnflattener.findOrCreateJsonObject((JsonValue)currentVal, objKey, aryIdx);
                        objKey = JsonUnflattener.extractKey(keyPart);
                        aryIdx = null;
                    }
                }
                if (objKey == null && aryIdx == null) {
                    if (JsonUnflattener.isJsonArray(keyPart)) {
                        aryIdx = JsonUnflattener.extractIndex(keyPart);
                        if (currentVal == null) {
                            currentVal = Json.array();
                        }
                    } else {
                        objKey = JsonUnflattener.extractKey(keyPart);
                        if (currentVal == null) {
                            currentVal = Json.object();
                        }
                    }
                }
                if (unflattened != null) continue;
                unflattened = currentVal;
            }
            JsonUnflattener.setUnflattenedValue(flattened, key, (JsonValue)currentVal, objKey, aryIdx);
        }
        try {
            unflattened.writeTo((Writer)sw, this.getWriterConfig());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.unflattenedJson = sw.toString();
        return this.unflattenedJson;
    }

    private JsonArray unflattenArray(JsonArray array) {
        JsonArray unflattenArray = Json.array().asArray();
        for (JsonValue value : array) {
            if (value.isArray()) {
                unflattenArray.add((JsonValue)this.unflattenArray(value.asArray()));
                continue;
            }
            if (value.isObject()) {
                unflattenArray.add(Json.parse((String)new JsonUnflattener(value.toString()).withSeparator(this.separator.charValue()).unflatten()));
                continue;
            }
            unflattenArray.add(value);
        }
        return unflattenArray;
    }

    private static String extractKey(String keyPart) {
        if (keyPart.matches(objectComplexKey)) {
            return keyPart.replaceAll("^\\[\\s*\"", "").replaceAll("\"\\s*\\]$", "");
        }
        return keyPart;
    }

    private static Integer extractIndex(String keyPart) {
        return Integer.valueOf(keyPart.replaceAll("[\\[\\]\\s]", ""));
    }

    private static boolean isJsonArray(String keyPart) {
        return keyPart.matches(arrayIndex);
    }

    private static JsonValue findOrCreateJsonArray(JsonValue currentVal, String objKey, Integer aryIdx) {
        if (objKey != null) {
            JsonObject jsonObj = currentVal.asObject();
            if (jsonObj.get(objKey) == null) {
                JsonValue ary = Json.array();
                jsonObj.add(objKey, ary);
                return ary;
            }
            return jsonObj.get(objKey);
        }
        JsonArray jsonAry = currentVal.asArray();
        if (jsonAry.size() <= aryIdx || jsonAry.get(aryIdx.intValue()).equals((Object)Json.NULL)) {
            JsonValue ary = Json.array();
            JsonUnflattener.assureJsonArraySize(jsonAry, aryIdx);
            jsonAry.set(aryIdx.intValue(), ary);
            return ary;
        }
        return jsonAry.get(aryIdx.intValue());
    }

    private static JsonValue findOrCreateJsonObject(JsonValue currentVal, String objKey, Integer aryIdx) {
        if (objKey != null) {
            JsonObject jsonObj = currentVal.asObject();
            if (jsonObj.get(objKey) == null) {
                JsonObject obj = Json.object();
                jsonObj.add(objKey, (JsonValue)obj);
                return obj;
            }
            return jsonObj.get(objKey);
        }
        JsonArray jsonAry = currentVal.asArray();
        if (jsonAry.size() <= aryIdx || jsonAry.get(aryIdx.intValue()).equals((Object)Json.NULL)) {
            JsonObject obj = Json.object();
            JsonUnflattener.assureJsonArraySize(jsonAry, aryIdx);
            jsonAry.set(aryIdx.intValue(), (JsonValue)obj);
            return obj;
        }
        return jsonAry.get(aryIdx.intValue());
    }

    private static void setUnflattenedValue(JsonObject flattened, String key, JsonValue currentVal, String objKey, Integer aryIdx) {
        if (objKey != null) {
            currentVal.asObject().add(objKey, flattened.get(key));
        } else {
            JsonUnflattener.assureJsonArraySize(currentVal.asArray(), aryIdx);
            currentVal.asArray().set(aryIdx.intValue(), flattened.get(key));
        }
    }

    private static void assureJsonArraySize(JsonArray jsonArray, Integer index) {
        while (index >= jsonArray.size()) {
            jsonArray.add(Json.NULL);
        }
    }
}

