/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.flattener;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.github.wnameless.json.flattener.FlattenMode;
import com.github.wnameless.json.flattener.IndexedPeekIterator;
import com.github.wnameless.json.flattener.JsonifyArrayList;
import com.github.wnameless.json.flattener.JsonifyLinkedHashMap;
import com.github.wnameless.json.flattener.PrintMode;
import com.github.wnameless.json.flattener.StringEscapePolicy;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;

public final class JsonFlattener {
    public static final String ROOT = "root";
    private final JsonValue source;
    private final Deque<IndexedPeekIterator<?>> elementIters = new ArrayDeque();
    private final JsonifyLinkedHashMap<String, Object> flattenedMap = new JsonifyLinkedHashMap();
    private FlattenMode flattenMode = FlattenMode.NORMAL;
    private StringEscapePolicy policy = StringEscapePolicy.NORMAL;
    private Character separator = Character.valueOf('.');
    private PrintMode printMode = PrintMode.MINIMAL;
    private String flattenedJson = null;

    public static String flatten(String json) {
        return new JsonFlattener(json).flatten();
    }

    public static Map<String, Object> flattenAsMap(String json) {
        return new JsonFlattener(json).flattenAsMap();
    }

    public JsonFlattener(String json) {
        this.source = Json.parse((String)json);
    }

    public JsonFlattener withFlattenMode(FlattenMode flattenMode) {
        this.flattenMode = flattenMode;
        return this;
    }

    public JsonFlattener withSeparator(char separator) {
        this.separator = Character.valueOf(separator);
        return this;
    }

    public JsonFlattener withPrintMode(PrintMode printMode) {
        if (this.flattenedJson != null) {
            throw new IllegalStateException("Print mode can NOT be changed after flattening JSON");
        }
        this.printMode = printMode;
        return this;
    }

    public JsonFlattener withStringEscapePolicy(StringEscapePolicy policy) {
        this.policy = policy;
        this.flattenedMap.setTranslator(policy.getCharSequenceTranslator());
        return this;
    }

    public String flatten() {
        if (this.flattenedJson != null) {
            return this.flattenedJson;
        }
        this.flattenAsMap();
        if (this.flattenedMap.containsKey(ROOT)) {
            this.flattenedJson = this.javaObj2Json(this.flattenedMap.get(ROOT));
            return this.flattenedJson;
        }
        this.flattenedJson = this.flattenedMap.toString(this.printMode);
        return this.flattenedJson;
    }

    private String javaObj2Json(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof CharSequence) {
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            sb.append(this.policy.getCharSequenceTranslator().translate((CharSequence)obj));
            sb.append('\"');
            return sb.toString();
        }
        if (obj instanceof JsonifyArrayList) {
            JsonifyArrayList list = (JsonifyArrayList)obj;
            return list.toString(this.printMode);
        }
        return obj.toString();
    }

    public Map<String, Object> flattenAsMap() {
        if (this.flattenedMap.isEmpty()) {
            this.reduce(this.source);
        }
        while (!this.elementIters.isEmpty()) {
            IndexedPeekIterator<?> deepestIter = this.elementIters.getLast();
            if (!deepestIter.hasNext()) {
                this.elementIters.removeLast();
                continue;
            }
            if (deepestIter.peek() instanceof JsonObject.Member) {
                JsonObject.Member mem = (JsonObject.Member)deepestIter.next();
                this.reduce(mem.getValue());
                continue;
            }
            JsonValue val = (JsonValue)deepestIter.next();
            this.reduce(val);
        }
        return this.flattenedMap;
    }

    private void reduce(JsonValue val) {
        if (val.isObject() && val.asObject().iterator().hasNext()) {
            this.elementIters.add(new IndexedPeekIterator(val.asObject().iterator()));
        } else if (val.isArray() && val.asArray().iterator().hasNext()) {
            switch (this.flattenMode) {
                case KEEP_ARRAYS: {
                    JsonifyArrayList<Object> array = new JsonifyArrayList<Object>();
                    array.setTranslator(this.policy.getCharSequenceTranslator());
                    for (JsonValue value : val.asArray()) {
                        array.add(this.jsonVal2Obj(value));
                    }
                    this.flattenedMap.put(this.computeKey(), array);
                    break;
                }
                default: {
                    this.elementIters.add(new IndexedPeekIterator(val.asArray().iterator()));
                    break;
                }
            }
        } else {
            String key = this.computeKey();
            Object value = this.jsonVal2Obj(val);
            if (!ROOT.equals(key) || !Collections.emptyMap().equals(value)) {
                this.flattenedMap.put(key, this.jsonVal2Obj(val));
            }
        }
    }

    private Object jsonVal2Obj(JsonValue jsonValue) {
        if (jsonValue.isBoolean()) {
            return jsonValue.asBoolean();
        }
        if (jsonValue.isString()) {
            return jsonValue.asString();
        }
        if (jsonValue.isNumber()) {
            return new BigDecimal(jsonValue.toString());
        }
        switch (this.flattenMode) {
            case KEEP_ARRAYS: {
                if (jsonValue.isArray()) {
                    if (!jsonValue.asArray().iterator().hasNext()) {
                        return new JsonifyArrayList();
                    }
                    JsonifyArrayList<Object> array = new JsonifyArrayList<Object>();
                    array.setTranslator(this.policy.getCharSequenceTranslator());
                    for (JsonValue jv : jsonValue.asArray()) {
                        array.add(this.jsonVal2Obj(jv));
                    }
                    return array;
                }
                return new JsonFlattener(jsonValue.toString()).withFlattenMode(FlattenMode.KEEP_ARRAYS).flattenAsMap();
            }
        }
        if (jsonValue.isArray()) {
            return new JsonifyArrayList();
        }
        if (jsonValue.isObject()) {
            return new JsonifyLinkedHashMap();
        }
        return null;
    }

    private String computeKey() {
        if (this.elementIters.isEmpty()) {
            return ROOT;
        }
        StringBuilder sb = new StringBuilder();
        for (IndexedPeekIterator<?> iter : this.elementIters) {
            if (iter.getCurrent() instanceof JsonObject.Member) {
                String key = ((JsonObject.Member)iter.getCurrent()).getName();
                if (key.contains(this.separator.toString())) {
                    sb.append('[');
                    sb.append('\\');
                    sb.append('\"');
                    sb.append(this.policy.getCharSequenceTranslator().translate((CharSequence)key));
                    sb.append('\\');
                    sb.append('\"');
                    sb.append(']');
                    continue;
                }
                if (sb.length() != 0) {
                    sb.append(this.separator);
                }
                sb.append(this.policy.getCharSequenceTranslator().translate((CharSequence)key));
                continue;
            }
            sb.append('[');
            sb.append(iter.getIndex());
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 27;
        result = 31 * result + this.source.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonFlattener)) {
            return false;
        }
        return this.source.equals((Object)((JsonFlattener)o).source);
    }

    public String toString() {
        return "JsonFlattener{source=" + this.source + "}";
    }
}

