/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.fft;

import org.visnow.jlargearrays.DoubleLargeArray;
import org.visnow.jlargearrays.FloatLargeArray;

public class RealFFTUtils_2D {
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int ZERO = 0;
    private static final long ONEL = 1L;
    private static final long TWOL = 2L;
    private static final long ZEROL = 0L;
    private final int columns;
    private final int rows;
    private final long columnsl;
    private final long rowsl;

    public RealFFTUtils_2D(long rows, long columns) {
        this.columns = (int)columns;
        this.rows = (int)rows;
        this.columnsl = columns;
        this.rowsl = rows;
    }

    public int getIndex(int r, int c) {
        int cmod2 = c & 1;
        int rmul2 = r << 1;
        if (r != 0) {
            if (c <= 1) {
                if (rmul2 == this.rows) {
                    if (cmod2 == 1) {
                        return Integer.MIN_VALUE;
                    }
                    return this.rows * this.columns >> 1;
                }
                if (rmul2 < this.rows) {
                    return this.columns * r + cmod2;
                }
                if (cmod2 == 0) {
                    return this.columns * (this.rows - r);
                }
                return -(this.columns * (this.rows - r) + 1);
            }
            if (c == this.columns || c == this.columns + 1) {
                if (rmul2 == this.rows) {
                    if (cmod2 == 1) {
                        return Integer.MIN_VALUE;
                    }
                    return (this.rows * this.columns >> 1) + 1;
                }
                if (rmul2 < this.rows) {
                    if (cmod2 == 0) {
                        return this.columns * (this.rows - r) + 1;
                    }
                    return -(this.columns * (this.rows - r));
                }
                return this.columns * r + 1 - cmod2;
            }
            if (c < this.columns) {
                return this.columns * r + c;
            }
            if (cmod2 == 0) {
                return this.columns * (this.rows + 2 - r) - c;
            }
            return -(this.columns * (this.rows + 2 - r) - c + 2);
        }
        if (c == 1 || c == this.columns + 1) {
            return Integer.MIN_VALUE;
        }
        if (c == this.columns) {
            return 1;
        }
        if (c < this.columns) {
            return c;
        }
        if (cmod2 == 0) {
            return (this.columns << 1) - c;
        }
        return -((this.columns << 1) - c + 2);
    }

    public long getIndex(long r, long c) {
        long cmod2 = c & 1L;
        long rmul2 = r << 1;
        if (r != 0L) {
            if (c <= 1L) {
                if (rmul2 == this.rowsl) {
                    if (cmod2 == 1L) {
                        return Long.MIN_VALUE;
                    }
                    return this.rowsl * this.columnsl >> 1;
                }
                if (rmul2 < this.rowsl) {
                    return this.columnsl * r + cmod2;
                }
                if (cmod2 == 0L) {
                    return this.columnsl * (this.rowsl - r);
                }
                return -(this.columnsl * (this.rowsl - r) + 1L);
            }
            if (c == this.columnsl || c == this.columnsl + 1L) {
                if (rmul2 == this.rowsl) {
                    if (cmod2 == 1L) {
                        return Long.MIN_VALUE;
                    }
                    return (this.rowsl * this.columnsl >> 1) + 1L;
                }
                if (rmul2 < this.rowsl) {
                    if (cmod2 == 0L) {
                        return this.columnsl * (this.rowsl - r) + 1L;
                    }
                    return -(this.columnsl * (this.rowsl - r));
                }
                return this.columnsl * r + 1L - cmod2;
            }
            if (c < this.columnsl) {
                return this.columnsl * r + c;
            }
            if (cmod2 == 0L) {
                return this.columnsl * (this.rowsl + 2L - r) - c;
            }
            return -(this.columnsl * (this.rowsl + 2L - r) - c + 2L);
        }
        if (c == 1L || c == this.columnsl + 1L) {
            return Long.MIN_VALUE;
        }
        if (c == this.columnsl) {
            return 1L;
        }
        if (c < this.columnsl) {
            return c;
        }
        if (cmod2 == 0L) {
            return (this.columnsl << 1) - c;
        }
        return -((this.columnsl << 1) - c + 2L);
    }

    public void pack(double val, int r, int c, double[] packed, int pos) {
        int index = this.getIndex(r, c);
        if (index >= 0) {
            packed[pos + index] = val;
        } else if (index > Integer.MIN_VALUE) {
            packed[pos - index] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r, c));
        }
    }

    public void pack(double val, long r, long c, DoubleLargeArray packed, long pos) {
        long index = this.getIndex(r, c);
        if (index >= 0L) {
            packed.setDouble(pos + index, val);
        } else if (index > Long.MIN_VALUE) {
            packed.setDouble(pos - index, -val);
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r, c));
        }
    }

    public void pack(double val, int r, int c, double[][] packed) {
        int index = this.getIndex(r, c);
        if (index >= 0) {
            packed[index / this.columns][index % this.columns] = val;
        } else if (index > Integer.MIN_VALUE) {
            packed[-index / this.columns][-index % this.columns] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r, c));
        }
    }

    public void pack(float val, int r, int c, float[] packed, int pos) {
        int index = this.getIndex(r, c);
        if (index >= 0) {
            packed[pos + index] = val;
        } else if (index > Integer.MIN_VALUE) {
            packed[pos - index] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r, c));
        }
    }

    public void pack(float val, long r, long c, FloatLargeArray packed, long pos) {
        long index = this.getIndex(r, c);
        if (index >= 0L) {
            packed.setFloat(pos + index, val);
        } else if (index > Long.MIN_VALUE) {
            packed.setFloat(pos - index, -val);
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r, c));
        }
    }

    public void pack(float val, int r, int c, float[][] packed) {
        int index = this.getIndex(r, c);
        if (index >= 0) {
            packed[index / this.columns][index % this.columns] = val;
        } else if (index > Integer.MIN_VALUE) {
            packed[-index / this.columns][-index % this.columns] = -val;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", r, c));
        }
    }

    public double unpack(int r, int c, double[] packed, int pos) {
        int index = this.getIndex(r, c);
        if (index >= 0) {
            return packed[pos + index];
        }
        if (index > Integer.MIN_VALUE) {
            return -packed[pos - index];
        }
        return 0.0;
    }

    public double unpack(long r, long c, DoubleLargeArray packed, long pos) {
        long index = this.getIndex(r, c);
        if (index >= 0L) {
            return packed.getDouble(pos + index);
        }
        if (index > Long.MIN_VALUE) {
            return -packed.getDouble(pos - index);
        }
        return 0.0;
    }

    public double unpack(int r, int c, double[][] packed) {
        int index = this.getIndex(r, c);
        if (index >= 0) {
            return packed[index / this.columns][index % this.columns];
        }
        if (index > Integer.MIN_VALUE) {
            return -packed[-index / this.columns][-index % this.columns];
        }
        return 0.0;
    }

    public float unpack(int r, int c, float[] packed, int pos) {
        int index = this.getIndex(r, c);
        if (index >= 0) {
            return packed[pos + index];
        }
        if (index > Integer.MIN_VALUE) {
            return -packed[pos - index];
        }
        return 0.0f;
    }

    public float unpack(long r, long c, FloatLargeArray packed, long pos) {
        long index = this.getIndex(r, c);
        if (index >= 0L) {
            return packed.getFloat(pos + index);
        }
        if (index > Long.MIN_VALUE) {
            return -packed.getFloat(pos - index);
        }
        return 0.0f;
    }

    public float unpack(int r, int c, float[][] packed) {
        int index = this.getIndex(r, c);
        if (index >= 0) {
            return packed[index / this.columns][index % this.columns];
        }
        if (index > Integer.MIN_VALUE) {
            return -packed[-index / this.columns][-index % this.columns];
        }
        return 0.0f;
    }
}

