/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dst;

import java.util.Arrays;
import org.jtransforms.dst.FloatDST_1D;
import org.jtransforms.dst.FloatDST_2D;
import org.jtransforms.dst.FloatDST_3D;
import org.jtransforms.utils.CommonUtils;
import org.jtransforms.utils.IOUtils;
import org.visnow.jlargearrays.ConcurrencyUtils;
import org.visnow.jlargearrays.FloatLargeArray;

public class BenchmarkFloatDST {
    private static int nthread = 8;
    private static int niter = 200;
    private static int nsize = 16;
    private static int threadsBegin2D = 65636;
    private static int threadsBegin3D = 65636;
    private static boolean doWarmup = true;
    private static long[] sizes1D = new long[]{262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 10368L, 27000L, 75600L, 165375L, 362880L, 1562500L, 0x310000L, 6250000L};
    private static long[] sizes2D = new long[]{256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 260L, 520L, 1050L, 1458L, 1960L, 2916L, 4116L, 5832L};
    private static long[] sizes3D = new long[]{16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 5L, 17L, 30L, 95L, 180L, 270L, 324L, 420L};
    private static boolean doScaling = false;

    private BenchmarkFloatDST() {
    }

    public static void parseArguments(String[] args) {
        if (args.length > 0) {
            int i;
            nthread = Integer.parseInt(args[0]);
            threadsBegin2D = Integer.parseInt(args[1]);
            threadsBegin3D = Integer.parseInt(args[2]);
            niter = Integer.parseInt(args[3]);
            doWarmup = Boolean.parseBoolean(args[4]);
            doScaling = Boolean.parseBoolean(args[5]);
            nsize = Integer.parseInt(args[6]);
            sizes1D = new long[nsize];
            sizes2D = new long[nsize];
            sizes3D = new long[nsize];
            for (i = 0; i < nsize; ++i) {
                BenchmarkFloatDST.sizes1D[i] = Integer.parseInt(args[7 + i]);
            }
            for (i = 0; i < nsize; ++i) {
                BenchmarkFloatDST.sizes2D[i] = Integer.parseInt(args[7 + nsize + i]);
            }
            for (i = 0; i < nsize; ++i) {
                BenchmarkFloatDST.sizes3D[i] = Integer.parseInt(args[7 + nsize + nsize + i]);
            }
        } else {
            System.out.println("Default settings are used.");
        }
        ConcurrencyUtils.setNumberOfThreads((int)nthread);
        CommonUtils.setThreadsBeginN_2D(threadsBegin2D);
        CommonUtils.setThreadsBeginN_3D(threadsBegin3D);
        System.out.println("nthred = " + nthread);
        System.out.println("threadsBegin2D = " + threadsBegin2D);
        System.out.println("threadsBegin3D = " + threadsBegin3D);
        System.out.println("niter = " + niter);
        System.out.println("doWarmup = " + doWarmup);
        System.out.println("doScaling = " + doScaling);
        System.out.println("nsize = " + nsize);
        System.out.println("sizes1D[] = " + Arrays.toString(sizes1D));
        System.out.println("sizes2D[] = " + Arrays.toString(sizes2D));
        System.out.println("sizes3D[] = " + Arrays.toString(sizes3D));
    }

    public static void benchmarkForward_1D() {
        double[] times_without_constructor = new double[nsize];
        double[] times_with_constructor = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            float[] x;
            System.out.println("Forward DST 1D of size " + sizes1D[i]);
            if (doWarmup) {
                FloatDST_1D dst = new FloatDST_1D(sizes1D[i]);
                x = new float[(int)sizes1D[i]];
                IOUtils.fillMatrix_1D(sizes1D[i], x);
                dst.forward(x, doScaling);
                IOUtils.fillMatrix_1D(sizes1D[i], x);
                dst.forward(x, doScaling);
            }
            long elapsedTime = System.nanoTime();
            FloatDST_1D dst = new FloatDST_1D(sizes1D[i]);
            times_with_constructor[i] = (double)(System.nanoTime() - elapsedTime) / 1000000.0;
            x = new float[(int)sizes1D[i]];
            double min_time = 0.0;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_1D(sizes1D[i], x);
                elapsedTime = System.nanoTime();
                dst.forward(x, doScaling);
                elapsedTime = System.nanoTime() - elapsedTime;
                if (!((double)elapsedTime < min_time)) continue;
                min_time = elapsedTime;
            }
            times_without_constructor[i] = min_time / 1000000.0;
            int n = i;
            times_with_constructor[n] = times_with_constructor[n] + times_without_constructor[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", times_without_constructor[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", times_with_constructor[i]) + " msec");
            x = null;
            dst = null;
            System.gc();
            CommonUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDST_1D.txt", nthread, niter, doWarmup, doScaling, sizes1D, times_without_constructor, times_with_constructor);
    }

    public static void benchmarkForward_2D_input_1D() {
        double[] times_without_constructor = new double[nsize];
        double[] times_with_constructor = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            FloatLargeArray x;
            System.out.println("Forward DST 2D (input 1D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            if (doWarmup) {
                FloatDST_2D dst2 = new FloatDST_2D(sizes2D[i], sizes2D[i]);
                x = new FloatLargeArray(sizes2D[i] * sizes2D[i], false);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], x);
                dst2.forward(x, doScaling);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], x);
                dst2.forward(x, doScaling);
            }
            long elapsedTime = System.nanoTime();
            FloatDST_2D dst2 = new FloatDST_2D(sizes2D[i], sizes2D[i]);
            times_with_constructor[i] = (double)(System.nanoTime() - elapsedTime) / 1000000.0;
            x = new FloatLargeArray(sizes2D[i] * sizes2D[i], false);
            double min_time = 0.0;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], x);
                elapsedTime = System.nanoTime();
                dst2.forward(x, doScaling);
                elapsedTime = System.nanoTime() - elapsedTime;
                if (!((double)elapsedTime < min_time)) continue;
                min_time = elapsedTime;
            }
            times_without_constructor[i] = min_time / 1000000.0;
            int n = i;
            times_with_constructor[n] = times_with_constructor[n] + times_without_constructor[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", times_without_constructor[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", times_with_constructor[i]) + " msec");
            x = null;
            dst2 = null;
            System.gc();
            CommonUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDST_2D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes2D, times_without_constructor, times_with_constructor);
    }

    public static void benchmarkForward_2D_input_2D() {
        double[] times_without_constructor = new double[nsize];
        double[] times_with_constructor = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            float[][] x;
            System.out.println("Forward DST 2D (input 2D) of size " + sizes2D[i] + " x " + sizes2D[i]);
            if (doWarmup) {
                FloatDST_2D dst2 = new FloatDST_2D(sizes2D[i], sizes2D[i]);
                x = new float[(int)sizes2D[i]][(int)sizes2D[i]];
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], x);
                dst2.forward(x, doScaling);
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], x);
                dst2.forward(x, doScaling);
            }
            long elapsedTime = System.nanoTime();
            FloatDST_2D dst2 = new FloatDST_2D(sizes2D[i], sizes2D[i]);
            times_with_constructor[i] = (double)(System.nanoTime() - elapsedTime) / 1000000.0;
            x = new float[(int)sizes2D[i]][(int)sizes2D[i]];
            double min_time = 0.0;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], x);
                elapsedTime = System.nanoTime();
                dst2.forward(x, doScaling);
                elapsedTime = System.nanoTime() - elapsedTime;
                if (!((double)elapsedTime < min_time)) continue;
                min_time = elapsedTime;
            }
            times_without_constructor[i] = min_time / 1000000.0;
            int n = i;
            times_with_constructor[n] = times_with_constructor[n] + times_without_constructor[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", times_without_constructor[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", times_with_constructor[i]) + " msec");
            x = null;
            dst2 = null;
            System.gc();
            CommonUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDST_2D_input_2D.txt", nthread, niter, doWarmup, doScaling, sizes2D, times_without_constructor, times_with_constructor);
    }

    public static void benchmarkForward_3D_input_1D() {
        double[] times_without_constructor = new double[nsize];
        double[] times_with_constructor = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            FloatLargeArray x;
            System.out.println("Forward DST 3D (input 1D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            if (doWarmup) {
                FloatDST_3D dst3 = new FloatDST_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
                x = new FloatLargeArray(sizes3D[i] * sizes3D[i] * sizes3D[i], false);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], x);
                dst3.forward(x, doScaling);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], x);
                dst3.forward(x, doScaling);
            }
            long elapsedTime = System.nanoTime();
            FloatDST_3D dst3 = new FloatDST_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            times_with_constructor[i] = (double)(System.nanoTime() - elapsedTime) / 1000000.0;
            x = new FloatLargeArray(sizes3D[i] * sizes3D[i] * sizes3D[i], false);
            double min_time = 0.0;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], x);
                elapsedTime = System.nanoTime();
                dst3.forward(x, doScaling);
                elapsedTime = System.nanoTime() - elapsedTime;
                if (!((double)elapsedTime < min_time)) continue;
                min_time = elapsedTime;
            }
            times_without_constructor[i] = min_time / 1000000.0;
            int n = i;
            times_with_constructor[n] = times_with_constructor[n] + times_without_constructor[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", times_without_constructor[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", times_with_constructor[i]) + " msec");
            x = null;
            dst3 = null;
            System.gc();
            CommonUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDST_3D_input_1D.txt", nthread, niter, doWarmup, doScaling, sizes3D, times_without_constructor, times_with_constructor);
    }

    public static void benchmarkForward_3D_input_3D() {
        double[] times_without_constructor = new double[nsize];
        double[] times_with_constructor = new double[nsize];
        for (int i = 0; i < nsize; ++i) {
            float[][][] x;
            System.out.println("Forward DST 3D (input 3D) of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i]);
            if (doWarmup) {
                FloatDST_3D dst3 = new FloatDST_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
                x = new float[(int)sizes3D[i]][(int)sizes3D[i]][(int)sizes3D[i]];
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], x);
                dst3.forward(x, doScaling);
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], x);
                dst3.forward(x, doScaling);
            }
            long elapsedTime = System.nanoTime();
            FloatDST_3D dst3 = new FloatDST_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            times_with_constructor[i] = (double)(System.nanoTime() - elapsedTime) / 1000000.0;
            x = new float[(int)sizes3D[i]][(int)sizes3D[i]][(int)sizes3D[i]];
            double min_time = 0.0;
            for (int j = 0; j < niter; ++j) {
                IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], x);
                elapsedTime = System.nanoTime();
                dst3.forward(x, doScaling);
                elapsedTime = System.nanoTime() - elapsedTime;
                if (!((double)elapsedTime < min_time)) continue;
                min_time = elapsedTime;
            }
            times_without_constructor[i] = min_time / 1000000.0;
            int n = i;
            times_with_constructor[n] = times_with_constructor[n] + times_without_constructor[i];
            System.out.println("\tBest execution time without constructor: " + String.format("%.2f", times_without_constructor[i]) + " msec");
            System.out.println("\tBest execution time with constructor: " + String.format("%.2f", times_with_constructor[i]) + " msec");
            x = null;
            dst3 = null;
            System.gc();
            CommonUtils.sleep(5000L);
        }
        IOUtils.writeFFTBenchmarkResultsToFile("benchmarkFloatForwardDST_3D_input_3D.txt", nthread, niter, doWarmup, doScaling, sizes3D, times_without_constructor, times_with_constructor);
    }

    public static void main(String[] args) {
        BenchmarkFloatDST.parseArguments(args);
        BenchmarkFloatDST.benchmarkForward_1D();
        BenchmarkFloatDST.benchmarkForward_2D_input_1D();
        BenchmarkFloatDST.benchmarkForward_2D_input_2D();
        BenchmarkFloatDST.benchmarkForward_3D_input_1D();
        BenchmarkFloatDST.benchmarkForward_3D_input_3D();
        System.exit(0);
    }
}

