/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dht;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jtransforms.dht.FloatDHT_1D;
import org.jtransforms.utils.CommonUtils;
import org.visnow.jlargearrays.ConcurrencyUtils;
import org.visnow.jlargearrays.FloatLargeArray;
import org.visnow.jlargearrays.LargeArray;

public class FloatDHT_3D {
    private int slices;
    private long slicesl;
    private int rows;
    private long rowsl;
    private int columns;
    private long columnsl;
    private int sliceStride;
    private long sliceStridel;
    private int rowStride;
    private long rowStridel;
    private FloatDHT_1D dhtSlices;
    private FloatDHT_1D dhtRows;
    private FloatDHT_1D dhtColumns;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public FloatDHT_3D(long slices, long rows, long columns) {
        if (slices <= 1L || rows <= 1L || columns <= 1L) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = (int)slices;
        this.rows = (int)rows;
        this.columns = (int)columns;
        this.slicesl = slices;
        this.rowsl = rows;
        this.columnsl = columns;
        this.sliceStride = (int)(rows * columns);
        this.rowStride = (int)columns;
        this.sliceStridel = rows * columns;
        this.rowStridel = columns;
        if (slices * rows * columns >= CommonUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (CommonUtils.isPowerOf2(slices) && CommonUtils.isPowerOf2(rows) && CommonUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
        }
        CommonUtils.setUseLargeArrays(slices * rows * columns > (long)LargeArray.getMaxSizeOf32bitArray());
        this.dhtSlices = new FloatDHT_1D(slices);
        this.dhtRows = slices == rows ? this.dhtSlices : new FloatDHT_1D(rows);
        this.dhtColumns = slices == columns ? this.dhtSlices : (rows == columns ? this.dhtRows : new FloatDHT_1D(columns));
    }

    public void forward(final float[] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, true);
                this.ddxt3db_subth(-1, a, true);
            } else {
                this.ddxt3da_sub(-1, a, true);
                this.ddxt3db_sub(-1, a, true);
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_3D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                int idx1 = s * this.this$0.sliceStride;
                                for (int r = 0; r < this.this$0.rows; ++r) {
                                    this.this$0.dhtColumns.forward(a, idx1 + r * this.this$0.rowStride);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_3D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            float[] temp = new float[this.this$0.rows];
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                int idx1 = s * this.this$0.sliceStride;
                                for (int c = 0; c < this.this$0.columns; ++c) {
                                    int idx3;
                                    int r;
                                    for (r = 0; r < this.this$0.rows; ++r) {
                                        idx3 = idx1 + r * this.this$0.rowStride + c;
                                        temp[r] = a[idx3];
                                    }
                                    this.this$0.dhtRows.forward(temp);
                                    for (r = 0; r < this.this$0.rows; ++r) {
                                        idx3 = idx1 + r * this.this$0.rowStride + c;
                                        a[idx3] = temp[r];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rows / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int startRow = l * p;
                    final int stopRow = l == nthreads - 1 ? this.rows : startRow + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_3D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            float[] temp = new float[this.this$0.slices];
                            for (int r = startRow; r < stopRow; ++r) {
                                int idx1 = r * this.this$0.rowStride;
                                for (int c = 0; c < this.this$0.columns; ++c) {
                                    int idx3;
                                    int s;
                                    for (s = 0; s < this.this$0.slices; ++s) {
                                        idx3 = s * this.this$0.sliceStride + idx1 + c;
                                        temp[s] = a[idx3];
                                    }
                                    this.this$0.dhtSlices.forward(temp);
                                    for (s = 0; s < this.this$0.slices; ++s) {
                                        idx3 = s * this.this$0.sliceStride + idx1 + c;
                                        a[idx3] = temp[s];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                int idx3;
                int c;
                int idx1;
                for (int s = 0; s < this.slices; ++s) {
                    int idx12 = s * this.sliceStride;
                    for (int r = 0; r < this.rows; ++r) {
                        this.dhtColumns.forward(a, idx12 + r * this.rowStride);
                    }
                }
                float[] temp = new float[this.rows];
                for (int s = 0; s < this.slices; ++s) {
                    idx1 = s * this.sliceStride;
                    for (c = 0; c < this.columns; ++c) {
                        int r;
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + r * this.rowStride + c;
                            temp[r] = a[idx3];
                        }
                        this.dhtRows.forward(temp);
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + r * this.rowStride + c;
                            a[idx3] = temp[r];
                        }
                    }
                }
                temp = new float[this.slices];
                for (int r = 0; r < this.rows; ++r) {
                    idx1 = r * this.rowStride;
                    for (c = 0; c < this.columns; ++c) {
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx3 = s * this.sliceStride + idx1 + c;
                            temp[s] = a[idx3];
                        }
                        this.dhtSlices.forward(temp);
                        for (s = 0; s < this.slices; ++s) {
                            idx3 = s * this.sliceStride + idx1 + c;
                            a[idx3] = temp[s];
                        }
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void forward(final FloatLargeArray a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, true);
                this.ddxt3db_subth(-1, a, true);
            } else {
                this.ddxt3da_sub(-1, a, true);
                this.ddxt3db_sub(-1, a, true);
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.slicesl >= (long)nthreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
                long lastSlice;
                long firstSlice;
                Future[] futures = new Future[nthreads];
                long p = this.slicesl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = (long)l * p;
                    lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_3D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            for (long s = firstSlice; s < lastSlice; ++s) {
                                long idx1 = s * (long)this.this$0.sliceStride;
                                for (long r = 0L; r < this.this$0.rowsl; ++r) {
                                    this.this$0.dhtColumns.forward(a, idx1 + r * (long)this.this$0.rowStride);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = (long)l * p;
                    lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_3D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            FloatLargeArray temp = new FloatLargeArray(this.this$0.rowsl, false);
                            for (long s = firstSlice; s < lastSlice; ++s) {
                                long idx1 = s * (long)this.this$0.sliceStride;
                                for (long c = 0L; c < this.this$0.columnsl; ++c) {
                                    long idx3;
                                    long r;
                                    for (r = 0L; r < this.this$0.rowsl; ++r) {
                                        idx3 = idx1 + r * (long)this.this$0.rowStride + c;
                                        temp.setFloat(r, a.getFloat(idx3));
                                    }
                                    this.this$0.dhtRows.forward(temp);
                                    for (r = 0L; r < this.this$0.rowsl; ++r) {
                                        idx3 = idx1 + r * (long)this.this$0.rowStride + c;
                                        a.setFloat(idx3, temp.getFloat(r));
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rowsl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final long startRow = (long)l * p;
                    final long stopRow = l == nthreads - 1 ? this.rowsl : startRow + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_3D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            FloatLargeArray temp = new FloatLargeArray(this.this$0.slicesl, false);
                            for (long r = startRow; r < stopRow; ++r) {
                                long idx1 = r * (long)this.this$0.rowStride;
                                for (long c = 0L; c < this.this$0.columnsl; ++c) {
                                    long idx3;
                                    long s;
                                    for (s = 0L; s < this.this$0.slicesl; ++s) {
                                        idx3 = s * (long)this.this$0.sliceStride + idx1 + c;
                                        temp.setFloat(s, a.getFloat(idx3));
                                    }
                                    this.this$0.dhtSlices.forward(temp);
                                    for (s = 0L; s < this.this$0.slicesl; ++s) {
                                        idx3 = s * (long)this.this$0.sliceStride + idx1 + c;
                                        a.setFloat(idx3, temp.getFloat(s));
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                long idx3;
                long c;
                long idx1;
                for (long s = 0L; s < this.slicesl; ++s) {
                    long idx12 = s * (long)this.sliceStride;
                    for (long r = 0L; r < this.rowsl; ++r) {
                        this.dhtColumns.forward(a, idx12 + r * (long)this.rowStride);
                    }
                }
                FloatLargeArray temp = new FloatLargeArray(this.rowsl, false);
                for (long s = 0L; s < this.slicesl; ++s) {
                    idx1 = s * (long)this.sliceStride;
                    for (c = 0L; c < this.columnsl; ++c) {
                        long r;
                        for (r = 0L; r < this.rowsl; ++r) {
                            idx3 = idx1 + r * (long)this.rowStride + c;
                            temp.setFloat(r, a.getFloat(idx3));
                        }
                        this.dhtRows.forward(temp);
                        for (r = 0L; r < this.rowsl; ++r) {
                            idx3 = idx1 + r * (long)this.rowStride + c;
                            a.setFloat(idx3, temp.getFloat(r));
                        }
                    }
                }
                temp = new FloatLargeArray(this.slicesl, false);
                for (long r = 0L; r < this.rowsl; ++r) {
                    idx1 = r * (long)this.rowStride;
                    for (c = 0L; c < this.columnsl; ++c) {
                        long s;
                        for (s = 0L; s < this.slicesl; ++s) {
                            idx3 = s * (long)this.sliceStride + idx1 + c;
                            temp.setFloat(s, a.getFloat(idx3));
                        }
                        this.dhtSlices.forward(temp);
                        for (s = 0L; s < this.slicesl; ++s) {
                            idx3 = s * (long)this.sliceStride + idx1 + c;
                            a.setFloat(idx3, temp.getFloat(s));
                        }
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void forward(final float[][][] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, true);
                this.ddxt3db_subth(-1, a, true);
            } else {
                this.ddxt3da_sub(-1, a, true);
                this.ddxt3db_sub(-1, a, true);
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_3D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < this.this$0.rows; ++r) {
                                    this.this$0.dhtColumns.forward(a[s][r]);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_3D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            float[] temp = new float[this.this$0.rows];
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int c = 0; c < this.this$0.columns; ++c) {
                                    int r;
                                    for (r = 0; r < this.this$0.rows; ++r) {
                                        temp[r] = a[s][r][c];
                                    }
                                    this.this$0.dhtRows.forward(temp);
                                    for (r = 0; r < this.this$0.rows; ++r) {
                                        a[s][r][c] = temp[r];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rows / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_3D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            float[] temp = new float[this.this$0.slices];
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < this.this$0.columns; ++c) {
                                    int s;
                                    for (s = 0; s < this.this$0.slices; ++s) {
                                        temp[s] = a[s][r][c];
                                    }
                                    this.this$0.dhtSlices.forward(temp);
                                    for (s = 0; s < this.this$0.slices; ++s) {
                                        a[s][r][c] = temp[s];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                int c;
                int r;
                for (int s = 0; s < this.slices; ++s) {
                    for (r = 0; r < this.rows; ++r) {
                        this.dhtColumns.forward(a[s][r]);
                    }
                }
                float[] temp = new float[this.rows];
                for (int s = 0; s < this.slices; ++s) {
                    for (c = 0; c < this.columns; ++c) {
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            temp[r2] = a[s][r2][c];
                        }
                        this.dhtRows.forward(temp);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            a[s][r2][c] = temp[r2];
                        }
                    }
                }
                temp = new float[this.slices];
                for (r = 0; r < this.rows; ++r) {
                    for (c = 0; c < this.columns; ++c) {
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            temp[s] = a[s][r][c];
                        }
                        this.dhtSlices.forward(temp);
                        for (s = 0; s < this.slices; ++s) {
                            a[s][r][c] = temp[s];
                        }
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void inverse(final float[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_3D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                int idx1 = s * this.this$0.sliceStride;
                                for (int r = 0; r < this.this$0.rows; ++r) {
                                    this.this$0.dhtColumns.inverse(a, idx1 + r * this.this$0.rowStride, scale);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_3D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            float[] temp = new float[this.this$0.rows];
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                int idx1 = s * this.this$0.sliceStride;
                                for (int c = 0; c < this.this$0.columns; ++c) {
                                    int idx3;
                                    int r;
                                    for (r = 0; r < this.this$0.rows; ++r) {
                                        idx3 = idx1 + r * this.this$0.rowStride + c;
                                        temp[r] = a[idx3];
                                    }
                                    this.this$0.dhtRows.inverse(temp, scale);
                                    for (r = 0; r < this.this$0.rows; ++r) {
                                        idx3 = idx1 + r * this.this$0.rowStride + c;
                                        a[idx3] = temp[r];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rows / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_3D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            float[] temp = new float[this.this$0.slices];
                            for (int r = firstRow; r < lastRow; ++r) {
                                int idx1 = r * this.this$0.rowStride;
                                for (int c = 0; c < this.this$0.columns; ++c) {
                                    int idx3;
                                    int s;
                                    for (s = 0; s < this.this$0.slices; ++s) {
                                        idx3 = s * this.this$0.sliceStride + idx1 + c;
                                        temp[s] = a[idx3];
                                    }
                                    this.this$0.dhtSlices.inverse(temp, scale);
                                    for (s = 0; s < this.this$0.slices; ++s) {
                                        idx3 = s * this.this$0.sliceStride + idx1 + c;
                                        a[idx3] = temp[s];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                int idx3;
                int c;
                int idx1;
                for (int s = 0; s < this.slices; ++s) {
                    int idx12 = s * this.sliceStride;
                    for (int r = 0; r < this.rows; ++r) {
                        this.dhtColumns.inverse(a, idx12 + r * this.rowStride, scale);
                    }
                }
                float[] temp = new float[this.rows];
                for (int s = 0; s < this.slices; ++s) {
                    idx1 = s * this.sliceStride;
                    for (c = 0; c < this.columns; ++c) {
                        int r;
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + r * this.rowStride + c;
                            temp[r] = a[idx3];
                        }
                        this.dhtRows.inverse(temp, scale);
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + r * this.rowStride + c;
                            a[idx3] = temp[r];
                        }
                    }
                }
                temp = new float[this.slices];
                for (int r = 0; r < this.rows; ++r) {
                    idx1 = r * this.rowStride;
                    for (c = 0; c < this.columns; ++c) {
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx3 = s * this.sliceStride + idx1 + c;
                            temp[s] = a[idx3];
                        }
                        this.dhtSlices.inverse(temp, scale);
                        for (s = 0; s < this.slices; ++s) {
                            idx3 = s * this.sliceStride + idx1 + c;
                            a[idx3] = temp[s];
                        }
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void inverse(final FloatLargeArray a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.slicesl >= (long)nthreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
                long lastSlice;
                long firstSlice;
                Future[] futures = new Future[nthreads];
                long p = this.slicesl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = (long)l * p;
                    lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_3D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            for (long s = firstSlice; s < lastSlice; ++s) {
                                long idx1 = s * this.this$0.sliceStridel;
                                for (long r = 0L; r < this.this$0.rowsl; ++r) {
                                    this.this$0.dhtColumns.inverse(a, idx1 + r * this.this$0.rowStridel, scale);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = (long)l * p;
                    lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_3D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            FloatLargeArray temp = new FloatLargeArray(this.this$0.rowsl, false);
                            for (long s = firstSlice; s < lastSlice; ++s) {
                                long idx1 = s * this.this$0.sliceStridel;
                                for (long c = 0L; c < this.this$0.columnsl; ++c) {
                                    long idx3;
                                    long r;
                                    for (r = 0L; r < this.this$0.rowsl; ++r) {
                                        idx3 = idx1 + r * this.this$0.rowStridel + c;
                                        temp.setFloat(r, a.getFloat(idx3));
                                    }
                                    this.this$0.dhtRows.inverse(temp, scale);
                                    for (r = 0L; r < this.this$0.rowsl; ++r) {
                                        idx3 = idx1 + r * this.this$0.rowStridel + c;
                                        a.setFloat(idx3, temp.getFloat(r));
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rowsl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final long firstRow = (long)l * p;
                    final long lastRow = l == nthreads - 1 ? this.rowsl : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_3D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            FloatLargeArray temp = new FloatLargeArray(this.this$0.slicesl, false);
                            for (long r = firstRow; r < lastRow; ++r) {
                                long idx1 = r * this.this$0.rowStridel;
                                for (long c = 0L; c < this.this$0.columnsl; ++c) {
                                    long idx3;
                                    long s;
                                    for (s = 0L; s < this.this$0.slicesl; ++s) {
                                        idx3 = s * this.this$0.sliceStridel + idx1 + c;
                                        temp.setFloat(s, a.getFloat(idx3));
                                    }
                                    this.this$0.dhtSlices.inverse(temp, scale);
                                    for (s = 0L; s < this.this$0.slicesl; ++s) {
                                        idx3 = s * this.this$0.sliceStridel + idx1 + c;
                                        a.setFloat(idx3, temp.getFloat(s));
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                long idx3;
                long c;
                long idx1;
                for (long s = 0L; s < this.slicesl; ++s) {
                    long idx12 = s * this.sliceStridel;
                    for (long r = 0L; r < this.rowsl; ++r) {
                        this.dhtColumns.inverse(a, idx12 + r * this.rowStridel, scale);
                    }
                }
                FloatLargeArray temp = new FloatLargeArray(this.rowsl, false);
                for (long s = 0L; s < this.slicesl; ++s) {
                    idx1 = s * this.sliceStridel;
                    for (c = 0L; c < this.columnsl; ++c) {
                        long r;
                        for (r = 0L; r < this.rowsl; ++r) {
                            idx3 = idx1 + r * this.rowStridel + c;
                            temp.setFloat(r, a.getFloat(idx3));
                        }
                        this.dhtRows.inverse(temp, scale);
                        for (r = 0L; r < this.rowsl; ++r) {
                            idx3 = idx1 + r * this.rowStridel + c;
                            a.setFloat(idx3, temp.getFloat(r));
                        }
                    }
                }
                temp = new FloatLargeArray(this.slicesl, false);
                for (long r = 0L; r < this.rowsl; ++r) {
                    idx1 = r * this.rowStridel;
                    for (c = 0L; c < this.columnsl; ++c) {
                        long s;
                        for (s = 0L; s < this.slicesl; ++s) {
                            idx3 = s * this.sliceStridel + idx1 + c;
                            temp.setFloat(s, a.getFloat(idx3));
                        }
                        this.dhtSlices.inverse(temp, scale);
                        for (s = 0L; s < this.slicesl; ++s) {
                            idx3 = s * this.sliceStridel + idx1 + c;
                            a.setFloat(idx3, temp.getFloat(s));
                        }
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void inverse(final float[][][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_3D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < this.this$0.rows; ++r) {
                                    this.this$0.dhtColumns.inverse(a[s][r], scale);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_3D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            float[] temp = new float[this.this$0.rows];
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int c = 0; c < this.this$0.columns; ++c) {
                                    int r;
                                    for (r = 0; r < this.this$0.rows; ++r) {
                                        temp[r] = a[s][r][c];
                                    }
                                    this.this$0.dhtRows.inverse(temp, scale);
                                    for (r = 0; r < this.this$0.rows; ++r) {
                                        a[s][r][c] = temp[r];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rows / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_3D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            float[] temp = new float[this.this$0.slices];
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < this.this$0.columns; ++c) {
                                    int s;
                                    for (s = 0; s < this.this$0.slices; ++s) {
                                        temp[s] = a[s][r][c];
                                    }
                                    this.this$0.dhtSlices.inverse(temp, scale);
                                    for (s = 0; s < this.this$0.slices; ++s) {
                                        a[s][r][c] = temp[s];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                int c;
                int r;
                for (int s = 0; s < this.slices; ++s) {
                    for (r = 0; r < this.rows; ++r) {
                        this.dhtColumns.inverse(a[s][r], scale);
                    }
                }
                float[] temp = new float[this.rows];
                for (int s = 0; s < this.slices; ++s) {
                    for (c = 0; c < this.columns; ++c) {
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            temp[r2] = a[s][r2][c];
                        }
                        this.dhtRows.inverse(temp, scale);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            a[s][r2][c] = temp[r2];
                        }
                    }
                }
                temp = new float[this.slices];
                for (r = 0; r < this.rows; ++r) {
                    for (c = 0; c < this.columns; ++c) {
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            temp[s] = a[s][r][c];
                        }
                        this.dhtSlices.inverse(temp, scale);
                        for (s = 0; s < this.slices; ++s) {
                            a[s][r][c] = temp[s];
                        }
                    }
                }
            }
            this.yTransform(a);
        }
    }

    private void ddxt3da_sub(int isgn, float[] a, boolean scale) {
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        float[] t = new float[nt];
        if (isgn == -1) {
            for (int s = 0; s < this.slices; ++s) {
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                for (r = 0; r < this.rows; ++r) {
                    this.dhtColumns.forward(a, idx0 + r * this.rowStride);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = this.rows + r2;
                            t[r2] = a[idx1];
                            t[idx2] = a[idx1 + 1];
                            t[idx2 + this.rows] = a[idx1 + 2];
                            t[idx2 + 2 * this.rows] = a[idx1 + 3];
                        }
                        this.dhtRows.forward(t, 0);
                        this.dhtRows.forward(t, this.rows);
                        this.dhtRows.forward(t, 2 * this.rows);
                        this.dhtRows.forward(t, 3 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = this.rows + r2;
                            a[idx1] = t[r2];
                            a[idx1 + 1] = t[idx2];
                            a[idx1 + 2] = t[idx2 + this.rows];
                            a[idx1 + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    t[r] = a[idx1];
                    t[this.rows + r] = a[idx1 + 1];
                }
                this.dhtRows.forward(t, 0);
                this.dhtRows.forward(t, this.rows);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    a[idx1] = t[r];
                    a[idx1 + 1] = t[this.rows + r];
                }
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                for (r = 0; r < this.rows; ++r) {
                    this.dhtColumns.inverse(a, idx0 + r * this.rowStride, scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = this.rows + r3;
                            t[r3] = a[idx1];
                            t[idx2] = a[idx1 + 1];
                            t[idx2 + this.rows] = a[idx1 + 2];
                            t[idx2 + 2 * this.rows] = a[idx1 + 3];
                        }
                        this.dhtRows.inverse(t, 0, scale);
                        this.dhtRows.inverse(t, this.rows, scale);
                        this.dhtRows.inverse(t, 2 * this.rows, scale);
                        this.dhtRows.inverse(t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = this.rows + r3;
                            a[idx1] = t[r3];
                            a[idx1 + 1] = t[idx2];
                            a[idx1 + 2] = t[idx2 + this.rows];
                            a[idx1 + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    t[r] = a[idx1];
                    t[this.rows + r] = a[idx1 + 1];
                }
                this.dhtRows.inverse(t, 0, scale);
                this.dhtRows.inverse(t, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    a[idx1] = t[r];
                    a[idx1 + 1] = t[this.rows + r];
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, FloatLargeArray a, boolean scale) {
        long nt = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        FloatLargeArray t = new FloatLargeArray(nt);
        if (isgn == -1) {
            for (long s = 0L; s < this.slicesl; ++s) {
                long idx1;
                long r;
                long idx0 = s * this.sliceStridel;
                for (r = 0L; r < this.rowsl; ++r) {
                    this.dhtColumns.forward(a, idx0 + r * this.rowStridel);
                }
                if (this.columnsl > 2L) {
                    for (long c = 0L; c < this.columnsl; c += 4L) {
                        long idx2;
                        long r2;
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx1 = idx0 + r2 * this.rowStridel + c;
                            idx2 = this.rowsl + r2;
                            t.setFloat(r2, a.getFloat(idx1));
                            t.setFloat(idx2, a.getFloat(idx1 + 1L));
                            t.setFloat(idx2 + this.rowsl, a.getFloat(idx1 + 2L));
                            t.setFloat(idx2 + 2L * this.rowsl, a.getFloat(idx1 + 3L));
                        }
                        this.dhtRows.forward(t, 0L);
                        this.dhtRows.forward(t, this.rowsl);
                        this.dhtRows.forward(t, 2L * this.rowsl);
                        this.dhtRows.forward(t, 3L * this.rowsl);
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx1 = idx0 + r2 * this.rowStridel + c;
                            idx2 = this.rowsl + r2;
                            a.setFloat(idx1, t.getFloat(r2));
                            a.setFloat(idx1 + 1L, t.getFloat(idx2));
                            a.setFloat(idx1 + 2L, t.getFloat(idx2 + this.rowsl));
                            a.setFloat(idx1 + 3L, t.getFloat(idx2 + 2L * this.rowsl));
                        }
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    t.setFloat(r, a.getFloat(idx1));
                    t.setFloat(this.rowsl + r, a.getFloat(idx1 + 1L));
                }
                this.dhtRows.forward(t, 0L);
                this.dhtRows.forward(t, this.rowsl);
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    a.setFloat(idx1, t.getFloat(r));
                    a.setFloat(idx1 + 1L, t.getFloat(this.rowsl + r));
                }
            }
        } else {
            for (long s = 0L; s < this.slicesl; ++s) {
                long idx1;
                long r;
                long idx0 = s * this.sliceStridel;
                for (r = 0L; r < this.rowsl; ++r) {
                    this.dhtColumns.inverse(a, idx0 + r * this.rowStridel, scale);
                }
                if (this.columnsl > 2L) {
                    for (long c = 0L; c < this.columnsl; c += 4L) {
                        long idx2;
                        long r3;
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c;
                            idx2 = this.rowsl + r3;
                            t.setFloat(r3, a.getFloat(idx1));
                            t.setFloat(idx2, a.getFloat(idx1 + 1L));
                            t.setFloat(idx2 + this.rowsl, a.getFloat(idx1 + 2L));
                            t.setFloat(idx2 + 2L * this.rowsl, a.getFloat(idx1 + 3L));
                        }
                        this.dhtRows.inverse(t, 0L, scale);
                        this.dhtRows.inverse(t, this.rowsl, scale);
                        this.dhtRows.inverse(t, 2L * this.rowsl, scale);
                        this.dhtRows.inverse(t, 3L * this.rowsl, scale);
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c;
                            idx2 = this.rowsl + r3;
                            a.setFloat(idx1, t.getFloat(r3));
                            a.setFloat(idx1 + 1L, t.getFloat(idx2));
                            a.setFloat(idx1 + 2L, t.getFloat(idx2 + this.rowsl));
                            a.setFloat(idx1 + 3L, t.getFloat(idx2 + 2L * this.rowsl));
                        }
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    t.setFloat(r, a.getFloat(idx1));
                    t.setFloat(this.rowsl + r, a.getFloat(idx1 + 1L));
                }
                this.dhtRows.inverse(t, 0L, scale);
                this.dhtRows.inverse(t, this.rowsl, scale);
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    a.setFloat(idx1, t.getFloat(r));
                    a.setFloat(idx1 + 1L, t.getFloat(this.rowsl + r));
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, float[][][] a, boolean scale) {
        int nt = 4 * this.rows;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        float[] t = new float[nt];
        if (isgn == -1) {
            for (int s = 0; s < this.slices; ++s) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    this.dhtColumns.forward(a[s][r]);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            t[r2] = a[s][r2][c];
                            t[idx2] = a[s][r2][c + 1];
                            t[idx2 + this.rows] = a[s][r2][c + 2];
                            t[idx2 + 2 * this.rows] = a[s][r2][c + 3];
                        }
                        this.dhtRows.forward(t, 0);
                        this.dhtRows.forward(t, this.rows);
                        this.dhtRows.forward(t, 2 * this.rows);
                        this.dhtRows.forward(t, 3 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            a[s][r2][c] = t[r2];
                            a[s][r2][c + 1] = t[idx2];
                            a[s][r2][c + 2] = t[idx2 + this.rows];
                            a[s][r2][c + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    t[r] = a[s][r][0];
                    t[this.rows + r] = a[s][r][1];
                }
                this.dhtRows.forward(t, 0);
                this.dhtRows.forward(t, this.rows);
                for (r = 0; r < this.rows; ++r) {
                    a[s][r][0] = t[r];
                    a[s][r][1] = t[this.rows + r];
                }
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    this.dhtColumns.inverse(a[s][r], scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            t[r3] = a[s][r3][c];
                            t[idx2] = a[s][r3][c + 1];
                            t[idx2 + this.rows] = a[s][r3][c + 2];
                            t[idx2 + 2 * this.rows] = a[s][r3][c + 3];
                        }
                        this.dhtRows.inverse(t, 0, scale);
                        this.dhtRows.inverse(t, this.rows, scale);
                        this.dhtRows.inverse(t, 2 * this.rows, scale);
                        this.dhtRows.inverse(t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            a[s][r3][c] = t[r3];
                            a[s][r3][c + 1] = t[idx2];
                            a[s][r3][c + 2] = t[idx2 + this.rows];
                            a[s][r3][c + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    t[r] = a[s][r][0];
                    t[this.rows + r] = a[s][r][1];
                }
                this.dhtRows.inverse(t, 0, scale);
                this.dhtRows.inverse(t, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    a[s][r][0] = t[r];
                    a[s][r][1] = t[this.rows + r];
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, float[] a, boolean scale) {
        block20: {
            float[] t;
            block18: {
                block19: {
                    int nt = 4 * this.slices;
                    if (this.columns == 2) {
                        nt >>= 1;
                    }
                    t = new float[nt];
                    if (isgn != -1) break block18;
                    if (this.columns <= 2) break block19;
                    for (int r = 0; r < this.rows; ++r) {
                        int idx0 = r * this.rowStride;
                        for (int c = 0; c < this.columns; c += 4) {
                            int idx2;
                            int idx1;
                            int s;
                            for (s = 0; s < this.slices; ++s) {
                                idx1 = s * this.sliceStride + idx0 + c;
                                idx2 = this.slices + s;
                                t[s] = a[idx1];
                                t[idx2] = a[idx1 + 1];
                                t[idx2 + this.slices] = a[idx1 + 2];
                                t[idx2 + 2 * this.slices] = a[idx1 + 3];
                            }
                            this.dhtSlices.forward(t, 0);
                            this.dhtSlices.forward(t, this.slices);
                            this.dhtSlices.forward(t, 2 * this.slices);
                            this.dhtSlices.forward(t, 3 * this.slices);
                            for (s = 0; s < this.slices; ++s) {
                                idx1 = s * this.sliceStride + idx0 + c;
                                idx2 = this.slices + s;
                                a[idx1] = t[s];
                                a[idx1 + 1] = t[idx2];
                                a[idx1 + 2] = t[idx2 + this.slices];
                                a[idx1 + 3] = t[idx2 + 2 * this.slices];
                            }
                        }
                    }
                    break block20;
                }
                if (this.columns != 2) break block20;
                for (int r = 0; r < this.rows; ++r) {
                    int idx1;
                    int s;
                    int idx0 = r * this.rowStride;
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        t[s] = a[idx1];
                        t[this.slices + s] = a[idx1 + 1];
                    }
                    this.dhtSlices.forward(t, 0);
                    this.dhtSlices.forward(t, this.slices);
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        a[idx1] = t[s];
                        a[idx1 + 1] = t[this.slices + s];
                    }
                }
                break block20;
            }
            if (this.columns > 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx0 = r * this.rowStride;
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int idx1;
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx1 = s * this.sliceStride + idx0 + c;
                            idx2 = this.slices + s;
                            t[s] = a[idx1];
                            t[idx2] = a[idx1 + 1];
                            t[idx2 + this.slices] = a[idx1 + 2];
                            t[idx2 + 2 * this.slices] = a[idx1 + 3];
                        }
                        this.dhtSlices.inverse(t, 0, scale);
                        this.dhtSlices.inverse(t, this.slices, scale);
                        this.dhtSlices.inverse(t, 2 * this.slices, scale);
                        this.dhtSlices.inverse(t, 3 * this.slices, scale);
                        for (s = 0; s < this.slices; ++s) {
                            idx1 = s * this.sliceStride + idx0 + c;
                            idx2 = this.slices + s;
                            a[idx1] = t[s];
                            a[idx1 + 1] = t[idx2];
                            a[idx1 + 2] = t[idx2 + this.slices];
                            a[idx1 + 3] = t[idx2 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx1;
                    int s;
                    int idx0 = r * this.rowStride;
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        t[s] = a[idx1];
                        t[this.slices + s] = a[idx1 + 1];
                    }
                    this.dhtSlices.inverse(t, 0, scale);
                    this.dhtSlices.inverse(t, this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        a[idx1] = t[s];
                        a[idx1 + 1] = t[this.slices + s];
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, FloatLargeArray a, boolean scale) {
        block20: {
            FloatLargeArray t;
            block18: {
                block19: {
                    long nt = 4L * this.slicesl;
                    if (this.columnsl == 2L) {
                        nt >>= 1;
                    }
                    t = new FloatLargeArray(nt);
                    if (isgn != -1) break block18;
                    if (this.columnsl <= 2L) break block19;
                    for (long r = 0L; r < this.rowsl; ++r) {
                        long idx0 = r * this.rowStridel;
                        for (long c = 0L; c < this.columnsl; c += 4L) {
                            long idx2;
                            long idx1;
                            long s;
                            for (s = 0L; s < this.slicesl; ++s) {
                                idx1 = s * this.sliceStridel + idx0 + c;
                                idx2 = this.slicesl + s;
                                t.setFloat(s, a.getFloat(idx1));
                                t.setFloat(idx2, a.getFloat(idx1 + 1L));
                                t.setFloat(idx2 + this.slicesl, a.getFloat(idx1 + 2L));
                                t.setFloat(idx2 + 2L * this.slicesl, a.getFloat(idx1 + 3L));
                            }
                            this.dhtSlices.forward(t, 0L);
                            this.dhtSlices.forward(t, this.slicesl);
                            this.dhtSlices.forward(t, 2L * this.slicesl);
                            this.dhtSlices.forward(t, 3L * this.slicesl);
                            for (s = 0L; s < this.slicesl; ++s) {
                                idx1 = s * this.sliceStridel + idx0 + c;
                                idx2 = this.slicesl + s;
                                a.setFloat(idx1, t.getFloat(s));
                                a.setFloat(idx1 + 1L, t.getFloat(idx2));
                                a.setFloat(idx1 + 2L, t.getFloat(idx2 + this.slicesl));
                                a.setFloat(idx1 + 3L, t.getFloat(idx2 + 2L * this.slicesl));
                            }
                        }
                    }
                    break block20;
                }
                if (this.columnsl != 2L) break block20;
                for (long r = 0L; r < this.rowsl; ++r) {
                    long idx1;
                    long s;
                    long idx0 = r * this.rowStridel;
                    for (s = 0L; s < this.slicesl; ++s) {
                        idx1 = s * this.sliceStridel + idx0;
                        t.setFloat(s, a.getFloat(idx1));
                        t.setFloat(this.slicesl + s, a.getFloat(idx1 + 1L));
                    }
                    this.dhtSlices.forward(t, 0L);
                    this.dhtSlices.forward(t, this.slicesl);
                    for (s = 0L; s < this.slicesl; ++s) {
                        idx1 = s * this.sliceStridel + idx0;
                        a.setFloat(idx1, t.getFloat(s));
                        a.setFloat(idx1 + 1L, t.getFloat(this.slicesl + s));
                    }
                }
                break block20;
            }
            if (this.columnsl > 2L) {
                for (long r = 0L; r < this.rowsl; ++r) {
                    long idx0 = r * this.rowStridel;
                    for (long c = 0L; c < this.columnsl; c += 4L) {
                        long idx2;
                        long idx1;
                        long s;
                        for (s = 0L; s < this.slicesl; ++s) {
                            idx1 = s * this.sliceStridel + idx0 + c;
                            idx2 = this.slicesl + s;
                            t.setFloat(s, a.getFloat(idx1));
                            t.setFloat(idx2, a.getFloat(idx1 + 1L));
                            t.setFloat(idx2 + this.slicesl, a.getFloat(idx1 + 2L));
                            t.setFloat(idx2 + 2L * this.slicesl, a.getFloat(idx1 + 3L));
                        }
                        this.dhtSlices.inverse(t, 0L, scale);
                        this.dhtSlices.inverse(t, this.slicesl, scale);
                        this.dhtSlices.inverse(t, 2L * this.slicesl, scale);
                        this.dhtSlices.inverse(t, 3L * this.slicesl, scale);
                        for (s = 0L; s < this.slicesl; ++s) {
                            idx1 = s * this.sliceStridel + idx0 + c;
                            idx2 = this.slicesl + s;
                            a.setFloat(idx1, t.getFloat(s));
                            a.setFloat(idx1 + 1L, t.getFloat(idx2));
                            a.setFloat(idx1 + 2L, t.getFloat(idx2 + this.slicesl));
                            a.setFloat(idx1 + 3L, t.getFloat(idx2 + 2L * this.slicesl));
                        }
                    }
                }
            } else if (this.columnsl == 2L) {
                for (long r = 0L; r < this.rowsl; ++r) {
                    long idx1;
                    long s;
                    long idx0 = r * this.rowStridel;
                    for (s = 0L; s < this.slicesl; ++s) {
                        idx1 = s * this.sliceStridel + idx0;
                        t.setFloat(s, a.getFloat(idx1));
                        t.setFloat(this.slicesl + s, a.getFloat(idx1 + 1L));
                    }
                    this.dhtSlices.inverse(t, 0L, scale);
                    this.dhtSlices.inverse(t, this.slicesl, scale);
                    for (s = 0L; s < this.slicesl; ++s) {
                        idx1 = s * this.sliceStridel + idx0;
                        a.setFloat(idx1, t.getFloat(s));
                        a.setFloat(idx1 + 1L, t.getFloat(this.slicesl + s));
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, float[][][] a, boolean scale) {
        block20: {
            float[] t;
            block18: {
                block19: {
                    int nt = 4 * this.slices;
                    if (this.columns == 2) {
                        nt >>= 1;
                    }
                    t = new float[nt];
                    if (isgn != -1) break block18;
                    if (this.columns <= 2) break block19;
                    for (int r = 0; r < this.rows; ++r) {
                        for (int c = 0; c < this.columns; c += 4) {
                            int idx2;
                            int s;
                            for (s = 0; s < this.slices; ++s) {
                                idx2 = this.slices + s;
                                t[s] = a[s][r][c];
                                t[idx2] = a[s][r][c + 1];
                                t[idx2 + this.slices] = a[s][r][c + 2];
                                t[idx2 + 2 * this.slices] = a[s][r][c + 3];
                            }
                            this.dhtSlices.forward(t, 0);
                            this.dhtSlices.forward(t, this.slices);
                            this.dhtSlices.forward(t, 2 * this.slices);
                            this.dhtSlices.forward(t, 3 * this.slices);
                            for (s = 0; s < this.slices; ++s) {
                                idx2 = this.slices + s;
                                a[s][r][c] = t[s];
                                a[s][r][c + 1] = t[idx2];
                                a[s][r][c + 2] = t[idx2 + this.slices];
                                a[s][r][c + 3] = t[idx2 + 2 * this.slices];
                            }
                        }
                    }
                    break block20;
                }
                if (this.columns != 2) break block20;
                for (int r = 0; r < this.rows; ++r) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        t[s] = a[s][r][0];
                        t[this.slices + s] = a[s][r][1];
                    }
                    this.dhtSlices.forward(t, 0);
                    this.dhtSlices.forward(t, this.slices);
                    for (s = 0; s < this.slices; ++s) {
                        a[s][r][0] = t[s];
                        a[s][r][1] = t[this.slices + s];
                    }
                }
                break block20;
            }
            if (this.columns > 2) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx2 = this.slices + s;
                            t[s] = a[s][r][c];
                            t[idx2] = a[s][r][c + 1];
                            t[idx2 + this.slices] = a[s][r][c + 2];
                            t[idx2 + 2 * this.slices] = a[s][r][c + 3];
                        }
                        this.dhtSlices.inverse(t, 0, scale);
                        this.dhtSlices.inverse(t, this.slices, scale);
                        this.dhtSlices.inverse(t, 2 * this.slices, scale);
                        this.dhtSlices.inverse(t, 3 * this.slices, scale);
                        for (s = 0; s < this.slices; ++s) {
                            idx2 = this.slices + s;
                            a[s][r][c] = t[s];
                            a[s][r][c + 1] = t[idx2];
                            a[s][r][c + 2] = t[idx2 + this.slices];
                            a[s][r][c + 3] = t[idx2 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        t[s] = a[s][r][0];
                        t[this.slices + s] = a[s][r][1];
                    }
                    this.dhtSlices.inverse(t, 0, scale);
                    this.dhtSlices.inverse(t, this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        a[s][r][0] = t[s];
                        a[s][r][1] = t[this.slices + s];
                    }
                }
            }
        }
    }

    private void ddxt3da_subth(final int isgn, final float[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                final /* synthetic */ FloatDHT_3D this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    float[] t = new float[ntf];
                    if (isgn == -1) {
                        for (int s = n0; s < this.this$0.slices; s += nthreads) {
                            int idx1;
                            int r;
                            int idx0 = s * this.this$0.sliceStride;
                            for (r = 0; r < this.this$0.rows; ++r) {
                                this.this$0.dhtColumns.forward(a, idx0 + r * this.this$0.rowStride);
                            }
                            if (this.this$0.columns > 2) {
                                for (int c = 0; c < this.this$0.columns; c += 4) {
                                    int idx2;
                                    int r2;
                                    for (r2 = 0; r2 < this.this$0.rows; ++r2) {
                                        idx1 = idx0 + r2 * this.this$0.rowStride + c;
                                        idx2 = this.this$0.rows + r2;
                                        t[r2] = a[idx1];
                                        t[idx2] = a[idx1 + 1];
                                        t[idx2 + this.this$0.rows] = a[idx1 + 2];
                                        t[idx2 + 2 * this.this$0.rows] = a[idx1 + 3];
                                    }
                                    this.this$0.dhtRows.forward(t, 0);
                                    this.this$0.dhtRows.forward(t, this.this$0.rows);
                                    this.this$0.dhtRows.forward(t, 2 * this.this$0.rows);
                                    this.this$0.dhtRows.forward(t, 3 * this.this$0.rows);
                                    for (r2 = 0; r2 < this.this$0.rows; ++r2) {
                                        idx1 = idx0 + r2 * this.this$0.rowStride + c;
                                        idx2 = this.this$0.rows + r2;
                                        a[idx1] = t[r2];
                                        a[idx1 + 1] = t[idx2];
                                        a[idx1 + 2] = t[idx2 + this.this$0.rows];
                                        a[idx1 + 3] = t[idx2 + 2 * this.this$0.rows];
                                    }
                                }
                                continue;
                            }
                            if (this.this$0.columns != 2) continue;
                            for (r = 0; r < this.this$0.rows; ++r) {
                                idx1 = idx0 + r * this.this$0.rowStride;
                                t[r] = a[idx1];
                                t[this.this$0.rows + r] = a[idx1 + 1];
                            }
                            this.this$0.dhtRows.forward(t, 0);
                            this.this$0.dhtRows.forward(t, this.this$0.rows);
                            for (r = 0; r < this.this$0.rows; ++r) {
                                idx1 = idx0 + r * this.this$0.rowStride;
                                a[idx1] = t[r];
                                a[idx1 + 1] = t[this.this$0.rows + r];
                            }
                        }
                    } else {
                        for (int s = n0; s < this.this$0.slices; s += nthreads) {
                            int idx1;
                            int r;
                            int idx0 = s * this.this$0.sliceStride;
                            for (r = 0; r < this.this$0.rows; ++r) {
                                this.this$0.dhtColumns.inverse(a, idx0 + r * this.this$0.rowStride, scale);
                            }
                            if (this.this$0.columns > 2) {
                                for (int c = 0; c < this.this$0.columns; c += 4) {
                                    int idx2;
                                    int r3;
                                    for (r3 = 0; r3 < this.this$0.rows; ++r3) {
                                        idx1 = idx0 + r3 * this.this$0.rowStride + c;
                                        idx2 = this.this$0.rows + r3;
                                        t[r3] = a[idx1];
                                        t[idx2] = a[idx1 + 1];
                                        t[idx2 + this.this$0.rows] = a[idx1 + 2];
                                        t[idx2 + 2 * this.this$0.rows] = a[idx1 + 3];
                                    }
                                    this.this$0.dhtRows.inverse(t, 0, scale);
                                    this.this$0.dhtRows.inverse(t, this.this$0.rows, scale);
                                    this.this$0.dhtRows.inverse(t, 2 * this.this$0.rows, scale);
                                    this.this$0.dhtRows.inverse(t, 3 * this.this$0.rows, scale);
                                    for (r3 = 0; r3 < this.this$0.rows; ++r3) {
                                        idx1 = idx0 + r3 * this.this$0.rowStride + c;
                                        idx2 = this.this$0.rows + r3;
                                        a[idx1] = t[r3];
                                        a[idx1 + 1] = t[idx2];
                                        a[idx1 + 2] = t[idx2 + this.this$0.rows];
                                        a[idx1 + 3] = t[idx2 + 2 * this.this$0.rows];
                                    }
                                }
                                continue;
                            }
                            if (this.this$0.columns != 2) continue;
                            for (r = 0; r < this.this$0.rows; ++r) {
                                idx1 = idx0 + r * this.this$0.rowStride;
                                t[r] = a[idx1];
                                t[this.this$0.rows + r] = a[idx1 + 1];
                            }
                            this.this$0.dhtRows.inverse(t, 0, scale);
                            this.this$0.dhtRows.inverse(t, this.this$0.rows, scale);
                            for (r = 0; r < this.this$0.rows; ++r) {
                                idx1 = idx0 + r * this.this$0.rowStride;
                                a[idx1] = t[r];
                                a[idx1 + 1] = t[this.this$0.rows + r];
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3da_subth(final int isgn, final FloatLargeArray a, final boolean scale) {
        final int nthreads = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.slicesl ? this.slicesl : (long)ConcurrencyUtils.getNumberOfThreads());
        long nt = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        final long ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final long n0 = i;
            futures[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                final /* synthetic */ FloatDHT_3D this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    FloatLargeArray t = new FloatLargeArray(ntf);
                    if (isgn == -1) {
                        for (long s = n0; s < this.this$0.slicesl; s += (long)nthreads) {
                            long idx1;
                            long r;
                            long idx0 = s * (long)this.this$0.sliceStride;
                            for (r = 0L; r < this.this$0.rowsl; ++r) {
                                this.this$0.dhtColumns.forward(a, idx0 + r * (long)this.this$0.rowStride);
                            }
                            if (this.this$0.columnsl > 2L) {
                                for (long c = 0L; c < this.this$0.columnsl; c += 4L) {
                                    long idx2;
                                    long r2;
                                    for (r2 = 0L; r2 < this.this$0.rowsl; ++r2) {
                                        idx1 = idx0 + r2 * (long)this.this$0.rowStride + c;
                                        idx2 = this.this$0.rowsl + r2;
                                        t.setFloat(r2, a.getFloat(idx1));
                                        t.setFloat(idx2, a.getFloat(idx1 + 1L));
                                        t.setFloat(idx2 + this.this$0.rowsl, a.getFloat(idx1 + 2L));
                                        t.setFloat(idx2 + 2L * this.this$0.rowsl, a.getFloat(idx1 + 3L));
                                    }
                                    this.this$0.dhtRows.forward(t, 0L);
                                    this.this$0.dhtRows.forward(t, this.this$0.rowsl);
                                    this.this$0.dhtRows.forward(t, 2L * this.this$0.rowsl);
                                    this.this$0.dhtRows.forward(t, 3L * this.this$0.rowsl);
                                    for (r2 = 0L; r2 < this.this$0.rowsl; ++r2) {
                                        idx1 = idx0 + r2 * (long)this.this$0.rowStride + c;
                                        idx2 = this.this$0.rowsl + r2;
                                        a.setFloat(idx1, t.getFloat(r2));
                                        a.setFloat(idx1 + 1L, t.getFloat(idx2));
                                        a.setFloat(idx1 + 2L, t.getFloat(idx2 + this.this$0.rowsl));
                                        a.setFloat(idx1 + 3L, t.getFloat(idx2 + 2L * this.this$0.rowsl));
                                    }
                                }
                                continue;
                            }
                            if (this.this$0.columnsl != 2L) continue;
                            for (r = 0L; r < this.this$0.rowsl; ++r) {
                                idx1 = idx0 + r * (long)this.this$0.rowStride;
                                t.setFloat(r, a.getFloat(idx1));
                                t.setFloat(this.this$0.rowsl + r, a.getFloat(idx1 + 1L));
                            }
                            this.this$0.dhtRows.forward(t, 0L);
                            this.this$0.dhtRows.forward(t, this.this$0.rowsl);
                            for (r = 0L; r < this.this$0.rowsl; ++r) {
                                idx1 = idx0 + r * (long)this.this$0.rowStride;
                                a.setFloat(idx1, t.getFloat(r));
                                a.setFloat(idx1 + 1L, t.getFloat(this.this$0.rowsl + r));
                            }
                        }
                    } else {
                        for (long s = n0; s < this.this$0.slicesl; s += (long)nthreads) {
                            long idx1;
                            long r;
                            long idx0 = s * (long)this.this$0.sliceStride;
                            for (r = 0L; r < this.this$0.rowsl; ++r) {
                                this.this$0.dhtColumns.inverse(a, idx0 + r * (long)this.this$0.rowStride, scale);
                            }
                            if (this.this$0.columnsl > 2L) {
                                for (long c = 0L; c < this.this$0.columnsl; c += 4L) {
                                    long idx2;
                                    long r3;
                                    for (r3 = 0L; r3 < this.this$0.rowsl; ++r3) {
                                        idx1 = idx0 + r3 * (long)this.this$0.rowStride + c;
                                        idx2 = this.this$0.rowsl + r3;
                                        t.setFloat(r3, a.getFloat(idx1));
                                        t.setFloat(idx2, a.getFloat(idx1 + 1L));
                                        t.setFloat(idx2 + this.this$0.rowsl, a.getFloat(idx1 + 2L));
                                        t.setFloat(idx2 + 2L * this.this$0.rowsl, a.getFloat(idx1 + 3L));
                                    }
                                    this.this$0.dhtRows.inverse(t, 0L, scale);
                                    this.this$0.dhtRows.inverse(t, this.this$0.rowsl, scale);
                                    this.this$0.dhtRows.inverse(t, 2L * this.this$0.rowsl, scale);
                                    this.this$0.dhtRows.inverse(t, 3L * this.this$0.rowsl, scale);
                                    for (r3 = 0L; r3 < this.this$0.rowsl; ++r3) {
                                        idx1 = idx0 + r3 * (long)this.this$0.rowStride + c;
                                        idx2 = this.this$0.rowsl + r3;
                                        a.setFloat(idx1, t.getFloat(r3));
                                        a.setFloat(idx1 + 1L, t.getFloat(idx2));
                                        a.setFloat(idx1 + 2L, t.getFloat(idx2 + this.this$0.rowsl));
                                        a.setFloat(idx1 + 3L, t.getFloat(idx2 + 2L * this.this$0.rowsl));
                                    }
                                }
                                continue;
                            }
                            if (this.this$0.columnsl != 2L) continue;
                            for (r = 0L; r < this.this$0.rowsl; ++r) {
                                idx1 = idx0 + r * (long)this.this$0.rowStride;
                                t.setFloat(r, a.getFloat(idx1));
                                t.setFloat(this.this$0.rowsl + r, a.getFloat(idx1 + 1L));
                            }
                            this.this$0.dhtRows.inverse(t, 0L, scale);
                            this.this$0.dhtRows.inverse(t, this.this$0.rowsl, scale);
                            for (r = 0L; r < this.this$0.rowsl; ++r) {
                                idx1 = idx0 + r * (long)this.this$0.rowStride;
                                a.setFloat(idx1, t.getFloat(r));
                                a.setFloat(idx1 + 1L, t.getFloat(this.this$0.rowsl + r));
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3da_subth(final int isgn, final float[][][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                final /* synthetic */ FloatDHT_3D this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    float[] t = new float[ntf];
                    if (isgn == -1) {
                        for (int s = n0; s < this.this$0.slices; s += nthreads) {
                            int r;
                            for (r = 0; r < this.this$0.rows; ++r) {
                                this.this$0.dhtColumns.forward(a[s][r]);
                            }
                            if (this.this$0.columns > 2) {
                                for (int c = 0; c < this.this$0.columns; c += 4) {
                                    int idx2;
                                    int r2;
                                    for (r2 = 0; r2 < this.this$0.rows; ++r2) {
                                        idx2 = this.this$0.rows + r2;
                                        t[r2] = a[s][r2][c];
                                        t[idx2] = a[s][r2][c + 1];
                                        t[idx2 + this.this$0.rows] = a[s][r2][c + 2];
                                        t[idx2 + 2 * this.this$0.rows] = a[s][r2][c + 3];
                                    }
                                    this.this$0.dhtRows.forward(t, 0);
                                    this.this$0.dhtRows.forward(t, this.this$0.rows);
                                    this.this$0.dhtRows.forward(t, 2 * this.this$0.rows);
                                    this.this$0.dhtRows.forward(t, 3 * this.this$0.rows);
                                    for (r2 = 0; r2 < this.this$0.rows; ++r2) {
                                        idx2 = this.this$0.rows + r2;
                                        a[s][r2][c] = t[r2];
                                        a[s][r2][c + 1] = t[idx2];
                                        a[s][r2][c + 2] = t[idx2 + this.this$0.rows];
                                        a[s][r2][c + 3] = t[idx2 + 2 * this.this$0.rows];
                                    }
                                }
                                continue;
                            }
                            if (this.this$0.columns != 2) continue;
                            for (r = 0; r < this.this$0.rows; ++r) {
                                t[r] = a[s][r][0];
                                t[this.this$0.rows + r] = a[s][r][1];
                            }
                            this.this$0.dhtRows.forward(t, 0);
                            this.this$0.dhtRows.forward(t, this.this$0.rows);
                            for (r = 0; r < this.this$0.rows; ++r) {
                                a[s][r][0] = t[r];
                                a[s][r][1] = t[this.this$0.rows + r];
                            }
                        }
                    } else {
                        for (int s = n0; s < this.this$0.slices; s += nthreads) {
                            int r;
                            for (r = 0; r < this.this$0.rows; ++r) {
                                this.this$0.dhtColumns.inverse(a[s][r], scale);
                            }
                            if (this.this$0.columns > 2) {
                                for (int c = 0; c < this.this$0.columns; c += 4) {
                                    int idx2;
                                    int r3;
                                    for (r3 = 0; r3 < this.this$0.rows; ++r3) {
                                        idx2 = this.this$0.rows + r3;
                                        t[r3] = a[s][r3][c];
                                        t[idx2] = a[s][r3][c + 1];
                                        t[idx2 + this.this$0.rows] = a[s][r3][c + 2];
                                        t[idx2 + 2 * this.this$0.rows] = a[s][r3][c + 3];
                                    }
                                    this.this$0.dhtRows.inverse(t, 0, scale);
                                    this.this$0.dhtRows.inverse(t, this.this$0.rows, scale);
                                    this.this$0.dhtRows.inverse(t, 2 * this.this$0.rows, scale);
                                    this.this$0.dhtRows.inverse(t, 3 * this.this$0.rows, scale);
                                    for (r3 = 0; r3 < this.this$0.rows; ++r3) {
                                        idx2 = this.this$0.rows + r3;
                                        a[s][r3][c] = t[r3];
                                        a[s][r3][c + 1] = t[idx2];
                                        a[s][r3][c + 2] = t[idx2 + this.this$0.rows];
                                        a[s][r3][c + 3] = t[idx2 + 2 * this.this$0.rows];
                                    }
                                }
                                continue;
                            }
                            if (this.this$0.columns != 2) continue;
                            for (r = 0; r < this.this$0.rows; ++r) {
                                t[r] = a[s][r][0];
                                t[this.this$0.rows + r] = a[s][r][1];
                            }
                            this.this$0.dhtRows.inverse(t, 0, scale);
                            this.this$0.dhtRows.inverse(t, this.this$0.rows, scale);
                            for (r = 0; r < this.this$0.rows; ++r) {
                                a[s][r][0] = t[r];
                                a[s][r][1] = t[this.this$0.rows + r];
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3db_subth(final int isgn, final float[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                final /* synthetic */ FloatDHT_3D this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    block19: {
                        float[] t;
                        block17: {
                            block18: {
                                t = new float[ntf];
                                if (isgn != -1) break block17;
                                if (this.this$0.columns <= 2) break block18;
                                for (int r = n0; r < this.this$0.rows; r += nthreads) {
                                    int idx0 = r * this.this$0.rowStride;
                                    for (int c = 0; c < this.this$0.columns; c += 4) {
                                        int idx2;
                                        int idx1;
                                        int s;
                                        for (s = 0; s < this.this$0.slices; ++s) {
                                            idx1 = s * this.this$0.sliceStride + idx0 + c;
                                            idx2 = this.this$0.slices + s;
                                            t[s] = a[idx1];
                                            t[idx2] = a[idx1 + 1];
                                            t[idx2 + this.this$0.slices] = a[idx1 + 2];
                                            t[idx2 + 2 * this.this$0.slices] = a[idx1 + 3];
                                        }
                                        this.this$0.dhtSlices.forward(t, 0);
                                        this.this$0.dhtSlices.forward(t, this.this$0.slices);
                                        this.this$0.dhtSlices.forward(t, 2 * this.this$0.slices);
                                        this.this$0.dhtSlices.forward(t, 3 * this.this$0.slices);
                                        for (s = 0; s < this.this$0.slices; ++s) {
                                            idx1 = s * this.this$0.sliceStride + idx0 + c;
                                            idx2 = this.this$0.slices + s;
                                            a[idx1] = t[s];
                                            a[idx1 + 1] = t[idx2];
                                            a[idx1 + 2] = t[idx2 + this.this$0.slices];
                                            a[idx1 + 3] = t[idx2 + 2 * this.this$0.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (this.this$0.columns != 2) break block19;
                            for (int r = n0; r < this.this$0.rows; r += nthreads) {
                                int idx1;
                                int s;
                                int idx0 = r * this.this$0.rowStride;
                                for (s = 0; s < this.this$0.slices; ++s) {
                                    idx1 = s * this.this$0.sliceStride + idx0;
                                    t[s] = a[idx1];
                                    t[this.this$0.slices + s] = a[idx1 + 1];
                                }
                                this.this$0.dhtSlices.forward(t, 0);
                                this.this$0.dhtSlices.forward(t, this.this$0.slices);
                                for (s = 0; s < this.this$0.slices; ++s) {
                                    idx1 = s * this.this$0.sliceStride + idx0;
                                    a[idx1] = t[s];
                                    a[idx1 + 1] = t[this.this$0.slices + s];
                                }
                            }
                            break block19;
                        }
                        if (this.this$0.columns > 2) {
                            for (int r = n0; r < this.this$0.rows; r += nthreads) {
                                int idx0 = r * this.this$0.rowStride;
                                for (int c = 0; c < this.this$0.columns; c += 4) {
                                    int idx2;
                                    int idx1;
                                    int s;
                                    for (s = 0; s < this.this$0.slices; ++s) {
                                        idx1 = s * this.this$0.sliceStride + idx0 + c;
                                        idx2 = this.this$0.slices + s;
                                        t[s] = a[idx1];
                                        t[idx2] = a[idx1 + 1];
                                        t[idx2 + this.this$0.slices] = a[idx1 + 2];
                                        t[idx2 + 2 * this.this$0.slices] = a[idx1 + 3];
                                    }
                                    this.this$0.dhtSlices.inverse(t, 0, scale);
                                    this.this$0.dhtSlices.inverse(t, this.this$0.slices, scale);
                                    this.this$0.dhtSlices.inverse(t, 2 * this.this$0.slices, scale);
                                    this.this$0.dhtSlices.inverse(t, 3 * this.this$0.slices, scale);
                                    for (s = 0; s < this.this$0.slices; ++s) {
                                        idx1 = s * this.this$0.sliceStride + idx0 + c;
                                        idx2 = this.this$0.slices + s;
                                        a[idx1] = t[s];
                                        a[idx1 + 1] = t[idx2];
                                        a[idx1 + 2] = t[idx2 + this.this$0.slices];
                                        a[idx1 + 3] = t[idx2 + 2 * this.this$0.slices];
                                    }
                                }
                            }
                        } else if (this.this$0.columns == 2) {
                            for (int r = n0; r < this.this$0.rows; r += nthreads) {
                                int idx1;
                                int s;
                                int idx0 = r * this.this$0.rowStride;
                                for (s = 0; s < this.this$0.slices; ++s) {
                                    idx1 = s * this.this$0.sliceStride + idx0;
                                    t[s] = a[idx1];
                                    t[this.this$0.slices + s] = a[idx1 + 1];
                                }
                                this.this$0.dhtSlices.inverse(t, 0, scale);
                                this.this$0.dhtSlices.inverse(t, this.this$0.slices, scale);
                                for (s = 0; s < this.this$0.slices; ++s) {
                                    idx1 = s * this.this$0.sliceStride + idx0;
                                    a[idx1] = t[s];
                                    a[idx1 + 1] = t[this.this$0.slices + s];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3db_subth(final int isgn, final FloatLargeArray a, final boolean scale) {
        final int nthreads = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.rowsl ? this.rowsl : (long)ConcurrencyUtils.getNumberOfThreads());
        long nt = 4L * this.slicesl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        final long ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final long n0 = i;
            futures[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                final /* synthetic */ FloatDHT_3D this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    block19: {
                        FloatLargeArray t;
                        block17: {
                            block18: {
                                t = new FloatLargeArray(ntf);
                                if (isgn != -1) break block17;
                                if (this.this$0.columnsl <= 2L) break block18;
                                for (long r = n0; r < this.this$0.rowsl; r += (long)nthreads) {
                                    long idx0 = r * this.this$0.rowStridel;
                                    for (long c = 0L; c < this.this$0.columnsl; c += 4L) {
                                        long idx2;
                                        long idx1;
                                        long s;
                                        for (s = 0L; s < this.this$0.slicesl; ++s) {
                                            idx1 = s * this.this$0.sliceStridel + idx0 + c;
                                            idx2 = this.this$0.slicesl + s;
                                            t.setFloat(s, a.getFloat(idx1));
                                            t.setFloat(idx2, a.getFloat(idx1 + 1L));
                                            t.setFloat(idx2 + this.this$0.slicesl, a.getFloat(idx1 + 2L));
                                            t.setFloat(idx2 + 2L * this.this$0.slicesl, a.getFloat(idx1 + 3L));
                                        }
                                        this.this$0.dhtSlices.forward(t, 0L);
                                        this.this$0.dhtSlices.forward(t, this.this$0.slicesl);
                                        this.this$0.dhtSlices.forward(t, 2L * this.this$0.slicesl);
                                        this.this$0.dhtSlices.forward(t, 3L * this.this$0.slicesl);
                                        for (s = 0L; s < this.this$0.slicesl; ++s) {
                                            idx1 = s * this.this$0.sliceStridel + idx0 + c;
                                            idx2 = this.this$0.slicesl + s;
                                            a.setFloat(idx1, t.getFloat(s));
                                            a.setFloat(idx1 + 1L, t.getFloat(idx2));
                                            a.setFloat(idx1 + 2L, t.getFloat(idx2 + this.this$0.slicesl));
                                            a.setFloat(idx1 + 3L, t.getFloat(idx2 + 2L * this.this$0.slicesl));
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (this.this$0.columnsl != 2L) break block19;
                            for (long r = n0; r < this.this$0.rowsl; r += (long)nthreads) {
                                long idx1;
                                long s;
                                long idx0 = r * this.this$0.rowStridel;
                                for (s = 0L; s < this.this$0.slicesl; ++s) {
                                    idx1 = s * this.this$0.sliceStridel + idx0;
                                    t.setFloat(s, a.getFloat(idx1));
                                    t.setFloat(this.this$0.slicesl + s, a.getFloat(idx1 + 1L));
                                }
                                this.this$0.dhtSlices.forward(t, 0L);
                                this.this$0.dhtSlices.forward(t, this.this$0.slicesl);
                                for (s = 0L; s < this.this$0.slicesl; ++s) {
                                    idx1 = s * this.this$0.sliceStridel + idx0;
                                    a.setFloat(idx1, t.getFloat(s));
                                    a.setFloat(idx1 + 1L, t.getFloat(this.this$0.slicesl + s));
                                }
                            }
                            break block19;
                        }
                        if (this.this$0.columnsl > 2L) {
                            for (long r = n0; r < this.this$0.rowsl; r += (long)nthreads) {
                                long idx0 = r * this.this$0.rowStridel;
                                for (long c = 0L; c < this.this$0.columnsl; c += 4L) {
                                    long idx2;
                                    long idx1;
                                    long s;
                                    for (s = 0L; s < this.this$0.slicesl; ++s) {
                                        idx1 = s * this.this$0.sliceStridel + idx0 + c;
                                        idx2 = this.this$0.slicesl + s;
                                        t.setFloat(s, a.getFloat(idx1));
                                        t.setFloat(idx2, a.getFloat(idx1 + 1L));
                                        t.setFloat(idx2 + this.this$0.slicesl, a.getFloat(idx1 + 2L));
                                        t.setFloat(idx2 + 2L * this.this$0.slicesl, a.getFloat(idx1 + 3L));
                                    }
                                    this.this$0.dhtSlices.inverse(t, 0L, scale);
                                    this.this$0.dhtSlices.inverse(t, this.this$0.slicesl, scale);
                                    this.this$0.dhtSlices.inverse(t, 2L * this.this$0.slicesl, scale);
                                    this.this$0.dhtSlices.inverse(t, 3L * this.this$0.slicesl, scale);
                                    for (s = 0L; s < this.this$0.slicesl; ++s) {
                                        idx1 = s * this.this$0.sliceStridel + idx0 + c;
                                        idx2 = this.this$0.slicesl + s;
                                        a.setFloat(idx1, t.getFloat(s));
                                        a.setFloat(idx1 + 1L, t.getFloat(idx2));
                                        a.setFloat(idx1 + 2L, t.getFloat(idx2 + this.this$0.slicesl));
                                        a.setFloat(idx1 + 3L, t.getFloat(idx2 + 2L * this.this$0.slicesl));
                                    }
                                }
                            }
                        } else if (this.this$0.columnsl == 2L) {
                            for (long r = n0; r < this.this$0.rowsl; r += (long)nthreads) {
                                long idx1;
                                long s;
                                long idx0 = r * this.this$0.rowStridel;
                                for (s = 0L; s < this.this$0.slicesl; ++s) {
                                    idx1 = s * this.this$0.sliceStridel + idx0;
                                    t.setFloat(s, a.getFloat(idx1));
                                    t.setFloat(this.this$0.slicesl + s, a.getFloat(idx1 + 1L));
                                }
                                this.this$0.dhtSlices.inverse(t, 0L, scale);
                                this.this$0.dhtSlices.inverse(t, this.this$0.slicesl, scale);
                                for (s = 0L; s < this.this$0.slicesl; ++s) {
                                    idx1 = s * this.this$0.sliceStridel + idx0;
                                    a.setFloat(idx1, t.getFloat(s));
                                    a.setFloat(idx1 + 1L, t.getFloat(this.this$0.slicesl + s));
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3db_subth(final int isgn, final float[][][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                final /* synthetic */ FloatDHT_3D this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    block19: {
                        float[] t;
                        block17: {
                            block18: {
                                t = new float[ntf];
                                if (isgn != -1) break block17;
                                if (this.this$0.columns <= 2) break block18;
                                for (int r = n0; r < this.this$0.rows; r += nthreads) {
                                    for (int c = 0; c < this.this$0.columns; c += 4) {
                                        int idx2;
                                        int s;
                                        for (s = 0; s < this.this$0.slices; ++s) {
                                            idx2 = this.this$0.slices + s;
                                            t[s] = a[s][r][c];
                                            t[idx2] = a[s][r][c + 1];
                                            t[idx2 + this.this$0.slices] = a[s][r][c + 2];
                                            t[idx2 + 2 * this.this$0.slices] = a[s][r][c + 3];
                                        }
                                        this.this$0.dhtSlices.forward(t, 0);
                                        this.this$0.dhtSlices.forward(t, this.this$0.slices);
                                        this.this$0.dhtSlices.forward(t, 2 * this.this$0.slices);
                                        this.this$0.dhtSlices.forward(t, 3 * this.this$0.slices);
                                        for (s = 0; s < this.this$0.slices; ++s) {
                                            idx2 = this.this$0.slices + s;
                                            a[s][r][c] = t[s];
                                            a[s][r][c + 1] = t[idx2];
                                            a[s][r][c + 2] = t[idx2 + this.this$0.slices];
                                            a[s][r][c + 3] = t[idx2 + 2 * this.this$0.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (this.this$0.columns != 2) break block19;
                            for (int r = n0; r < this.this$0.rows; r += nthreads) {
                                int s;
                                for (s = 0; s < this.this$0.slices; ++s) {
                                    t[s] = a[s][r][0];
                                    t[this.this$0.slices + s] = a[s][r][1];
                                }
                                this.this$0.dhtSlices.forward(t, 0);
                                this.this$0.dhtSlices.forward(t, this.this$0.slices);
                                for (s = 0; s < this.this$0.slices; ++s) {
                                    a[s][r][0] = t[s];
                                    a[s][r][1] = t[this.this$0.slices + s];
                                }
                            }
                            break block19;
                        }
                        if (this.this$0.columns > 2) {
                            for (int r = n0; r < this.this$0.rows; r += nthreads) {
                                for (int c = 0; c < this.this$0.columns; c += 4) {
                                    int idx2;
                                    int s;
                                    for (s = 0; s < this.this$0.slices; ++s) {
                                        idx2 = this.this$0.slices + s;
                                        t[s] = a[s][r][c];
                                        t[idx2] = a[s][r][c + 1];
                                        t[idx2 + this.this$0.slices] = a[s][r][c + 2];
                                        t[idx2 + 2 * this.this$0.slices] = a[s][r][c + 3];
                                    }
                                    this.this$0.dhtSlices.inverse(t, 0, scale);
                                    this.this$0.dhtSlices.inverse(t, this.this$0.slices, scale);
                                    this.this$0.dhtSlices.inverse(t, 2 * this.this$0.slices, scale);
                                    this.this$0.dhtSlices.inverse(t, 3 * this.this$0.slices, scale);
                                    for (s = 0; s < this.this$0.slices; ++s) {
                                        idx2 = this.this$0.slices + s;
                                        a[s][r][c] = t[s];
                                        a[s][r][c + 1] = t[idx2];
                                        a[s][r][c + 2] = t[idx2 + this.this$0.slices];
                                        a[s][r][c + 3] = t[idx2 + 2 * this.this$0.slices];
                                    }
                                }
                            }
                        } else if (this.this$0.columns == 2) {
                            for (int r = n0; r < this.this$0.rows; r += nthreads) {
                                int s;
                                for (s = 0; s < this.this$0.slices; ++s) {
                                    t[s] = a[s][r][0];
                                    t[this.this$0.slices + s] = a[s][r][1];
                                }
                                this.this$0.dhtSlices.inverse(t, 0, scale);
                                this.this$0.dhtSlices.inverse(t, this.this$0.slices, scale);
                                for (s = 0; s < this.this$0.slices; ++s) {
                                    a[s][r][0] = t[s];
                                    a[s][r][1] = t[this.this$0.slices + s];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void yTransform(float[] a) {
        for (int s = 0; s <= this.slices / 2; ++s) {
            int sC = (this.slices - s) % this.slices;
            int idx9 = s * this.sliceStride;
            int idx10 = sC * this.sliceStride;
            for (int r = 0; r <= this.rows / 2; ++r) {
                int rC = (this.rows - r) % this.rows;
                int idx11 = r * this.rowStride;
                int idx12 = rC * this.rowStride;
                for (int c = 0; c <= this.columns / 2; ++c) {
                    int cC = (this.columns - c) % this.columns;
                    int idx1 = idx9 + idx12 + c;
                    int idx2 = idx9 + idx11 + cC;
                    int idx3 = idx10 + idx11 + c;
                    int idx4 = idx10 + idx12 + cC;
                    int idx5 = idx10 + idx12 + c;
                    int idx6 = idx10 + idx11 + cC;
                    int idx7 = idx9 + idx11 + c;
                    int idx8 = idx9 + idx12 + cC;
                    float A = a[idx1];
                    float B = a[idx2];
                    float C = a[idx3];
                    float D = a[idx4];
                    float E = a[idx5];
                    float F = a[idx6];
                    float G = a[idx7];
                    float H = a[idx8];
                    a[idx7] = (A + B + C - D) / 2.0f;
                    a[idx3] = (E + F + G - H) / 2.0f;
                    a[idx1] = (G + H + E - F) / 2.0f;
                    a[idx5] = (C + D + A - B) / 2.0f;
                    a[idx2] = (H + G + F - E) / 2.0f;
                    a[idx6] = (D + C + B - A) / 2.0f;
                    a[idx8] = (B + A + D - C) / 2.0f;
                    a[idx4] = (F + E + H - G) / 2.0f;
                }
            }
        }
    }

    private void yTransform(FloatLargeArray a) {
        for (long s = 0L; s <= this.slicesl / 2L; ++s) {
            long sC = (this.slicesl - s) % this.slicesl;
            long idx9 = s * this.sliceStridel;
            long idx10 = sC * this.sliceStridel;
            for (long r = 0L; r <= this.rowsl / 2L; ++r) {
                long rC = (this.rowsl - r) % this.rowsl;
                long idx11 = r * this.rowStridel;
                long idx12 = rC * this.rowStridel;
                for (long c = 0L; c <= this.columnsl / 2L; ++c) {
                    long cC = (this.columnsl - c) % this.columnsl;
                    long idx1 = idx9 + idx12 + c;
                    long idx2 = idx9 + idx11 + cC;
                    long idx3 = idx10 + idx11 + c;
                    long idx4 = idx10 + idx12 + cC;
                    long idx5 = idx10 + idx12 + c;
                    long idx6 = idx10 + idx11 + cC;
                    long idx7 = idx9 + idx11 + c;
                    long idx8 = idx9 + idx12 + cC;
                    float A = a.getFloat(idx1);
                    float B = a.getFloat(idx2);
                    float C = a.getFloat(idx3);
                    float D = a.getFloat(idx4);
                    float E = a.getFloat(idx5);
                    float F = a.getFloat(idx6);
                    float G = a.getFloat(idx7);
                    float H = a.getFloat(idx8);
                    a.setFloat(idx7, (A + B + C - D) / 2.0f);
                    a.setFloat(idx3, (E + F + G - H) / 2.0f);
                    a.setFloat(idx1, (G + H + E - F) / 2.0f);
                    a.setFloat(idx5, (C + D + A - B) / 2.0f);
                    a.setFloat(idx2, (H + G + F - E) / 2.0f);
                    a.setFloat(idx6, (D + C + B - A) / 2.0f);
                    a.setFloat(idx8, (B + A + D - C) / 2.0f);
                    a.setFloat(idx4, (F + E + H - G) / 2.0f);
                }
            }
        }
    }

    private void yTransform(float[][][] a) {
        for (int s = 0; s <= this.slices / 2; ++s) {
            int sC = (this.slices - s) % this.slices;
            for (int r = 0; r <= this.rows / 2; ++r) {
                int rC = (this.rows - r) % this.rows;
                for (int c = 0; c <= this.columns / 2; ++c) {
                    int cC = (this.columns - c) % this.columns;
                    float A = a[s][rC][c];
                    float B = a[s][r][cC];
                    float C = a[sC][r][c];
                    float D = a[sC][rC][cC];
                    float E = a[sC][rC][c];
                    float F = a[sC][r][cC];
                    float G = a[s][r][c];
                    float H = a[s][rC][cC];
                    a[s][r][c] = (A + B + C - D) / 2.0f;
                    a[sC][r][c] = (E + F + G - H) / 2.0f;
                    a[s][rC][c] = (G + H + E - F) / 2.0f;
                    a[sC][rC][c] = (C + D + A - B) / 2.0f;
                    a[s][r][cC] = (H + G + F - E) / 2.0f;
                    a[sC][r][cC] = (D + C + B - A) / 2.0f;
                    a[s][rC][cC] = (B + A + D - C) / 2.0f;
                    a[sC][rC][cC] = (F + E + H - G) / 2.0f;
                }
            }
        }
    }
}

