/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dht;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jtransforms.dht.FloatDHT_1D;
import org.jtransforms.utils.CommonUtils;
import org.visnow.jlargearrays.ConcurrencyUtils;
import org.visnow.jlargearrays.FloatLargeArray;
import org.visnow.jlargearrays.LargeArray;

public class FloatDHT_2D {
    private int rows;
    private int columns;
    private long rowsl;
    private long columnsl;
    private FloatDHT_1D dhtColumns;
    private FloatDHT_1D dhtRows;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public FloatDHT_2D(long rows, long columns) {
        if (rows <= 1L || columns <= 1L) {
            throw new IllegalArgumentException("rows and columns must be greater than 1");
        }
        this.rows = (int)rows;
        this.columns = (int)columns;
        this.rowsl = rows;
        this.columnsl = columns;
        if (rows * columns >= CommonUtils.getThreadsBeginN_2D()) {
            this.useThreads = true;
        }
        if (CommonUtils.isPowerOf2(rows) && CommonUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
        }
        CommonUtils.setUseLargeArrays(rows * columns > (long)LargeArray.getMaxSizeOf32bitArray());
        this.dhtRows = new FloatDHT_1D(rows);
        this.dhtColumns = rows == columns ? this.dhtRows : new FloatDHT_1D(columns);
    }

    public void forward(final float[] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a, true);
                this.ddxt2d0_subth(-1, a, true);
            } else {
                this.ddxt2d_sub(-1, a, true);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(a, i * this.columns);
                }
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_2D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            for (int i = firstRow; i < lastRow; ++i) {
                                this.this$0.dhtColumns.forward(a, i * this.this$0.columns);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.columns / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstColumn = l * p;
                    final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_2D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            float[] temp = new float[this.this$0.rows];
                            for (int c = firstColumn; c < lastColumn; ++c) {
                                int r;
                                for (r = 0; r < this.this$0.rows; ++r) {
                                    temp[r] = a[r * this.this$0.columns + c];
                                }
                                this.this$0.dhtRows.forward(temp);
                                for (r = 0; r < this.this$0.rows; ++r) {
                                    a[r * this.this$0.columns + c] = temp[r];
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(a, i * this.columns);
                }
                float[] temp = new float[this.rows];
                for (int c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        temp[r] = a[r * this.columns + c];
                    }
                    this.dhtRows.forward(temp);
                    for (r = 0; r < this.rows; ++r) {
                        a[r * this.columns + c] = temp[r];
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void forward(final FloatLargeArray a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a, true);
                this.ddxt2d0_subth(-1, a, true);
            } else {
                this.ddxt2d_sub(-1, a, true);
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.dhtColumns.forward(a, i * this.columnsl);
                }
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
                Future[] futures = new Future[nthreads];
                long p = this.rowsl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final long firstRow = (long)l * p;
                    final long lastRow = l == nthreads - 1 ? this.rowsl : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_2D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            for (long i = firstRow; i < lastRow; ++i) {
                                this.this$0.dhtColumns.forward(a, i * this.this$0.columnsl);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.columnsl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final long firstColumn = (long)l * p;
                    final long lastColumn = l == nthreads - 1 ? this.columnsl : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_2D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            FloatLargeArray temp = new FloatLargeArray(this.this$0.rowsl, false);
                            for (long c = firstColumn; c < lastColumn; ++c) {
                                long r;
                                for (r = 0L; r < this.this$0.rowsl; ++r) {
                                    temp.setFloat(r, a.getFloat(r * this.this$0.columnsl + c));
                                }
                                this.this$0.dhtRows.forward(temp);
                                for (r = 0L; r < this.this$0.rowsl; ++r) {
                                    a.setFloat(r * this.this$0.columnsl + c, temp.getFloat(r));
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.dhtColumns.forward(a, i * this.columnsl);
                }
                FloatLargeArray temp = new FloatLargeArray(this.rowsl, false);
                for (long c = 0L; c < this.columnsl; ++c) {
                    long r;
                    for (r = 0L; r < this.rowsl; ++r) {
                        temp.setFloat(r, a.getFloat(r * this.columnsl + c));
                    }
                    this.dhtRows.forward(temp);
                    for (r = 0L; r < this.rowsl; ++r) {
                        a.setFloat(r * this.columnsl + c, temp.getFloat(r));
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void forward(final float[][] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a, true);
                this.ddxt2d0_subth(-1, a, true);
            } else {
                this.ddxt2d_sub(-1, a, true);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(a[i]);
                }
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_2D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            for (int i = firstRow; i < lastRow; ++i) {
                                this.this$0.dhtColumns.forward(a[i]);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.columns / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstColumn = l * p;
                    final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_2D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            float[] temp = new float[this.this$0.rows];
                            for (int c = firstColumn; c < lastColumn; ++c) {
                                int r;
                                for (r = 0; r < this.this$0.rows; ++r) {
                                    temp[r] = a[r][c];
                                }
                                this.this$0.dhtRows.forward(temp);
                                for (r = 0; r < this.this$0.rows; ++r) {
                                    a[r][c] = temp[r];
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(a[i]);
                }
                float[] temp = new float[this.rows];
                for (int c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        temp[r] = a[r][c];
                    }
                    this.dhtRows.forward(temp);
                    for (r = 0; r < this.rows; ++r) {
                        a[r][c] = temp[r];
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void inverse(final float[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a, scale);
                this.ddxt2d0_subth(1, a, scale);
            } else {
                this.ddxt2d_sub(1, a, scale);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(a, i * this.columns, scale);
                }
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_2D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            for (int i = firstRow; i < lastRow; ++i) {
                                this.this$0.dhtColumns.inverse(a, i * this.this$0.columns, scale);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.columns / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstColumn = l * p;
                    final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_2D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            float[] temp = new float[this.this$0.rows];
                            for (int c = firstColumn; c < lastColumn; ++c) {
                                int r;
                                for (r = 0; r < this.this$0.rows; ++r) {
                                    temp[r] = a[r * this.this$0.columns + c];
                                }
                                this.this$0.dhtRows.inverse(temp, scale);
                                for (r = 0; r < this.this$0.rows; ++r) {
                                    a[r * this.this$0.columns + c] = temp[r];
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(a, i * this.columns, scale);
                }
                float[] temp = new float[this.rows];
                for (int c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        temp[r] = a[r * this.columns + c];
                    }
                    this.dhtRows.inverse(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        a[r * this.columns + c] = temp[r];
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void inverse(final FloatLargeArray a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a, scale);
                this.ddxt2d0_subth(1, a, scale);
            } else {
                this.ddxt2d_sub(1, a, scale);
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.dhtColumns.inverse(a, i * this.columnsl, scale);
                }
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
                Future[] futures = new Future[nthreads];
                long p = this.rowsl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final long firstRow = (long)l * p;
                    final long lastRow = l == nthreads - 1 ? this.rowsl : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_2D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            for (long i = firstRow; i < lastRow; ++i) {
                                this.this$0.dhtColumns.inverse(a, i * this.this$0.columnsl, scale);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.columnsl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final long firstColumn = (long)l * p;
                    final long lastColumn = l == nthreads - 1 ? this.columnsl : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_2D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            FloatLargeArray temp = new FloatLargeArray(this.this$0.rowsl, false);
                            for (long c = firstColumn; c < lastColumn; ++c) {
                                long r;
                                for (r = 0L; r < this.this$0.rowsl; ++r) {
                                    temp.setFloat(r, a.getFloat(r * this.this$0.columnsl + c));
                                }
                                this.this$0.dhtRows.inverse(temp, scale);
                                for (r = 0L; r < this.this$0.rowsl; ++r) {
                                    a.setFloat(r * this.this$0.columnsl + c, temp.getFloat(r));
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (long i = 0L; i < this.rowsl; ++i) {
                    this.dhtColumns.inverse(a, i * this.columnsl, scale);
                }
                FloatLargeArray temp = new FloatLargeArray(this.rowsl, false);
                for (long c = 0L; c < this.columnsl; ++c) {
                    long r;
                    for (r = 0L; r < this.rowsl; ++r) {
                        temp.setFloat(r, a.getFloat(r * this.columnsl + c));
                    }
                    this.dhtRows.inverse(temp, scale);
                    for (r = 0L; r < this.rowsl; ++r) {
                        a.setFloat(r * this.columnsl + c, temp.getFloat(r));
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void inverse(final float[][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a, scale);
                this.ddxt2d0_subth(1, a, scale);
            } else {
                this.ddxt2d_sub(1, a, scale);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(a[i], scale);
                }
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_2D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            for (int i = firstRow; i < lastRow; ++i) {
                                this.this$0.dhtColumns.inverse(a[i], scale);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.columns / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstColumn = l * p;
                    final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                        final /* synthetic */ FloatDHT_2D this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            float[] temp = new float[this.this$0.rows];
                            for (int c = firstColumn; c < lastColumn; ++c) {
                                int r;
                                for (r = 0; r < this.this$0.rows; ++r) {
                                    temp[r] = a[r][c];
                                }
                                this.this$0.dhtRows.inverse(temp, scale);
                                for (r = 0; r < this.this$0.rows; ++r) {
                                    a[r][c] = temp[r];
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion((Future[])futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(a[i], scale);
                }
                float[] temp = new float[this.rows];
                for (int c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        temp[r] = a[r][c];
                    }
                    this.dhtRows.inverse(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        a[r][c] = temp[r];
                    }
                }
            }
            this.yTransform(a);
        }
    }

    private void ddxt2d_subth(final int isgn, final float[] a, final boolean scale) {
        int nthread = Math.min(this.columns, ConcurrencyUtils.getNumberOfThreads());
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        } else if (this.columns < 2) {
            nt >>= 2;
        }
        final int ntf = nt;
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                final /* synthetic */ FloatDHT_2D this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    block13: {
                        int idx2;
                        int idx1;
                        float[] t;
                        block12: {
                            t = new float[ntf];
                            if (this.this$0.columns <= 2) break block12;
                            if (isgn == -1) {
                                for (int c = 4 * n0; c < this.this$0.columns; c += 4 * nthreads) {
                                    int idx22;
                                    int idx12;
                                    int r;
                                    for (r = 0; r < this.this$0.rows; ++r) {
                                        idx12 = r * this.this$0.columns + c;
                                        idx22 = this.this$0.rows + r;
                                        t[r] = a[idx12];
                                        t[idx22] = a[idx12 + 1];
                                        t[idx22 + this.this$0.rows] = a[idx12 + 2];
                                        t[idx22 + 2 * this.this$0.rows] = a[idx12 + 3];
                                    }
                                    this.this$0.dhtRows.forward(t, 0);
                                    this.this$0.dhtRows.forward(t, this.this$0.rows);
                                    this.this$0.dhtRows.forward(t, 2 * this.this$0.rows);
                                    this.this$0.dhtRows.forward(t, 3 * this.this$0.rows);
                                    for (r = 0; r < this.this$0.rows; ++r) {
                                        idx12 = r * this.this$0.columns + c;
                                        idx22 = this.this$0.rows + r;
                                        a[idx12] = t[r];
                                        a[idx12 + 1] = t[idx22];
                                        a[idx12 + 2] = t[idx22 + this.this$0.rows];
                                        a[idx12 + 3] = t[idx22 + 2 * this.this$0.rows];
                                    }
                                }
                            } else {
                                for (int c = 4 * n0; c < this.this$0.columns; c += 4 * nthreads) {
                                    int idx23;
                                    int idx13;
                                    int r;
                                    for (r = 0; r < this.this$0.rows; ++r) {
                                        idx13 = r * this.this$0.columns + c;
                                        idx23 = this.this$0.rows + r;
                                        t[r] = a[idx13];
                                        t[idx23] = a[idx13 + 1];
                                        t[idx23 + this.this$0.rows] = a[idx13 + 2];
                                        t[idx23 + 2 * this.this$0.rows] = a[idx13 + 3];
                                    }
                                    this.this$0.dhtRows.inverse(t, 0, scale);
                                    this.this$0.dhtRows.inverse(t, this.this$0.rows, scale);
                                    this.this$0.dhtRows.inverse(t, 2 * this.this$0.rows, scale);
                                    this.this$0.dhtRows.inverse(t, 3 * this.this$0.rows, scale);
                                    for (r = 0; r < this.this$0.rows; ++r) {
                                        idx13 = r * this.this$0.columns + c;
                                        idx23 = this.this$0.rows + r;
                                        a[idx13] = t[r];
                                        a[idx13 + 1] = t[idx23];
                                        a[idx13 + 2] = t[idx23 + this.this$0.rows];
                                        a[idx13 + 3] = t[idx23 + 2 * this.this$0.rows];
                                    }
                                }
                            }
                            break block13;
                        }
                        if (this.this$0.columns != 2) break block13;
                        int r = 0;
                        while (r < this.this$0.rows) {
                            idx1 = r * this.this$0.columns + 2 * n0;
                            idx2 = r++;
                            t[idx2] = a[idx1];
                            t[idx2 + this.this$0.rows] = a[idx1 + 1];
                        }
                        if (isgn == -1) {
                            this.this$0.dhtRows.forward(t, 0);
                            this.this$0.dhtRows.forward(t, this.this$0.rows);
                        } else {
                            this.this$0.dhtRows.inverse(t, 0, scale);
                            this.this$0.dhtRows.inverse(t, this.this$0.rows, scale);
                        }
                        r = 0;
                        while (r < this.this$0.rows) {
                            idx1 = r * this.this$0.columns + 2 * n0;
                            idx2 = r++;
                            a[idx1] = t[idx2];
                            a[idx1 + 1] = t[idx2 + this.this$0.rows];
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d_subth(final int isgn, final FloatLargeArray a, final boolean scale) {
        int nthread = (int)Math.min(this.columnsl, (long)ConcurrencyUtils.getNumberOfThreads());
        long nt = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        } else if (this.columnsl < 2L) {
            nt >>= 2;
        }
        final long ntf = nt;
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final long n0 = i;
            futures[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                final /* synthetic */ FloatDHT_2D this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    block13: {
                        long idx2;
                        long idx1;
                        FloatLargeArray t;
                        block12: {
                            t = new FloatLargeArray(ntf);
                            if (this.this$0.columnsl <= 2L) break block12;
                            if (isgn == -1) {
                                for (long c = 4L * n0; c < this.this$0.columnsl; c += (long)(4 * nthreads)) {
                                    long idx22;
                                    long idx12;
                                    long r;
                                    for (r = 0L; r < this.this$0.rowsl; ++r) {
                                        idx12 = r * this.this$0.columnsl + c;
                                        idx22 = this.this$0.rowsl + r;
                                        t.setFloat(r, a.getFloat(idx12));
                                        t.setFloat(idx22, a.getFloat(idx12 + 1L));
                                        t.setFloat(idx22 + this.this$0.rowsl, a.getFloat(idx12 + 2L));
                                        t.setFloat(idx22 + 2L * this.this$0.rowsl, a.getFloat(idx12 + 3L));
                                    }
                                    this.this$0.dhtRows.forward(t, 0L);
                                    this.this$0.dhtRows.forward(t, this.this$0.rowsl);
                                    this.this$0.dhtRows.forward(t, 2L * this.this$0.rowsl);
                                    this.this$0.dhtRows.forward(t, 3L * this.this$0.rowsl);
                                    for (r = 0L; r < this.this$0.rowsl; ++r) {
                                        idx12 = r * this.this$0.columnsl + c;
                                        idx22 = this.this$0.rowsl + r;
                                        a.setFloat(idx12, t.getFloat(r));
                                        a.setFloat(idx12 + 1L, t.getFloat(idx22));
                                        a.setFloat(idx12 + 2L, t.getFloat(idx22 + this.this$0.rowsl));
                                        a.setFloat(idx12 + 3L, t.getFloat(idx22 + 2L * this.this$0.rowsl));
                                    }
                                }
                            } else {
                                for (long c = 4L * n0; c < this.this$0.columnsl; c += (long)(4 * nthreads)) {
                                    long idx23;
                                    long idx13;
                                    long r;
                                    for (r = 0L; r < this.this$0.rowsl; ++r) {
                                        idx13 = r * this.this$0.columnsl + c;
                                        idx23 = this.this$0.rowsl + r;
                                        t.setFloat(r, a.getFloat(idx13));
                                        t.setFloat(idx23, a.getFloat(idx13 + 1L));
                                        t.setFloat(idx23 + this.this$0.rowsl, a.getFloat(idx13 + 2L));
                                        t.setFloat(idx23 + 2L * this.this$0.rowsl, a.getFloat(idx13 + 3L));
                                    }
                                    this.this$0.dhtRows.inverse(t, 0L, scale);
                                    this.this$0.dhtRows.inverse(t, this.this$0.rowsl, scale);
                                    this.this$0.dhtRows.inverse(t, 2L * this.this$0.rowsl, scale);
                                    this.this$0.dhtRows.inverse(t, 3L * this.this$0.rowsl, scale);
                                    for (r = 0L; r < this.this$0.rowsl; ++r) {
                                        idx13 = r * this.this$0.columnsl + c;
                                        idx23 = this.this$0.rowsl + r;
                                        a.setFloat(idx13, t.getFloat(r));
                                        a.setFloat(idx13 + 1L, t.getFloat(idx23));
                                        a.setFloat(idx13 + 2L, t.getFloat(idx23 + this.this$0.rowsl));
                                        a.setFloat(idx13 + 3L, t.getFloat(idx23 + 2L * this.this$0.rowsl));
                                    }
                                }
                            }
                            break block13;
                        }
                        if (this.this$0.columnsl != 2L) break block13;
                        long r = 0L;
                        while (r < this.this$0.rowsl) {
                            idx1 = r * this.this$0.columnsl + 2L * n0;
                            idx2 = r++;
                            t.setFloat(idx2, a.getFloat(idx1));
                            t.setFloat(idx2 + this.this$0.rowsl, a.getFloat(idx1 + 1L));
                        }
                        if (isgn == -1) {
                            this.this$0.dhtRows.forward(t, 0L);
                            this.this$0.dhtRows.forward(t, this.this$0.rowsl);
                        } else {
                            this.this$0.dhtRows.inverse(t, 0L, scale);
                            this.this$0.dhtRows.inverse(t, this.this$0.rowsl, scale);
                        }
                        r = 0L;
                        while (r < this.this$0.rowsl) {
                            idx1 = r * this.this$0.columnsl + 2L * n0;
                            idx2 = r++;
                            a.setFloat(idx1, t.getFloat(idx2));
                            a.setFloat(idx1 + 1L, t.getFloat(idx2 + this.this$0.rowsl));
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d_subth(final int isgn, final float[][] a, final boolean scale) {
        int nthread = Math.min(this.columns, ConcurrencyUtils.getNumberOfThreads());
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        } else if (this.columns < 2) {
            nt >>= 2;
        }
        final int ntf = nt;
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                final /* synthetic */ FloatDHT_2D this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    block13: {
                        int idx2;
                        int r;
                        float[] t;
                        block12: {
                            t = new float[ntf];
                            if (this.this$0.columns <= 2) break block12;
                            if (isgn == -1) {
                                for (int c = 4 * n0; c < this.this$0.columns; c += 4 * nthreads) {
                                    int idx22;
                                    int r2;
                                    for (r2 = 0; r2 < this.this$0.rows; ++r2) {
                                        idx22 = this.this$0.rows + r2;
                                        t[r2] = a[r2][c];
                                        t[idx22] = a[r2][c + 1];
                                        t[idx22 + this.this$0.rows] = a[r2][c + 2];
                                        t[idx22 + 2 * this.this$0.rows] = a[r2][c + 3];
                                    }
                                    this.this$0.dhtRows.forward(t, 0);
                                    this.this$0.dhtRows.forward(t, this.this$0.rows);
                                    this.this$0.dhtRows.forward(t, 2 * this.this$0.rows);
                                    this.this$0.dhtRows.forward(t, 3 * this.this$0.rows);
                                    for (r2 = 0; r2 < this.this$0.rows; ++r2) {
                                        idx22 = this.this$0.rows + r2;
                                        a[r2][c] = t[r2];
                                        a[r2][c + 1] = t[idx22];
                                        a[r2][c + 2] = t[idx22 + this.this$0.rows];
                                        a[r2][c + 3] = t[idx22 + 2 * this.this$0.rows];
                                    }
                                }
                            } else {
                                for (int c = 4 * n0; c < this.this$0.columns; c += 4 * nthreads) {
                                    int idx23;
                                    int r3;
                                    for (r3 = 0; r3 < this.this$0.rows; ++r3) {
                                        idx23 = this.this$0.rows + r3;
                                        t[r3] = a[r3][c];
                                        t[idx23] = a[r3][c + 1];
                                        t[idx23 + this.this$0.rows] = a[r3][c + 2];
                                        t[idx23 + 2 * this.this$0.rows] = a[r3][c + 3];
                                    }
                                    this.this$0.dhtRows.inverse(t, 0, scale);
                                    this.this$0.dhtRows.inverse(t, this.this$0.rows, scale);
                                    this.this$0.dhtRows.inverse(t, 2 * this.this$0.rows, scale);
                                    this.this$0.dhtRows.inverse(t, 3 * this.this$0.rows, scale);
                                    for (r3 = 0; r3 < this.this$0.rows; ++r3) {
                                        idx23 = this.this$0.rows + r3;
                                        a[r3][c] = t[r3];
                                        a[r3][c + 1] = t[idx23];
                                        a[r3][c + 2] = t[idx23 + this.this$0.rows];
                                        a[r3][c + 3] = t[idx23 + 2 * this.this$0.rows];
                                    }
                                }
                            }
                            break block13;
                        }
                        if (this.this$0.columns != 2) break block13;
                        for (r = 0; r < this.this$0.rows; ++r) {
                            idx2 = r;
                            t[idx2] = a[r][2 * n0];
                            t[idx2 + this.this$0.rows] = a[r][2 * n0 + 1];
                        }
                        if (isgn == -1) {
                            this.this$0.dhtRows.forward(t, 0);
                            this.this$0.dhtRows.forward(t, this.this$0.rows);
                        } else {
                            this.this$0.dhtRows.inverse(t, 0, scale);
                            this.this$0.dhtRows.inverse(t, this.this$0.rows, scale);
                        }
                        for (r = 0; r < this.this$0.rows; ++r) {
                            idx2 = r;
                            a[r][2 * n0] = t[idx2];
                            a[r][2 * n0 + 1] = t[idx2 + this.this$0.rows];
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d0_subth(final int isgn, final float[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                final /* synthetic */ FloatDHT_2D this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int r = n0; r < this.this$0.rows; r += nthreads) {
                            this.this$0.dhtColumns.forward(a, r * this.this$0.columns);
                        }
                    } else {
                        for (int r = n0; r < this.this$0.rows; r += nthreads) {
                            this.this$0.dhtColumns.inverse(a, r * this.this$0.columns, scale);
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d0_subth(final int isgn, final FloatLargeArray a, final boolean scale) {
        final int nthreads = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.rowsl ? this.rowsl : (long)ConcurrencyUtils.getNumberOfThreads());
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final long n0 = i;
            futures[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                final /* synthetic */ FloatDHT_2D this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (long r = n0; r < this.this$0.rowsl; r += (long)nthreads) {
                            this.this$0.dhtColumns.forward(a, r * this.this$0.columnsl);
                        }
                    } else {
                        for (long r = n0; r < this.this$0.rowsl; r += (long)nthreads) {
                            this.this$0.dhtColumns.inverse(a, r * this.this$0.columnsl, scale);
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d0_subth(final int isgn, final float[][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit((Runnable)new Runnable(){
                final /* synthetic */ FloatDHT_2D this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int r = n0; r < this.this$0.rows; r += nthreads) {
                            this.this$0.dhtColumns.forward(a[r]);
                        }
                    } else {
                        for (int r = n0; r < this.this$0.rows; r += nthreads) {
                            this.this$0.dhtColumns.inverse(a[r], scale);
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion((Future[])futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d_sub(int isgn, float[] a, boolean scale) {
        block16: {
            int idx1;
            int r;
            float[] t;
            block15: {
                int nt = 4 * this.rows;
                if (this.columns == 2) {
                    nt >>= 1;
                } else if (this.columns < 2) {
                    nt >>= 2;
                }
                t = new float[nt];
                if (this.columns <= 2) break block15;
                if (isgn == -1) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int idx12;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx12 = r2 * this.columns + c;
                            idx2 = this.rows + r2;
                            t[r2] = a[idx12];
                            t[idx2] = a[idx12 + 1];
                            t[idx2 + this.rows] = a[idx12 + 2];
                            t[idx2 + 2 * this.rows] = a[idx12 + 3];
                        }
                        this.dhtRows.forward(t, 0);
                        this.dhtRows.forward(t, this.rows);
                        this.dhtRows.forward(t, 2 * this.rows);
                        this.dhtRows.forward(t, 3 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx12 = r2 * this.columns + c;
                            idx2 = this.rows + r2;
                            a[idx12] = t[r2];
                            a[idx12 + 1] = t[idx2];
                            a[idx12 + 2] = t[idx2 + this.rows];
                            a[idx12 + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int idx13;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx13 = r3 * this.columns + c;
                            idx2 = this.rows + r3;
                            t[r3] = a[idx13];
                            t[idx2] = a[idx13 + 1];
                            t[idx2 + this.rows] = a[idx13 + 2];
                            t[idx2 + 2 * this.rows] = a[idx13 + 3];
                        }
                        this.dhtRows.inverse(t, 0, scale);
                        this.dhtRows.inverse(t, this.rows, scale);
                        this.dhtRows.inverse(t, 2 * this.rows, scale);
                        this.dhtRows.inverse(t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx13 = r3 * this.columns + c;
                            idx2 = this.rows + r3;
                            a[idx13] = t[r3];
                            a[idx13 + 1] = t[idx2];
                            a[idx13 + 2] = t[idx2 + this.rows];
                            a[idx13 + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                }
                break block16;
            }
            if (this.columns != 2) break block16;
            for (r = 0; r < this.rows; ++r) {
                idx1 = r * this.columns;
                t[r] = a[idx1];
                t[this.rows + r] = a[idx1 + 1];
            }
            if (isgn == -1) {
                this.dhtRows.forward(t, 0);
                this.dhtRows.forward(t, this.rows);
            } else {
                this.dhtRows.inverse(t, 0, scale);
                this.dhtRows.inverse(t, this.rows, scale);
            }
            for (r = 0; r < this.rows; ++r) {
                idx1 = r * this.columns;
                a[idx1] = t[r];
                a[idx1 + 1] = t[this.rows + r];
            }
        }
    }

    private void ddxt2d_sub(int isgn, FloatLargeArray a, boolean scale) {
        block16: {
            long idx1;
            long r;
            FloatLargeArray t;
            block15: {
                long nt = 4L * this.rowsl;
                if (this.columnsl == 2L) {
                    nt >>= 1;
                } else if (this.columnsl < 2L) {
                    nt >>= 2;
                }
                t = new FloatLargeArray(nt);
                if (this.columnsl <= 2L) break block15;
                if (isgn == -1) {
                    for (long c = 0L; c < this.columnsl; c += 4L) {
                        long idx2;
                        long idx12;
                        long r2;
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx12 = r2 * this.columnsl + c;
                            idx2 = this.rowsl + r2;
                            t.setFloat(r2, a.getFloat(idx12));
                            t.setFloat(idx2, a.getFloat(idx12 + 1L));
                            t.setFloat(idx2 + this.rowsl, a.getFloat(idx12 + 2L));
                            t.setFloat(idx2 + 2L * this.rowsl, a.getFloat(idx12 + 3L));
                        }
                        this.dhtRows.forward(t, 0L);
                        this.dhtRows.forward(t, this.rowsl);
                        this.dhtRows.forward(t, 2L * this.rowsl);
                        this.dhtRows.forward(t, 3L * this.rowsl);
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx12 = r2 * this.columnsl + c;
                            idx2 = this.rowsl + r2;
                            a.setFloat(idx12, t.getFloat(r2));
                            a.setFloat(idx12 + 1L, t.getFloat(idx2));
                            a.setFloat(idx12 + 2L, t.getFloat(idx2 + this.rowsl));
                            a.setFloat(idx12 + 3L, t.getFloat(idx2 + 2L * this.rowsl));
                        }
                    }
                } else {
                    for (long c = 0L; c < this.columnsl; c += 4L) {
                        long idx2;
                        long idx13;
                        long r3;
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx13 = r3 * this.columnsl + c;
                            idx2 = this.rowsl + r3;
                            t.setFloat(r3, a.getFloat(idx13));
                            t.setFloat(idx2, a.getFloat(idx13 + 1L));
                            t.setFloat(idx2 + this.rowsl, a.getFloat(idx13 + 2L));
                            t.setFloat(idx2 + 2L * this.rowsl, a.getFloat(idx13 + 3L));
                        }
                        this.dhtRows.inverse(t, 0L, scale);
                        this.dhtRows.inverse(t, this.rowsl, scale);
                        this.dhtRows.inverse(t, 2L * this.rowsl, scale);
                        this.dhtRows.inverse(t, 3L * this.rowsl, scale);
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx13 = r3 * this.columnsl + c;
                            idx2 = this.rowsl + r3;
                            a.setFloat(idx13, t.getFloat(r3));
                            a.setFloat(idx13 + 1L, t.getFloat(idx2));
                            a.setFloat(idx13 + 2L, t.getFloat(idx2 + this.rowsl));
                            a.setFloat(idx13 + 3L, t.getFloat(idx2 + 2L * this.rowsl));
                        }
                    }
                }
                break block16;
            }
            if (this.columnsl != 2L) break block16;
            for (r = 0L; r < this.rowsl; ++r) {
                idx1 = r * this.columnsl;
                t.setFloat(r, a.getFloat(idx1));
                t.setFloat(this.rowsl + r, a.getFloat(idx1 + 1L));
            }
            if (isgn == -1) {
                this.dhtRows.forward(t, 0L);
                this.dhtRows.forward(t, this.rowsl);
            } else {
                this.dhtRows.inverse(t, 0L, scale);
                this.dhtRows.inverse(t, this.rowsl, scale);
            }
            for (r = 0L; r < this.rowsl; ++r) {
                idx1 = r * this.columnsl;
                a.setFloat(idx1, t.getFloat(r));
                a.setFloat(idx1 + 1L, t.getFloat(this.rowsl + r));
            }
        }
    }

    private void ddxt2d_sub(int isgn, float[][] a, boolean scale) {
        block16: {
            int r;
            float[] t;
            block15: {
                int nt = 4 * this.rows;
                if (this.columns == 2) {
                    nt >>= 1;
                } else if (this.columns < 2) {
                    nt >>= 2;
                }
                t = new float[nt];
                if (this.columns <= 2) break block15;
                if (isgn == -1) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            t[r2] = a[r2][c];
                            t[idx2] = a[r2][c + 1];
                            t[idx2 + this.rows] = a[r2][c + 2];
                            t[idx2 + 2 * this.rows] = a[r2][c + 3];
                        }
                        this.dhtRows.forward(t, 0);
                        this.dhtRows.forward(t, this.rows);
                        this.dhtRows.forward(t, 2 * this.rows);
                        this.dhtRows.forward(t, 3 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            a[r2][c] = t[r2];
                            a[r2][c + 1] = t[idx2];
                            a[r2][c + 2] = t[idx2 + this.rows];
                            a[r2][c + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            t[r3] = a[r3][c];
                            t[idx2] = a[r3][c + 1];
                            t[idx2 + this.rows] = a[r3][c + 2];
                            t[idx2 + 2 * this.rows] = a[r3][c + 3];
                        }
                        this.dhtRows.inverse(t, 0, scale);
                        this.dhtRows.inverse(t, this.rows, scale);
                        this.dhtRows.inverse(t, 2 * this.rows, scale);
                        this.dhtRows.inverse(t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            a[r3][c] = t[r3];
                            a[r3][c + 1] = t[idx2];
                            a[r3][c + 2] = t[idx2 + this.rows];
                            a[r3][c + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                }
                break block16;
            }
            if (this.columns != 2) break block16;
            for (r = 0; r < this.rows; ++r) {
                t[r] = a[r][0];
                t[this.rows + r] = a[r][1];
            }
            if (isgn == -1) {
                this.dhtRows.forward(t, 0);
                this.dhtRows.forward(t, this.rows);
            } else {
                this.dhtRows.inverse(t, 0, scale);
                this.dhtRows.inverse(t, this.rows, scale);
            }
            for (r = 0; r < this.rows; ++r) {
                a[r][0] = t[r];
                a[r][1] = t[this.rows + r];
            }
        }
    }

    private void yTransform(float[] a) {
        for (int r = 0; r <= this.rows / 2; ++r) {
            int mRow = (this.rows - r) % this.rows;
            int idx1 = r * this.columns;
            int idx2 = mRow * this.columns;
            for (int c = 0; c <= this.columns / 2; ++c) {
                int mCol = (this.columns - c) % this.columns;
                float A = a[idx1 + c];
                float B = a[idx2 + c];
                float C = a[idx1 + mCol];
                float D = a[idx2 + mCol];
                float E = (A + D - (B + C)) / 2.0f;
                a[idx1 + c] = A - E;
                a[idx2 + c] = B + E;
                a[idx1 + mCol] = C + E;
                a[idx2 + mCol] = D - E;
            }
        }
    }

    private void yTransform(FloatLargeArray a) {
        for (long r = 0L; r <= this.rowsl / 2L; ++r) {
            long mRow = (this.rowsl - r) % this.rowsl;
            long idx1 = r * this.columnsl;
            long idx2 = mRow * this.columnsl;
            for (long c = 0L; c <= this.columnsl / 2L; ++c) {
                long mCol = (this.columnsl - c) % this.columnsl;
                float A = a.getFloat(idx1 + c);
                float B = a.getFloat(idx2 + c);
                float C = a.getFloat(idx1 + mCol);
                float D = a.getFloat(idx2 + mCol);
                float E = (A + D - (B + C)) / 2.0f;
                a.setFloat(idx1 + c, A - E);
                a.setFloat(idx2 + c, B + E);
                a.setFloat(idx1 + mCol, C + E);
                a.setFloat(idx2 + mCol, D - E);
            }
        }
    }

    private void yTransform(float[][] a) {
        for (int r = 0; r <= this.rows / 2; ++r) {
            int mRow = (this.rows - r) % this.rows;
            for (int c = 0; c <= this.columns / 2; ++c) {
                int mCol = (this.columns - c) % this.columns;
                float A = a[r][c];
                float B = a[mRow][c];
                float C = a[r][mCol];
                float D = a[mRow][mCol];
                float E = (A + D - (B + C)) / 2.0f;
                a[r][c] = A - E;
                a[mRow][c] = B + E;
                a[r][mCol] = C + E;
                a[mRow][mCol] = D - E;
            }
        }
    }
}

