/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed.bluez;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlHelper {
    private XmlHelper() {
    }

    public static Document parseXmlString(String _xmlStr) throws IOException {
        DocumentBuilderFactory dbFac = DocumentBuilderFactory.newInstance();
        dbFac.setNamespaceAware(false);
        dbFac.setValidating(false);
        try {
            dbFac.setFeature("http://xml.org/sax/features/namespaces", false);
            dbFac.setFeature("http://xml.org/sax/features/validation", false);
            dbFac.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            dbFac.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            return dbFac.newDocumentBuilder().parse(new ByteArrayInputStream(_xmlStr.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException _ex) {
            throw _ex;
        }
        catch (Exception _ex) {
            String logString = _xmlStr;
            if (_xmlStr.length() > 250) {
                logString = _xmlStr.substring(0, 249);
            }
            throw new IOException("Failed to parse " + logString, _ex);
        }
    }

    public static NodeList applyXpathExpressionToDocument(String _xpathExpression, Node _xmlDocumentOrNode) throws IOException {
        Object result;
        XPathExpression expr;
        XPathFactory xfactory = XPathFactory.newInstance();
        XPath xpath = xfactory.newXPath();
        try {
            expr = xpath.compile(_xpathExpression);
        }
        catch (XPathExpressionException _ex) {
            throw new IOException(_ex);
        }
        try {
            result = expr.evaluate(_xmlDocumentOrNode, XPathConstants.NODESET);
        }
        catch (Exception _ex) {
            throw new IOException(_ex);
        }
        return (NodeList)result;
    }
}

