/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import com.welie.blessed.BluetoothGattCharacteristic;
import com.welie.blessed.BluetoothPeripheral;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BluetoothGattService {
    @Nullable
    protected BluetoothPeripheral peripheral = null;
    @NotNull
    protected final UUID uuid;
    protected final List<BluetoothGattCharacteristic> characteristics = new ArrayList<BluetoothGattCharacteristic>();

    public BluetoothGattService(@NotNull UUID uuid) {
        this.uuid = Objects.requireNonNull(uuid, "no valid UUID supplied");
    }

    @Nullable
    public BluetoothPeripheral getPeripheral() {
        return this.peripheral;
    }

    void setPeripheral(@NotNull BluetoothPeripheral device) {
        this.peripheral = Objects.requireNonNull(device, "no valid peripheral specified");
    }

    public boolean addCharacteristic(@NotNull BluetoothGattCharacteristic characteristic) {
        Objects.requireNonNull(characteristic, "no valid characteristic supplied");
        characteristic.setService(this);
        return this.characteristics.add(characteristic);
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public List<BluetoothGattCharacteristic> getCharacteristics() {
        return Collections.unmodifiableList(this.characteristics);
    }

    @Nullable
    public BluetoothGattCharacteristic getCharacteristic(@NotNull UUID uuid) {
        Objects.requireNonNull(uuid, "no valid uuid supplied");
        for (BluetoothGattCharacteristic characteristic : this.characteristics) {
            if (!uuid.equals(characteristic.getUuid())) continue;
            return characteristic;
        }
        return null;
    }
}

