/*
 * Decompiled with CFR 0.152.
 */
package testapp;

import com.welie.blessed.BluetoothBytesParser;

public class PulseOximeterContinuousMeasurement {
    private final int SpO2;
    private final int pulseRate;
    private int SpO2Fast;
    private int pulseRateFast;
    private int SpO2Slow;
    private int pulseRateSlow;
    private float pulseAmplitudeIndex;
    private int measurementStatus;
    private int sensorStatus;

    public PulseOximeterContinuousMeasurement(byte[] value) {
        BluetoothBytesParser parser = new BluetoothBytesParser(value);
        int flags = parser.getIntValue(17);
        boolean spo2FastPresent = (flags & 1) > 0;
        boolean spo2SlowPresent = (flags & 2) > 0;
        boolean measurementStatusPresent = (flags & 4) > 0;
        boolean sensorStatusPresent = (flags & 8) > 0;
        boolean pulseAmplitudeIndexPresent = (flags & 0x10) > 0;
        this.SpO2 = parser.getFloatValue(50).intValue();
        this.pulseRate = parser.getFloatValue(50).intValue();
        if (spo2FastPresent) {
            this.SpO2Fast = parser.getFloatValue(50).intValue();
            this.pulseRateFast = parser.getFloatValue(50).intValue();
        }
        if (spo2SlowPresent) {
            this.SpO2Slow = parser.getFloatValue(50).intValue();
            this.pulseRateSlow = parser.getFloatValue(50).intValue();
        }
        if (measurementStatusPresent) {
            this.measurementStatus = parser.getIntValue(18);
        }
        if (sensorStatusPresent) {
            this.sensorStatus = parser.getIntValue(18);
            int n = parser.getIntValue(17);
        }
        if (pulseAmplitudeIndexPresent) {
            this.pulseAmplitudeIndex = parser.getFloatValue(50).floatValue();
        }
    }

    public int getSpO2() {
        return this.SpO2;
    }

    public int getPulseRate() {
        return this.pulseRate;
    }

    public int getSpO2Fast() {
        return this.SpO2Fast;
    }

    public int getPulseRateFast() {
        return this.pulseRateFast;
    }

    public int getSpO2Slow() {
        return this.SpO2Slow;
    }

    public int getPulseRateSlow() {
        return this.pulseRateSlow;
    }

    public float getPulseAmplitudeIndex() {
        return this.pulseAmplitudeIndex;
    }

    public int getMeasurementStatus() {
        return this.measurementStatus;
    }

    public int getSensorStatus() {
        return this.sensorStatus;
    }

    public String toString() {
        if (this.SpO2 == 2047 || this.pulseRate == 2047) {
            return "invalid measurement";
        }
        return String.format("SpO2 %d%%, Pulse %d bpm, PAI %.1f", this.SpO2, this.pulseRate, Float.valueOf(this.pulseAmplitudeIndex));
    }
}

