/*
 * Decompiled with CFR 0.152.
 */
package testapp;

import com.welie.blessed.BluetoothBytesParser;
import com.welie.blessed.BluetoothCentralManager;
import com.welie.blessed.BluetoothCentralManagerCallback;
import com.welie.blessed.BluetoothCommandStatus;
import com.welie.blessed.BluetoothGattCharacteristic;
import com.welie.blessed.BluetoothGattService;
import com.welie.blessed.BluetoothPeripheral;
import com.welie.blessed.BluetoothPeripheralCallback;
import com.welie.blessed.Handler;
import com.welie.blessed.ScanResult;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import testapp.BloodPressureMeasurement;
import testapp.HeartRateMeasurement;
import testapp.PulseOximeterContinuousMeasurement;
import testapp.PulseOximeterSpotMeasurement;
import testapp.TemperatureMeasurement;
import testapp.WeightMeasurement;

public class BluetoothHandler {
    private static final String TAG = BluetoothHandler.class.getSimpleName();
    private final Logger logger = LoggerFactory.getLogger(TAG);
    private final BluetoothCentralManager central;
    private final Handler handler = new Handler("testapp.BluetoothHandler");
    private boolean justBonded = false;
    private static final List<String> blackList = new ArrayList<String>();
    @Nullable
    private ScheduledFuture<?> timeoutFuture;
    private static final UUID BLP_SERVICE_UUID = UUID.fromString("00001810-0000-1000-8000-00805f9b34fb");
    private static final UUID BLOOD_PRESSURE_MEASUREMENT_CHARACTERISTIC_UUID = UUID.fromString("00002A35-0000-1000-8000-00805f9b34fb");
    private static final UUID HTS_SERVICE_UUID = UUID.fromString("00001809-0000-1000-8000-00805f9b34fb");
    private static final UUID TEMPERATURE_MEASUREMENT_CHARACTERISTIC_UUID = UUID.fromString("00002A1C-0000-1000-8000-00805f9b34fb");
    private static final UUID HRS_SERVICE_UUID = UUID.fromString("0000180D-0000-1000-8000-00805f9b34fb");
    private static final UUID HEARTRATE_MEASUREMENT_CHARACTERISTIC_UUID = UUID.fromString("00002A37-0000-1000-8000-00805f9b34fb");
    private static final UUID DIS_SERVICE_UUID = UUID.fromString("0000180A-0000-1000-8000-00805f9b34fb");
    private static final UUID MANUFACTURER_NAME_CHARACTERISTIC_UUID = UUID.fromString("00002A29-0000-1000-8000-00805f9b34fb");
    private static final UUID MODEL_NUMBER_CHARACTERISTIC_UUID = UUID.fromString("00002A24-0000-1000-8000-00805f9b34fb");
    private static final UUID CTS_SERVICE_UUID = UUID.fromString("00001805-0000-1000-8000-00805f9b34fb");
    private static final UUID CURRENT_TIME_CHARACTERISTIC_UUID = UUID.fromString("00002A2B-0000-1000-8000-00805f9b34fb");
    private static final UUID BTS_SERVICE_UUID = UUID.fromString("0000180F-0000-1000-8000-00805f9b34fb");
    private static final UUID BATTERY_LEVEL_CHARACTERISTIC_UUID = UUID.fromString("00002A19-0000-1000-8000-00805f9b34fb");
    public static final UUID PLX_SERVICE_UUID = UUID.fromString("00001822-0000-1000-8000-00805f9b34fb");
    private static final UUID PLX_SPOT_MEASUREMENT_CHAR_UUID = UUID.fromString("00002a5e-0000-1000-8000-00805f9b34fb");
    private static final UUID PLX_CONTINUOUS_MEASUREMENT_CHAR_UUID = UUID.fromString("00002a5f-0000-1000-8000-00805f9b34fb");
    public static final UUID WSS_SERVICE_UUID = UUID.fromString("0000181D-0000-1000-8000-00805f9b34fb");
    private static final UUID WSS_MEASUREMENT_CHAR_UUID = UUID.fromString("00002A9D-0000-1000-8000-00805f9b34fb");
    private final BluetoothPeripheralCallback peripheralCallback = new BluetoothPeripheralCallback(){

        @Override
        public void onServicesDiscovered(@NotNull BluetoothPeripheral peripheral, @NotNull List<BluetoothGattService> services) {
            peripheral.readCharacteristic(DIS_SERVICE_UUID, MANUFACTURER_NAME_CHARACTERISTIC_UUID);
            peripheral.readCharacteristic(DIS_SERVICE_UUID, MODEL_NUMBER_CHARACTERISTIC_UUID);
            BluetoothGattCharacteristic currentTimeCharacteristic = peripheral.getCharacteristic(CTS_SERVICE_UUID, CURRENT_TIME_CHARACTERISTIC_UUID);
            if (currentTimeCharacteristic != null) {
                peripheral.setNotify(currentTimeCharacteristic, true);
                if (currentTimeCharacteristic.supportsWritingWithResponse()) {
                    BluetoothBytesParser parser = new BluetoothBytesParser();
                    parser.setCurrentTime(Calendar.getInstance());
                    peripheral.writeCharacteristic(currentTimeCharacteristic, parser.getValue(), BluetoothGattCharacteristic.WriteType.WITH_RESPONSE);
                }
            }
            peripheral.readCharacteristic(BTS_SERVICE_UUID, BATTERY_LEVEL_CHARACTERISTIC_UUID);
            peripheral.setNotify(BLP_SERVICE_UUID, BLOOD_PRESSURE_MEASUREMENT_CHARACTERISTIC_UUID, true);
            peripheral.setNotify(HTS_SERVICE_UUID, TEMPERATURE_MEASUREMENT_CHARACTERISTIC_UUID, true);
            peripheral.setNotify(PLX_SERVICE_UUID, PLX_CONTINUOUS_MEASUREMENT_CHAR_UUID, true);
            peripheral.setNotify(PLX_SERVICE_UUID, PLX_SPOT_MEASUREMENT_CHAR_UUID, true);
            peripheral.setNotify(HRS_SERVICE_UUID, HEARTRATE_MEASUREMENT_CHARACTERISTIC_UUID, true);
            peripheral.setNotify(WSS_SERVICE_UUID, WSS_MEASUREMENT_CHAR_UUID, true);
        }

        @Override
        public void onNotificationStateUpdate(@NotNull BluetoothPeripheral peripheral, @NotNull BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
            if (status == BluetoothCommandStatus.COMMAND_SUCCESS) {
                boolean isNotifying = peripheral.isNotifying(characteristic);
                BluetoothHandler.this.logger.info(String.format("SUCCESS: Notify set to '%s' for %s", isNotifying, characteristic.getUuid()));
                if (isNotifying) {
                    String peripheralName;
                    String string = peripheralName = peripheral.getName() == null ? "" : peripheral.getName();
                    if (BluetoothHandler.this.justBonded && BluetoothHandler.this.isANDPeripheral(peripheralName)) {
                        peripheral.cancelConnection();
                        BluetoothHandler.this.justBonded = false;
                    }
                    if (BluetoothHandler.this.isANDPeripheral(peripheralName)) {
                        BluetoothHandler.this.startDisconnectTimer(peripheral);
                    }
                } else if (peripheral.getNotifyingCharacteristics().isEmpty()) {
                    peripheral.cancelConnection();
                }
            } else {
                BluetoothHandler.this.logger.error(String.format("ERROR: Changing notification state failed for %s", characteristic.getUuid()));
            }
        }

        @Override
        public void onCharacteristicUpdate(@NotNull BluetoothPeripheral peripheral, byte[] value, @NotNull BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
            UUID characteristicUUID = characteristic.getUuid();
            BluetoothBytesParser parser = new BluetoothBytesParser(value);
            if (status != BluetoothCommandStatus.COMMAND_SUCCESS) {
                BluetoothHandler.this.logger.error(String.format("command failed with status %s", new Object[]{status}));
                return;
            }
            if (characteristicUUID.equals(MANUFACTURER_NAME_CHARACTERISTIC_UUID)) {
                String manufacturer = parser.getStringValue(0);
                BluetoothHandler.this.logger.info(String.format("Received manufacturer: '%s'", manufacturer));
            } else if (characteristicUUID.equals(MODEL_NUMBER_CHARACTERISTIC_UUID)) {
                String modelNumber = parser.getStringValue(0);
                BluetoothHandler.this.logger.info(String.format("Received modelnumber: '%s'", modelNumber));
            } else if (characteristicUUID.equals(TEMPERATURE_MEASUREMENT_CHARACTERISTIC_UUID)) {
                TemperatureMeasurement measurement = new TemperatureMeasurement(value);
                BluetoothHandler.this.logger.info(measurement.toString());
                BluetoothHandler.this.startDisconnectTimer(peripheral);
            } else if (characteristicUUID.equals(BLOOD_PRESSURE_MEASUREMENT_CHARACTERISTIC_UUID)) {
                BloodPressureMeasurement measurement = new BloodPressureMeasurement(value);
                BluetoothHandler.this.logger.info(measurement.toString());
                BluetoothHandler.this.startDisconnectTimer(peripheral);
            } else if (characteristicUUID.equals(PLX_CONTINUOUS_MEASUREMENT_CHAR_UUID)) {
                PulseOximeterContinuousMeasurement measurement = new PulseOximeterContinuousMeasurement(value);
                BluetoothHandler.this.logger.info(measurement.toString());
            } else if (characteristicUUID.equals(PLX_SPOT_MEASUREMENT_CHAR_UUID)) {
                PulseOximeterSpotMeasurement measurement = new PulseOximeterSpotMeasurement(value);
                BluetoothHandler.this.logger.info(measurement.toString());
                BluetoothHandler.this.startDisconnectTimer(peripheral);
            } else if (characteristicUUID.equals(HEARTRATE_MEASUREMENT_CHARACTERISTIC_UUID)) {
                HeartRateMeasurement measurement = new HeartRateMeasurement(value);
                BluetoothHandler.this.logger.info(measurement.toString());
            } else if (characteristicUUID.equals(WSS_MEASUREMENT_CHAR_UUID)) {
                WeightMeasurement measurement = new WeightMeasurement(value);
                BluetoothHandler.this.logger.info(measurement.toString());
                BluetoothHandler.this.startDisconnectTimer(peripheral);
            } else if (characteristicUUID.equals(CURRENT_TIME_CHARACTERISTIC_UUID)) {
                Date currentTime = parser.getDateTime();
                BluetoothHandler.this.logger.info(String.format("Received device time: %s", currentTime));
            } else if (characteristicUUID.equals(BATTERY_LEVEL_CHARACTERISTIC_UUID)) {
                int batteryLevel = parser.getIntValue(17);
                BluetoothHandler.this.logger.info(String.format("battery level %d", batteryLevel));
            }
        }

        @Override
        public void onBondingStarted(@NotNull BluetoothPeripheral peripheral) {
            BluetoothHandler.this.logger.info("bonding started");
        }

        @Override
        public void onBondingSucceeded(@NotNull BluetoothPeripheral peripheral) {
            BluetoothHandler.this.logger.info("bonding succeeded");
            BluetoothHandler.this.justBonded = true;
        }

        @Override
        public void onBondingFailed(@NotNull BluetoothPeripheral peripheral) {
            BluetoothHandler.this.logger.info("bonding failed");
        }

        @Override
        public void onBondLost(@NotNull BluetoothPeripheral peripheral) {
            BluetoothHandler.this.logger.info("bond lost");
        }

        @Override
        public void onReadRemoteRssi(@NotNull BluetoothPeripheral peripheral, int rssi, BluetoothCommandStatus status) {
            BluetoothHandler.this.logger.info(String.format("rssi is %d", rssi));
        }
    };
    private final BluetoothCentralManagerCallback bluetoothCentralManagerCallback = new BluetoothCentralManagerCallback(){

        @Override
        public void onConnectedPeripheral(@NotNull BluetoothPeripheral peripheral) {
            BluetoothHandler.this.logger.info("connected peripheral");
        }

        @Override
        public void onConnectionFailed(@NotNull BluetoothPeripheral peripheral, @NotNull BluetoothCommandStatus status) {
            BluetoothHandler.this.logger.info(String.format("connection failed with status %s", new Object[]{status}));
            String peripheralAddress = peripheral.getAddress();
            BluetoothHandler.this.handler.postDelayed(() -> blackList.remove(peripheralAddress), 2000L);
        }

        @Override
        public void onDisconnectedPeripheral(@NotNull BluetoothPeripheral peripheral, @NotNull BluetoothCommandStatus status) {
            BluetoothHandler.this.logger.info("disconnected peripheral");
            String peripheralAddress = peripheral.getAddress();
            BluetoothHandler.this.handler.postDelayed(() -> {
                BluetoothHandler.this.logger.info(String.format("removing '%s' from blacklist", peripheralAddress));
                blackList.remove(peripheralAddress);
            }, 40000L);
        }

        @Override
        public void onDiscoveredPeripheral(@NotNull BluetoothPeripheral peripheral, @NotNull ScanResult scanResult) {
            String peripheralAddress = peripheral.getAddress();
            boolean blacklisted = blackList.contains(peripheralAddress);
            if (blacklisted) {
                return;
            }
            blackList.add(peripheralAddress);
            BluetoothHandler.this.logger.info(scanResult.toString());
            BluetoothHandler.this.central.connectPeripheral(peripheral, BluetoothHandler.this.peripheralCallback);
        }
    };

    private boolean isANDPeripheral(String peripheralName) {
        return peripheralName.contains("352BLE") || peripheralName.contains("651BLE");
    }

    public void startDisconnectTimer(BluetoothPeripheral peripheral) {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
            this.timeoutFuture = null;
        }
        Runnable timeoutRunnable = () -> this.turnOffAllNotifications(peripheral);
        this.timeoutFuture = this.handler.postDelayed(timeoutRunnable, 2000L);
    }

    private void turnOffAllNotifications(@NotNull BluetoothPeripheral peripheral) {
        peripheral.getNotifyingCharacteristics().forEach(characteristic -> peripheral.setNotify((BluetoothGattCharacteristic)characteristic, false));
    }

    public BluetoothHandler() {
        this.logger.info("initializing BluetoothCentral");
        this.central = new BluetoothCentralManager(this.bluetoothCentralManagerCallback, new HashSet<String>(Collections.singletonList("ScanOption.NoNullNames")));
        this.central.setPinCodeForPeripheral("B0:49:5F:01:20:8F", "635227");
        this.startScanning();
    }

    void startScanning() {
        this.central.scanForPeripheralsWithServices(new UUID[]{WSS_SERVICE_UUID, HTS_SERVICE_UUID, PLX_SERVICE_UUID, BLP_SERVICE_UUID, HRS_SERVICE_UUID});
    }
}

