/*
 * Decompiled with CFR 0.152.
 */
package testapp;

import com.welie.blessed.BluetoothBytesParser;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class BloodPressureMeasurement
implements Serializable {
    public final Integer userID;
    public final Float systolic;
    public final Float diastolic;
    public final Float meanArterialPressure;
    public final Date timestamp;
    public final boolean isMMHG;
    public final Float pulseRate;

    public BloodPressureMeasurement(byte[] value) {
        BluetoothBytesParser parser = new BluetoothBytesParser(value);
        int flags = parser.getIntValue(17);
        this.isMMHG = (flags & 1) <= 0;
        boolean timestampPresent = (flags & 2) > 0;
        boolean pulseRatePresent = (flags & 4) > 0;
        boolean userIdPresent = (flags & 8) > 0;
        boolean measurementStatusPresent = (flags & 0x10) > 0;
        this.systolic = parser.getFloatValue(50);
        this.diastolic = parser.getFloatValue(50);
        this.meanArterialPressure = parser.getFloatValue(50);
        this.timestamp = timestampPresent ? parser.getDateTime() : Calendar.getInstance().getTime();
        this.pulseRate = pulseRatePresent ? parser.getFloatValue(50) : null;
        this.userID = userIdPresent ? parser.getIntValue(17) : null;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "%.0f/%.0f %s, MAP %.0f, %.0f bpm, user %d at (%s)", this.systolic, this.diastolic, this.isMMHG ? "mmHg" : "kPa", this.meanArterialPressure, this.pulseRate, this.userID, this.timestamp);
    }
}

