/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jnr.constants.platform.Errno;
import jnr.constants.platform.LastError;
import jnr.constants.platform.SocketLevel;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.StructLayout;
import jnr.posix.CmsgHdr;
import jnr.posix.MsgHdr;
import jnr.posix.NativePOSIX;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import jnr.posix.util.Platform;
import jnr.unixsocket.UnixSocket;
import jnr.unixsocket.UnixSocketChannel;

public final class FreeBSDHelper {
    private static final CmsgCredLayout cmsgCredLayout = new CmsgCredLayout(Runtime.getSystemRuntime());

    private FreeBSDHelper() {
    }

    public static boolean isFreeBSD() {
        return Platform.IS_FREEBSD;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void send_cred(Socket _us) throws IOException {
        POSIX posix = POSIXFactory.getNativePOSIX();
        String data = "\u0000";
        byte[] dataBytes = data.getBytes();
        MsgHdr outMessage = posix.allocateMsgHdr();
        ByteBuffer[] outIov = new ByteBuffer[]{ByteBuffer.allocateDirect(dataBytes.length)};
        outIov[0].put(dataBytes);
        outIov[0].flip();
        outMessage.setIov(outIov);
        CmsgHdr outControl = outMessage.allocateControl(cmsgCredLayout.size());
        outControl.setLevel(SocketLevel.SOL_SOCKET.intValue());
        outControl.setType(3);
        ByteBuffer fdBuf = ByteBuffer.allocateDirect(cmsgCredLayout.size());
        fdBuf.order(ByteOrder.nativeOrder());
        outControl.setData(fdBuf);
        int fd = ((UnixSocketChannel)((UnixSocket)_us).getChannel()).getFD();
        int sentBytes = -1;
        while ((sentBytes = posix.sendmsg(fd, outMessage, 0)) < 0 && Errno.valueOf(posix.errno()) == Errno.EINTR) {
        }
        if (sentBytes < 0) {
            long err = posix.errno();
            if (Errno.valueOf(err) != Errno.EINVAL) throw new IOException("Failed to write credentials byte: " + LastError.valueOf(err).toString());
            _us.getOutputStream().write(dataBytes);
            return;
        } else {
            if (sentBytes != 0) return;
            throw new IOException("wrote zero bytes writing credentials byte");
        }
    }

    public static long recv_cred(Socket _us) {
        NativePOSIX posix = (NativePOSIX)POSIXFactory.getNativePOSIX();
        MsgHdr inMessage = posix.allocateMsgHdr();
        ByteBuffer[] inIov = new ByteBuffer[]{ByteBuffer.allocateDirect(1)};
        inMessage.setIov(inIov);
        int fd = ((UnixSocketChannel)((UnixSocket)_us).getChannel()).getFD();
        int recvBytes = -1;
        while ((recvBytes = posix.recvmsg(fd, inMessage, 0)) < 0 && Errno.valueOf(posix.errno()) == Errno.EINTR) {
        }
        if (recvBytes > 0 && inIov[0].get(0) == 0) {
            for (CmsgHdr cmsg : inMessage.getControls()) {
                if (cmsg.getType() != 3 || cmsg.getLevel() != SocketLevel.SOL_SOCKET.intValue() || cmsg.getLen() < posix.socketMacros().CMSG_LEN(84)) continue;
                ByteBuffer data = cmsg.getData();
                Pointer memory = Runtime.getSystemRuntime().getMemoryManager().allocateTemporary(cmsgCredLayout.size(), true);
                for (int i = 0; i < cmsgCredLayout.size(); ++i) {
                    memory.putByte(i, data.get(i));
                }
                return FreeBSDHelper.cmsgCredLayout.cmcred_euid.get(memory);
            }
        }
        return -1L;
    }

    static class CmsgCredLayout
    extends StructLayout {
        final StructLayout.pid_t cmcred_pid = new StructLayout.pid_t(this);
        final StructLayout.uid_t cmcred_uid = new StructLayout.uid_t(this);
        final StructLayout.uid_t cmcred_euid = new StructLayout.uid_t(this);
        final StructLayout.gid_t cmcred_gid = new StructLayout.gid_t(this);
        final StructLayout.Signed16 cmcred_ngroups = new StructLayout.Signed16(this);
        final StructLayout.gid_t[] cmcred_groups = (StructLayout.gid_t[])this.array(new StructLayout.gid_t[16]);

        CmsgCredLayout(Runtime _runtime) {
            super(_runtime);
        }
    }
}

